--[[
******************************************************************
Script to get a list of the Shared XPS Card Printers that are 
resident on another computer. Created using registry values on Windows 7
32 bit.

variables returned to the calling script are:
nmbrSharedXPSCardPrinters --> the number of shared XPS Card Printers.
tbSharedXPSCardPrinters --> a list of UNC names for the shared XPS Card Printers.
******************************************************************
]]--
nmbrSharedXPSCardPrinters = 0;
tbSharedXPSCardPrinters = {};
DXP01DriverName = "XPS Card Printer"; -- our driver name. Do not change!

-- The regisry key differs on Windows XP.  Detmine the OS and then set the appropriate registry key.
local strBaseRegKeyName = "";
local tbOSVersionInfo = System.GetOSVersionInfo();
local MajorVersionNumber = String.ToNumber(tbOSVersionInfo.MajorVersion);
if (MajorVersionNumber == 5) then
	strBaseRegKeyName = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Providers\\LanMan Print Services\\Servers";
else
	strBaseRegKeyName = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Providers\\Client Side Rendering Print Provider\\Servers";
end
-- Dialog.Message("DEBUG", strBaseRegKeyName, MB_OK, MB_ICONNONE, MB_DEFBUTTON1);
-- Get list of all servers that have printers this client is sharing.
local tbSharedPrinterServers = {};
tbSharedPrinterServers = Registry.GetKeyNames(HKEY_LOCAL_MACHINE, strBaseRegKeyName);
if (tbSharedPrinterServers ~= nil) then -- at least one server is listed.
	for ServerIndex,ServerValue in pairs(tbSharedPrinterServers) do -- for each server, get the list of printers on that server.
		local tbSharedPrintersOnServer = {}; -- initial the table of printers on this server.
		tbSharedPrintersOnServer = Registry.GetKeyNames(HKEY_LOCAL_MACHINE, strBaseRegKeyName.."\\"..ServerValue.."\\Printers");
		if (tbSharedPrintersOnServer ~= nil) then -- at least one printer was found on this server.  Need to find if any are XPS Card Printers.
		   	for PrinterIndex,PrinterValue in pairs(tbSharedPrintersOnServer) do
		      	strPrinterDriver = Registry.GetValue(HKEY_LOCAL_MACHINE, strBaseRegKeyName.."\\"..ServerValue.."\\Printers\\"..PrinterValue, "Printer Driver", false);
		      	if (strPrinterDriver == DXP01DriverName) then -- this is an XPS Card Printer.	
	       			local strUncPrinterName = Registry.GetValue(HKEY_LOCAL_MACHINE, strBaseRegKeyName.."\\"..ServerValue.."\\Printers\\"..PrinterValue.."\\DsSpooler", "uNCName", false);
	       			Table.Insert(tbSharedXPSCardPrinters, Table.Count(tbSharedXPSCardPrinters)+1, strUncPrinterName);
	       			nmbrSharedXPSCardPrinters = nmbrSharedXPSCardPrinters + 1; 
		      	end	
		    end -- end of "printers on a named server" for loop
		end	
	end -- end of server for loop	
else -- there are no shared printers and no servers listed.
	nmbrSharedXPSCardPrinters = 0;
	return true;
end	