--[[
******************************************************************
Script to get a list of the XPS Card Printers installed on the system.

variables returned to the calling script are:
strScriptReturnStatus --> a string containing log information
countXPSCardPrinters --> the number if installed XPS Card Printers.
tbXPSCardPrinters --> a list of the names of the installed XPS Card Printers.
******************************************************************
]]--
fDebug("[Script Start]: GetXPSCardPrinterList");
nmbrXPSCardPrinters = 0;
tbXPSCardPrinters = {};
DXP01DriverName = "XPS Card Printer"; -- our driver name. Do not change!
tbRegValues = Registry.GetKeyNames(HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers");
-- Check for error code.
local lastError = Application.GetLastError();
if (lastError == 0) then
	nPrinters = Table.Count(tbRegValues);
	fDebug("  INFO: Printers found: "..nPrinters); 
	if (nPrinters > 0) then -- we have at least one printer, check for XPS Card Printers.
		strRegValues =  "";
	   	for index,value in pairs(tbRegValues) do
	       strDriver = Registry.GetValue(HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers\\"..value, "Printer Driver", false)
	       if (strDriver == DXP01DriverName) then -- this is an XPS Card Printer.  Make sure it is one that has not been removed (i.e. does not have a comma in the name)
	       		if (String.Find(value,",",1,true) == -1) then -- no commas were found.
	       			Table.Insert(tbXPSCardPrinters, Table.Count(tbXPSCardPrinters)+1, value);
	       			nmbrXPSCardPrinters = nmbrXPSCardPrinters + 1;
	       			fDebug("  INFO: XPS printer added to list: "..value..".      XPS Card printers found: "..nmbrXPSCardPrinters); 
	       		end	
	       end	
	    end   
	end
	fDebug("  INFO: XPS Card Printers found: "..nmbrXPSCardPrinters); 
	fDebug("[Script Exit]: GetXPSCardPrinterList \r\n");
	return true;
else -- error returned trying to get printer list from registry
	fDebug("  ERROR: Call to Registry.GetKeyName returned with error: "..lastError);
	fDebug("[Script Exit]: GetXPSCardPrinterList \r\n");
	return false;
end
fDebug("[Script Exit]: GetXPSCardPrinterList \r\n");