--[[ 
Copy custom topcoat and erase masking sample bitmaps known folder if they are not preent.

NOTE: This function is considered non-critical so it does not set the global flag bContinueInstall

Returned:
=========
bScriptRanToCompletion tells calling app that script ran.

 ]]--

fDebug("[Script Start]: Install_CustomMaskBitmaps.lua");
bScriptRanToCompletion = false;
local PATH_CUSTOM_FOLDER = "C:\\CardPrinter"; -- legacy folder path.  Used by SP driver.  Do not change!
local functionErrorCode = 0;

function DoesCustomBitmapFolderExist()
	fDebug("  Checking if custom mask bitmaps folder exists at: "..PATH_CUSTOM_FOLDER.."...");
	local folderExists = Folder.DoesExist(PATH_CUSTOM_FOLDER);
	if (folderExists) then
		fDebug("  INFO: Folder exists.");
		return true
	else	
		functionErrorCode = Application.GetLastError();
		if (functionErrorCode ~= 0) then
			fDebug("  ERROR: Check for folder failed.  Error: "..functionErrorCode);
		else
			fDebug("  INFO: Folder does not exist.");
		end	
		return false
	end
end


function CreateCustomBitmapFolder()
	fDebug("  Creating custom mask bitmaps folder at: "..PATH_CUSTOM_FOLDER.."...");
	Folder.Create(PATH_CUSTOM_FOLDER);
	functionErrorCode = Application.GetLastError();
	if (functionErrorCode ~= 0) then
		fDebug("  ERROR: Could not create folder.  Error: "..functionErrorCode);
	else
		fDebug("  INFO: Folder created.");
	end	
	return
end


function CopySampleBitmaps()
	fDebug("  Copying custom mask sample bitmaps to: "..PATH_CUSTOM_FOLDER.."...");
	-- loop through the image files and copy them if they do not exist
	local tblFileNames = {"CRDPortTopcoatFront.bmp", "CRDPortTopcoatBack.bmp","CRDLandTopcoatFront.bmp", "CRDLandTopcoatBack.bmp", "CRDLandEraseFront.bmp", "CRDPortEraseFront.bmp"};
	local fileCount = Table.Count(tblFileNames);
	local loopCounter = 1;
	repeat
		local strFileName = tblFileNames[loopCounter];
		if not (File.DoesExist(PATH_CUSTOM_FOLDER.."\\"..strFileName)) then --  If file is installed, do not overwrite it.
			File.Copy(_SourceFolder.."\\AutoPlay\\Images\\"..strFileName, PATH_CUSTOM_FOLDER.."\\"..strFileName, false, false, false, false, nil); 
			functionErrorCode = Application.GetLastError();
			if (functionErrorCode ~= 0) then
				fDebug("  ERROR: Could not copy file "..strFileName..".  Error: "..functionErrorCode);
				return false;
			else
				fDebug("  INFO: File: "..strFileName.." copied.");	 
			end
		else
			fDebug("  INFO: File: "..strFileName.." detected.  Use existing file.");
		end
		loopCounter = loopCounter + 1;
	until loopCounter > fileCount
	return true
end

-- Execute the functions

local folderExists = DoesCustomBitmapFolderExist();
if (functionErrorCode ~= 0) then
	fDebug("[Script Exit]: Install_CustomMaskBitmaps.lua. FAILED! Check for folder failed.");
end	

if ((functionErrorCode == 0) and (not folderExists)) then
	CreateCustomBitmapFolder();
	if (functionErrorCode ~= 0) then
		fDebug("[Script Exit]: Install_CustomMaskBitmaps.lua. FAILED! Could not create folder.");
	end	
end

if (functionErrorCode == 0) then
	if not(CopySampleBitmaps()) then
		fDebug("[Script Exit]: Install_CustomMaskBitmaps.lua. FAILED! Could not copy custom files.");
	end
end


if (functionErrorCode == 0) then
	fDebug("[Script Exit]: Install_CustomMaskBitmaps.lua.");
end

	
bScriptRanToCompletion = true;	