--[[
============================================================================================
Script to install the SP/CP magnetic stripe fonts.  The XPS driver will detect and use these
fonts so applications written for the SP printer will work without modification.
============================================================================================
]]--

fDebug("\r\n\r\n\[Enter Script}: Installing legacy magstripe fonts...");

local tblFileNames = { "Track1.ttf", "Track2.ttf","Track3.ttf","Trackntt.ttf" };
local tblFontNames = { "Track 1 - Magnetic stripe", "Track 2 - Magnetic stripe", "Track 3 - Magnetic stripe", "Track NTT - Magnetic stripe"}
-- ************************************
--   Get Fonts folder path
-- ************************************
local fonts_dir = Shell.GetFolder(SHF_FONTS); -- Gets the path to the user's Font directory.
local error = Application.GetLastError();
if (error ~= 0) then
	fDebug("ERROR: Error detecting system font folder: "..error);
else
	-- Put a loop here to loop through a table of font names and file names so the same code can be reused n times.
	local fontCount = Table.Count(tblFontNames);
	local loopCounter = 1;
	repeat
		local strFontFileName = tblFileNames[loopCounter];
		local strFontName = tblFontNames[loopCounter];
		--  ************************************
		--  Detect if the font is installed.  If it is, try to unregister it.
		--  This may fail because the file is present but the font is not registered.
		--  If it fails, continue on.
		--  ************************************
		if (File.DoesExist(fonts_dir.."\\"..strFontFileName)) then -- Check if the font exits.  If it does, unregister it.
			fDebug("  INFO: Font file: "..strFontFileName.." found on the system.  Unregistering. ");
			System.UnregisterFont(fonts_dir.."\\"..strFontFileName, strFontName, true);
		end
	
		-- ************************************
		-- Copy the font file to the Fonts directory overwriting the file if it is already there.
		-- This may fail if the font is marked 'in use'
		-- If it fails, continue on.
		-- 	************************************
		File.Copy(_SourceFolder.."\\AutoPlay\\Fonts\\"..strFontFileName, fonts_dir.."\\"..strFontFileName, false, true, false, true, nil); -- Copy the magstripe file to the Fonts folder.
		local error = Application.GetLastError();
		if (error ~= 0) then
			fDebug("  ERROR: Error copying font file: "..strFontFileName..".  Error: "..error);
		else
			fDebug("  INFO: Copied font file: "..strFontFileName.." with name: "..strFontName.. " to: "..fonts_dir);
		end
		-- ************************************
		-- Register the font.
		-- This should not fail.
		-- ************************************
		if (File.DoesExist(fonts_dir.."\\"..strFontFileName)) then
			System.RegisterFont(fonts_dir.."\\"..strFontFileName, strFontName, true); -- Register the font.
			local error = Application.GetLastError();
			if (error ~= 0) then
				fDebug("  ERROR: Error registering font file: "..strFontFileName..".  Error: "..error);
			else
				fDebug("  INFO: Registered magstripe font file: "..strFontFileName.." with name: "..strFontName);
			end
		end
		loopCounter = loopCounter + 1;
	until loopCounter > fontCount
end

-- Send signals back to the main script using the bContinueInstall and bScriptRanToCompletion flags.
bContinueInstall = true;
bScriptRanToCompletion = true;
fDebug("[Exit Script]: Legacy files installation finished.\r\n");
