
fDebug("\r\n\r\n\[Enter Script]: Installing magstripe fonts...");
local bContinue = true;
local fonts_dir = "";
local functionReturnCode = 0;
local tblFileNames = { "DXP01_T1.ttf", "DXP01_T2.ttf","DXP01_T3.ttf","DXP01_JIS.ttf" };
local tblFontNames = { "Mag Track 1 XPS Card Printer", "Mag Track 2 XPS Card Printer", "Mag Track 3 XPS Card Printer", "Mag Track JIS XPS Card Printer"}

fonts_dir = Shell.GetFolder(SHF_FONTS); -- Gets the path to the user's Font directory.
functionReturnCode = Application.GetLastError();
if (functionReturnCode ~= 0) then
	fDebug("ERROR: Error detecting system font folder: "..functionReturnCode);
	bContinue = false;
end

if (bContinue) then
	local fontCount = Table.Count(tblFontNames);
	fDebug("  INFO: Number of magstripe fonts to install: "..fontCount);
	local loopCounter = 1;
	repeat  
		local strFontFileName = tblFileNames[loopCounter];
		local strFontName = tblFontNames[loopCounter];		
		if not (File.DoesExist(fonts_dir.."\\"..strFontFileName)) then
			File.Copy(_SourceFolder.."\\AutoPlay\\Fonts\\"..strFontFileName, fonts_dir.."\\"..strFontFileName, false, true, false, true, nil); 
			functionReturnCode = Application.GetLastError();
			if (functionReturnCode ~= 0) then -- This may fail if the font is marked 'in use'
				fDebug("  WARNING: Error copying font file: "..strFontFileName..".  Error: "..functionReturnCode);
			else
				fDebug("  INFO: copied magstripe font file: "..strFontFileName.." with name: "..strFontName);
			end

			System.RegisterFont(fonts_dir.."\\"..strFontFileName, strFontName, true);
			functionReturnCode = Application.GetLastError();
			if (functionReturnCode ~= 0) then
				fDebug("ERROR: Error registering font file: "..strFontFileName..".  Error: "..functionReturnCode);
			else
				fDebug("  INFO: Registered magstripe font file: "..strFontFileName.." with name: "..strFontName);
			end
		end
	loopCounter = loopCounter + 1;
	until ((loopCounter > fontCount) or (loopCounter > 10))
end	

bContinueInstall = true;
bScriptRanToCompletion = true;
fDebug("[Exit Script]: Magstripe fonts installed.\r\n");
