-- ***********************************************************
-- Script to install the USB Event Watcher Service
-- Added to v2.1 post release for DC France customer
-- ***********************************************************
fDebug("\r\nInstalling USB Event Watcher service...");

local bServiceExists = false;
local bContinue = true;
local pathCommonAppDataFolder = Shell.GetFolder(SHF_APPLICATIONDATA_COMMON);
local pathServiceFolder = pathCommonAppDataFolder.."\\Datacard\\XPS Card Printer\\Service";
local ServiceDisplayName = "DXP01 USB Event Watcher";
local ServiceKeyName = "DXP01USBWatcher";

-- Create a folder name specific for the OS type (32-bit or 64-bit) to use later when building paths.
local OSTypeFolder = "";
if (System.Is64BitOS()) then
 	OSTypeFolder = "AMD64";
else
	OSTypeFolder = "i386"; 
end	

-- check if the service is running, if it is stop it

local nServiceState = Service.Query(ServiceDisplayName, ServiceKeyName);
if (nServiceState == 0) then -- service is not present. Continue.
	fDebug("INFO:  USB Event Watcher service not detected.");
	-- do nothing
elseif (nServiceState == 1) then -- service is present but stopped. Set flag.
	bServiceExists = true;
	fDebug("INFO:  USB Event Watcher service detected but not running.");
elseif (nServiceState > 1) then -- service is running.Set flag and stop service.
	fDebug("INFO: USB Event Watcher service detected and running. State returned: "..nServiceState);
	bServiceExists = true;
	fDebug("INFO: Stopping USB Event Watcher service and waiting 5 seconds... ")
	Service.Stop(ServiceDisplayName, "", 5);
	Application.Sleep(5000);
else
	bContinue = false;
	fDebug("Error getting USB Event Watcher service state. State returned: "..nServiceState);
end

-- Create root driver folder if it does not already exist.
if bContinue then
	if not(Folder.DoesExist(pathServiceFolder)) then
		fDebug("INFO:  Creating Service folder at: "..pathServiceFolder);
		Folder.Create(pathServiceFolder);
		error = Application.GetLastError();
		if (error ~= 0) then
			bContinue = false;
			fDebug("Creating service folder at "..pathServiceFolder.." failed with error: "..error);
		end
	else
		fDebug("INFO:  Service folder exists at: "..pathServiceFolder);	
	end
end


-- copy the files appropriate for the OS bit width
if bContinue then
	local installServiceFolder = _SourceFolder.."\\Service\\"..OSTypeFolder;
	if (Folder.DoesExist(installServiceFolder)) then
		fDebug("INFO:  Installation Service folder found at: "..installServiceFolder);
		File.Copy(installServiceFolder.."\\*.*", pathServiceFolder, false, true, true, true, nil);
		error = Application.GetLastError();
		if (error ~= 0) then
			bContinue = false;
			fDebug("Error: Driver file copy from: "..installServiceFolder.." to: "..pathServiceFolder.." failed with error: "..error);
		else
			fDebug("INFO: Service files copied from: "..installServiceFolder.." to: "..pathServiceFolder);
		end
	else
		fDebug("ERROR:  Installation Service folder not found at: "..installServiceFolder);
	end
end


-- create the service if it does not already exist and then start it
if bContinue then
	if not(bServiceExists) then
		fDebug("INFO:  Creating service and waiting 3 seconds... ");	
		Service.Create(pathServiceFolder.."\\dxp01XPSWinService.exe", ServiceDisplayName, ServiceKeyName, SERVICE_WIN32_OWN_PROCESS, false, SERVICE_AUTO_START, SERVICE_ERROR_NORMAL, "", nil, nil, "", "");
		Application.Sleep(3000);
	end
	fDebug("INFO:  Starting service and waiting 3 seconds... ");	
	Service.Start(ServiceDisplayName, "", nil);
	Application.Sleep(3000);
	
	local nServiceState = Service.Query(ServiceDisplayName, "");
	if (nServiceState == 4) then
		fDebug("INFO: USB Event Watcher Service is running!");
	elseif (nServiceState == 2) then
		fDebug("WARNING: USB Event Watcher Service is still starting.  Check the Services control panel to make sure it starts.");
	else
		fDebug("ERROR: USB Service did not start. Its state is reported as: "..nServiceState);
		bContinue = false;
	end
end


-- Send a signal back to the main script using the bContinueInstall flag.
if bContinue then
	bContinueInstall = true;
	fDebug("SUCCESS: USB Service installed and started.");
else
	bContinueInstall = false;
	fDebug("FAILURE: USB Service failed to install.");
end

