--[[
******************************************************************
Script to copy the uninstaller to the APP folder and provide a short-cut to launch it.
Moved this from the Copy_Driver_Files script on 7-21-2012 as part of the v4.0 installation changes.

******************************************************************
]]--

fDebug("\r\nInstalling the driver uninstall program...");

-- bOverwriteFiles does not matter for this script because existing files are deleted before new
-- files are copied.  Set to true so it always has a known good value.
bOverwriteFiles = true;


-- Create a folder name specific for the OS type (32-bit or 64-bit) to use later when building paths.
local OSTypeFolder = "";
if (System.Is64BitOS()) then
 	OSTypeFolder = "AMD64";
else
	OSTypeFolder = "x86"; -- this naming covention is unique to the uninstaller.
end

-- initialize local variables
local bContinue = true;
local error = 0;
local pathCommonAppDataFolder = Shell.GetFolder(SHF_APPLICATIONDATA_COMMON);
local pathRootDriverFolder = pathCommonAppDataFolder.."\\Datacard\\XPS Card Printer";

-- Stand-alone uninstall variables
local strUninstallExeName = "dxp01uninst41.exe";
local strUninstallPathOnDisk = pathRootDriverFolder.."\\"..strUninstallExeName;
local strUninstallPathOnMedia = _SourceFolder.."\\AutoPlay\\Uninstall\\"..OSTypeFolder.."\\dxp01uninst.exe";
local strLanguageResourcesPathOnMedia = _SourceFolder.."\\AutoPlay\\Uninstall\\*.dll";
local strStartMenu = Shell.GetFolder(SHF_STARTMENU_COMMON);
local pathStartMenuShortcut = "";
-- Branding logic for start menu shortcut
if (OEMDetected) then
	if (OEMTag == "OEM01") then -- Polaroid
		pathStartMenuShortcut = strStartMenu.."\\Valid USA Printers";
	end
else
	pathStartMenuShortcut = strStartMenu.."\\Datacard Printers";
end

--[[
******************************************************************
KCF 5-18-2012: Added the following block of code for v3.1 driver release
Get localized shortcut name from current language file if there is one.
******************************************************************
]]--
local strUninstallShortcutName = "";
local strUninstallShortcutName = XML.GetValue("DXP01/UninstallStartMenuText");
if String.Length(strUninstallShortcutName) < 4 then -- 4 was an arbitrary number.
	strUninstallShortcutName = "XPS Card Printer Uninstall";
end

--[[
******************************************************************
Create folder to hold the driver files. If it already exists
remove the old files and Start menu shortcut.
******************************************************************
 ]]--

-- Create root driver folder if it does not already exist.
if not (Folder.DoesExist(pathRootDriverFolder)) then
	Folder.Create(pathRootDriverFolder);
	error = Application.GetLastError();
	if (error ~= 0) then
		bContinue = false;
		fDebug("Creating root driver folder at "..pathRootDriverFolder.." failed with error: "..error);
	end
else -- the folder exists so an old uninstall exists.  Remove old version files.
	Shell.DeleteShortcut(pathStartMenuShortcut, strUninstallShortcutName);
	File.Delete(pathRootDriverFolder.."\\dxp01uninst*.*", false, false, true);
end

--[[
****************************************************************************
Copy uninstall file and resource dlls to disk in the root driver folder.

KF NOTE: The uninstall exe file was given a new name in v4.1.333 (3-31-2013) 
to workaround an issue where the exe would be deleted after the update restart 
if the v4.1 driver was updated over the v4.0 driver with no restart between 
the installations. If we need to repeat this in the future, just modify the
variable at the start of this script by changing the version number in the name.
****************************************************************************
]]--
fDebug("INFO: Copying uninstall exe to "..strUninstallPathOnDisk);
if (File.DoesExist(strUninstallPathOnMedia)) then
	File.Copy(strUninstallPathOnMedia, strUninstallPathOnDisk, false, bOverwriteFiles, true, true, nil);
	error = Application.GetLastError();
	if (error ~= 0) then
		fDebug("ERROR: Driver uninstall file copy to "..strUninstallPathOnDisk.." failed with error: "..error);
		bContinue = false;
	end
else
	fDebug("ERROR: Driver uninstall file not found at "..strUninstallPathOnMedia);
	bContinue = false;
end

--[[
****************************************************************************
 Copy uninstall translated resource files.
****************************************************************************
]]--
fDebug("INFO: Copying uninstall language resources to "..pathRootDriverFolder);
if (bContinue) then
	File.Copy(strLanguageResourcesPathOnMedia, pathRootDriverFolder, false, bOverwriteFiles, true, true, nil);
	error = Application.GetLastError();
	if (error ~= 0) then
		fDebug("ERROR: Driver uninstall language files copy to "..pathRootDriverFolder.." failed with error: "..error);
	end
end

--[[
****************************************************************************
 Create unistall shortcut
****************************************************************************
]]--
if (bContinue) then
	fDebug("INFO: Creating uninstall shortcut: "..strUninstallShortcutName.." at: "..pathStartMenuShortcut.." for: "..strUninstallPathOnDisk);
	Shell.CreateShortcut(pathStartMenuShortcut, strUninstallShortcutName, strUninstallPathOnDisk, "", "", "", 0, SW_SHOWNORMAL, nil);
	error = Application.GetLastError();
	if (error ~= 0) then
		fDebug("ERROR: Create shortcut failed with error: "..error);
	else
		fDebug("INFO: completed adding shortcut to Start menu");
	end
end

-- Send a signal back to the main script using the bContinueInstall flag.
if (bContinue) then
	bContinueInstall = true;
	fDebug("SUCCESS: Install_Uninstaller script completed without error.\r\n");
else
	bContinueInstall = false;
	fDebug("FAIL: Install_Uninstaller script terminated with an error.\r\n");
end
