--[[ 
==============================================================================================
Script to determine if the Evergreen driver is installed.

 **** NOTES ****
9-14-11: Ken Fischer: PTR 512: Modified to resolve issue where share client is detected as an 
installed driver, even though it is not a full driver. Need to find a driver file that is only 
installed on the share host. Sangeeta provided the answer.  The file I am looking for is OK but 
the location should be changed to the System32 folder instead of the 3 folder.

Global variables:
IsDriverInstalled  - returned to the calling script
strDriverVersion - returned to the calling script
===============================================================================================
]]--

fDebug("[Script Start]: IsDriverInstalled");
IsDriverInstalled = false;
strDriverVersion = "";
local strDriverFileToCheck = "dxp01mon.dll";

if (System.Is64BitOS()) then -- if 64 bit OS turn off redirection
  DLL.CallFunction("kernel32.dll", "Wow64DisableWow64FsRedirection", "\""..Application.GetWndHandle().."\"", DLL_RETURN_TYPE_LONG, DLL_CALL_STDCALL);
end

fDebug("  Looking in folder: ".._SystemFolder.." for file: "..strDriverFileToCheck.."...");

if (File.DoesExist(_SystemFolder.."\\"..strDriverFileToCheck)) then
	IsDriverInstalled = true;
	local DriverFileInfo = File.GetVersionInfo(_SystemFolder.."\\"..strDriverFileToCheck);
	-- Get the last error code
	local nError = Application.GetLastError();
	if (nError == 0) then
    	-- There was not an error
    	strDriverVersion = DriverFileInfo.ProductVersion;
    	fDebug("  INFO: Driver version found.");
	else
    	-- There was an error.
    	strDriverVersion = "?";
    	fDebug("  ERROR: Driver found, but version check failed. Error number: "..nError);
	end
else
	fDebug("  INFO: No driver file found.");
end

if (System.Is64BitOS()) then -- if 64 bit OS turn redirection back on.
  DLL.CallFunction("kernel32.dll", "Wow64RevertWow64FsRedirection", "\""..Application.GetWndHandle().."\"" , DLL_RETURN_TYPE_LONG, DLL_CALL_STDCALL);
end

fDebug("[Script Exit]: IsDriverInstalled \r\n");