-- 
-- Script to determine if shared Evergreen driver client is installed.
-- Copied from the script IsDriverInstalled.lua for the v2.1 installation.
-- This script only works if there isn't a full driver installed on the system.  If there
-- is, it will return a false positive.
-- 
IsShareClientInstalled = false;
strShareClientVersion = "";

if (System.Is64BitOS()) then
	OSDriverFolder = "x64";
else
	OSDriverFolder = "w32x86";
end	

if (File.DoesExist(_SystemFolder.."\\spool\\drivers\\"..OSDriverFolder.."\\3\\dxp01mon.dll")) then
	IsShareClientInstalled = true;
	local DriverFileInfo = File.GetVersionInfo(_SystemFolder.."\\spool\\drivers\\"..OSDriverFolder.."\\3\\dxp01mon.dll");
	-- Get the last error code
	local nError = Application.GetLastError();
	if nError == 0 then
    	-- There was not an error
    	strShareClientVersion = DriverFileInfo.ProductVersion;
	else
    	-- There was an error.
    	strShareClientVersion = "?";
	end
end