--[[ 
============================================================================================================
Check if the spooler service is running and if it isn't attempt to start it.
============================================================================================================
]]--
	fDebug("[Script Start]: IsSpoolerRunning");
	bContinueInstall = true;	-- global used to communicate back to caller
	local ServiceToQueryDisplay = "Print Spooler";
	local ServiceToQueryKey = "Spooler";
	local LastError = 0;
	
	local QueryResult = Service.Query(ServiceToQueryDisplay, ServiceToQueryKey);
	if not (QueryResult == SERVICE_RUNNING) then -- The service is not running.	    
	    LastError = 0; -- reset LastError to 0 so it is in a known good state to start with.
	    if (QueryResult == SERVICE_PAUSED) then
	    	fDebug("  Spooler service is paused. Attempting to restore to running state...");	
	        Service.Continue(ServiceToQueryDisplay, ServiceToQueryKey); -- The service is paused, try continue
	        LastError = Application.GetLastError();
	    elseif (QueryResult == SERVICE_STOPPED) then
	    	fDebug("  Spooler service is stopped. Attempting to restart...");
	        Service.Start(ServiceToQueryDisplay, ServiceToQueryKey, nil); -- The service is stopped, try start
	        LastError = Application.GetLastError();
	    else -- State being returned is neither running, stopped, nor paused. Bail out because we need the spooler running.
	    	fDebug("  ERROR: Spooler service is returning state: "..QueryResult..". Driver installation will terminate.");
	    	bContinueInstall = false;
	    end  
	     
	    if (LastError ~= 0) then
	        fDebug("  FAIL: Failed to get spooler service into running state.");
	        bContinueInstall = false;
	    end    
	    if bContinueInstall then --recheck that the spooler is running
	        fDebug("  Checking that spooler service has be restored to a running state...");
	        for serviceStartRecheckCount = 1, 5, 1 do
	        	Application.Sleep(2000);
	        	if (Service.Query(ServiceToQueryDisplay, ServiceToQueryKey) == SERVICE_RUNNING) then
	        		bContinueInstall = true;
	        		break
	        	end	
	        end				
		    if bContinueInstall then
		    	fDebug("  SUCCESS: The spooler service is running.");
		    else
		    	fDebug("  FAIL: Failed to get spooler service into running state.  State returned: "..QueryResult..".");
		    end	
	    end
	else -- The service is running
		bContinueInstall = true;
	    fDebug("  SUCCESS: The spooler service is running.");
	end
	fDebug("[Script Exit]: IsSpoolerRunning \r\n");