--[[ 
====================================================================================
Script to determine if the DPX01 USBLAN driver is installed.
Assumes that finding the Belcarra driver in the system32\drivers folder means the 
USBLAN driver is installed.

Returns booleans
bUSBLANDriverInstalled - tells calling function if the USBLAN driver is installed
bContinueInstall
bScriptRanToCompletion
====================================================================================
]]--
fDebug("[Script Start]: IsUSBLANDriverInstalled");
bUSBLANDriverInstalled = false; -- returned to the calling script

if (System.Is64BitOS()) then -- if 64 bit OS turn off redirection
  DLL.CallFunction("kernel32.dll", "Wow64DisableWow64FsRedirection", "\""..Application.GetWndHandle().."\"", DLL_RETURN_TYPE_LONG, DLL_CALL_STDCALL);
end

local strDriverFileToCheck = _SystemFolder.."\\Drivers\\dxp01bdblan.sys";
fDebug("  Looking for USBLAN driver file: "..strDriverFileToCheck.."...");
if (File.DoesExist(strDriverFileToCheck)) then
	bUSBLANDriverInstalled = true;
	bContinueInstall = true;
	local tVersionInfo = File.GetVersionInfo(strDriverFileToCheck);
	local strInstalledBelcarraVersion = tVersionInfo.FileVersion;
	fDebug("  INFO: USBLAN driver found. File version: "..strInstalledBelcarraVersion);
else
	bUSBLANDriverInstalled = false;
	local lastError = Application.GetLastError();
	if (lastError ~= 0) then
		fDebug("  ERROR: Attempt to find "..strDriverFileToCheck.." failed with error: "..lastError);
		bContinueInstall = false;
	else
		bContinueInstall = true;
	end
	fDebug("  INFO: No USBLAN driver file found.");
end

if (System.Is64BitOS()) then -- if 64 bit OS turn redirection back on.
  DLL.CallFunction("kernel32.dll", "Wow64RevertWow64FsRedirection", "\""..Application.GetWndHandle().."\"" , DLL_RETURN_TYPE_LONG, DLL_CALL_STDCALL);
end

bScriptRanToCompletion = true;
fDebug("[Script Exit]: IsUSBLANDriverInstalled \r\n");
