--[[ 
============================================================================================================
Places driver files in a location that the OS expects to find driver files. 

** NOTE ** This script relies on the files being installed on disk by the Copy_Driver_Files.lua script.

bContinueInstall is a global flag that is uses to let the calling app know if the action succeeded of failed.
============================================================================================================
]]--
fDebug("[Script Start]: Stage_USBLANDriver...");
bContinueInstall = true;

local pathCommonAppDataFolder = Shell.GetFolder(SHF_APPLICATIONDATA_COMMON);
local pathDpinstExeFolder = pathCommonAppDataFolder.."\\Datacard\\XPS Card Printer";
local dpinstExe = "";
local strInstalledPrinterName = "XPS Card Printer";
local dpinstParams = "";
local dpinstQuietParam = "";
	
-- create variable to hold location of the dpinst exe.
if (System.Is64BitOS()) then
	dpinstExe = pathDpinstExeFolder.."\\dpinst64.exe";
else
	dpinstExe = pathDpinstExeFolder.."\\dpinst32.exe";
end

-- If the driver is signed using the Datacard certificate we cannot do a silent install.
if (UseDCGCert) then
	fDebug("  INFO: Datacard signed. Staging will ask user to trust our install.");
	dpinstQuietParam = "";
else
	dpinstQuietParam = " /q /sw /f";
end	
dpinstParams = dpinstQuietParam.." /sa";


-- =============================================================
-- Stage the Belcarra USBLAN driver. 
-- =============================================================
fDebug("  INFO: Staging USB driver... ");
local dpinstRtnAsNumber = 0;
fDebug("  INFO: Calling "..dpinstExe.." with parameters: "..dpinstParams.." using files from: "..pathDpinstExeFolder.."\\USB");
local nStagingStatus = File.Run(dpinstExe, dpinstParams.." /path USB", pathDpinstExeFolder, SW_SHOWNORMAL, true);
--[[******************* IMPLEMENATION NOTE ******************************************
dpinst has returned.  Check its return value to see if driver got staged.
These return code values are masked hex values.  See this link for details:
http://msdn.microsoft.com/en-us/library/windows/hardware/ff544790(v=vs.85).aspx
Because we are staging one driver package, the two values we should see are 100 and 0.
100 = driver staged, 0 = driver already staged 
**************************************************************************************
]]--		
local dpinstRtnAsHexCode = string.format("%X", nStagingStatus);
dpinstRtnAsNumber = String.ToNumber(dpinstRtnAsHexCode);
fDebug("  INFO: USB dpinst return code: "..dpinstRtnAsNumber);
if (dpinstRtnAsNumber > 100) then
	-- KCF 9-28-12: Changed this from test for not 100 and not 0.  Found that reinstalling USB using AutoPlay returned a 1 which is also valid. 
	-- Rather than add another and to the logic decided based on the MSDN information below that anything 100 or less is good. 
	-- DPINST return codes: http://msdn.microsoft.com/en-us/library/windows/hardware/ff544790(v=vs.85).aspx
	fDebug("FAIL: USB dpinst failed. Trying pnpUtil next.");
	-- Need to determine if pnputil.exe is on this system. 
    -- Disable file system redirection for 64-bit OS or the Shell Execute cannot find pnputil.exe
	if (System.Is64BitOS()) then
		fDebug("  INFO: 64-bit OS detected. Temporarily disabling file system redirection.");
		DLL.CallFunction(_WindowsFolder.."\\SysWOW64\\kernel32.dll", "Wow64DisableWow64FsRedirection", "\""..Application.GetWndHandle().."\"", DLL_RETURN_TYPE_LONG, DLL_CALL_STDCALL); 
	end		
	fDebug("  Checking if system contains PnPutil.exe...");
	local PnpUtilFound = File.DoesExist(_SystemFolder.."\\PnPutil.exe");
	if (PnpUtilFound) then
		fDebug("  INFO: Found pnputil.exe");
		-- Run pnputil.exe.  NOTE: You must run from the directory containing the INF files or this will not work!!
		local ArgWorkingDir = pathDpinstExeFolder.."\\USB";
		fDebug("  INFO: Running pnputil.exe against INF files at: "..ArgWorkingDir);
		local RtnCode = File.Run(_SystemFolder.."\\pnputil.exe", "-a *.INF", ArgWorkingDir, SW_HIDE, true);
		-- Check to see if an error occurred when launching the file.
		local LastError = Application.GetLastError();
		-- If an error occurred, display an error message to the user.
		if (LastError == 0) then
			bContinueInstall = true;
			fDebug("  INFO: USB driver files staged using pnputil.");
		else
			bContinueInstall = false;
			fDebug("FAIL: USB driver files not staged. Call to pnputil failed with error: "..LastError..": ".._tblErrorMessages[LastError]);
		end		
	else -- pnputil.exe not avaialable. Return failed and stop installation.
		bContinueInstall = false;
		fDebug("FAIL: USB driver files not staged. dpinst failed and pnputil not available. \r\n");
	end
	-- Need to reenable file system redirection so system acts as expected.
	if (System.Is64BitOS()) then
		fDebug("INFO: 64-bit OS detected. Re-enabling file system redirection.");
		DLL.CallFunction(_WindowsFolder.."\\SysWOW64\\kernel32.dll", "Wow64RevertWow64FsRedirection", "\""..Application.GetWndHandle().."\"" , DLL_RETURN_TYPE_LONG, DLL_CALL_STDCALL);
	end		
end

fDebug("[Script Exit]: Stage_USBLANDriver \r\n");	