--[[
Update an installed driver with the new version when only network drivers are installed

Prerequisties
=============
Update requires that the installed driver is at least version 4.0


Returned:
=========
bContinueInstall is a global flag that is uses to let the calling app know if the action succeeded of failed.
bScriptRanToCompletion tells calling app that script ran.
]]--

fDebug("[Script Start]: UpdateDriver_NetworkOnly.lua");
bContinueInstall = true;
bScriptRanToCompletion = false;
local pathCommonAppDataFolder = Shell.GetFolder(SHF_APPLICATIONDATA_COMMON);
local pathDpinstFolder = pathCommonAppDataFolder.."\\Datacard\\XPS Card Printer";
local LastError = 0;
local dpinstExe = "";

if (System.Is64BitOS()) then
	dpinstExe = pathDpinstFolder.."\\dpinst64.exe";
else
	dpinstExe = pathDpinstFolder.."\\dpinst32.exe";
end

local dpinstQuietParam = "";
if (UseDCGCert) then
	fDebug("INFO: Datacard signed. Staging will ask user to trust our install.");
	dpinstQuietParam = " ";
else
	dpinstQuietParam = " /q /sw ";
end	

if bDebugOn then
	dpinstQuietParam = dpinstQuietParam.."/c ";
end	

--[[ 
============================================================
        FUNCTIONS
============================================================ 
]]--
function CopyDriverFilesToCommonAppFolders()
	fDebug("  INFO: Copying files to XPS Card Printer folder.");
	bOverwriteFiles = true;
	Application.RunScriptFile("AutoPlay\\Scripts\\Copy_Driver_Files.lua");
	if bContinueInstall then
		return true;
	else
		return false;
	end		
end


function RestartSpoolerService()
	fDebug("  INFO: Making sure Spooler is running.");
	Application.RunScriptFile("AutoPlay\\Scripts\\IsSpoolerRunning.lua");
	if bContinueInstall then
		return true;
	else
		return false;
	end		
end


function UpdatePrinterDriver() 
	fDebug("  INFO: Using rundll32 to stage the driver...");
	local strInstalledPrinterName = "XPS Card Printer"; -- Name of our driver.  Do Not Change!
	local nRtnCode = Shell.Execute(_SystemFolder.."\\rundll32.exe", "open", _SystemFolder.."\\printui.dll,PrintUIEntry /ia /m\""..strInstalledPrinterName.."\" /f\""..pathDpinstFolder.."\\network\\dxp01drv.inf\"", "", SW_SHOWNORMAL, true);
	local nLastError = Application.GetLastError();
	fDebug("  INFO: rundll32 of printui dll return code: "..nRtnCode.."  GetLastError value is: "..nLastError);	
	if (nLastError ~= 0) then
		bContinueInstall = false;
		fDebug("  ERROR: Driver not updated. Call to PrintUIEntry of printui dll failed with error: "..LastError..": ".._tblErrorMessages[LastError].."\r\n");
		return false;
	end
	return true;	
end		


function InstallDriverUninstallUtility()
	fDebug("  INFO: Installing uninstall utility...");
	Application.RunScriptFile("AutoPlay\\Scripts\\Install_Uninstaller.lua");
	if bContinueInstall then
		return true;
	else
		fDebug("  WARNING: Uninstall utility did not install properly. Driver update will continue.");
		return false;
	end		
end

--[[
========================================================
 CALL THE FUNCTIONS
========================================================
]]--

-- Copy installation files over existing files in CommonAppData folders
if not(CopyDriverFilesToCommonAppFolders()) then
	bContinueInstall = false;
	fDebug("  FAILED: Driver files did not copy to CommonAppFolder.");
end


-- Make sure the spooler is running
if not(RestartSpoolerService()) then
	bContinueInstall = false;
	fDebug("  FAILED: Spooler could not be started.");
end


-- Update the printer driver using the new driver files
if bContinueInstall then 
	if not(UpdatePrinterDriver()) then
		bContinueInstall = false;
		fDebug("  FAILED: Printer driver was not staged.");
	end
end

-- Update the driver uninstall utility. Continue even if this fails.
if bContinueInstall then
	InstallDriverUninstallUtility()
end


-- END
bScriptRanToCompletion = true;
fDebug("[Script Exit]: UpdateDriver_NetworkOnly \r\n");
return;