/*
 * Decompiled with CFR 0.152.
 */
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class DLSInstallerListener
extends SimpleInstallerListener {
    protected static final String strUsbfs = "usbfs                   /proc/bus/usb           usbfs   noauto,devmode=0666 0 0\n";
    protected static final String strSysInit = "[ -d /proc/bus/usb ] && mount usbfs\n";
    protected int numCommPorts = 4;
    protected String strInstallPath;
    protected ArrayList<File> fileList = new ArrayList();
    protected AbstractUIProgressHandler handler;
    protected boolean bUpdateClasspath = false;
    protected boolean bUpdateComport = false;
    protected boolean bUpdateUsb = false;
    protected boolean bUpdateLibrarypath = false;

    public DLSInstallerListener() {
        try {
            String str = System.getProperty("os.name");
            str = str.toUpperCase();
            if (!OsVersion.IS_WINDOWS && !(str = System.getProperty("user.name")).equals("root")) {
                System.out.print("\r\nSorry: " + str + ", but setup.jar must be run as root\r\n\r\n");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private FileOutputStream getOutputStream(String fileName) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(fileName);
        }
        catch (FileNotFoundException e) {
            outputStream = null;
        }
        catch (SecurityException se) {
            outputStream = null;
        }
        return outputStream;
    }

    @Override
    public boolean isFileListener() {
        return true;
    }

    @Override
    public void beforeFile(File file, PackFile pf) throws Exception {
        if (file != null) {
            this.fileList.add(file);
        }
    }

    @Override
    public void afterFile(File fileIn, PackFile pf) throws Exception {
        if (fileIn == null) {
            return;
        }
        this.chmod(fileIn.getAbsolutePath(), 666);
        if (pf.getAdditionals() == null) {
            return;
        }
        Object file = pf.getAdditionals().get("chmod.file");
        int fileVal = -1;
        if (file != null && file instanceof Integer) {
            fileVal = (Integer)file;
        }
        this.chmod(fileIn.getAbsolutePath(), fileVal);
    }

    @Override
    public void afterDir(File dirPath, PackFile pf) throws Exception {
        if (dirPath == null) {
            return;
        }
        this.chmod(dirPath.getAbsolutePath(), 777);
        if (pf.getAdditionals() == null) {
            return;
        }
        Object file = pf.getAdditionals().get("chmod.dir");
        int fileVal = -1;
        if (file != null && file instanceof Integer) {
            fileVal = (Integer)file;
        }
        this.chmod(dirPath.getAbsolutePath(), fileVal);
    }

    @Override
    public void beforePack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
        String str = pack.name;
        if (str != null) {
            if (str.equals("Update CLASSPATH")) {
                this.bUpdateClasspath = true;
            } else if (str.equals("Update COM port Access")) {
                this.bUpdateComport = true;
            } else if (str.equals("Update USB Access")) {
                this.bUpdateUsb = true;
            } else if (str.equals("Update LD_LIBRARY_PATH")) {
                this.bUpdateLibrarypath = true;
            }
        }
    }

    @Override
    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        this.strInstallPath = idata.getInstallPath();
        this.handler = handler;
        if (this.bUpdateUsb) {
            this.updateFSTab();
        }
        if (this.bUpdateComport) {
            this.updateLocal();
        }
        if (this.bUpdateClasspath) {
            this.updateClassPath();
        }
        if (this.bUpdateLibrarypath) {
            this.updateLibraryPath();
        }
        if (OsVersion.IS_WINDOWS) {
            handler.emitNotification("A system reboot is required for changes to take effect.");
        } else {
            handler.emitNotification("A Logoff and Logon is required for changes to take effect.");
        }
        FileExecutor fe = null;
        String[] output = null;
        if (System.getProperty("sun.arch.data.model").contains("32")) {
            String[] params = new String[]{"ln", "-s", this.strInstallPath + "/SupportJars/libJavaxUsb32.so", this.strInstallPath + "/SupportJars/libJavaxUsb.so"};
            output = new String[2];
            fe = new FileExecutor();
            fe.executeCommand(params, output);
        } else {
            String[] params = new String[]{"ln", "-s", this.strInstallPath + "/SupportJars/libJavaxUsb64.so", this.strInstallPath + "/SupportJars/libJavaxUsb.so"};
            output = new String[2];
            fe = new FileExecutor();
            fe.executeCommand(params, output);
        }
        this.cleanup();
    }

    protected void cleanup() {
    }

    protected void updateFSTab() {
        if (OsVersion.IS_WINDOWS) {
            return;
        }
        this.updateSysInit();
        FileExecutor fe = new FileExecutor();
        String[] output = new String[2];
        if (this.findAndReplace("/etc/fstab", "usbfs", strUsbfs, false)) {
            String[] umount = new String[]{"umount", "usbfs"};
            fe.executeCommand(umount, output);
            String[] mount = new String[]{"mount", "usbfs"};
            fe.executeCommand(mount, output);
        } else {
            String[] umount2 = new String[]{"umount", "/proc/bus/usb"};
            fe.executeCommand(umount2, output);
            String[] mount2 = new String[]{"mount", "-n", "-t", "usbfs", "-o", "devmode=0666", "/proc/bus/usb", "/proc/bus/usb"};
            fe.executeCommand(mount2, output);
        }
        this.chmod("/etc/fstab", 644);
    }

    protected void updateLocal() {
        File f;
        if (OsVersion.IS_WINDOWS) {
            return;
        }
        if (!new File("/etc/rc.d/boot.local").canWrite()) {
            // empty if block
        }
        String strFilename = (f = new File("/etc/rc.d/boot.local")).exists() && f.canWrite() ? "/etc/rc.d/boot.local" : "/etc/rc.d/rc.local";
        for (int i = 0; i < this.numCommPorts; ++i) {
            String strFind = "stty --file=/dev/ttyS" + Integer.toString(i) + " raw";
            String strReplace = strFind + "\n";
            this.findAndReplace(strFilename, strFind, strReplace, true);
            String[] params = new String[]{"stty", "--file=/dev/ttyS" + Integer.toString(i), "raw"};
            FileExecutor fe = new FileExecutor();
            String[] output = new String[2];
            fe.executeCommand(params, output);
            strFind = "chmod a+rw /dev/ttyS" + Integer.toString(i);
            strReplace = strFind + "\n";
            this.findAndReplace(strFilename, strFind, strReplace, true);
            this.chmod("/dev/ttyS" + Integer.toString(i), 666);
        }
        this.chmod(strFilename, 755);
    }

    protected void updateSysInit() {
        if (OsVersion.IS_WINDOWS) {
            return;
        }
        String strFilename = "/etc/rc.d/rc.sysinit";
        ArrayList<String> v = new ArrayList<String>();
        try {
            FileInputStream fis = new FileInputStream(strFilename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String str = br.readLine();
            while (str != null) {
                if (str.indexOf("mount -n -t usbfs") >= 0 && str.indexOf("devmode=0666") < 0) {
                    v.add(str);
                }
                str = br.readLine();
            }
        }
        catch (NullPointerException npe) {
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        int pos = 0;
        for (String str : v) {
            pos = str.indexOf("mount -n -t usbfs");
            if (pos < 0) continue;
            try {
                String strTmp = str.substring(0, pos + 18) + "-o devmode=0666 " + str.substring(pos + 18) + "\n";
                this.findAndReplace(strFilename, str, strTmp, false);
            }
            catch (Exception e) {}
        }
        this.chmod("/etc/rc.d/rc.sysinit", 755);
    }

    protected void addHexClassPath(String strFilename, String strEnv, String strHexValue) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            String str = "";
            FileInputStream fis = new FileInputStream(strFilename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            str = br.readLine();
            while (str != null) {
                list.add(str);
                str = br.readLine();
            }
            br.close();
            fis.close();
            File delFile = new File(strFilename);
            delFile.delete();
            FileOutputStream fos = new FileOutputStream(strFilename);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
            Iterator it = list.iterator();
            while (it.hasNext()) {
                str = (String)it.next();
                String strTmp = str.toUpperCase();
                int pos = 12;
                if (strTmp.indexOf("\"" + strEnv + "\"") == 0) {
                    while (it.hasNext() && str.charAt(str.length() - 1) == '\\') {
                        str = (String)it.next();
                    }
                    bw.write("\"" + strEnv + "\"=");
                    for (int i = 0; i < strHexValue.length(); ++i) {
                        bw.write(strHexValue.charAt(i));
                        if (++pos <= 78 || strHexValue.charAt(i) != ',') continue;
                        pos = 2;
                        bw.write("\\\n  ");
                    }
                    bw.write("\n");
                    continue;
                }
                bw.write(str + "\n");
            }
            bw.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void updateWindowsPath(String strEnv, String strDLSEnv, String strPath) {
        try {
            int i;
            boolean bFound = false;
            int pos = 0;
            String strClassPathReg = "c:\\ClassPath.reg";
            String strHex = "";
            String[] params = new String[]{"regedit", "/E:A", strClassPathReg, "\"HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment\""};
            String[] output = new String[2];
            FileExecutor fe = new FileExecutor();
            fe.executeCommand(params, output);
            FileInputStream fis = new FileInputStream(strClassPathReg);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String strIn = br.readLine();
            while (strIn != null) {
                String str = strIn.toUpperCase();
                if (str.indexOf("\"" + strEnv + "\"=") == 0) {
                    pos = strIn.indexOf("=");
                    strHex = strIn.substring(pos + 1);
                    if (strHex.indexOf("hex(2):") != 0) {
                        byte[] bIn = strHex.getBytes();
                        int prvCh = 32;
                        strHex = "hex(2):";
                        for (i = 1; i < bIn.length - 1; ++i) {
                            if (prvCh != 92 || bIn[i] != 92) {
                                strHex = strHex + Integer.toHexString(bIn[i]) + (bIn.length == i - 1 ? "" : ",");
                            }
                            prvCh = (char)bIn[i];
                        }
                        strHex = strHex + "00";
                    }
                    bFound = true;
                    break;
                }
                String strTmp = strIn = br.readLine();
                while (strTmp != null && strTmp.length() != 0 && strTmp.charAt(strTmp.length() - 1) == '\\') {
                    strTmp = br.readLine();
                    if (strTmp == null || strTmp.length() == 0) continue;
                    strIn = strIn.substring(0, strIn.length() - 1);
                    strIn = strIn + strTmp.trim();
                }
            }
            br.close();
            fis.close();
            String strHexDLSEnv = "";
            for (int i2 = 0; i2 < strDLSEnv.length(); ++i2) {
                strHexDLSEnv = strHexDLSEnv + Integer.toHexString(strDLSEnv.charAt(i2)) + ",";
            }
            if (bFound) {
                if (strHex.indexOf(strHexDLSEnv) < 0) {
                    String[] bytes = strHex.split(",");
                    strHex = "";
                    for (i = 0; i < bytes.length && !bytes[i].equals("00"); ++i) {
                        strHex = strHex + bytes[i] + ",";
                    }
                    strHex = strHex + "3b,25," + strHexDLSEnv + "25,00";
                    this.addHexClassPath(strClassPathReg, strEnv, strHex);
                }
            } else {
                this.findAndReplace(strClassPathReg, "\"" + strEnv + "\"=", "\"" + strEnv + "\"=hex(2):25," + strHexDLSEnv + "25,00\n", true);
            }
            byte[] buf = strPath.getBytes();
            strPath = "";
            for (i = 0; i < buf.length; ++i) {
                strPath = buf[i] == 92 ? strPath + "\\\\" : strPath + (char)buf[i];
            }
            this.findAndReplace(strClassPathReg, "\"" + strDLSEnv + "\"=", "\"" + strDLSEnv + "\"=" + "\"" + strPath + "\"\n", true);
            String[] params2 = new String[]{"regedit", "/s", strClassPathReg};
            fe.executeCommand(params2, output);
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    protected void updateClassPath() {
        String strFSep;
        String strSep;
        if (OsVersion.IS_WINDOWS) {
            strSep = ";";
            strFSep = "\\";
        } else {
            strSep = ":";
            strFSep = "/";
        }
        String strPath = null;
        String strTemp = null;
        String strClassPath = this.strInstallPath + strSep + this.strInstallPath + strFSep + "SupportJars" + strSep;
        String strEnvPath = this.strInstallPath + strSep + this.strInstallPath + strFSep + "SupportJars" + strSep;
        Iterator<File> it = this.fileList.iterator();
        String strSave = "";
        while (it.hasNext()) {
            File element = it.next();
            strPath = element.getAbsolutePath();
            if (strPath == null || (strTemp = strPath.toUpperCase()).indexOf(".JAR") <= 0) continue;
            if (strTemp.indexOf("LINUX_COMM") > 0) {
                strSave = strPath + strSep;
                continue;
            }
            strClassPath = strClassPath + strPath + strSep;
        }
        if (OsVersion.IS_WINDOWS) {
            this.updateWindowsPath("CLASSPATH", "DLS_CLASSPATH", strClassPath);
            this.updateWindowsPath("PATH", "DLS_PATH", strEnvPath);
        } else {
            this.chmod("/etc/profile", 644);
        }
    }

    protected void updateLibraryPath() {
        if (OsVersion.IS_WINDOWS) {
            return;
        }
        String strSep = ":";
        String strFSep = "/";
        String strSoPath = this.strInstallPath + strFSep + "SupportJars";
        this.findAndReplace("/etc/profile", "DLS_LD_LIBRARY_PATH=", "DLS_LD_LIBRARY_PATH=" + strSoPath + "\n", true);
        this.findAndReplace("/etc/profile", "LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$DLS_LD_LIBRARY_PATH", "LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$DLS_LD_LIBRARY_PATH\n", true);
        this.findAndReplace("/etc/profile", "export LD_LIBRARY_PATH", "export LD_LIBRARY_PATH\n", true);
        this.chmod("/etc/profile", 644);
    }

    protected boolean findAndReplace(String strFilename, String strFind, String strReplace, boolean bWriteIfNotFound) {
        boolean bFound = false;
        File f = new File(strFilename);
        if (!f.exists()) {
            return bFound;
        }
        String strTempExtension = "dls";
        String strBakExtension = "bak";
        try {
            File newFile = null;
            String str = "";
            File oldFile = new File(strFilename + "." + strTempExtension);
            oldFile.delete();
            oldFile = new File(strFilename + "." + strBakExtension);
            oldFile.delete();
            FileOutputStream fos = new FileOutputStream(strFilename + "." + strTempExtension);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
            FileInputStream fis = new FileInputStream(strFilename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            try {
                str = br.readLine();
                while (str != null) {
                    if (str.indexOf(strFind) == 0) {
                        bFound = true;
                        bw.write(strReplace);
                    } else {
                        bw.write(str + "\n");
                    }
                    str = br.readLine();
                }
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            if (!bFound && bWriteIfNotFound) {
                bw.write(strReplace);
                bFound = true;
            }
            bw.close();
            br.close();
            if (bFound) {
                oldFile = new File(strFilename);
                newFile = new File(strFilename + "." + strBakExtension);
                oldFile.renameTo(newFile);
                oldFile = new File(strFilename + "." + strTempExtension);
                newFile = new File(strFilename);
                oldFile.renameTo(newFile);
            }
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return bFound;
    }

    protected void chmod(String strPath, int permissions) {
        if (OsVersion.IS_WINDOWS || strPath == null) {
            return;
        }
        try {
            File path = new File(strPath);
            if (!path.exists()) {
                return;
            }
            String permStr = Integer.toString(permissions);
            String[] params = new String[]{"chmod", permStr, path.getAbsolutePath()};
            String[] output = new String[2];
            FileExecutor fe = new FileExecutor();
            fe.executeCommand(params, output);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setInstalldata(AutomatedInstallData data) {
        data.info.setAppVersion("1.14.006");
    }
}

