/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.common;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Branding {
    public static final String DEF_MFGNAME = "Datalogic Scanning";
    public static final String DEF_MFGSNAME = "DLA";
    public static final String DEF_NAME = "Datalogic ADC";
    public static final String DEF_PREFIX = "dls";
    public static final String DEF_PRODUCT = "DLSJavaPOS";
    public static final String DELIM_PREFIX = "{BP}";
    public static final String FILE_BRANDING = "brand.properties";
    public static final String KEY_MFGNAME = "ManufacturerName";
    public static final String KEY_MFGSNAME = "ManufacturerShortName";
    public static final String KEY_NAME = "BrandingName";
    public static final String KEY_PREFIX = "BrandingPrefix";
    public static final String KEY_PRODUCT = "BrandedProduct";
    private static volatile Branding sm_branding = null;
    private Properties m_props = new Properties();
    private static final Logger m_log = LogManager.getLogger(Branding.class);

    private Branding() {
    }

    public String getBrandedDevice(String sSrc) {
        String sRes = null;
        if (sSrc != null) {
            sRes = sSrc.replace(DELIM_PREFIX, this.getBrandingPrefix().toUpperCase());
        }
        return sRes;
    }

    public String getBrandedProduct() {
        return this.m_props.getProperty(KEY_PRODUCT, DEF_PRODUCT);
    }

    public String getBrandedPropName(String sSrc) {
        String sRes = null;
        if (sSrc != null) {
            sRes = sSrc.replace(DELIM_PREFIX, this.getBrandingPrefix());
        }
        return sRes;
    }

    public String getBrandingName() {
        return this.m_props.getProperty(KEY_NAME, DEF_NAME);
    }

    public String getBrandingPrefix() {
        return this.m_props.getProperty(KEY_PREFIX, DEF_PREFIX);
    }

    public static Branding getInstance() {
        Branding oBranding = null;
        if (sm_branding == null) {
            oBranding = new Branding();
            oBranding.load();
            sm_branding = oBranding;
        }
        return sm_branding;
    }

    public String getManufacturerName() {
        return this.m_props.getProperty(KEY_MFGNAME, DEF_MFGNAME);
    }

    public String getManufacturerShortName() {
        return this.m_props.getProperty(KEY_MFGSNAME, DEF_MFGSNAME);
    }

    protected void load() {
        FileInputStream oIn = null;
        this.m_props = new Properties();
        try {
            oIn = new FileInputStream(FILE_BRANDING);
        }
        catch (FileNotFoundException ex) {
            m_log.error("load: Branding File not found. ", (Throwable)ex);
            return;
        }
        try {
            this.m_props.load(oIn);
        }
        catch (IOException ex) {
            m_log.error("load: Failed to load branding. ", (Throwable)ex);
            try {
                oIn.close();
            }
            catch (IOException exc) {
                m_log.error("load: Failed to close file. ", (Throwable)exc);
            }
            return;
        }
        catch (IllegalArgumentException ex) {
            m_log.error("load: Illegal argument. ", (Throwable)ex);
            try {
                oIn.close();
            }
            catch (IOException exc) {
                m_log.error("load: Failed to close file. ", (Throwable)exc);
            }
            return;
        }
        try {
            oIn.close();
        }
        catch (IOException ex) {
            m_log.error("load: Failed to close file. ", (Throwable)ex);
        }
    }
}

