/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.common;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import jpos.config.JposEntry;
import jpos.config.JposEntryRegistry;
import jpos.config.simple.SimpleEntry;
import jpos.loader.JposServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DLSCConfig {
    String[][] strConfigArray;
    private String strLogicalName;
    private String strTrue = "TRUE";
    private String strOne = "1";
    public HashMap<String, String> mapConfig = new HashMap();
    public HashMap<String, Object> mapConfigItems = new HashMap();
    protected static final String DLS_USB_FLASH = "DLS-USB-Flash";
    private static final Logger m_log = LogManager.getLogger(DLSCConfig.class);

    protected abstract String[][] getConfigArray();

    public boolean loadConfiguration(String strLogicalName) {
        int i;
        m_log.trace("loadConfiguration (in): " + strLogicalName);
        this.strConfigArray = this.getConfigArray();
        boolean bRc = true;
        this.strLogicalName = strLogicalName;
        for (int i2 = 0; i2 < this.strConfigArray.length; ++i2) {
            String put = this.mapConfig.put(this.strConfigArray[i2][0], this.strConfigArray[i2][1]);
        }
        JposEntryRegistry registry = JposServiceLoader.getManager().getEntryRegistry();
        JposEntry entry = registry.getJposEntry(strLogicalName);
        m_log.debug("loadConfiguration: Entry = " + entry.toString());
        Enumeration e = entry.getPropertyNames();
        while (e.hasMoreElements()) {
            String param = (String)e.nextElement();
            boolean isHex = param.matches("[0-9a-fA-F]+");
            if (param.length() != 4 || !isHex) continue;
            String contents = this.readOption(entry, param, "0000");
            Object put = this.mapConfigItems.put(param, contents);
        }
        for (i = 0; i < this.strConfigArray.length; ++i) {
            this.strConfigArray[i][1] = this.readOption(entry, this.strConfigArray[i][0], this.strConfigArray[i][1]);
        }
        this.mapConfig.clear();
        for (i = 0; i < this.strConfigArray.length; ++i) {
            String put = this.mapConfig.put(this.strConfigArray[i][0], this.strConfigArray[i][1]);
        }
        m_log.trace("loadConfiguration (out)");
        return bRc;
    }

    public boolean saveConfiguration() {
        m_log.trace("saveConfiguration (in)");
        if (this.strLogicalName == null) {
            m_log.trace("saveConfiguration (out): false");
            return false;
        }
        try {
            JposEntryRegistry registry = JposServiceLoader.getManager().getEntryRegistry();
            registry.load();
            JposEntry entry = registry.getJposEntry(this.strLogicalName);
            if (entry == null) {
                entry = new SimpleEntry();
                entry.addProperty("logicalName", this.strLogicalName);
                registry.addJposEntry(entry);
            }
            this.saveConfiguration(entry);
            registry.save();
        }
        catch (Exception e) {
            m_log.error("Error saving configuration: " + this.strLogicalName + ", ", (Throwable)e);
            m_log.trace("saveConfiguration (out): false");
            return false;
        }
        m_log.trace("saveConfiguration (out): true");
        return true;
    }

    public boolean saveConfiguration(JposEntry entry) {
        m_log.trace("saveConfiguration (in)");
        try {
            if (entry != null) {
                for (Map.Entry<String, String> e : this.mapConfig.entrySet()) {
                    String sName = e.getKey();
                    String sValue = e.getValue();
                    if (entry.hasPropertyWithName(sName)) {
                        entry.modifyPropertyValue(sName, sValue);
                        continue;
                    }
                    entry.addProperty(sName, sValue);
                }
            }
        }
        catch (Exception e) {
            m_log.error("Error saving configuration: " + this.strLogicalName + ", ", (Throwable)e);
            m_log.trace("saveConfiguration (out): false");
            return false;
        }
        m_log.trace("saveConfiguration (out): true");
        return true;
    }

    public String getLogicalName() {
        return this.strLogicalName;
    }

    protected String readOption(JposEntry entry, String strOption, String strDefault) {
        String strRetValue = strDefault;
        String strValue = null;
        try {
            strValue = (String)entry.getPropertyValue(strOption);
        }
        catch (ClassCastException cce) {
            try {
                strValue = ((Integer)entry.getPropertyValue(strOption)).toString();
            }
            catch (ClassCastException cce2) {
                try {
                    Boolean b = (Boolean)entry.getPropertyValue(strOption);
                    strValue = b.booleanValue() ? "1" : "0";
                }
                catch (ClassCastException cce3) {
                    // empty catch block
                }
            }
        }
        if (strValue != null) {
            strRetValue = strValue;
        }
        return strRetValue;
    }

    public boolean getOptionAsBoolean(String strOption) {
        String strValue = "";
        String strStored = this.getOption(strOption);
        if (strStored != null) {
            strValue = strStored.toUpperCase();
        }
        return strValue.equals(this.strTrue) || strValue.equals(this.strOne);
    }

    public int getOptionAsInt(String strOption) {
        String strValue = this.getOption(strOption).replaceAll("[^\\d.]", "");
        int nRet = 0;
        try {
            nRet = Integer.parseInt(strValue);
        }
        catch (NumberFormatException nfe) {
            m_log.error("Error converting int: " + strOption + ":" + strValue, (Throwable)nfe);
        }
        return nRet;
    }

    public int getOptionAsIntHex(String strOption) {
        String strValue = this.getOption(strOption);
        int nRet = 0;
        try {
            nRet = Integer.parseInt(strValue, 16);
        }
        catch (NumberFormatException nfe) {
            m_log.error("Error converting int: " + strOption + ":" + strValue, (Throwable)nfe);
        }
        return nRet;
    }

    public String getOption(String strOption) {
        String strValue = "";
        try {
            strValue = this.mapConfig.get(strOption);
        }
        catch (NullPointerException npe) {
            m_log.error("Error getOption: " + strOption + ": null", (Throwable)npe);
        }
        return strValue;
    }

    public void setOption(String strOption, boolean bValue) {
        if (bValue) {
            this.setOption(strOption, "True");
        } else {
            this.setOption(strOption, "False");
        }
    }

    public void setOption(String strOption, int nValue) {
        this.setOption(strOption, Integer.toString(nValue));
    }

    public void setOption(String strOption, String strValue) {
        this.mapConfig.put(strOption, strValue);
    }
}

