/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.common;

import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.interpretation.DLS8xxxScanner;
import com.dls.jpos.interpretation.DLS9xxxScanner;
import com.dls.jpos.interpretation.DLSPortalScanner;
import com.dls.jpos.interpretation.DLSSCSerialScale;
import com.dls.jpos.interpretation.DLSSCSerialScanner;
import com.dls.jpos.interpretation.DLSScale;
import com.dls.jpos.interpretation.DLSScanner;
import com.dls.jpos.interpretation.DLSSerialScale;
import com.dls.jpos.interpretation.DLSSerialScanner;
import com.dls.jpos.interpretation.DLSUSBScale;
import com.dls.jpos.interpretation.DLSUSBScanner;
import com.dls.jpos.transport.DLSPort;
import com.dls.jpos.transport.DLSSerialPort;
import com.dls.jpos.transport.DLSTCPIPPort;
import com.dls.jpos.transport.DLSUsbJavax;
import com.dls.jpos.transport.DLSUsbWin32;
import java.io.File;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSObjectFactory {
    private static HashMap<Object, Object> hashPorts = new HashMap();
    public static final String TCPIP_DEVICE_BUS = "TCPIP";
    private static final Logger m_log = LogManager.getLogger(DLSObjectFactory.class);

    public static DLSPort createPort(DLSDeviceInfo info) throws DLSException {
        m_log.trace("createPort (in)");
        String bus = info.getDeviceBus();
        if (bus.equals("USB") || bus.equals("HID")) {
            if (info.getUsage() != 0) {
                if (File.separatorChar == '\\') {
                    m_log.trace("createPort (out) - WindowsUSB");
                    return new DLSUsbWin32(info);
                }
                m_log.debug("createPort (out) - LinuxUSB");
                return new DLSUsbJavax(info);
            }
            m_log.error("USB defined, but no USAGE ID available - createPort() error.");
            throw new DLSException(-2147483645, "Error creating port");
        }
        if (bus.equals(TCPIP_DEVICE_BUS)) {
            m_log.debug("createPort (out) - TCPIP");
            return new DLSTCPIPPort(info);
        }
        DLSSerialPort wp = (DLSSerialPort)hashPorts.get(info.getPort());
        if (wp == null) {
            wp = new DLSSerialPort(info);
            hashPorts.put(info.getPort(), wp);
        }
        m_log.debug("createPort() - SerialPortRXTX");
        DLSSerialPort p = wp;
        m_log.trace("createPort (out) - Serialport");
        return p;
    }

    public static DLSScanner createScanner(String strLogicalName) throws DLSException {
        m_log.trace("createScanner (in): " + strLogicalName);
        DLSScanner scanner = null;
        m_log.debug("createScanner: Creating DeviceInfo object for instantiation of scanner.");
        DLSDeviceInfo info = new DLSDeviceInfo();
        m_log.debug("createScanner: calling info.loadConfiguration() to populate values.");
        info.loadConfiguration(strLogicalName);
        m_log.debug("createScanner: testing USB bus type");
        if (info.getDeviceBus().equals("USB") || info.getDeviceBus().equals("HID")) {
            m_log.info("createScanner: create DLSUSBScanner()");
            scanner = new DLSUSBScanner();
        } else if (info.getDeviceBus().equals("RS232")) {
            if (info.getSingleCable()) {
                m_log.info("createScanner: create DLSSCSerialScanner()");
                scanner = new DLSSCSerialScanner();
            } else if (info.get8xxx()) {
                m_log.info("createScanner: create DLS8xxxScanner()");
                scanner = new DLS8xxxScanner();
            } else if (info.get9xxx()) {
                m_log.info("createScanner: create DLS9xxxScanner()");
                scanner = new DLS9xxxScanner();
            } else {
                m_log.info("createScanner: create DLSSerialScanner()");
                scanner = new DLSSerialScanner();
            }
        } else if (info.getDeviceBus().equals(TCPIP_DEVICE_BUS)) {
            m_log.info("createScanner: create DLSPortalScanner()");
            scanner = new DLSPortalScanner();
        } else {
            m_log.info("createScanner: Unable to detect scanner connect type.  Configuration ERROR in jpos.xml");
            throw new DLSException(-2147483643, "jpos.xml config error");
        }
        m_log.trace("createScanner (out)");
        return scanner;
    }

    public static DLSScale createScale(String strLogicalName) throws DLSException {
        m_log.trace("createScale (in): " + strLogicalName);
        DLSScale scale = null;
        DLSDeviceInfo info = new DLSDeviceInfo();
        info.loadConfiguration(strLogicalName);
        if (info.getDeviceBus().equals("USB") || info.getDeviceBus().equals("HID")) {
            m_log.info("create DLSUSBScale()");
            scale = new DLSUSBScale();
        } else if (info.getDeviceBus().equals("RS232")) {
            if (info.getSingleCable()) {
                m_log.info("create DLSSCSerialScale()");
                scale = new DLSSCSerialScale();
            } else {
                m_log.info("create DLSSerialScale()");
                scale = new DLSSerialScale();
            }
        } else {
            m_log.error("Unable to detect scale connect type.  Configuration ERROR in jpos.xml");
            throw new DLSException(-2147483643, "jpos.xml config error");
        }
        m_log.trace("createScale (out)");
        return scale;
    }
}

