/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.common;

import com.dls.jpos.common.Branding;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSProperties {
    public static final String KEY_TEMPDIR = "TempDir";
    public static final String KEY_HDLRESETTIME = "HDLResetWaitTime";
    public static final String KEY_RECORDRETRY = "HDLRecordRetry";
    public static final String ENV_TEMP = "TEMP";
    private static DLSProperties sm_instance;
    protected SortedProperties prop = null;
    protected ArrayList<PropertiesListener> eventListeners;
    String strClasspathLocation = null;
    private Logger m_log = LogManager.getLogger(DLSProperties.class);

    private DLSProperties() {
        this.eventListeners = new ArrayList();
    }

    public void addEventListener(PropertiesListener pl) {
        this.eventListeners.add(pl);
    }

    private FileInputStream findFileInClasspath(String fileName) {
        String classpath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        String fileSeparator = System.getProperty("file.separator");
        FileInputStream inputStream = null;
        String path = "";
        StringTokenizer tokenizer = new StringTokenizer(classpath, pathSeparator, false);
        while (tokenizer.hasMoreTokens()) {
            try {
                path = tokenizer.nextToken().trim();
                if (path.equals("")) continue;
                File location = new File(path);
                if (location.isDirectory()) {
                    this.strClasspathLocation = path;
                    if (!fileName.startsWith(fileSeparator) && !path.endsWith(fileSeparator)) {
                        this.strClasspathLocation = this.strClasspathLocation + fileSeparator;
                    }
                    this.strClasspathLocation = this.strClasspathLocation + fileName;
                    inputStream = this.getInputStream(this.strClasspathLocation);
                    if (inputStream != null) break;
                    this.strClasspathLocation = null;
                    continue;
                }
                if (!path.contains(fileName)) continue;
                this.strClasspathLocation = path;
                inputStream = this.getInputStream(path);
                break;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                this.m_log.error("findFileInClasspath: Error locating file. ", (Throwable)e);
            }
        }
        return inputStream;
    }

    public int getRecordRetry() {
        return this.get(KEY_RECORDRETRY, 5);
    }

    public String getTempDir() {
        String sDef = "";
        sDef = File.separator.equals("\\") ? System.getenv(ENV_TEMP) : "/tmp";
        String sDir = this.get(KEY_TEMPDIR, sDef);
        if (sDir.isEmpty()) {
            sDir = sDef;
        }
        if (!sDir.endsWith("\\") && !sDir.endsWith("/")) {
            sDir = sDir + File.separator;
        }
        return sDir;
    }

    protected void fireOptionsLoadedEvent() {
        Enumeration<PropertiesListener> e = Collections.enumeration(this.eventListeners);
        while (e.hasMoreElements()) {
            PropertiesListener listener = e.nextElement();
            listener.onOptionsLoaded();
        }
    }

    protected void fireOptionsSavedEvent() {
        Enumeration<PropertiesListener> e = Collections.enumeration(this.eventListeners);
        while (e.hasMoreElements()) {
            PropertiesListener listener = e.nextElement();
            listener.onOptionsSaved();
        }
    }

    public int get(String strOption, int nDefault) {
        String strValue = this.get(strOption, Integer.toString(nDefault));
        if (strValue.isEmpty()) {
            return nDefault;
        }
        return Integer.parseInt(strValue);
    }

    public boolean get(String strOption, boolean bDefault) {
        String strValue = this.get(strOption, Boolean.toString(bDefault));
        if (strValue.isEmpty()) {
            return bDefault;
        }
        return strValue.equals("1") || strValue.equals("-1") || strValue.toUpperCase().equals("TRUE");
    }

    public String get(String strOption, String strDefault) {
        String strValue = this.prop.getProperty(strOption);
        if (strValue == null) {
            this.prop.setProperty(strOption, strDefault);
            strValue = strDefault;
        }
        return strValue;
    }

    public int getHDLResetTime() {
        return this.get(KEY_HDLRESETTIME, 30);
    }

    public static synchronized DLSProperties getInstance() {
        if (sm_instance == null) {
            sm_instance = new DLSProperties();
            sm_instance.load();
        }
        return sm_instance;
    }

    private FileOutputStream getOutputStream(String fileName) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(fileName);
        }
        catch (FileNotFoundException e) {
            this.m_log.error("getOutputStream: Exception getting output stream. ", (Throwable)e);
            outputStream = null;
        }
        catch (SecurityException se) {
            this.m_log.error("getOutputStream: Security Exception. ", (Throwable)se);
            outputStream = null;
        }
        return outputStream;
    }

    public SortedProperties getProps() {
        return this.prop;
    }

    public Enumeration getPropsEnum() {
        return this.prop.propertyNames();
    }

    protected void load() {
        Branding oBr = Branding.getInstance();
        String sPropFile = oBr.getBrandingPrefix() + ".properties";
        try {
            this.prop = new SortedProperties();
            String separator = System.getProperty("file.separator");
            InputStream inProp = null;
            File dlsProperties = new File(sPropFile);
            inProp = this.getInputStream(sPropFile);
            if (inProp == null) {
                String tempFile;
                inProp = this.getInputStream(".." + separator + "config" + separator + sPropFile);
                dlsProperties = new File(".." + separator + "config" + separator + sPropFile);
                if (inProp == null && (inProp = this.findFileInClasspath(sPropFile)) == null && (inProp = this.getInputStream(tempFile = this.tempFile())) == null) {
                    inProp = this.getClass().getResourceAsStream(sPropFile);
                }
            }
            if (inProp != null) {
                this.prop.load(inProp);
                inProp = null;
            }
            this.fireOptionsLoadedEvent();
        }
        catch (IOException ioe) {
            this.m_log.error("load: Exception loading file. ", (Throwable)ioe);
        }
    }

    public void removeEventListener(PropertiesListener pl) {
        this.eventListeners.remove(pl);
    }

    public void save() {
        Branding oBr = Branding.getInstance();
        String sPropFile = oBr.getBrandingPrefix() + ".properties";
        String separator = System.getProperty("file.separator");
        FileOutputStream outProp = null;
        outProp = this.getOutputStream(sPropFile);
        if (outProp == null && (outProp = this.getOutputStream(".." + separator + "config" + separator + sPropFile)) == null) {
            if (this.strClasspathLocation != null) {
                outProp = this.getOutputStream(this.strClasspathLocation);
            }
            if (outProp == null) {
                String tempFile = this.tempFile();
                outProp = this.getOutputStream(tempFile);
            }
        }
        try {
            String sOut = oBr.getBrandedProduct() + " properties file.  Copyright (C) " + oBr.getBrandingName();
            this.prop.store(outProp, sOut);
        }
        catch (IOException ex) {
            this.m_log.error("save: Exception saving file. ", (Throwable)ex);
        }
        this.fireOptionsSavedEvent();
    }

    public void set(String strOption, String strValue) {
        this.prop.setProperty(strOption, strValue);
    }

    public void set(String strOption, boolean bValue) {
        String strValue = bValue ? "true" : "false";
        this.set(strOption, strValue);
    }

    public void set(String strOption, int nValue) {
        String strValue = Integer.toString(nValue);
        this.set(strOption, strValue);
    }

    public String tempFile() {
        Branding oBr = Branding.getInstance();
        String sPropFile = oBr.getBrandingPrefix() + ".properties";
        String tempDir = System.getProperty("java.io.tmpdir");
        String separator = System.getProperty("file.separator");
        String tempFile = tempDir + (tempDir.endsWith(separator) ? "" : separator) + sPropFile;
        return tempFile;
    }

    private FileInputStream getInputStream(String fileName) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            this.m_log.error("getInputStream: Exception getting input stream. ", (Throwable)e);
            inputStream = null;
        }
        catch (SecurityException se) {
            this.m_log.error("getInputStream: Security Exception. ", (Throwable)se);
            inputStream = null;
        }
        return inputStream;
    }

    public static class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        @Override
        public Enumeration<Object> keys() {
            Enumeration<Object> keysEnum = super.keys();
            ArrayList<Object> keyList = new ArrayList<Object>();
            while (keysEnum.hasMoreElements()) {
                keyList.add(keysEnum.nextElement());
            }
            Collections.sort(keyList, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            Enumeration<Object> sortedKeys = Collections.enumeration(keyList);
            return sortedKeys;
        }
    }

    public static interface PropertiesListener {
        public void onOptionsLoaded();

        public void onOptionsSaved();
    }
}

