/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.common;

import com.dls.jpos.common.DLSCConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSScaleConfig
extends DLSCConfig {
    public static final String KEY_CANACCEPTSTATISTICSCMD = "canAcceptStatisticsCmd";
    public static final String KEY_CANNOTIFYPOWERCHANGE = "canNotifyPowerChange";
    public static final String KEY_CANSTATUSUPDATE = "canStatusUpdate";
    public static final String KEY_DISPLAYREQUIRED = "displayRequired";
    public static final String KEY_ENFORCEZERORETURN = "enforceZeroReturn";
    public static final String KEY_FIVEDIGITWEIGHT = "fiveDigitWeight";
    public static final String KEY_INDICATEZEROWITHLED = "indicateZeroWithLED";
    public static final String KEY_LIVEWEIGHTPOLLRATE = "liveWeightPollRate";
    public static final String KEY_MBEANSENABLED = "MBeansEnabled";
    public static final String KEY_METRICWEIGHTMODE = "metricWeightMode";
    public static final String KEY_OPERATIONMODE = "operationMode";
    public static final String KEY_VIBRATIONSENSITIVITY = "vibrationSensitivity";
    public static final String KEY_WMIENABLED = "WMIEnabled";
    public static final String KEY_ZEROVALID = "zeroValid";
    protected String[][] strConfig = new String[][]{{"operationMode", "0"}, {"displayRequired", "True"}, {"indicateZeroWithLED", "True"}, {"metricWeightMode", "False"}, {"enforceZeroReturn", "False"}, {"vibrationSensitivity", "2"}, {"fiveDigitWeight", "True"}, {"canStatusUpdate", "True"}, {"liveWeightPollRate", "250"}, {"zeroValid", "False"}, {"WMIEnabled", "False"}, {"MBeansEnabled", "False"}, {"canAcceptStatisticsCmd", "False"}, {"canNotifyPowerChange", "False"}};
    private static final Logger m_log = LogManager.getLogger(DLSScaleConfig.class);

    public DLSScaleConfig() {
    }

    public DLSScaleConfig(byte[] abConfig) {
        this();
        this.loadConfig(abConfig);
    }

    private void loadConfig(byte[] abConfig) {
        if (abConfig == null) {
            m_log.error("loadConfig: null byte array supplied.");
            return;
        }
        if (abConfig.length < 6) {
            m_log.error("loadConfig: invalid byte array supplied, must be at least 6 bytes.");
            return;
        }
        this.setOperationMode(abConfig[3] & 3);
        this.setDisplayRequired((abConfig[3] & 4) == 4);
        this.setIndicateZeroWithLED((abConfig[3] & 8) == 8);
        this.setMetricWeightMode((abConfig[3] & 0x10) == 16);
        this.setEnforceZeroReturn((abConfig[3] & 0x20) == 32);
        this.setVibrationSensitivity((abConfig[3] & 0xC0) >> 6);
        this.setFiveDigitWeight((abConfig[4] & 1) == 1);
    }

    public boolean getCanAcceptStatisticsCmd() {
        return this.getOptionAsBoolean(KEY_CANACCEPTSTATISTICSCMD);
    }

    public boolean getCanNotifyPowerChange() {
        return this.getOptionAsBoolean(KEY_CANNOTIFYPOWERCHANGE);
    }

    public boolean getCanStatusUpdate() {
        return this.getOptionAsBoolean(KEY_CANSTATUSUPDATE);
    }

    @Override
    protected String[][] getConfigArray() {
        return this.strConfig;
    }

    public boolean getDisplayRequired() {
        return this.getOptionAsBoolean(KEY_DISPLAYREQUIRED);
    }

    public boolean getEnforceZeroReturn() {
        return this.getOptionAsBoolean(KEY_ENFORCEZERORETURN);
    }

    public boolean getFiveDigitWeight() {
        return this.getOptionAsBoolean(KEY_FIVEDIGITWEIGHT);
    }

    public boolean getIndicateZeroWithLED() {
        return this.getOptionAsBoolean(KEY_INDICATEZEROWITHLED);
    }

    public int getLiveWeightPoll() {
        return this.getOptionAsInt(KEY_LIVEWEIGHTPOLLRATE);
    }

    public boolean getMBeansEnabled() {
        return this.getOptionAsBoolean(KEY_MBEANSENABLED);
    }

    public boolean getMetricWeightMode() {
        return this.getOptionAsBoolean(KEY_METRICWEIGHTMODE);
    }

    public int getOperationMode() {
        return this.getOptionAsInt(KEY_OPERATIONMODE);
    }

    public int getVibrationSensitivity() {
        return this.getOptionAsInt(KEY_VIBRATIONSENSITIVITY);
    }

    public boolean getWMIEnabled() {
        return this.getOptionAsBoolean(KEY_WMIENABLED);
    }

    public boolean getZeroValid() {
        return this.getOptionAsBoolean(KEY_ZEROVALID);
    }

    public void setCanAcceptStatisticsCmd(boolean bValue) {
        this.setOption(KEY_CANACCEPTSTATISTICSCMD, bValue);
    }

    public void setCanNotifyPowerChange(boolean bValue) {
        this.setOption(KEY_CANNOTIFYPOWERCHANGE, bValue);
    }

    public void setCanStatusUpdate(int nValue) {
        this.setOption(KEY_CANSTATUSUPDATE, nValue);
    }

    public void setDisplayRequired(boolean bValue) {
        this.setOption(KEY_DISPLAYREQUIRED, bValue);
    }

    public void setEnforceZeroReturn(boolean bValue) {
        this.setOption(KEY_ENFORCEZERORETURN, bValue);
    }

    public void setFiveDigitWeight(boolean bValue) {
        this.setOption(KEY_FIVEDIGITWEIGHT, bValue);
    }

    public void setIndicateZeroWithLED(boolean bValue) {
        this.setOption(KEY_INDICATEZEROWITHLED, bValue);
    }

    public void setLiveWeighPoll(int nValue) {
        this.setOption(KEY_LIVEWEIGHTPOLLRATE, nValue);
    }

    public void setMBeansEnabled(boolean bValue) {
        this.setOption(KEY_MBEANSENABLED, bValue);
    }

    public void setMetricWeightMode(boolean bValue) {
        this.setOption(KEY_METRICWEIGHTMODE, bValue);
    }

    public void setOperationMode(int nValue) {
        this.setOption(KEY_OPERATIONMODE, nValue);
    }

    public void setVibrationSensitivity(int nValue) {
        this.setOption(KEY_VIBRATIONSENSITIVITY, nValue);
    }

    public void setWMIEnabled(boolean bValue) {
        this.setOption(KEY_WMIENABLED, bValue);
    }

    public void setZeroValid(boolean bValue) {
        this.setOption(KEY_ZEROVALID, bValue);
    }

    public String toString() {
        StringBuilder oOut = new StringBuilder();
        String sSep = System.getProperty("line.separator");
        oOut.append("displayRequired: ");
        oOut.append(this.getDisplayRequired());
        oOut.append(sSep);
        oOut.append("enforceZeroReturn: ");
        oOut.append(this.getEnforceZeroReturn());
        oOut.append(sSep);
        oOut.append("fiveDigitWeight: ");
        oOut.append(this.getFiveDigitWeight());
        oOut.append(sSep);
        oOut.append("indicateZeroWithLED: ");
        oOut.append(this.getIndicateZeroWithLED());
        oOut.append(sSep);
        oOut.append("metricWeightMode: ");
        oOut.append(this.getMetricWeightMode());
        oOut.append(sSep);
        oOut.append("operationMode: ");
        oOut.append(this.getOperationMode());
        oOut.append(sSep);
        oOut.append("vibrationSensitivity: ");
        oOut.append(this.getVibrationSensitivity());
        oOut.append(sSep);
        return oOut.toString();
    }
}

