/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.common;

import com.dls.jpos.common.Branding;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSRegistry;
import com.dls.jpos.common.FunctionLib;
import com.dls.jpos.interpretation.DLSDevice;
import com.dls.jpos.service.WMIService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSStatistics {
    private static volatile DLSStatistics instance = null;
    private int numDevices = 0;
    private int devicesProcessed = 0;
    private ArrayList<Object> attachedDevices = new ArrayList();
    private HashMap<String, Object> primaryScannerStats = null;
    public HashMap<Character, String> infoIdToLabel = new HashMap();
    public HashMap<Character, String> healthIdToLabel = new HashMap();
    public HashMap<Character, String> statIdToLabel = new HashMap();
    public HashMap<String, Object> wmi_upos_map = new HashMap();
    private DLSProperties options = null;
    private static final Logger m_log = LogManager.getLogger(DLSStatistics.class);

    private DLSStatistics() {
        this.infoIdToLabel.put(Character.valueOf('M'), "ModelNumber");
        this.infoIdToLabel.put(Character.valueOf('S'), "SerialNumber");
        this.infoIdToLabel.put(Character.valueOf('m'), "ScannerBoardSerialNumber");
        this.infoIdToLabel.put(Character.valueOf('A'), "FirmwareVersionNumber");
        this.infoIdToLabel.put(Character.valueOf('R'), "ScannerRevisionNumber");
        this.infoIdToLabel.put(Character.valueOf('C'), "ConfigFileVersionNumber");
        this.infoIdToLabel.put(Character.valueOf('B'), "ScannerBootROMID");
        this.infoIdToLabel.put(Character.valueOf('H'), "RadiolHardwareVersion");
        this.infoIdToLabel.put(Character.valueOf('U'), "CometROMID");
        this.infoIdToLabel.put(Character.valueOf('u'), "CometBootROMID");
        this.infoIdToLabel.put(Character.valueOf('W'), "ScaleInformation");
        this.infoIdToLabel.put(Character.valueOf('D'), "DisplayVersion");
        this.infoIdToLabel.put(Character.valueOf('E'), "EASVersion");
        this.infoIdToLabel.put(Character.valueOf('I'), "ScannerInterface");
        this.infoIdToLabel.put(Character.valueOf('r'), "RadioSoftwareVersion");
        this.infoIdToLabel.put(Character.valueOf('b'), "GunBootloaderVersion");
        this.infoIdToLabel.put(Character.valueOf('L'), "RadioBootloaderVersion");
        this.infoIdToLabel.put(Character.valueOf('X'), "BaseModelNumber");
        this.infoIdToLabel.put(Character.valueOf('F'), "FPGAVersion");
        this.infoIdToLabel.put(Character.valueOf('i'), "NumberOfAttachedDevices");
        this.infoIdToLabel.put(Character.valueOf('f'), "TDR_FPGAVersion");
        this.infoIdToLabel.put(Character.valueOf('P'), "IPEAppVersion");
        this.infoIdToLabel.put(Character.valueOf('l'), "USBLoaderVersion");
        this.infoIdToLabel.put(Character.valueOf('Q'), "SDRAMCfgVersion");
        this.infoIdToLabel.put(Character.valueOf('V'), "VisionLibraryVersion");
        this.infoIdToLabel.put(Character.valueOf('v'), "VirtualScanLineLibraryVersion");
        this.healthIdToLabel.put(Character.valueOf('m'), "MotorHealth");
        this.healthIdToLabel.put(Character.valueOf('h'), "VerticalLaserHealth");
        this.healthIdToLabel.put(Character.valueOf('v'), "HorizontalLaserHealth");
        this.healthIdToLabel.put(Character.valueOf('s'), "ScaleHealth");
        this.healthIdToLabel.put(Character.valueOf('d'), "RemoteDisplayHealth");
        this.healthIdToLabel.put(Character.valueOf('e'), "EASHealth");
        this.healthIdToLabel.put(Character.valueOf('c'), "CameraHealth");
        this.healthIdToLabel.put(Character.valueOf('r'), "RadiolHealth");
        this.healthIdToLabel.put(Character.valueOf('H'), "USBHandheldConnected");
        this.healthIdToLabel.put(Character.valueOf('D'), "USBSerialDongleConnected");
        this.healthIdToLabel.put(Character.valueOf('0'), "IPE0Health");
        this.healthIdToLabel.put(Character.valueOf('1'), "IPE1Health");
        this.healthIdToLabel.put(Character.valueOf('2'), "IPE2Health");
        this.healthIdToLabel.put(Character.valueOf('3'), "IPE3Health");
        this.healthIdToLabel.put(Character.valueOf('S'), "ScaleSentryHealth");
        this.statIdToLabel.put(Character.valueOf('P'), "HoursPoweredCount");
        this.statIdToLabel.put(Character.valueOf('m'), "MotorTime");
        this.statIdToLabel.put(Character.valueOf('l'), "LaserTime");
        this.statIdToLabel.put(Character.valueOf('L'), "GoodScanCount");
        this.statIdToLabel.put(Character.valueOf('z'), "ScaleZeroed");
        this.statIdToLabel.put(Character.valueOf('c'), "ScaleCalibrations");
        this.statIdToLabel.put(Character.valueOf('C'), "CustomData");
        this.statIdToLabel.put(Character.valueOf('E'), "EASDeactivations");
        this.statIdToLabel.put(Character.valueOf('e'), "EASManualPresses");
        this.statIdToLabel.put(Character.valueOf('B'), "BatteryChargeCycles");
        this.statIdToLabel.put(Character.valueOf('T'), "TriggerPulls");
        this.statIdToLabel.put(Character.valueOf('K'), "KeyPresses");
        this.statIdToLabel.put(Character.valueOf('R'), "TotalResets");
        this.statIdToLabel.put(Character.valueOf('r'), "ErrorResets");
        this.statIdToLabel.put(Character.valueOf('V'), "VerticalIPEForcedResets");
        this.statIdToLabel.put(Character.valueOf('H'), "HorizontalIPEForcedResets");
        this.statIdToLabel.put(Character.valueOf('D'), "Forced2DResets");
        this.statIdToLabel.put(Character.valueOf('Q'), "TDRForcedResets");
        this.statIdToLabel.put(Character.valueOf('v'), "VertExcessiveResets");
        this.statIdToLabel.put(Character.valueOf('h'), "HorzExcessiveResets");
        this.statIdToLabel.put(Character.valueOf('d'), "2DExcessiveResets");
        this.statIdToLabel.put(Character.valueOf('q'), "TRDExcessiveResets");
        this.statIdToLabel.put(Character.valueOf('Z'), "POSZeroRequests");
        this.statIdToLabel.put(Character.valueOf('X'), "EnforcedZeroEvents");
        this.statIdToLabel.put(Character.valueOf('S'), "ScaleSentryEvents");
        this.statIdToLabel.put(Character.valueOf('Y'), "EASRuntimeFaults");
        this.options = DLSProperties.getInstance();
    }

    public static DLSStatistics getInstance() {
        if (instance == null) {
            instance = new DLSStatistics();
        }
        return instance;
    }

    public HashMap<String, Object> compileStatistics(DLSDevice device) throws DLSException {
        this.primaryScannerStats = new HashMap();
        String[] statisticsData = new String[]{};
        statisticsData = device.getStatisticsData(Character.valueOf('i'), this.primaryScannerStats);
        if (statisticsData.length > 0) {
            this.processRawData(this.infoIdToLabel, this.primaryScannerStats, statisticsData);
        }
        if ((statisticsData = device.getStatisticsData(Character.valueOf('h'), this.primaryScannerStats)).length > 0) {
            this.processRawData(this.healthIdToLabel, this.primaryScannerStats, statisticsData);
        }
        if ((statisticsData = device.getStatisticsData(Character.valueOf('s'), this.primaryScannerStats)).length > 0) {
            this.processRawData(this.statIdToLabel, this.primaryScannerStats, statisticsData);
        }
        this.numDevices = 1;
        this.compileAttachedStatistics(device);
        return this.primaryScannerStats;
    }

    private void compileAttachedStatistics(DLSDevice device) throws DLSException {
        String[] statisticsData = new String[]{};
        this.attachedDevices = new ArrayList();
        this.devicesProcessed = 1;
        while (this.numDevices >= this.devicesProcessed) {
            HashMap<String, Object> scannerInfo = new HashMap<String, Object>();
            statisticsData = device.getStatisticsData(Character.valueOf('i'), scannerInfo, this.devicesProcessed);
            if (statisticsData.length > 0) {
                this.processRawData(this.infoIdToLabel, scannerInfo, statisticsData);
            }
            if ((statisticsData = device.getStatisticsData(Character.valueOf('h'), scannerInfo, this.devicesProcessed)).length > 0) {
                this.processRawData(this.healthIdToLabel, scannerInfo, statisticsData);
            }
            if ((statisticsData = device.getStatisticsData(Character.valueOf('s'), scannerInfo, this.devicesProcessed)).length > 0) {
                this.processRawData(this.statIdToLabel, scannerInfo, statisticsData);
            }
            this.attachedDevices.add(scannerInfo);
            ++this.devicesProcessed;
        }
    }

    private void processRawData(HashMap<Character, String> idToLabel, HashMap<String, Object> scannerInfo, String[] statisticsData) {
        String sValue = null;
        String sRawValue = null;
        Character cFrameId = null;
        String sTruncated = null;
        String sTrunc = null;
        for (int i = 0; i < statisticsData.length; ++i) {
            sRawValue = statisticsData[i];
            sTrunc = sRawValue.replaceAll("\\p{Cntrl}", "");
            sTruncated = sTrunc.replaceAll("Sp<", "");
            sTruncated = sTruncated.replaceAll("Sp=", "");
            if ((sTruncated = sTruncated.replaceAll("Sp>", "")).length() <= 1) continue;
            cFrameId = Character.valueOf(sTruncated.charAt(0));
            if (idToLabel.containsKey(cFrameId)) {
                sValue = sTruncated.substring(1);
                scannerInfo.put(idToLabel.get(cFrameId), sValue);
                m_log.debug("processRawData: Frame ID: " + cFrameId + " Value: " + sValue);
                continue;
            }
            m_log.error("processRawData: Unknown Frame ID found while processing raw i-h-s data: " + cFrameId + ".");
        }
    }

    public String[] generateOutput(String[] data, Character command) {
        HashMap<String, Object> scannerInfo = new HashMap<String, Object>();
        switch (command.charValue()) {
            case 'i': {
                this.processRawData(this.infoIdToLabel, scannerInfo, data);
                break;
            }
            case 'h': {
                this.processRawData(this.healthIdToLabel, scannerInfo, data);
                break;
            }
            case 's': {
                this.processRawData(this.statIdToLabel, scannerInfo, data);
            }
        }
        String[] stringData = new String[scannerInfo.size()];
        Enumeration<String> en = Collections.enumeration(new ArrayList<String>(scannerInfo.keySet()));
        String pad = " ...........................";
        int i = 0;
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            if (!scannerInfo.containsKey(key) || key.contains("Raw")) continue;
            String value = (String)scannerInfo.get(key);
            key = key + pad;
            stringData[i] = key.substring(0, 29) + " " + value;
            ++i;
        }
        return stringData;
    }

    public String logRawData(byte[] data) {
        return FunctionLib.byteArrayToString(data);
    }

    public void logStatistics(HashMap<String, Object> statistics) {
        Set<String> keySet = statistics.keySet();
        Enumeration<String> en = Collections.enumeration(keySet);
        String pad = " ...........................";
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            if (!statistics.containsKey(key) || key.contains("Raw")) continue;
            String value = statistics.get(key).toString();
            key = key + pad;
            m_log.info("** Stats ** " + key.substring(0, 29) + " " + value);
        }
    }

    public void buildXMLString(HashMap<String, Object> statistics, ArrayList<String> scannerInfo, String[] statisticsBuffer, String[] myLocalStatisticsBuffer) {
        int i;
        boolean bUPOSRetrieve = false;
        boolean bManufacturerRetrieve = false;
        boolean bRetrieveAll = false;
        boolean bStatsSpecificRetrieve = false;
        String deviceCategory = (String)statistics.get("DeviceCategory");
        if (statisticsBuffer[0].equals("U_")) {
            bUPOSRetrieve = true;
        }
        if (statisticsBuffer[0].equals("M_")) {
            bManufacturerRetrieve = true;
        }
        if (statisticsBuffer[0].equals("")) {
            bRetrieveAll = true;
        }
        if (myLocalStatisticsBuffer.length >= 1) {
            bStatsSpecificRetrieve = true;
        }
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat("MMM-dd-yyyy");
        String date_out = format.format(now);
        statistics.put("InstallDate", date_out);
        statistics.put("ManufactureDate", date_out);
        scannerInfo.add("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        scannerInfo.add("<UPOSStat version=\"" + statistics.get("UnifiedPOSVersion") + "\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.nrf-arts.org/UnifiedPOS/namespace/\" xsi:schemaLocation=\"http://www.nrf-arts.org/UnifiedPOS/namespace/ UPOSStat.xsd\">");
        scannerInfo.add("  <Event>");
        if (statistics.containsKey("GoodScanCount") || statistics.containsKey("GoodWeightReadCount")) {
            scannerInfo.add("    <Parameter>");
            if (deviceCategory.equals("Scanner")) {
                scannerInfo.add("      <Name>GoodScanCount</Name>");
                scannerInfo.add("      <Value>" + statistics.get("GoodScanCount") + "</Value>");
            } else {
                scannerInfo.add("      <Name>GoodWeightReadCount</Name>");
                scannerInfo.add("      <Value>" + statistics.get("GoodWeightReadCount") + "</Value>");
            }
            scannerInfo.add("    </Parameter>");
        }
        if (bUPOSRetrieve || bRetrieveAll) {
            scannerInfo.add("    <Parameter>");
            scannerInfo.add("      <Name>CapPowerReporting</Name>");
            scannerInfo.add("      <Value>" + statistics.get("CapPowerReporting") + "</Value>");
            scannerInfo.add("    </Parameter>");
            scannerInfo.add("    <Parameter>");
            scannerInfo.add("      <Name>CapStatisticsReporting</Name>");
            scannerInfo.add("      <Value>" + statistics.get("CapStatisticsReporting") + "</Value>");
            scannerInfo.add("    </Parameter>");
            scannerInfo.add("    <Parameter>");
            scannerInfo.add("      <Name>CapUpdateStatistics</Name>");
            scannerInfo.add("      <Value>" + statistics.get("CapUpdateStatistics") + "</Value>");
            scannerInfo.add("    </Parameter>");
            scannerInfo.add("    <Parameter>");
            scannerInfo.add("      <Name>CapCompareFirmwareVersion</Name>");
            scannerInfo.add("      <Value>" + statistics.get("CapCompareFirmwareVersion") + "</Value>");
            scannerInfo.add("    </Parameter>");
            scannerInfo.add("    <Parameter>");
            scannerInfo.add("      <Name>CapUpdateFirmware</Name>");
            scannerInfo.add("      <Value>" + statistics.get("CapUpdateFirmware") + "</Value>");
            scannerInfo.add("    </Parameter>");
        }
        String field = null;
        String value = null;
        if (bManufacturerRetrieve || bRetrieveAll) {
            try {
                for (i = 0; i < DLSJposConst.sStatsList.size(); ++i) {
                    field = DLSJposConst.sStatsList.get(i);
                    if (field == null || !statistics.containsKey(field)) continue;
                    value = statistics.get(field).toString();
                    scannerInfo.add("    <ManufacturerSpecific>");
                    scannerInfo.add("      <Name>" + StringEscapeUtils.escapeXml((String)field) + "</Name>");
                    scannerInfo.add("      <Value>" + StringEscapeUtils.escapeXml((String)value) + "</Value>");
                    scannerInfo.add("    </ManufacturerSpecific>");
                }
            }
            catch (NullPointerException npe) {
                m_log.error("NullPointerException: ", (Throwable)npe);
            }
            catch (Exception ex) {
                m_log.error("Exception: ", (Throwable)ex);
            }
        }
        if (bStatsSpecificRetrieve) {
            try {
                for (i = 0; i < myLocalStatisticsBuffer.length; ++i) {
                    field = myLocalStatisticsBuffer[i];
                    if (field == null || !statistics.containsKey(field)) continue;
                    value = statistics.get(field).toString();
                    scannerInfo.add("    <ManufacturerSpecific>");
                    scannerInfo.add("      <Name>" + StringEscapeUtils.escapeXml((String)field) + "</Name>");
                    scannerInfo.add("      <Value>" + StringEscapeUtils.escapeXml((String)value) + "</Value>");
                    scannerInfo.add("    </ManufacturerSpecific>");
                }
            }
            catch (NullPointerException npe) {
                m_log.error("NullPointerException: ", (Throwable)npe);
            }
        }
        String model = null;
        String serial = null;
        String firmware = null;
        String configFile = null;
        if (statistics.containsKey("ModelNumber")) {
            model = (String)statistics.get("ModelNumber");
        }
        if (statistics.containsKey("BaseModelNumber")) {
            model = (String)statistics.get("BaseModelNumber");
        }
        if (statistics.containsKey("GunModelNumber")) {
            model = (String)statistics.get("GunModelNumber");
        }
        if (statistics.containsKey("SerialNumber")) {
            serial = (String)statistics.get("SerialNumber");
        }
        if (statistics.containsKey("BaseSerialNumber")) {
            serial = (String)statistics.get("BaseSerialNumber");
        }
        if (statistics.containsKey("GunSerialNumber")) {
            serial = (String)statistics.get("GunSerialNumber");
        }
        if (statistics.containsKey("FirmwareVersionNumber")) {
            firmware = (String)statistics.get("FirmwareVersionNumber");
        }
        if (statistics.containsKey("BaseSoftwareVersion")) {
            firmware = (String)statistics.get("BaseSoftwareVersion");
        }
        if (statistics.containsKey("RadiolHardwareVersion")) {
            firmware = (String)statistics.get("RadiolHardwareVersion");
        }
        if (statistics.containsKey("GunSoftwareVersion")) {
            firmware = (String)statistics.get("GunSoftwareVersion");
        }
        if (statistics.containsKey("ConfigFileVersionNumber")) {
            configFile = (String)statistics.get("ConfigFileVersionNumber");
        }
        if (statistics.containsKey("BaseConfigPartNumber")) {
            configFile = (String)statistics.get("BaseConfigPartNumber");
        }
        if (statistics.containsKey("GunConfigPartNumber")) {
            configFile = (String)statistics.get("GunConfigPartNumber");
        }
        if (statistics.containsKey("RadioSoftwareVersion")) {
            configFile = (String)statistics.get("RadioSoftwareVersion");
        }
        if (statistics.containsKey("GunBootloaderVersion")) {
            configFile = (String)statistics.get("GunBootloaderVersion");
        }
        if (model == null) {
            model = "";
            statistics.put("ModelNumber", model);
        }
        if (serial == null) {
            serial = "";
            statistics.put("SerialNumber", serial);
        }
        if (firmware == null) {
            firmware = "";
            statistics.put("FirmwareVersionNumber", firmware);
        }
        scannerInfo.add("  </Event>");
        scannerInfo.add("  <Equipment>");
        scannerInfo.add("    <UnifiedPOSVersion>" + StringEscapeUtils.escapeXml((String)((String)statistics.get("UnifiedPOSVersion"))) + "</UnifiedPOSVersion>");
        scannerInfo.add("    <DeviceCategory>" + StringEscapeUtils.escapeXml((String)deviceCategory) + "</DeviceCategory>");
        scannerInfo.add("    <ManufacturerName>" + StringEscapeUtils.escapeXml((String)((String)statistics.get("ManufacturerName"))) + "</ManufacturerName>");
        scannerInfo.add("    <ModelName>" + StringEscapeUtils.escapeXml((String)model) + "</ModelName>");
        scannerInfo.add("    <SerialNumber>" + StringEscapeUtils.escapeXml((String)serial) + "</SerialNumber>");
        scannerInfo.add("    <FirmwareRevision>" + StringEscapeUtils.escapeXml((String)firmware) + "</FirmwareRevision>");
        scannerInfo.add("    <ConfigRevision>" + StringEscapeUtils.escapeXml((String)configFile) + "</ConfigRevision>");
        scannerInfo.add("    <Interface>" + StringEscapeUtils.escapeXml((String)((String)statistics.get("Interface"))) + "</Interface>");
        scannerInfo.add("    <InstallationDate>" + StringEscapeUtils.escapeXml((String)((String)statistics.get("InstallDate"))) + "</InstallationDate>");
        scannerInfo.add("  </Equipment>");
        scannerInfo.add("</UPOSStat>");
        Iterator<String> it = scannerInfo.iterator();
        int i2 = 0;
        while (it.hasNext()) {
            value = it.next();
            m_log.info(value);
            statisticsBuffer[0] = statisticsBuffer[0] + value + "\n";
            ++i2;
        }
    }

    public void writeScannerTempFile(String sFilename, HashMap<String, Object> wmiStatistics) throws IOException {
        m_log.trace("writeScannerTempFile (in): " + sFilename);
        String sOut = "";
        BufferedWriter oOut = null;
        StringBuilder oSb = new StringBuilder();
        Set<String> oKeys = wmiStatistics.keySet();
        Enumeration<String> oEnum = Collections.enumeration(oKeys);
        while (oEnum.hasMoreElements()) {
            String sKey = oEnum.nextElement().toString();
            Object oVal = wmiStatistics.get(sKey);
            if (oVal == null) continue;
            oSb.append(sKey);
            oSb.append("=");
            oSb.append(oVal.toString());
            oSb.append("\n");
        }
        sOut = oSb.toString();
        try {
            oOut = new BufferedWriter(new FileWriter(sFilename));
            oOut.write(sOut);
            ((Writer)oOut).close();
        }
        catch (IOException e) {
            FunctionLib.cleanup(oOut);
            throw e;
        }
        m_log.trace("writeScannerTempFile (out)");
    }

    public void readScaleTempFile(String sFilename, HashMap<String, Object> wmiStatistics) throws IOException {
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new FileReader(sFilename));
            while ((str = in.readLine()) != null) {
                String[] result = str.split("=");
                if (result.length == 1) {
                    wmiStatistics.put(result[0], "NA");
                    continue;
                }
                wmiStatistics.put(result[0], result[1]);
            }
            in.close();
        }
        catch (IOException e) {
            FunctionLib.cleanup(in);
            throw e;
        }
    }

    public void populateWMIUposMap() {
        this.wmi_upos_map.put("SerialNumber", "DeviceID");
        this.wmi_upos_map.put("ControlVersion", "UnifiedPOSVersion");
        this.wmi_upos_map.put("DeviceCategory", "DeviceCategory");
        this.wmi_upos_map.put("ManufacturerName", "ManufacturerName");
        this.wmi_upos_map.put("ModelNumber", "ModelName");
        this.wmi_upos_map.put("SerialNumber", "SerialNumber");
        this.wmi_upos_map.put("ManufactureDate", "ManufactureDate");
        this.wmi_upos_map.put("ScannerBoardSerialNumber", "MechanicalRevision");
        this.wmi_upos_map.put("FirmwareVersionNumber", "FirmwareRevision");
        this.wmi_upos_map.put("Interface", "Bus");
        this.wmi_upos_map.put("InstallDate", "InstallDate");
        this.wmi_upos_map.put("HoursPoweredCount", "HoursPoweredCount");
        this.wmi_upos_map.put("TotalResets", "TotalResets");
        this.wmi_upos_map.put("ErrorResets", "ErrorResets");
        this.wmi_upos_map.put("VerticalIPEForcedResets", "VerticalIPEForcedResets");
        this.wmi_upos_map.put("HorizontalIPEForcedResets", "HorizontalIPEForcedResets");
        this.wmi_upos_map.put("Forced2DResets", "Forced2DResets");
        this.wmi_upos_map.put("TDRForcedResets", "TDRForcedResets");
        this.wmi_upos_map.put("POSZeroRequests", "POSZeroRequests");
        this.wmi_upos_map.put("EnforcedZeroEvents", "EnforcedZeroEvents");
        this.wmi_upos_map.put("ScaleSentryEvents", "ScaleSentryEvents");
        this.wmi_upos_map.put("EASRuntimeFaults", "EASRuntimeFaults");
        this.wmi_upos_map.put("CommunicationErrorCount", "CommunicationErrorCount");
        this.wmi_upos_map.put("CapCompareFirmwareVersion", "CapCompareFirmwareVersion");
        this.wmi_upos_map.put("CapPowerReporting", "CapPowerReporting");
        this.wmi_upos_map.put("CapStatisticsReporting", "CapStatisticsReporting");
        this.wmi_upos_map.put("CapUpdateFirmware", "CapUpdateFirmware");
        this.wmi_upos_map.put("CapUpdateStatistics", "CapUpdateStatistics");
        this.wmi_upos_map.put("PowerNotify", "PowerNotify");
        this.wmi_upos_map.put("PowerState", "PowerState");
        this.wmi_upos_map.put("ManufacturerName", "Caption");
        this.wmi_upos_map.put("ControlVersion", "DeviceControlVersion");
        this.wmi_upos_map.put("Description", "Description");
        this.wmi_upos_map.put("ServiceVersion", "DeviceServiceVersion");
        this.wmi_upos_map.put("PhysicalDeviceDescription", "PhysicalDeviceDescription");
        this.wmi_upos_map.put("PhysicalDeviceName", "PhysicalDeviceName");
        this.wmi_upos_map.put("CapDisplay", "CapDisplay");
        this.wmi_upos_map.put("CapDisplayText", "CapDisplayText");
        this.wmi_upos_map.put("CapPriceCalculating", "CapPriceCalculating");
        this.wmi_upos_map.put("CapStatusUpdate", "CapStatusUpdate");
        this.wmi_upos_map.put("CapTareWeight", "CapTareWeight");
        this.wmi_upos_map.put("CapZeroScale", "CapZeroScale");
        this.wmi_upos_map.put("AsyncMode", "AsyncMode");
        this.wmi_upos_map.put("MaxDisplayTextChars", "MaxDisplayTextChars");
        this.wmi_upos_map.put("MaxWeight", "MaximumWeight");
        this.wmi_upos_map.put("ScaleMode", "WeightUnit");
        this.wmi_upos_map.put("ScaleCalibrations", "CalibrationCount");
        this.wmi_upos_map.put("GoodWeightReadCount", "GoodWeightReadCount");
        this.wmi_upos_map.put("ScaleZeroed", "RezeroCount");
        this.wmi_upos_map.put("CustomData", "CustomData");
        this.wmi_upos_map.put("ScaleHealth", "ScaleHealth");
        this.wmi_upos_map.put("RemoteDisplayHealth", "RemoteDisplayHealth");
        this.wmi_upos_map.put("ScaleInformation", "InternalScaleInformation");
        this.wmi_upos_map.put("DisplayVersion", "RemoteDisplayVersion");
        this.wmi_upos_map.put("GoodScanCount", "GoodScanCount");
        this.wmi_upos_map.put("ConfigFileVersionNumber", "ConfigurationFileID");
        this.wmi_upos_map.put("ApplicationRevisionLevel", "ApplicationRevisionLevel");
        this.wmi_upos_map.put("ScannerBootROMID", "BootloaderROMID");
        this.wmi_upos_map.put("CometROMID", "CometROMID");
        this.wmi_upos_map.put("CometBootROMID", "CometBootloaderROMID");
        this.wmi_upos_map.put("MotorHealth", "MotorHealth");
        this.wmi_upos_map.put("HorizontalLaserHealth", "HorizontalLaserHealth");
        this.wmi_upos_map.put("VerticalLaserHealth", "VerticalLaserHealth");
        this.wmi_upos_map.put("EASHealth", "EASSystemHealth");
        this.wmi_upos_map.put("CameraHealth", "CameraHealth");
        this.wmi_upos_map.put("USBHandheldConnected", "USBHandheldConnected");
        this.wmi_upos_map.put("USBSerialDongleConnected", "USBSerialDongleConnected");
        this.wmi_upos_map.put("IPE0Health", "IPE0Health");
        this.wmi_upos_map.put("IPE1Health", "IPE1Health");
        this.wmi_upos_map.put("IPE2Health", "IPE2Health");
        this.wmi_upos_map.put("IPE3Health", "IPE3Health");
        this.wmi_upos_map.put("ScaleSentryHealth", "ScaleSentryHealth");
        this.wmi_upos_map.put("ScannerTime", "MotorOnTime");
        this.wmi_upos_map.put("LaserTime", "LaserTime");
        this.wmi_upos_map.put("EASDeactivations", "EASDeactivateCount");
        this.wmi_upos_map.put("EASManualPresses", "EASManualCount");
        this.wmi_upos_map.put("FPGAVersion", "FPGAVersion");
        this.wmi_upos_map.put("IPEAppVersion", "IPEAppVersion");
        this.wmi_upos_map.put("USBLoaderVersion", "USBLoaderVersion");
        this.wmi_upos_map.put("SDRAMCfgVersion", "SDRAMCfgVersion");
        this.wmi_upos_map.put("VisionLibraryVersion", "VisionLibraryVersion");
        this.wmi_upos_map.put("VirtualScanLineLibraryVersion", "VirtualScanLineLibraryVersion");
        this.wmi_upos_map.put("RadiolHealth", "RadiolHealth");
        this.wmi_upos_map.put("RadiolHardwareVersion", "RadiolHardwareVersion");
        this.wmi_upos_map.put("RadioSoftwareVersion", "RadioSoftwareVersion");
        this.wmi_upos_map.put("BaseSoftwareVersion", "BaseSoftwareVersion");
        this.wmi_upos_map.put("GunSoftwareVersion", "GunSoftwareVersion");
        this.wmi_upos_map.put("BaseModelNumber", "BaseModelNumber");
        this.wmi_upos_map.put("GunModelNumber", "GunModelNumber");
        this.wmi_upos_map.put("GunSerialNumber", "GunSerialNumber");
        this.wmi_upos_map.put("BaseSerialNumber", "BaseSerialNumber");
        this.wmi_upos_map.put("BaseHoursPoweredCount", "BaseHoursPoweredCount");
        this.wmi_upos_map.put("BatteryChargeCycles", "BatteryChargeCycles");
        this.wmi_upos_map.put("TriggerPulls", "TriggerPulls");
        this.wmi_upos_map.put("KeyPresses", "KeyPresses");
        this.wmi_upos_map.put("LaserTime", "LaserTime");
        this.wmi_upos_map.put("LabelsScanned", "LabelsScanned");
        this.wmi_upos_map.put("GunBootloaderVersion", "GunBootloaderVersion");
    }

    public void populateWMIStatistics(HashMap<String, Object> statistics, HashMap<String, Object> wmiStatistics) {
        Object value = null;
        for (int i = 0; i < DLSJposConst.namesWMI.size(); ++i) {
            String WMIname = DLSJposConst.namesWMI.get(i);
            String UPOSname = DLSJposConst.namesUPOS.get(i);
            if (!statistics.containsKey(UPOSname) || (value = statistics.get(UPOSname)) == null) continue;
            wmiStatistics.put(WMIname, value);
        }
    }

    public boolean loadWMI(HashMap<String, Object> statistics, HashMap<String, Object> wmiStatistics, WMIService lWMI) {
        m_log.trace("loadWMI (in)");
        String scannerTempFilename = "scanner_temp.txt";
        String scaleTempFilename = "scale_temp.txt";
        String tempDir = this.options.getTempDir();
        this.populateWMIUposMap();
        if (DLSJposConst.namesWMI.size() != DLSJposConst.namesUPOS.size()) {
            m_log.trace("loadWMI (out): false");
            return false;
        }
        scannerTempFilename = tempDir + scannerTempFilename;
        scaleTempFilename = tempDir + scaleTempFilename;
        File scannerTempfile = new File(scannerTempFilename);
        File scaleTempfile = new File(scaleTempFilename);
        m_log.debug("loadWMI: Scanner temp file - " + scannerTempFilename);
        m_log.debug("loadWMI: Scale temp file - " + scaleTempFilename);
        try {
            this.writeScannerTempFile(scannerTempFilename, wmiStatistics);
        }
        catch (IOException ex) {
            m_log.error("loadWMI: IOException writing Scanner Temp File ", (Throwable)ex);
        }
        if (scaleTempfile.exists()) {
            try {
                this.readScaleTempFile(scaleTempFilename, wmiStatistics);
            }
            catch (IOException ex) {
                m_log.error("IOException: ", (Throwable)ex);
            }
        }
        this.populateWMIStatistics(statistics, wmiStatistics);
        lWMI.CreateWMIScannerFile(wmiStatistics);
        if (scannerTempfile.exists() && scaleTempfile.exists()) {
            lWMI.CreateWMIScaleFile(wmiStatistics);
        }
        boolean success = scannerTempfile.delete();
        success = scaleTempfile.delete();
        m_log.trace("loadWMI (out): true");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String scannerInfoFile(HashMap<String, Object> scanHT, String scannerInfoFilename, boolean avalancheEnabled) {
        String msg;
        block87: {
            String modelNumPieces;
            String[] begin;
            m_log.trace("scannerInfoFile (in): " + scannerInfoFilename + ", " + Boolean.toString(avalancheEnabled));
            String headerMsg = "";
            msg = "";
            String scannerMsg = "";
            String tempDir = this.options.getTempDir();
            headerMsg = headerMsg + "# Raw data from scanner/scale\n";
            if (scanHT.containsKey("RawInfo")) {
                headerMsg = headerMsg + "# Info command\n";
                headerMsg = headerMsg + scanHT.get("RawInfo") + "\n";
            }
            if (scanHT.containsKey("RawHealth")) {
                headerMsg = headerMsg + "# Health command\n";
                headerMsg = headerMsg + scanHT.get("RawHealth") + "\n";
            }
            if (scanHT.containsKey("RawStats")) {
                headerMsg = headerMsg + "# Stats command\n";
                headerMsg = headerMsg + scanHT.get("RawStats") + "\n";
            }
            msg = msg + "# Info\n";
            if (scanHT.containsKey("ModelNumber")) {
                msg = msg + "ModelNumber = " + scanHT.get("ModelNumber") + "\n";
            }
            if (scanHT.containsKey("SerialNumber")) {
                msg = msg + "SerialNumber = " + scanHT.get("SerialNumber") + "\n";
            }
            if (scanHT.containsKey("ScannerBoardSerialNumber")) {
                msg = msg + "ScannerBoardSerialNumber = " + scanHT.get("ScannerBoardSerialNumber") + "\n";
            }
            if (scanHT.containsKey("FirmwareVersionNumber")) {
                msg = msg + "FirmwareVersionNumber = " + scanHT.get("FirmwareVersionNumber") + "\n";
            }
            if (scanHT.containsKey("FPGAVersion")) {
                msg = msg + "FPGAVersion = " + scanHT.get("FPGAVersion") + "\n";
            }
            if (scanHT.containsKey("TDR_FPGAVersion")) {
                msg = msg + "TDR_FPGAVersion = " + scanHT.get("TDR_FPGAVersion") + "\n";
            }
            if (scanHT.containsKey("IPEAppVersion")) {
                msg = msg + "IPEAppVersion = " + scanHT.get("IPEAppVersion") + "\n";
            }
            if (scanHT.containsKey("USBLoaderVersion")) {
                msg = msg + "USBLoaderVersion = " + scanHT.get("USBLoaderVersion") + "\n";
            }
            if (scanHT.containsKey("SDRAMCfgVersion")) {
                msg = msg + "SDRAMCfgVersion = " + scanHT.get("SDRAMCfgVersion") + "\n";
            }
            if (scanHT.containsKey("VisionLibraryVersion")) {
                msg = msg + "VisionLibraryVersion = " + scanHT.get("VisionLibraryVersion") + "\n";
            }
            if (scanHT.containsKey("VirtualScanLineLibraryVersion")) {
                msg = msg + "VirtualScanLineLibraryVersion = " + scanHT.get("VirtualScanLineLibraryVersion") + "\n";
            }
            if (scanHT.containsKey("ScannerRevisionNumber")) {
                msg = msg + "ScannerRevisionNumber = " + scanHT.get("ScannerRevisionNumber") + "\n";
            }
            if (scanHT.containsKey("ConfigFileVersionNumber")) {
                msg = msg + "ConfigFileVersionNumber = " + scanHT.get("ConfigFileVersionNumber") + "\n";
            }
            if (scanHT.containsKey("ScannerBootROMID")) {
                msg = msg + "ScannerBootROMID = " + scanHT.get("ScannerBootROMID") + "\n";
            }
            if (scanHT.containsKey("RadiolHardwareVersion")) {
                msg = msg + "RadiolHardwareVersion = " + scanHT.get("RadiolHardwareVersion") + "\n";
            }
            if (scanHT.containsKey("CometROMID")) {
                msg = msg + "CometROMID = " + scanHT.get("CometROMID") + "\n";
            }
            if (scanHT.containsKey("CometBootROMID")) {
                msg = msg + "CometBootROMID = " + scanHT.get("CometBootROMID") + "\n";
            }
            if (scanHT.containsKey("ScaleInformation")) {
                msg = msg + "ScaleInformation = " + scanHT.get("ScaleInformation") + "\n";
            }
            if (scanHT.containsKey("DisplayVersion")) {
                msg = msg + "DisplayVersion = " + scanHT.get("DisplayVersion") + "\n";
            }
            if (scanHT.containsKey("EASVersion")) {
                msg = msg + "EASVersion = " + scanHT.get("EASVersion") + "\n";
            }
            if (scanHT.containsKey("ScannerInterface")) {
                msg = msg + "ScannerInterface = " + scanHT.get("ScannerInterface") + "\n";
            }
            if (scanHT.containsKey("RadioSoftwareVersion")) {
                msg = msg + "RadioSoftwareVersion = " + scanHT.get("RadioSoftwareVersion") + "\n";
            }
            if (scanHT.containsKey("BaseSoftwareVersion")) {
                msg = msg + "BaseSoftwareVersion = " + scanHT.get("BaseSoftwareVersion") + "\n";
            }
            if (scanHT.containsKey("GunSoftwareVersion")) {
                msg = msg + "GunSoftwareVersion = " + scanHT.get("GunSoftwareVersion") + "\n";
            }
            if (scanHT.containsKey("GunBootloaderVersion")) {
                msg = msg + "GunBootloaderVersion = " + scanHT.get("GunBootloaderVersion") + "\n";
            }
            if (scanHT.containsKey("RadioBootloaderVersion")) {
                msg = msg + "RadioBootloaderVersion = " + scanHT.get("RadioBootloaderVersion") + "\n";
            }
            if (scanHT.containsKey("BaseModelNumber")) {
                msg = msg + "BaseModelNumber = " + scanHT.get("BaseModelNumber") + "\n";
            }
            if (scanHT.containsKey("GunModelNumber")) {
                msg = msg + "GunModelNumber = " + scanHT.get("GunModelNumber") + "\n";
            }
            if (scanHT.containsKey("BaseSerialNumber")) {
                msg = msg + "BaseSerialNumber = " + scanHT.get("BaseSerialNumber") + "\n";
            }
            if (scanHT.containsKey("GunSerialNumber")) {
                msg = msg + "GunSerialNumber = " + scanHT.get("GunSerialNumber") + "\n";
            }
            if (scanHT.containsKey("BaseBootloaderVersion")) {
                msg = msg + "BaseBootloaderVersion = " + scanHT.get("BaseBootloaderVersion") + "\n";
            }
            msg = msg + "# Health\n";
            if (scanHT.containsKey("MotorHealth")) {
                msg = msg + "MotorHealth = " + scanHT.get("MotorHealth") + "\n";
            }
            if (scanHT.containsKey("VerticalLaserHealth")) {
                msg = msg + "VerticalLaserHealth = " + scanHT.get("VerticalLaserHealth") + "\n";
            }
            if (scanHT.containsKey("HorizontalLaserHealth")) {
                msg = msg + "HorizontalLaserHealth = " + scanHT.get("HorizontalLaserHealth") + "\n";
            }
            if (scanHT.containsKey("ScaleHealth")) {
                msg = msg + "ScaleHealth = " + scanHT.get("ScaleHealth") + "\n";
            }
            if (scanHT.containsKey("RemoteDisplayHealth")) {
                msg = msg + "RemoteDisplayHealth = " + scanHT.get("RemoteDisplayHealth") + "\n";
            }
            if (scanHT.containsKey("EASHealth")) {
                msg = msg + "EASHealth = " + scanHT.get("EASHealth") + "\n";
            }
            if (scanHT.containsKey("CameraHealth")) {
                msg = msg + "CameraHealth = " + scanHT.get("CameraHealth") + "\n";
            }
            if (scanHT.containsKey("RadiolHealth")) {
                msg = msg + "RadiolHealth = " + scanHT.get("RadiolHealth") + "\n";
            }
            if (scanHT.containsKey("IPE0Health")) {
                msg = msg + "IPE0Health = " + scanHT.get("IPE0Health") + "\n";
            }
            if (scanHT.containsKey("IPE1Health")) {
                msg = msg + "IPE1Health = " + scanHT.get("IPE1Health") + "\n";
            }
            if (scanHT.containsKey("IPE2Health")) {
                msg = msg + "IPE2Health = " + scanHT.get("IPE2Health") + "\n";
            }
            if (scanHT.containsKey("IPE3Health")) {
                msg = msg + "IPE3Health = " + scanHT.get("IPE3Health") + "\n";
            }
            if (scanHT.containsKey("ScaleSentryHealth")) {
                msg = msg + "ScaleSentryHealth = " + scanHT.get("ScaleSentryHealth") + "\n";
            }
            msg = msg + "# Stats\n";
            if (scanHT.containsKey("ScannerTime")) {
                msg = msg + "ScannerTime = " + scanHT.get("ScannerTime") + "\n";
            }
            if (scanHT.containsKey("HoursPoweredCount")) {
                msg = msg + "HoursPoweredCount = " + scanHT.get("HoursPoweredCount") + "\n";
            }
            if (scanHT.containsKey("LaserTime")) {
                msg = msg + "LaserTime = " + scanHT.get("LaserTime") + "\n";
            }
            if (scanHT.containsKey("GoodScanCount")) {
                msg = msg + "GoodScanCount = " + scanHT.get("GoodScanCount") + "\n";
            }
            if (scanHT.containsKey("ScaleZeroed")) {
                msg = msg + "ScaleZeroed = " + scanHT.get("ScaleZeroed") + "\n";
            }
            if (scanHT.containsKey("ScaleCalibrations")) {
                msg = msg + "ScaleCalibrations = " + scanHT.get("ScaleCalibrations") + "\n";
            }
            if (scanHT.containsKey("CustomData")) {
                msg = msg + "CustomData = " + scanHT.get("CustomData") + "\n";
            }
            if (scanHT.containsKey("EASDeactivations")) {
                msg = msg + "EASDeactivations = " + scanHT.get("EASDeactivations") + "\n";
            }
            if (scanHT.containsKey("EASManualPresses")) {
                msg = msg + "EASManualPresses = " + scanHT.get("EASManualPresses") + "\n";
            }
            if (scanHT.containsKey("BatteryChargeCycles")) {
                msg = msg + "BatteryChargeCycles = " + scanHT.get("BatteryChargeCycles") + "\n";
            }
            if (scanHT.containsKey("TriggerPulls")) {
                msg = msg + "TriggerPulls = " + scanHT.get("TriggerPulls") + "\n";
            }
            if (scanHT.containsKey("KeyPresses")) {
                msg = msg + "KeyPresses = " + scanHT.get("KeyPresses") + "\n";
            }
            if (scanHT.containsKey("TotalResets")) {
                msg = msg + "TotalResets = " + scanHT.get("TotalResets") + "\n";
            }
            if (scanHT.containsKey("ErrorResets")) {
                msg = msg + "ErrorResets = " + scanHT.get("ErrorResets") + "\n";
            }
            if (scanHT.containsKey("VerticalIPEForcedResets")) {
                msg = msg + "VerticalIPEForcedResets = " + scanHT.get("VerticalIPEForcedResets") + "\n";
            }
            if (scanHT.containsKey("HorizontalIPEForcedResets")) {
                msg = msg + "HorizontalIPEForcedResets = " + scanHT.get("HorizontalIPEForcedResets") + "\n";
            }
            if (scanHT.containsKey("Forced2DResets")) {
                msg = msg + "Forced2DResets = " + scanHT.get("Forced2DResets") + "\n";
            }
            if (scanHT.containsKey("TDRForcedResets")) {
                msg = msg + "TDRForcedResets = " + scanHT.get("TDRForcedResets") + "\n";
            }
            if (scanHT.containsKey("POSZeroRequests")) {
                msg = msg + "POSZeroRequests = " + scanHT.get("POSZeroRequests") + "\n";
            }
            if (scanHT.containsKey("EnforcedZeroEvents")) {
                msg = msg + "EnforcedZeroEvents = " + scanHT.get("EnforcedZeroEvents") + "\n";
            }
            if (scanHT.containsKey("ScaleSentryEvents")) {
                msg = msg + "ScaleSentryEvents = " + scanHT.get("ScaleSentryEvents") + "\n";
            }
            if (scanHT.containsKey("EASRuntimeFaults")) {
                msg = msg + "EASRuntimeFaults = " + scanHT.get("EASRuntimeFaults") + "\n";
            }
            headerMsg = headerMsg + "#\n";
            headerMsg = headerMsg + "# Parsed data\n";
            headerMsg = headerMsg + "#\n";
            headerMsg = headerMsg + "#\n";
            headerMsg = scanHT.containsKey("ModelNumber") ? ((begin = (modelNumPieces = (String)scanHT.get("ModelNumber")).split("-"))[0].length() > 0 ? headerMsg + "vendor = " + begin[0] + "\n" : headerMsg + "vendor = " + scanHT.get("ManufacturerName") + "\n") : headerMsg + "vendor = " + scanHT.get("ManufacturerName") + "\n";
            headerMsg = headerMsg + "# UPOS\n";
            headerMsg = headerMsg + "ManufacturerName = " + scanHT.get("ManufacturerName") + "\n";
            headerMsg = headerMsg + "DeviceCategory = " + scanHT.get("DeviceCategory") + "\n";
            headerMsg = headerMsg + "Interface = " + scanHT.get("Interface") + "\n";
            msg = msg + "#\n";
            msg = msg + "# JavaPOS \n";
            if (scanHT.containsKey("UnifiedPOSVersion")) {
                msg = msg + "# UnifiedPOSVersion = " + scanHT.get("UnifiedPOSVersion") + "\n";
            }
            if (scanHT.containsKey("ControlVersion")) {
                msg = msg + "# ControlVersion = " + scanHT.get("ControlVersion") + "\n";
            }
            if (scanHT.containsKey("ServiceVersion")) {
                msg = msg + "# ServiceVersion = " + scanHT.get("ServiceVersion") + "\n";
            }
            Branding oBr = Branding.getInstance();
            DateFormat fDateFormat = DateFormat.getDateTimeInstance(2, 2);
            Date now = new Date();
            String date_out = fDateFormat.format(now);
            msg = msg + "#\n";
            msg = msg + "# Creation date: \t" + date_out + "\r\n";
            msg = msg + "# Copyright 2012, " + oBr.getBrandingName() + "\r\n";
            msg = msg + "# EOF\r\n";
            scannerMsg = headerMsg + msg;
            BufferedWriter aOut = null;
            BufferedWriter out = null;
            try {
                File scannerInfoFile;
                scannerInfoFilename = tempDir + scannerInfoFilename;
                m_log.info("scannerInfoFilename = " + scannerInfoFilename);
                String scannerInfoAvalancheFilename = FunctionLib.getFilename(scannerInfoFilename) + ".prf";
                m_log.info("scannerInfoAvalancheFilename = " + scannerInfoAvalancheFilename);
                if (avalancheEnabled && File.separatorChar == '\\') {
                    String propsPath = "";
                    try {
                        propsPath = DLSRegistry.readString(-2147483646, "Software\\Wavelink\\Avalanche", "PROPS");
                    }
                    catch (IllegalArgumentException ex) {
                        m_log.error("scannerInfoFile: Illegal Argument. ", (Throwable)ex);
                    }
                    catch (IllegalAccessException ex) {
                        m_log.error("scannerInfoFile: Illegal Access. ", (Throwable)ex);
                    }
                    catch (InvocationTargetException ex) {
                        m_log.error("scannerInfoFile: Invalid Invocation Target. ", (Throwable)ex);
                    }
                    if (propsPath != null) {
                        File scannerAvalancheInfoFile;
                        m_log.info("scannerInfoFile: Avalanche PROPS directory = " + propsPath);
                        boolean exists = new File(propsPath).exists();
                        if (!exists) {
                            m_log.debug("scannerInfoFile: making dirs = " + propsPath);
                            boolean bMkDir = new File(propsPath).mkdirs();
                        }
                        if ((scannerAvalancheInfoFile = new File(propsPath + "\\" + "_" + scannerInfoAvalancheFilename)).createNewFile()) {
                            m_log.debug("scannerInfoFile: Creating Avalanche info file - " + scannerInfoAvalancheFilename);
                        }
                        m_log.debug("scannerInfoFile: writing file " + propsPath + "\\" + scannerInfoAvalancheFilename);
                        aOut = new BufferedWriter(new FileWriter(scannerAvalancheInfoFile));
                        aOut.write(scannerMsg);
                    }
                }
                if ((scannerInfoFile = new File(scannerInfoFilename)).createNewFile()) {
                    m_log.debug("scannerInfoFile: Creating info file - " + scannerInfoFilename);
                } else {
                    m_log.debug("scannerInfoFile: " + scannerInfoFilename + " info file already exists");
                }
                out = new BufferedWriter(new FileWriter(scannerInfoFile));
                out.write(scannerMsg);
                FunctionLib.cleanup(out);
            }
            catch (IOException e) {
                m_log.error("Jpos exception on createNewFile: " + scannerInfoFilename, (Throwable)e);
                msg = msg + "Exception on createNewFile: " + e + " " + scannerInfoFilename;
                break block87;
            }
            finally {
                FunctionLib.cleanup(out);
                FunctionLib.cleanup(aOut);
            }
            FunctionLib.cleanup(aOut);
        }
        m_log.trace("scannerInfoFile (out): " + msg);
        return msg;
    }
}

