/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.common;

import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSScaleConfig;
import com.dls.jpos.common.DLSScannerConfig;
import com.dls.jpos.common.WindWrapper;
import com.dls.jpos.interpretation.DLSScale;
import com.dls.jpos.interpretation.DLSScanner;
import com.dls.jpos.interpretation.DLSSerialScanner;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.DBT;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.platform.win32.Wtsapi32;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DevWatcher
implements Runnable {
    private DLSScanner scanner = null;
    private DLSScale scale = null;
    private DLSScannerConfig scannerConfig = null;
    private DLSScaleConfig scaleConfig = null;
    private static WindWrapper windbag;
    boolean bDeviceRemoved = false;
    public boolean bRunning = false;
    Timer taskTimer;
    DevTimerTask devTimer;
    WinDef.HWND hWnd;
    int eventCount = 0;
    private static final Logger m_log;

    public DevWatcher(DLSScanner scannerObject) {
        this.scanner = scannerObject;
        this.scannerConfig = (DLSScannerConfig)this.scanner.getConfiguration();
        windbag = WindWrapper.getInstance();
        this.taskTimer = new Timer();
    }

    public DevWatcher(DLSScale scaleObject) {
        this.scale = scaleObject;
        this.scaleConfig = (DLSScaleConfig)this.scale.getConfiguration();
        windbag = WindWrapper.getInstance();
        this.taskTimer = new Timer();
    }

    public void CloseWindow() {
        User32.INSTANCE.PostMessage(this.hWnd, 1092, null, null);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public WinDef.LRESULT callback(WinDef.HWND hwnd, int uMsg, WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
        m_log.trace("callback (in): " + hwnd + ", " + Integer.toString(uMsg) + ", " + wParam + ", " + lParam);
        switch (uMsg) {
            case 1: {
                m_log.debug("callback: WM_CREATE");
                this.onCreate(wParam, lParam);
                break;
            }
            case 2: {
                m_log.debug("callback: WM_DESTROY");
                User32.INSTANCE.PostQuitMessage(0);
                break;
            }
            case 537: {
                m_log.debug("callback: WM_DEVICECHANGE");
                this.onDeviceChange(wParam, lParam);
            }
        }
        m_log.trace("callback (out)");
        return User32.INSTANCE.DefWindowProc(hwnd, uMsg, wParam, lParam);
    }

    public int getLastError() {
        int rc = Kernel32.INSTANCE.GetLastError();
        return rc;
    }

    protected boolean isInList(String sName) {
        boolean bTest = false;
        if ((sName.toUpperCase().contains("VID_03F0") || sName.toUpperCase().contains("080C") || sName.toUpperCase().contains("VID_05F9")) && !sName.toUpperCase().contains("PID_4000")) {
            bTest = true;
        }
        return bTest;
    }

    protected void onCreate(WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
        m_log.trace("onCreate (in)");
        m_log.trace("onCreate (out)");
    }

    protected void onDeviceChange(WinDef.WPARAM wParam, WinDef.LPARAM lParam) {
        m_log.trace("onDeviceChange (in)");
        DBT.DEV_BROADCAST_DEVICEINTERFACE bdif = new DBT.DEV_BROADCAST_DEVICEINTERFACE(lParam.longValue());
        String sName = bdif.getDbcc_name();
        if (this.isInList(sName)) {
            ++this.eventCount;
            if (this.eventCount > 1) {
                if (3 == this.eventCount) {
                    this.eventCount = 0;
                }
                return;
            }
            m_log.debug("OnDeviceChange DBCC NAME: " + sName);
            switch (wParam.intValue()) {
                case 32768: {
                    m_log.trace("onDeviceChange: DBT_DEVICEARRIVAL.");
                    if (!this.bDeviceRemoved) break;
                    m_log.trace("onDeviceChange: device removed = " + Boolean.toString(this.bDeviceRemoved));
                    this.taskTimer.cancel();
                    this.taskTimer = new Timer();
                    this.devTimer = new DevTimerTask();
                    this.taskTimer.scheduleAtFixedRate((TimerTask)this.devTimer, 1000L, 1000L);
                    break;
                }
                case 32772: {
                    m_log.trace("onDeviceChange: DBT_DEVICEREMOVECOMPLETE.");
                    if (this.bDeviceRemoved) break;
                    try {
                        if (this.scanner instanceof DLSSerialScanner) {
                            DLSSerialScanner serialScanner = (DLSSerialScanner)this.scanner;
                            boolean bl = this.bDeviceRemoved = !serialScanner.findPort();
                            if (this.bDeviceRemoved) {
                                serialScanner.closePort();
                            }
                            m_log.debug("COM DEVICEREMOVE: " + Boolean.toString(this.bDeviceRemoved));
                        } else {
                            if (this.scanner != null) {
                                m_log.debug("onDeviceChange: Checking Health of Scanner.");
                                this.bDeviceRemoved = !this.scanner.doHealthCheck();
                            } else {
                                m_log.debug("onDeviceChange: Checking Health of Scale.");
                                this.bDeviceRemoved = !this.scale.doHealthCheck();
                            }
                            m_log.debug("OEM DEVICEREMOVE: " + Boolean.toString(this.bDeviceRemoved));
                        }
                        if (!this.bDeviceRemoved) break;
                        m_log.debug("DBT_DEVICEREMOVECOMPLETE");
                        if (this.scanner != null) {
                            if (!this.scannerConfig.getCanNotifyPowerChange()) break;
                            this.scanner.onStatusUpdate(2004);
                            break;
                        }
                        if (!this.scaleConfig.getCanNotifyPowerChange()) break;
                        this.scale.onStatusUpdate(2004);
                    }
                    catch (DLSException ex) {
                        m_log.error("DLSException in DBT_DEVICEREMOVECOMPLETE: ", (Throwable)ex);
                    }
                    break;
                }
                case 7: {
                    m_log.debug("Message DBT_DEVNODES_CHANGED");
                    break;
                }
                default: {
                    m_log.debug("Message WM_DEVICECHANGE message received, value unhandled.");
                }
            }
        }
        m_log.trace("onDeviceChange (out)");
    }

    public void postDestroy() {
        User32.INSTANCE.PostMessage(this.hWnd, 18, null, null);
    }

    @Override
    public void run() {
        WString windowClass = new WString("MyWindowClass");
        WinDef.HMODULE hInst = Kernel32.INSTANCE.GetModuleHandle("");
        WinUser.WNDCLASSEX wClass = new WinUser.WNDCLASSEX();
        wClass.hInstance = hInst;
        wClass.lpfnWndProc = windbag;
        wClass.lpszClassName = windowClass;
        User32.INSTANCE.RegisterClassEx(wClass);
        int lastError = this.getLastError();
        this.hWnd = User32.INSTANCE.CreateWindowEx(8, windowClass, "My hidden helper window, used only to catch the windows events", 0, 0, 0, 0, 0, WinUser.HWND_MESSAGE, null, (WinDef.HINSTANCE)hInst, null);
        lastError = this.getLastError();
        windbag.addWind(this.hWnd, this);
        Wtsapi32.INSTANCE.WTSRegisterSessionNotification(this.hWnd, 0);
        DBT.DEV_BROADCAST_DEVICEINTERFACE notificationFilter = new DBT.DEV_BROADCAST_DEVICEINTERFACE();
        notificationFilter.dbcc_size = 100;
        notificationFilter.dbcc_devicetype = 5;
        notificationFilter.dbcc_classguid = DBT.GUID_DEVINTERFACE_USB_DEVICE;
        WinUser.HDEVNOTIFY hDevNotify = User32.INSTANCE.RegisterDeviceNotification((WinNT.HANDLE)this.hWnd, (Structure)notificationFilter, 4);
        lastError = this.getLastError();
        this.bRunning = true;
        m_log.debug("Before Starting message pump in DevWatcher.");
        WinUser.MSG msg = new WinUser.MSG();
        while (User32.INSTANCE.GetMessage(msg, this.hWnd, 0, 0) != 0 && 1092 != msg.message) {
            User32.INSTANCE.TranslateMessage(msg);
            User32.INSTANCE.DispatchMessage(msg);
        }
        m_log.debug("After Ending message pump in DevWatcher.");
        windbag.removeWind(this.hWnd);
        User32.INSTANCE.UnregisterDeviceNotification(hDevNotify);
        Wtsapi32.INSTANCE.WTSUnRegisterSessionNotification(this.hWnd);
        User32.INSTANCE.UnregisterClass(windowClass, (WinDef.HINSTANCE)hInst);
        User32.INSTANCE.DestroyWindow(this.hWnd);
    }

    static {
        m_log = LogManager.getLogger(DevWatcher.class);
    }

    class DevTimerTask
    extends TimerTask {
        private int Counter = 5;

        DevTimerTask() {
        }

        @Override
        public void run() {
            if (0 >= this.Counter--) {
                m_log.error("DevTimerTask: Unable to reconnect to device. Canceling DevTimer Task.");
                this.cancel();
                return;
            }
            if (DevWatcher.this.bDeviceRemoved) {
                try {
                    if (DevWatcher.this.scanner instanceof DLSSerialScanner) {
                        DLSSerialScanner serialScanner = (DLSSerialScanner)DevWatcher.this.scanner;
                        boolean bl = DevWatcher.this.bDeviceRemoved = !serialScanner.findPort();
                        if (!DevWatcher.this.bDeviceRemoved) {
                            serialScanner.openPort();
                        }
                        m_log.debug("DevTimerTask.run: COM DEVICE ATTACHED: " + Boolean.toString(!DevWatcher.this.bDeviceRemoved));
                    } else {
                        m_log.debug("DevTimerTask.run: Calling onDeviceReattached.");
                        if (DevWatcher.this.scanner != null) {
                            DevWatcher.this.scanner.onDeviceReattached();
                            m_log.debug("DevTimerTask.run: Calling scanner.doHealthCheck.");
                            DevWatcher.this.bDeviceRemoved = !DevWatcher.this.scanner.doHealthCheck();
                        } else {
                            DevWatcher.this.scale.onDeviceReattached();
                            m_log.debug("DevTimerTask.run: Calling scale.doHealthCheck.");
                            DevWatcher.this.bDeviceRemoved = !DevWatcher.this.scale.doHealthCheck();
                        }
                        m_log.debug("DevTimerTask.run: doHealthCheck returned " + Boolean.toString(!DevWatcher.this.bDeviceRemoved) + ".");
                        m_log.debug("run: OEM DEVICE ATTACHED: " + Boolean.toString(!DevWatcher.this.bDeviceRemoved));
                    }
                    if (!DevWatcher.this.bDeviceRemoved) {
                        if (DevWatcher.this.scanner instanceof DLSSerialScanner && DevWatcher.this.scannerConfig.getCanNotifyPowerChange()) {
                            DevWatcher.this.scanner.onStatusUpdate(2001);
                        }
                        m_log.debug("run: DBT_DEVICEARRIVAL");
                        if (DevWatcher.this.scanner != null) {
                            DevWatcher.this.scanner.onDeviceArrival();
                        } else {
                            DevWatcher.this.scale.onDeviceArrival();
                        }
                        this.cancel();
                    }
                }
                catch (DLSException e) {
                    m_log.error("run: Error enabling/disabling device upon device arrival: ", (Throwable)e);
                    DevWatcher.this.bDeviceRemoved = true;
                }
            }
        }
    }
}

