/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.common;

import com.dls.jpos.common.DirFilterWatcher;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DirWatcher
extends TimerTask {
    private String path;
    private File[] filesArray;
    private HashMap<File, Long> dir = new HashMap();
    private DirFilterWatcher dfw;
    private static final Logger m_log = LogManager.getLogger(DirWatcher.class);

    public DirWatcher(String path) {
        this(path, "");
    }

    public DirWatcher(String path, String filter) {
        this.path = path;
        this.dfw = new DirFilterWatcher(filter);
        this.filesArray = new File(path).listFiles(this.dfw);
        if (this.filesArray == null) {
            m_log.error("DirWatcher: Invalid directory path.");
            return;
        }
        for (int i = 0; i < this.filesArray.length; ++i) {
            this.dir.put(this.filesArray[i], this.filesArray[i].lastModified());
        }
    }

    @Override
    public final void run() {
        HashSet<File> checkedFiles = new HashSet<File>();
        this.filesArray = new File(this.path).listFiles(this.dfw);
        if (this.filesArray == null) {
            m_log.error("Run: Invalid directory path.");
            return;
        }
        for (int i = 0; i < this.filesArray.length; ++i) {
            Long current = this.dir.get(this.filesArray[i]);
            checkedFiles.add(this.filesArray[i]);
            if (current == null) {
                this.dir.put(this.filesArray[i], this.filesArray[i].lastModified());
                this.onChange(this.filesArray[i], "add");
                continue;
            }
            if (current.longValue() == this.filesArray[i].lastModified()) continue;
            this.dir.put(this.filesArray[i], this.filesArray[i].lastModified());
        }
        HashMap<File, Long> temp = new HashMap<File, Long>();
        temp.putAll(this.dir);
        Set ref = temp.keySet();
        ref.removeAll(checkedFiles);
        for (File deletedFile : ref) {
            this.dir.remove(deletedFile);
            this.onChange(deletedFile, "delete");
        }
    }

    protected abstract void onChange(File var1, String var2);
}

