/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.common;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FunctionLib {
    private static final Logger m_log = LogManager.getLogger(FunctionLib.class);

    public static String byteArrayToString(byte[] data) {
        String sResult = "";
        String sRawData = "";
        StringBuilder oSb = new StringBuilder();
        boolean discard = true;
        if (data != null && data.length > 0) {
            for (int i = 0; i < data.length; ++i) {
                sResult = String.format(" 0x%02X", data[i]);
                oSb.append(sResult);
                if (data[i] == 0) continue;
                discard = false;
            }
            sRawData = discard ? "[0] **invalid packet - contained all nulls." : "[" + data.length + "]" + oSb.toString();
        } else {
            sRawData = data == null ? "[0] **invalid packet - byte array is null)" : "[0] **invalid packet - byte array is empty)";
        }
        return sRawData;
    }

    public static void cleanup(Closeable r) {
        try {
            if (r != null) {
                r.close();
            }
        }
        catch (IOException e) {
            m_log.error("IOException caught closing stream/reader: ", (Throwable)e);
        }
    }

    public static byte[] hexStringToByteArray(String sHex) {
        if (sHex == null) {
            throw new IllegalArgumentException();
        }
        if ((sHex = sHex.replaceAll("\\s", "")).length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] chars = sHex.toCharArray();
        int len = chars.length;
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(chars[i], 16) << 4) + Character.digit(chars[i + 1], 16));
        }
        return data;
    }

    public static String getFilename(String sFile) {
        if (sFile.lastIndexOf(File.separator) > 0) {
            sFile = sFile.substring(sFile.lastIndexOf(File.separator) + 1);
        }
        if (sFile.lastIndexOf(".") > 0) {
            sFile = sFile.substring(0, sFile.lastIndexOf("."));
        }
        return sFile;
    }

    public static String byteArrayToStringImage(byte[] data) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] >= 0 && data[i] <= 9) {
                String format = String.format("%d", data[i]);
                result.append(format);
                continue;
            }
            result.append((char)data[i]);
        }
        return result.toString();
    }
}

