/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.common;

import com.dls.jpos.common.FunctionLib;
import com.dls.jpos.common.LabelRow;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LabelParser {
    public static final String DECODE_TYPE_EU = "warhol";
    public static final String DECODE_TYPE_OEM = "oem";
    public static final String DECODE_TYPE_SCRS232 = "sc";
    public static final String DECODE_TYPE_US = "standard";
    public static final String DEFAULT_CSVFILE = "./LabelIdentifiers.csv";
    public static final String FIELD_EUCODE = "EUCode";
    public static final String FIELD_IBMUSBOEM = "IBMUSBOEM";
    public static final String FIELD_OUTPREFIX = "OutputPrefix";
    public static final String FIELD_OUTSUFFIX = "OutputSuffix";
    public static final String FIELD_SCRS232 = "SCRS232";
    public static final String FIELD_TAGNAME = "TagName";
    public static final String FIELD_UPOSID = "UPOSID";
    public static final String FIELD_UPOSNAME = "UPOSName";
    public static final String FIELD_USCODE = "USCode";
    public static final String SFIELD_EUCODE = "EU (code)";
    public static final String SFIELD_IBMUSBOEM = "IBM-USB-OEM";
    public static final String SFIELD_OUTPREFIX = "Output Prefix";
    public static final String SFIELD_OUTSUFFIX = "Output Suffix";
    public static final String SFIELD_SCRS232 = "SCRS232";
    public static final String SFIELD_TAGNAME = "Tag Name";
    public static final String SFIELD_UPOSID = "UPOS IDs";
    public static final String SFIELD_UPOSNAME = "UPOS Identifier Names";
    public static final String SFIELD_USCODE = "USA (code)";
    private static volatile LabelParser instance = null;
    private ArrayList<LabelRow> labelIdentifiers;
    private HashMap<String, String> fieldMap;
    private HashMap<String, Integer> namedIndexMap;
    private String[] indexMap;
    private int typeIndex;
    private String m_csvFile;
    private static final Logger m_log = LogManager.getLogger(LabelParser.class);

    private LabelParser() {
        this.mapFields();
        this.labelIdentifiers = new ArrayList();
        this.m_csvFile = DEFAULT_CSVFILE;
        this.parseCommaSeparatedFile();
    }

    public static int addOns(byte[] barcode, int type) {
        switch (type) {
            case 101: {
                if (barcode.length <= 12) break;
                type = 111;
                break;
            }
            case 102: {
                if (barcode.length <= 8) break;
                type = 112;
                break;
            }
            case 103: {
                if (barcode.length <= 8) break;
                type = 118;
                break;
            }
            case 104: {
                if (barcode.length <= 13) break;
                type = 119;
                break;
            }
        }
        return type;
    }

    private void cleanup(Closeable r) {
        try {
            if (r != null) {
                r.close();
            }
        }
        catch (IOException e) {
            m_log.error("IOException caught closing reader to (" + this.getCsvFile() + "): ", (Throwable)e);
        }
    }

    public String convertToReadable(int type) {
        m_log.trace("convertToReadable (in): " + Integer.toString(type));
        String readableType = "= SCAN_SDT_UNKNOWN";
        LabelRow labelRow = null;
        for (int i = 0; i < this.labelIdentifiers.size(); ++i) {
            labelRow = this.labelIdentifiers.get(i);
            if (labelRow.getUPOSID() != type) continue;
            m_log.debug("convertToReadable: bar code type = " + labelRow.getUPOSName());
            readableType = "= " + labelRow.getUPOSName();
            break;
        }
        if (readableType.equals("= SCAN_SDT_UNKNOWN") && type != 0) {
            m_log.error("convertToReadable: bar code type = SCAN_SDT_UNKNOWN: " + type);
        }
        m_log.trace("convertToReadable (out): " + readableType);
        return readableType;
    }

    public LabelRow extractBarcodeType(byte[] identifier) {
        m_log.trace("extractBarcodeType (in): " + new String(identifier));
        byte[] noCode = new byte[]{0};
        LabelRow unknown = new LabelRow("SCAN_SDT_UNKNOWN", 0, "CI_LABEL_ID_UNKNOWN", noCode, noCode, noCode, noCode, noCode, noCode);
        unknown.setIdentifierLength(0);
        if (identifier.length == 0) {
            return unknown;
        }
        LabelRow result = unknown;
        for (int i = 0; i < this.labelIdentifiers.size(); ++i) {
            LabelRow labelRow = this.labelIdentifiers.get(i);
            if (!Arrays.equals(identifier, labelRow.getByteArray(this.indexMap[this.typeIndex])) || result != unknown) continue;
            result = labelRow;
            result.setIdentifierLength(identifier.length);
            m_log.debug("extractBarcodeType: Identifier length = " + Integer.toString(identifier.length));
        }
        m_log.trace("extractBarcodeType (out)");
        return result;
    }

    public String getCsvFile() {
        return this.m_csvFile;
    }

    public static LabelParser getInstance() {
        if (instance == null) {
            instance = new LabelParser();
        }
        return instance;
    }

    private void mapFields() {
        this.fieldMap = new HashMap();
        this.fieldMap.put(SFIELD_UPOSNAME, FIELD_UPOSNAME);
        this.fieldMap.put(SFIELD_UPOSID, FIELD_UPOSID);
        this.fieldMap.put(SFIELD_TAGNAME, FIELD_TAGNAME);
        this.fieldMap.put(SFIELD_USCODE, FIELD_USCODE);
        this.fieldMap.put(SFIELD_EUCODE, FIELD_EUCODE);
        this.fieldMap.put(SFIELD_IBMUSBOEM, FIELD_IBMUSBOEM);
        this.fieldMap.put("SCRS232", "SCRS232");
        this.fieldMap.put(SFIELD_OUTPREFIX, FIELD_OUTPREFIX);
        this.fieldMap.put(SFIELD_OUTSUFFIX, FIELD_OUTSUFFIX);
        this.indexMap = new String[this.fieldMap.size()];
        this.namedIndexMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseCommaSeparatedFile() {
        BufferedReader br = null;
        String line = "";
        String cvsSplitBy = ",";
        String csvFile = this.getCsvFile();
        boolean firstRow = true;
        try {
            br = new BufferedReader(new FileReader(csvFile));
            while ((line = br.readLine()) != null) {
                String[] fields;
                if (firstRow) {
                    firstRow = false;
                    fields = line.split(cvsSplitBy);
                    for (int i = 0; i < fields.length; ++i) {
                        if (!this.fieldMap.containsKey(fields[i])) continue;
                        this.indexMap[i] = this.fieldMap.get(fields[i]);
                        this.namedIndexMap.put(this.fieldMap.get(fields[i]), i);
                    }
                    continue;
                }
                fields = line.split(cvsSplitBy);
                LabelRow newRow = new LabelRow();
                int iIndex = -1;
                String sValue = "UNKNOWN";
                if (this.namedIndexMap.containsKey(FIELD_UPOSNAME) && fields.length > (iIndex = this.namedIndexMap.get(FIELD_UPOSNAME).intValue())) {
                    sValue = fields[iIndex];
                }
                newRow.setUPOSName(sValue);
                sValue = "UNKNOWN";
                if (this.namedIndexMap.containsKey(FIELD_TAGNAME) && fields.length > (iIndex = this.namedIndexMap.get(FIELD_TAGNAME).intValue())) {
                    sValue = fields[iIndex];
                }
                newRow.setTagName(sValue);
                sValue = "00";
                if (this.namedIndexMap.containsKey(FIELD_UPOSID) && fields.length > (iIndex = this.namedIndexMap.get(FIELD_UPOSID).intValue())) {
                    sValue = fields[iIndex];
                }
                newRow.setUPOSID(Integer.parseInt(sValue));
                sValue = "00";
                if (this.namedIndexMap.containsKey(FIELD_USCODE) && fields.length > (iIndex = this.namedIndexMap.get(FIELD_USCODE).intValue())) {
                    sValue = fields[iIndex];
                }
                newRow.setUSCode(FunctionLib.hexStringToByteArray(sValue));
                sValue = "00";
                if (this.namedIndexMap.containsKey(FIELD_EUCODE) && fields.length > (iIndex = this.namedIndexMap.get(FIELD_EUCODE).intValue())) {
                    sValue = fields[iIndex];
                }
                newRow.setEUCode(FunctionLib.hexStringToByteArray(sValue));
                sValue = "00";
                if (this.namedIndexMap.containsKey(FIELD_IBMUSBOEM) && fields.length > (iIndex = this.namedIndexMap.get(FIELD_IBMUSBOEM).intValue())) {
                    sValue = fields[iIndex];
                }
                newRow.setIBMUSBOEM(FunctionLib.hexStringToByteArray(sValue));
                sValue = "00";
                if (this.namedIndexMap.containsKey("SCRS232") && fields.length > (iIndex = this.namedIndexMap.get("SCRS232").intValue())) {
                    sValue = fields[iIndex];
                }
                newRow.setSCRS232(FunctionLib.hexStringToByteArray(sValue));
                sValue = "00";
                if (this.namedIndexMap.containsKey(FIELD_OUTPREFIX) && fields.length > (iIndex = this.namedIndexMap.get(FIELD_OUTPREFIX).intValue())) {
                    sValue = fields[iIndex];
                }
                newRow.setOutputPrefix(FunctionLib.hexStringToByteArray(sValue));
                sValue = "00";
                if (this.namedIndexMap.containsKey(FIELD_OUTSUFFIX) && fields.length > (iIndex = this.namedIndexMap.get(FIELD_OUTSUFFIX).intValue())) {
                    sValue = fields[iIndex];
                }
                newRow.setOutputSuffix(FunctionLib.hexStringToByteArray(sValue));
                this.labelIdentifiers.add(newRow);
            }
        }
        catch (RuntimeException re) {
            throw re;
            catch (FileNotFoundException e) {
                m_log.error("FileNotFoundException caught parsing CSV file (" + csvFile + "): ", (Throwable)e);
                this.cleanup(br);
                return;
            }
            catch (IOException e) {
                m_log.error("IOException caught parsing CSV file (" + csvFile + "): ", (Throwable)e);
                this.cleanup(br);
                return;
                {
                    catch (Throwable throwable) {
                        this.cleanup(br);
                        throw throwable;
                    }
                }
                catch (Exception e2) {
                    m_log.error("Exception caught parsing CSV file (" + csvFile + "): ", (Throwable)e2);
                    this.cleanup(br);
                    return;
                }
            }
        }
        this.cleanup(br);
        return;
    }

    public void setCsvFile(String csvFile) {
        this.m_csvFile = csvFile;
    }

    public void setDecodeType(String decodeType) {
        m_log.trace("setDecodeType (in)");
        this.typeIndex = this.namedIndexMap.get(FIELD_USCODE);
        if (decodeType == null) {
            m_log.error("setDecodeType: NULL decodeType specified, using default.");
            return;
        }
        if (decodeType.contains(DECODE_TYPE_EU)) {
            this.typeIndex = this.namedIndexMap.get(FIELD_EUCODE);
        } else if (decodeType.contains(DECODE_TYPE_SCRS232)) {
            this.typeIndex = this.namedIndexMap.get("SCRS232");
        } else if (decodeType.contains(DECODE_TYPE_OEM)) {
            this.typeIndex = this.namedIndexMap.get(FIELD_IBMUSBOEM);
        }
        m_log.trace("setDecodeType (out)");
    }
}

