/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.Branding;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScannerConfig;
import com.dls.jpos.common.DLSState;
import com.dls.jpos.interpretation.DLSScanner;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLS8xxxScanner
extends DLSScanner {
    private int CMD_POS = 0;
    private static final String enableCmd = "E";
    private static final String disableCmd = "D";
    private static final String resetCmd = "R";
    private static final String idRequestCmd = "i";
    private static final String healthRequestCmd = "h";
    private static final String statisticsCmd = "s";
    private static final String infoCmd = "#+OWI0\r\n";
    private static final String joinCmd = "\r\r$+RN0$-\r";
    private int nWaitingOnEot = 0;
    private byte[] sohBuf;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final Object objWaitSohBuf = new Object();
    private boolean bFirmware = false;
    boolean bBatteryInfo = false;
    boolean SendingMessage = false;
    private final Object objWaitAck = new Object();
    public int returnType = 0;
    public int returnQty = 1;
    private static final Logger m_log = LogManager.getLogger(DLS8xxxScanner.class);

    @Override
    protected int sendMsg(String msg) {
        return this.port.sendData(msg);
    }

    protected int sendMsg(byte[] buf) {
        return this.port.sendData(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendReceiveMsg(String msg) {
        Object object = this.objWaitSohBuf;
        synchronized (object) {
            this.sohBuf = EMPTY_BYTE_ARRAY;
            this.SendingMessage = true;
            int bytesRead = this.sendMsg(msg);
            try {
                this.objWaitSohBuf.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                m_log.error("Interrupted exception ", (Throwable)ie);
            }
        }
        return this.sohBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendRecord(String sRecord) {
        m_log.trace("sendRecord (in): " + sRecord);
        Object object = this.objWaitAck;
        synchronized (object) {
            this.bFirmware = true;
            this.nResponse = 255;
            this.sendMsg(sRecord);
            try {
                this.objWaitAck.wait(this.getRecordTimeout());
            }
            catch (InterruptedException ie) {
                m_log.error("Interrupt exception ", (Throwable)ie);
            }
        }
        m_log.trace("sendRecord (out): " + Integer.toString(this.nResponse));
        return this.nResponse;
    }

    @Override
    public void enable() throws DLSException {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        this.sendMsg(enableCmd);
        this.setState(DLSState.ENABLED);
    }

    @Override
    public void disable() throws DLSException {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        this.sendMsg(disableCmd);
        this.setState(DLSState.DISABLED);
    }

    @Override
    public void reset() throws DLSException {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        this.sendMsg(resetCmd);
    }

    @Override
    public void enableBeep() {
    }

    @Override
    public void disableBeep() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSelfTest() {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        this.bAlive = true;
        if (this.scannerConfig.getCanAcceptStatisticsCmd()) {
            Object object = this.objWaitSohBuf;
            synchronized (object) {
                this.sohBuf = EMPTY_BYTE_ARRAY;
                this.sendMsg(statisticsCmd);
                try {
                    this.objWaitSohBuf.wait(this.nTimeout);
                    if (this.sohBuf.length == 0) {
                        this.bAlive = false;
                        this.fireDeviceErrorEvent(-116);
                    }
                }
                catch (InterruptedException ie) {
                    m_log.error("doSelfTest: Interrupted. ", (Throwable)ie);
                }
            }
        }
    }

    @Override
    public boolean doHealthCheck() throws DLSException {
        if (DLSJposConst.updateInProgress) {
            return true;
        }
        boolean bRc = true;
        byte[] buf = this.sendReceiveMsg(healthRequestCmd);
        if (buf.length != 0) {
            this.logHealthCheck(buf);
        } else {
            m_log.error("Timeout on HealthCheck");
            bRc = false;
        }
        return bRc;
    }

    @Override
    public boolean isAlive() {
        if (DLSJposConst.updateInProgress) {
            return this.bAlive;
        }
        this.doSelfTest();
        return this.bAlive;
    }

    @Override
    public int sendJoin() {
        int sentBytes = this.sendMsg(joinCmd);
        return sentBytes;
    }

    @Override
    @Deprecated
    public int sendReset() {
        String outBuf = "#+PROG\r";
        int sentBytes = this.sendMsg(outBuf);
        return sentBytes;
    }

    @Override
    public void setFirmwareBaudRate() {
        m_log.trace("setFirmwareBaudRate (in)");
        m_log.trace("setFirmwareBaudRate (out)");
    }

    @Override
    public void restoreBaudRate() {
        m_log.trace("restoreBaudRate (in)");
        m_log.trace("restoreBaudRate (out)");
    }

    @Override
    public void updateConfiguration() {
        m_log.trace("updateConfiguration (in)");
        m_log.trace("updateConfiguration (out)");
    }

    @Override
    public DLSScannerConfig reportConfiguration() {
        m_log.trace("reportConfiguration (in)");
        m_log.trace("reportConfiguration (out)");
        return this.scannerConfig;
    }

    @Override
    public void directIO(int command, int[] data, Object object) throws DLSException {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        String strResult = "Invalid Command";
        switch (command) {
            case 320: {
                String sDispOne = (String)object;
                this.sendMsg("@" + sDispOne + "\r");
                strResult = "Single Line";
                break;
            }
            case 334: {
                Object[] inObject = (Object[])object;
                String[] inStringArray = (String[])inObject;
                this.sendMsg("@" + inStringArray[0] + inStringArray[1] + "\r");
                strResult = "Double Line";
                break;
            }
            case 332: {
                data[0] = this.returnType;
                break;
            }
            case 331: {
                data[0] = this.returnQty;
                this.returnQty = 1;
                break;
            }
            case 333: {
                byte[] outBuf = (byte[])object;
                int sentBytes = this.sendMsg(outBuf);
                data[0] = 0;
                strResult = "Display Data";
                break;
            }
            case 335: {
                data[0] = this.returnType;
                strResult = "Return Data";
                break;
            }
            case 336: {
                this.sendMsg(infoCmd);
                strResult = "Return Battery Data";
            }
        }
    }

    @Override
    public boolean hasStatisticsReporting() {
        return this.scannerConfig.getCanAcceptStatisticsCmd();
    }

    @Override
    public HashMap<String, Object> getStatistics(boolean bEnabled) throws DLSException {
        byte[] buf;
        m_log.trace("getStatistics (in): " + Boolean.toString(bEnabled));
        HashMap<String, Object> table = new HashMap<String, Object>();
        if (DLSJposConst.updateInProgress) {
            m_log.warn("Firmware update in progress. Cannot pull i-h-s during firmware update.");
            m_log.trace("getStatistics (out)");
            return table;
        }
        if (!this.scannerConfig.getCanAcceptStatisticsCmd()) {
            m_log.warn("Scanner does not support i-h-s data.");
            m_log.trace("getStatistics (out)");
            return table;
        }
        Object put = table.put("GoodScanCount", "NA");
        String strInfoString = "";
        String[] strInfo = null;
        String str = null;
        String truncated = null;
        String truncated2 = null;
        int i = 0;
        if (!bEnabled) {
            this.enable();
        }
        if ((buf = this.sendReceiveMsg(idRequestCmd)).length == 0) {
            throw new DLSException(-2147483640, "Error retrieving Information");
        }
        strInfoString = new String(buf);
        strInfo = strInfoString.split("\u0003");
        block20: for (i = 0; i < strInfo.length; ++i) {
            str = strInfo[i];
            truncated = str.replaceAll("\\p{Cntrl}", "");
            truncated2 = truncated.replaceAll("Sp<", "");
            if (truncated2.length() <= 1) continue;
            switch (truncated2.charAt(0)) {
                case 'r': {
                    put = table.put("RadiolHardwareVersion", truncated2.substring(1));
                    continue block20;
                }
                case 'A': {
                    put = table.put("RadioSoftwareVersion", truncated2.substring(1));
                    continue block20;
                }
                case 'M': {
                    put = table.put("ModelNumber", truncated2.substring(1));
                    continue block20;
                }
                case 'S': {
                    put = table.put("ScannerBoardSerialNumber", truncated2.substring(1));
                    continue block20;
                }
                case 'X': {
                    put = table.put("BaseModelNumber", truncated2.substring(1));
                    continue block20;
                }
                case 'Y': {
                    put = table.put("BaseSerialNumber", truncated2.substring(1));
                    continue block20;
                }
                case 'Z': {
                    put = table.put("BaseSoftwareVersion", truncated2.substring(1));
                }
            }
        }
        buf = this.sendReceiveMsg(statisticsCmd);
        if (buf.length == 0) {
            throw new DLSException(-2147483640, "Error retrieving Information");
        }
        strInfoString = new String(buf);
        strInfo = strInfoString.split("\u0003");
        block21: for (i = 0; i < strInfo.length; ++i) {
            str = strInfo[i];
            truncated = str.replaceAll("\\p{Cntrl}", "");
            truncated2 = truncated.replaceAll("Sp<", "");
            if (truncated2.length() <= 1) continue;
            switch (truncated2.charAt(0)) {
                case 'B': {
                    put = table.put("BatteryChargeCycles", truncated2.substring(1));
                    continue block21;
                }
                case 'T': {
                    put = table.put("TriggerPulls", truncated2.substring(1));
                    continue block21;
                }
                case 'K': {
                    put = table.put("KeyPresses", truncated2.substring(1));
                    continue block21;
                }
                case 'l': {
                    put = table.put("LaserTime", truncated2.substring(1));
                    continue block21;
                }
                case 'L': {
                    put = table.put("GoodScanCount", truncated2.substring(1));
                    continue block21;
                }
                case 'p': {
                    put = table.put("BaseHoursPoweredCount", truncated2.substring(1));
                }
            }
        }
        buf = this.sendReceiveMsg(healthRequestCmd);
        if (buf.length == 0) {
            throw new DLSException(-2147483640, "Error retrieving Information");
        }
        strInfoString = new String(buf);
        strInfo = strInfoString.split("\u0003");
        for (i = 0; i < strInfo.length; ++i) {
            str = strInfo[i];
            truncated = str.replaceAll("\\p{Cntrl}", "");
            truncated2 = truncated.replaceAll("Sp<", "");
            if (truncated2.length() <= 1) continue;
            switch (truncated2.charAt(0)) {
                case 'r': {
                    put = table.put("RadiolHealth", truncated2.substring(1));
                }
            }
        }
        put = table.put("DeviceCategory", "Scanner");
        put = table.put("Interface", "RS232");
        this.statistics = table;
        if (!bEnabled) {
            this.disable();
        }
        m_log.trace("getStatistics (out)");
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataReceived(byte[] inBuf, int inLen) {
        m_log.trace("onDataReceived (in): " + Integer.toString(inLen));
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        if (inBuf == null || inLen == 0) {
            m_log.error("onDataReceived called with null or empty buffer.");
            m_log.trace("onDataReceived (out)");
            return;
        }
        m_log.debug("onDataReceived: inBuf = " + new String(inBuf));
        if (this.bFirmware) {
            Object object = this.objWaitAck;
            synchronized (object) {
                this.nResponse = inBuf[0];
                this.bFirmware = false;
                this.objWaitAck.notify();
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        String value = new String(inBuf);
        if (this.bBatteryInfo) {
            m_log.debug("onDataReceived battery stats: \n" + value);
        }
        m_log.debug("onDataReceived:" + value);
        if (this.SendingMessage) {
            Object object = this.objWaitSohBuf;
            synchronized (object) {
                this.SendingMessage = false;
                this.sohBuf = Arrays.copyOf(inBuf, inBuf.length);
                this.objWaitSohBuf.notifyAll();
            }
            if (inBuf[0] == 1) {
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        byte[] tmpBuf = inBuf;
        byte pre = oInfo.getRxPrefix();
        if (tmpBuf.length > 2) {
            if (pre == tmpBuf[0]) {
                this.CMD_POS = 1;
            }
            int nType = this.extractLocalBarcodeType(tmpBuf[this.CMD_POS], tmpBuf[this.CMD_POS + 1]);
            byte[] barcode = this.extractLocalBarcodeLabel(tmpBuf, 0);
            String str = new String(tmpBuf);
            String[] pieces = str.split("%");
            if (pieces[2].contains("Q1.2")) {
                try {
                    this.returnQty = Integer.parseInt(pieces[1].substring(1));
                }
                catch (Exception e) {
                    this.returnQty = 0;
                }
            } else {
                this.returnQty = 0;
            }
            switch (pieces[pieces.length - 1].charAt(0)) {
                case 'V': {
                    this.returnType = 1;
                    break;
                }
                case 'K': {
                    this.returnType = 2;
                    break;
                }
                case 'E': {
                    this.returnType = 3;
                    str = "ESC";
                    tmpBuf = str.getBytes();
                    pieces = str.split("");
                    break;
                }
                case 'I': {
                    this.returnType = 4;
                    str = "INQ";
                    tmpBuf = str.getBytes();
                    pieces = str.split("");
                    break;
                }
                case 'O': {
                    this.returnType = 5;
                    break;
                }
            }
            Branding oBr = Branding.getInstance();
            String sProp = "com." + oBr.getBrandingPrefix() + ".jpos.service.ScannerService.sendCookedData";
            DLSProperties options = DLSProperties.getInstance();
            this.bSendCookedData = options.get(sProp, false);
            if (this.bSendCookedData) {
                tmpBuf = pieces[0].getBytes();
            }
            nType = this.returnType;
            String strTmpBuf = new String(tmpBuf);
            m_log.debug("onDataReceived2:" + strTmpBuf);
            this.fireLabelReceivedEvent(tmpBuf, pieces[0].getBytes(), nType);
            if (strTmpBuf.contains("INQ") || strTmpBuf.contains("ESC")) {
                this.fireLabelReceivedEvent(tmpBuf, tmpBuf, nType);
            } else {
                this.fireLabelReceivedEvent(tmpBuf, EMPTY_BYTE_ARRAY, nType);
            }
            tmpBuf = EMPTY_BYTE_ARRAY;
            pieces = new String[]{};
            inBuf = EMPTY_BYTE_ARRAY;
        }
        this.msgList.clear();
        m_log.trace("onDataReceived (out)");
    }

    private int extractLocalBarcodeType(byte b1, byte b2) {
        int nType = 0;
        switch (b1) {
            case 73: {
                nType = 106;
                break;
            }
            case 72: {
                nType = 105;
                break;
            }
            case 66: {
                nType = 103;
                break;
            }
            case 65: {
                nType = 104;
                break;
            }
            case 67: {
                nType = 102;
                break;
            }
            case 77: {
                nType = 108;
                break;
            }
            case 78: {
                nType = 107;
                break;
            }
            case 80: {
                nType = 120;
                break;
            }
            case 75: {
                nType = 110;
                break;
            }
            case 76: {
                nType = 109;
                break;
            }
            case 69: {
                nType = 131;
                break;
            }
            case 79: {
                nType = 501;
            }
        }
        return nType;
    }

    private byte[] extractLocalBarcodeLabel(byte[] inBuf, int offset) {
        int start = 1;
        switch (inBuf[offset]) {
            case 66: {
                start = 2;
                break;
            }
            case 82: {
                start = 2;
                break;
            }
            case 70: {
                start = inBuf[offset + 1] == 70 ? 2 : 1;
            }
        }
        byte[] buf = new byte[inBuf.length - 1 - (start + offset)];
        int j = 0;
        for (int i = start + offset; i < inBuf.length - 1; ++i) {
            buf[j++] = inBuf[i];
        }
        return buf;
    }

    @Override
    public int sendMessage(String sRecord) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

