/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.Branding;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.LabelParser;
import com.dls.jpos.common.LabelRow;
import com.dls.jpos.interpretation.DLSSerialScanner;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLS9xxxScanner
extends DLSSerialScanner {
    private static final String reset$SCmd = "$S,Ar\r";
    private static final String infoCmd = "#+OWI0\r\n";
    private static final String joinCmd = "\r\r$+RN0$-\r";
    private static final String acceptHostCmd = "$S,CIFIH00,Ar\r";
    private static final String rejectHostCmd = "$S,CIFIH01,Ar\r";
    private static final String hostCmdResponse = "$>,>,>";
    private static final String resetCmdResponse = "$>,>\r";
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private boolean bBatteryInfo = false;
    public int returnType = 0;
    public int returnQty = 1;
    public int resetTimeout;
    private static final Logger m_log = LogManager.getLogger(DLS9xxxScanner.class);

    public DLS9xxxScanner() {
        Branding oBr = Branding.getInstance();
        String sProp = "com." + oBr.getBrandingPrefix() + ".jpos.service.Scanner.resetTimeout";
        DLSProperties options = DLSProperties.getInstance();
        this.resetTimeout = options.get(sProp, 40000);
    }

    @Override
    public void reset() throws DLSException {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        try {
            this.sendMsg(reset$SCmd);
            m_log.debug("sleeping for " + this.resetTimeout + " milliseconds [no new commands on this thread]...");
            Thread.sleep(this.resetTimeout);
        }
        catch (InterruptedException ex) {
            m_log.error("InterruptedException in reset(): ", (Throwable)ex);
        }
        catch (Exception e) {
            m_log.error("Exception in reset(): ", (Throwable)e);
        }
    }

    public byte[] acceptHostCommands() {
        try {
            this.sendMsg(acceptHostCmd);
            m_log.debug("Sleeping for " + this.resetTimeout + " milliseconds [no new commands on this thread]...");
            Thread.sleep(this.resetTimeout);
        }
        catch (InterruptedException ie) {
            m_log.error("Interrupted Exception in acceptHostCommands(): ", (Throwable)ie);
        }
        catch (Exception e) {
            m_log.error("Exception in acceptHostCommands(): ", (Throwable)e);
        }
        byte[] buf = this.sendReceiveMsg("h");
        if (buf.length == 0) {
            m_log.error("Could not retrieve health after resetTimeout.");
        }
        return buf;
    }

    public byte[] rejectHostCommands() {
        byte[] buf = EMPTY_BYTE_ARRAY;
        try {
            this.sendMsg(rejectHostCmd);
            m_log.debug("Sleeping for " + this.resetTimeout + " milliseconds [no new commands on this thread]...");
            Thread.sleep(this.resetTimeout);
            buf = new byte[1];
        }
        catch (InterruptedException ie) {
            m_log.error("Interrupted Exception in rejectHostCommands(): ", (Throwable)ie);
            buf = EMPTY_BYTE_ARRAY;
        }
        catch (Exception e) {
            m_log.error("Exception in rejectHostCommands(): ", (Throwable)e);
            buf = EMPTY_BYTE_ARRAY;
        }
        return buf;
    }

    @Override
    public int sendJoin() {
        int sentBytes = this.sendMsg(joinCmd);
        return sentBytes;
    }

    @Override
    public void setFirmwareBaudRate() {
        m_log.debug("setFirmwareBaudRate called - no action for PowerScan 9500.");
    }

    @Override
    public void restoreBaudRate() {
        m_log.debug("restoreBaudRate called - no action for PowerScan 9500.");
    }

    @Override
    public void directIO(int command, int[] data, Object object) throws DLSException {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        String strResult = "Invalid Command";
        switch (command) {
            case 320: {
                this.acceptHostCommands();
                String sDispOne = object.toString();
                this.sendMsg("@" + sDispOne + "\r");
                strResult = "Single Line";
                this.rejectHostCommands();
                break;
            }
            case 334: {
                this.acceptHostCommands();
                Object[] inObject = (Object[])object;
                String[] inStringArray = (String[])inObject;
                this.sendMsg("@" + inStringArray[0] + inStringArray[1] + "\r");
                strResult = "Double Line";
                this.rejectHostCommands();
                break;
            }
            case 332: {
                data[0] = this.returnType;
                break;
            }
            case 331: {
                data[0] = this.returnQty;
                this.returnQty = 1;
                break;
            }
            case 333: {
                this.acceptHostCommands();
                int sentBytes = this.sendMsg(object.toString());
                data[0] = 0;
                strResult = "Display Data";
                this.rejectHostCommands();
                break;
            }
            case 335: {
                data[0] = this.returnType;
                strResult = "Return Data";
                break;
            }
            case 336: {
                strResult = this.statistics.containsKey("BatteryChargeCycles") ? "Return Battery Data: " + this.statistics.get("BatteryChargeCycles") : "Battery Data Not Available";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataReceived(byte[] inBuf, int inLen) {
        m_log.trace("onDataReceived (in): " + Integer.toString(inLen));
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        if (inBuf == null || inLen == 0) {
            m_log.error("onDataReceived() called with null or empty buffer.");
            m_log.trace("onDataReceived (out)");
            return;
        }
        m_log.debug("onDataReceived: inBuf = " + new String(inBuf));
        String value = new String(inBuf);
        if (this.bFirmware) {
            Object object = this.objWaitAck;
            synchronized (object) {
                this.nResponse = inBuf[0];
                this.bFirmware = false;
                m_log.debug("onDataReceived (Firmware):" + this.nResponse);
                this.objWaitAck.notify();
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        if (this.bBatteryInfo) {
            m_log.debug("onDataReceived (Battery Stats): \n" + value);
        }
        m_log.debug("onDataReceived: " + value);
        if (this.bStatMessageSent) {
            Object object = this.objWaitSohBuf;
            synchronized (object) {
                this.bStatMessageSent = false;
                this.sohBuf = Arrays.copyOf(inBuf, inBuf.length);
                this.objWaitSohBuf.notifyAll();
            }
            if (inBuf[0] == 1) {
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        byte[] tmpBuf = inBuf;
        byte pre = oInfo.getRxPrefix();
        if (tmpBuf.length > 2) {
            if (pre == tmpBuf[0]) {
                this.CMD_POS = 1;
            }
            byte[] identifier = new byte[]{tmpBuf[this.CMD_POS], tmpBuf[this.CMD_POS + 1], tmpBuf[this.CMD_POS + 2]};
            LabelRow labelRow = this.extractBarcodeType(identifier);
            int type = labelRow.getUPOSID();
            int identifierLength = labelRow.getIdentifierLength();
            byte[] barcode = this.extractLocalBarcodeLabel(tmpBuf, identifierLength);
            type = LabelParser.addOns(barcode, type);
            String str = new String(inBuf);
            String[] pieces = str.split("%");
            if (pieces[2].contains("Q1.2")) {
                try {
                    this.returnQty = Integer.parseInt(pieces[1].substring(1));
                }
                catch (Exception e) {
                    this.returnQty = 0;
                }
            } else {
                this.returnQty = 0;
            }
            switch (pieces[pieces.length - 1].charAt(0)) {
                case 'V': {
                    this.returnType = 1;
                    break;
                }
                case 'K': {
                    this.returnType = 2;
                    break;
                }
                case 'E': {
                    this.returnType = 3;
                    str = "ESC";
                    tmpBuf = str.getBytes();
                    pieces = str.split("");
                    break;
                }
                case 'I': {
                    this.returnType = 4;
                    str = "INQ";
                    tmpBuf = str.getBytes();
                    pieces = str.split("");
                    break;
                }
                case 'O': {
                    this.returnType = 5;
                    break;
                }
            }
            Branding oBr = Branding.getInstance();
            String sProp = "com." + oBr.getBrandingPrefix() + ".jpos.service.ScannerService.sendCookedData";
            DLSProperties options = DLSProperties.getInstance();
            this.bSendCookedData = options.get(sProp, false);
            if (this.bSendCookedData) {
                tmpBuf = pieces[0].getBytes();
            }
            type = this.returnType;
            String strTmpBuf = new String(tmpBuf);
            m_log.debug("onDataReceived (Label):" + strTmpBuf);
            this.fireLabelReceivedEvent(tmpBuf, pieces[0].getBytes(), type);
            if (strTmpBuf.contains("INQ") || strTmpBuf.contains("ESC")) {
                this.fireLabelReceivedEvent(tmpBuf, tmpBuf, type);
            } else {
                this.fireLabelReceivedEvent(tmpBuf, EMPTY_BYTE_ARRAY, type);
            }
            tmpBuf = EMPTY_BYTE_ARRAY;
            pieces = new String[]{};
            inBuf = EMPTY_BYTE_ARRAY;
        }
        this.msgList.clear();
        m_log.trace("onDataReceived (out)");
    }

    private byte[] extractLocalBarcodeLabel(byte[] inBuf, int offset) {
        int start = 1;
        switch (inBuf[offset]) {
            case 66: {
                start = 2;
                break;
            }
            case 82: {
                start = 2;
                break;
            }
            case 70: {
                start = inBuf[offset + 1] == 70 ? 2 : 1;
            }
        }
        byte[] buf = new byte[inBuf.length - 1 - (start + offset)];
        int j = 0;
        for (int i = start + offset; i < inBuf.length - 1; ++i) {
            buf[j++] = inBuf[i];
        }
        return buf;
    }

    @Override
    public int sendMessage(String sMessage) {
        byte[] buf = EMPTY_BYTE_ARRAY;
        buf = sMessage.equals("acceptHostCmd") ? this.acceptHostCommands() : (sMessage.equals("rejectHostCmd") ? this.rejectHostCommands() : this.sendReceiveMsg(sMessage));
        return buf.length;
    }
}

