/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSObjectFactory;
import com.dls.jpos.common.DLSState;
import com.dls.jpos.common.FunctionLib;
import com.dls.jpos.interpretation.DeviceErrorStatusListener;
import com.dls.jpos.interpretation.DirectIODataListener;
import com.dls.jpos.service.DLSScannerService;
import com.dls.jpos.transport.DLSPort;
import com.dls.jpos.transport.DataReceivedListener;
import com.dls.jpos.transport.DeviceAddedListener;
import com.dls.jpos.transport.DeviceReattachedListener;
import com.dls.jpos.transport.DeviceRemovedListener;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DLSDevice
implements DataReceivedListener,
DeviceAddedListener,
DeviceRemovedListener,
DeviceReattachedListener {
    @Deprecated
    public DLSDeviceInfo info = null;
    private String strLogicalName = null;
    DLSPort port = null;
    ArrayList<Object> deviceErrorListeners;
    ArrayList<Object> deviceStatusListeners;
    ArrayList<Object> directIODataListeners;
    boolean bAlive = false;
    int nTimeout = 5000;
    private boolean bNeedBCC = false;
    private int lastPos = 0;
    ByteArrayOutputStream bs;
    ArrayList<Object> msgList;
    HashMap<String, Object> statistics;
    private DLSState deviceState = DLSState.CLOSED;
    private static final Logger m_log = LogManager.getLogger(DLSDevice.class);

    public DLSDevice() {
        this.deviceErrorListeners = new ArrayList();
        this.deviceStatusListeners = new ArrayList();
        this.directIODataListeners = new ArrayList();
        this.bs = new ByteArrayOutputStream();
        this.msgList = new ArrayList();
        this.info = new DLSDeviceInfo();
    }

    public void addDeviceErrorListener(DeviceErrorStatusListener del) {
        m_log.trace("addDeviceErrorListener (in)");
        this.deviceErrorListeners.add(del);
        m_log.trace("addDeviceErrorListener (out)");
    }

    public void addDeviceStatusListener(DeviceErrorStatusListener dsl) {
        m_log.trace("addDeviceStatusListener (in)");
        this.deviceStatusListeners.add(dsl);
        m_log.trace("addDeviceStatusListener (out)");
    }

    public void addDirectIODataListener(DirectIODataListener dl) {
        m_log.trace("addDirectIODataListener (in)");
        this.directIODataListeners.add(dl);
        m_log.trace("addDirectIODataListener (out)");
    }

    protected char blockCheckCharacter(String message) {
        char bcc = '\u0000';
        int length = message.length();
        for (int i = 0; i < length; ++i) {
            bcc = (char)(bcc ^ message.charAt(i));
        }
        return bcc;
    }

    public void claim(long lTimeout) throws DLSException {
        m_log.trace("claim (in): " + Long.toString(lTimeout));
        if (this.port != null && this.port.isOpen()) {
            this.port.closePort();
            this.release();
        }
        this.port = DLSObjectFactory.createPort(this.getDeviceInfo());
        if (!this.port.openPort()) {
            m_log.error("Error opening port");
            throw new DLSException(-2147483644, "Port open error");
        }
        this.setState(DLSState.CLAIMED);
        this.port.addDataReceivedListener(this);
        this.port.addDeviceAddedListener(this);
        this.port.addDeviceRemovedListener(this);
        this.port.addDeviceReattachedListener(this);
        this.internalClaim();
        m_log.trace("claim (out)");
    }

    public void close() throws DLSException {
        m_log.trace("close (in)");
        if (this.port != null && this.port.isOpen()) {
            this.port.removeDataReceivedListener(this);
            m_log.debug("port.removeDataReceivedListener(this)");
            this.port.closePort();
            m_log.debug("port.closePort()");
            this.port = null;
        }
        this.setState(DLSState.CLOSED);
        m_log.trace("close (out)");
    }

    protected void concatUSBMessages(byte[] inBuf, boolean bEOD) {
        m_log.trace("concatUSBMessages (in)");
        for (int i = 0; i < inBuf.length; ++i) {
            this.bs.write(inBuf[i]);
        }
        if (bEOD) {
            byte[] tmpBuf = this.bs.toByteArray();
            boolean add = this.msgList.add(tmpBuf);
            if (!add) {
                m_log.error("concatUSBMessages: Failed to add buffer to msgList.");
            }
            this.bs.reset();
        }
        m_log.trace("concatUSBMessages (out)");
    }

    public abstract void directIO(int var1, int[] var2, Object var3) throws DLSException;

    public abstract void disable() throws DLSException;

    public abstract boolean doHealthCheck() throws DLSException;

    public abstract void doSelfTest() throws DLSException;

    public abstract void enable() throws DLSException;

    protected void fireDeviceErrorEvent(int errorCode) {
        m_log.trace("fireDeviceErrorEvent (in): " + errorCode);
        m_log.debug("fireDeviceErrorEvent: " + DLSScannerService.convertStatusToReadable(errorCode));
        Enumeration<Object> e = Collections.enumeration(this.deviceErrorListeners);
        while (e.hasMoreElements()) {
            DeviceErrorStatusListener listener = (DeviceErrorStatusListener)e.nextElement();
            listener.onDeviceError(errorCode);
        }
        m_log.trace("fireDeviceErrorEvent (out)");
    }

    protected void fireDeviceStatusEvent(int statusCode) {
        m_log.trace("fireDeviceStatusEvent (in): " + Integer.toString(statusCode));
        if (statusCode == -200) {
            m_log.info("fireDeviceStatusEvent: STATUS_ALIVE " + statusCode);
        }
        if (statusCode == -201) {
            m_log.info("fireDeviceStatusEvent: STATUS_NOT_ALIVE " + statusCode);
        }
        if (statusCode == -202) {
            m_log.info("fireDeviceStatusEvent: STATUS_ENABLED " + statusCode);
        }
        if (statusCode == -203) {
            m_log.info("fireDeviceStatusEvent: STATUS_NOT_ENABLED " + statusCode);
        }
        switch (statusCode) {
            case 11: {
                m_log.info("SCAL_SUE_STABLE_WEIGHT");
                break;
            }
            case 12: {
                m_log.info("SCAL_SUE_WEIGHT_UNSTABLE");
                break;
            }
            case 13: {
                m_log.info("SCAL_SUE_WEIGHT_ZERO");
                break;
            }
            case 14: {
                m_log.info("SCAL_SUE_WEIGHT_OVERWEIGHT");
                break;
            }
            case 15: {
                m_log.info("SCAL_SUE_NOT_READY");
                break;
            }
            case 16: {
                m_log.info("SCAL_SUE_WEIGHT_UNDER_ZERO");
                break;
            }
        }
        Enumeration<Object> e = Collections.enumeration(this.deviceStatusListeners);
        while (e.hasMoreElements()) {
            DeviceErrorStatusListener listener = (DeviceErrorStatusListener)e.nextElement();
            listener.onDeviceStatus(statusCode);
        }
        m_log.trace("fireDeviceStatusEvent (out)");
    }

    protected void fireDirectIODataEvent(int cmd, byte[] buf) {
        m_log.trace("fireDirectIODataEvent (in): " + cmd);
        Enumeration<Object> e = Collections.enumeration(this.deviceErrorListeners);
        while (e.hasMoreElements()) {
            DirectIODataListener listener = (DirectIODataListener)e.nextElement();
            listener.onDirectIOData(cmd, buf);
        }
        m_log.trace("fireDirectIODataEvent (out)");
    }

    public abstract DLSCConfig getConfiguration();

    public boolean getDeviceEnabled() {
        return this.getState() == DLSState.ENABLED;
    }

    public DLSDeviceInfo getDeviceInfo() {
        return this.info;
    }

    public String getLogicalName() {
        return this.strLogicalName;
    }

    public synchronized DLSState getState() {
        return this.deviceState;
    }

    public HashMap<String, Object> getStatistics() throws DLSException {
        throw new DLSException(-2147483642, "getStatistics not supported for this device.");
    }

    public HashMap<String, Object> getStatistics(boolean bEnabled) throws DLSException {
        throw new DLSException(-2147483642, "getStatistics not supported for this device.");
    }

    public String[] getStatisticsData(Character character, HashMap<String, Object> scannerInfo, int devicesProcessed) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String[] getStatisticsData(Character character, HashMap<String, Object> primaryScannerStats) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean hasStatisticsReporting() {
        return false;
    }

    protected void internalClaim() {
    }

    protected void internalRelease() {
    }

    public abstract boolean isAlive() throws DLSException;

    @Override
    public void onDataReceived(byte[] inBuf, int len) {
    }

    @Override
    public void onDeviceAdded() {
    }

    public void onDeviceArrival() {
    }

    @Override
    public void onDeviceReattached() {
    }

    @Override
    public void onDeviceRemoved() {
    }

    public void open(String strLogicalName) throws DLSException {
        m_log.trace("open (in): " + strLogicalName);
        this.setLogicalName(strLogicalName);
        DLSDeviceInfo oInfo = new DLSDeviceInfo();
        oInfo.loadConfiguration(strLogicalName);
        this.setDeviceInfo(oInfo);
        m_log.trace("open (out)");
    }

    protected void parseMessages(byte[] inBuf, byte endChar, boolean bUseBCC) {
        m_log.trace("parseMessages (in): " + new String(inBuf) + ", " + Byte.toString(endChar) + ", " + Boolean.toString(bUseBCC));
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        boolean bUseCR_OR_LF = oInfo.getOptionAsBoolean("useSunJavaxComm");
        for (int i = 0; i < inBuf.length; ++i) {
            byte[] tmpBuf;
            this.bs.write(inBuf[i]);
            if (this.bNeedBCC) {
                this.bNeedBCC = false;
                tmpBuf = this.bs.toByteArray();
                boolean add = this.msgList.add(tmpBuf);
                this.bs.reset();
                continue;
            }
            if (inBuf[i] != endChar && (!bUseCR_OR_LF || inBuf[i] != 10)) continue;
            if (bUseBCC) {
                this.bNeedBCC = true;
                continue;
            }
            if (i < inBuf.length - 1 && (endChar == 10 || endChar == 13)) continue;
            tmpBuf = this.bs.toByteArray();
            String sBuf = FunctionLib.byteArrayToString(tmpBuf);
            m_log.debug("parseMessages: adding to msgList with: " + sBuf);
            boolean add = this.msgList.add(tmpBuf);
            if (!add) {
                m_log.warn("parseMessages: failed ot add to msgList.");
            }
            this.bs.reset();
        }
        m_log.trace("parseMessages (out)");
    }

    protected void parseMessages(byte[] inBuf, byte endChar) {
        this.parseMessages(inBuf, endChar, false);
    }

    public void release() throws DLSException {
        m_log.trace("release (in)");
        if (this.port == null) {
            m_log.error("release: Member attribute 'port' is null.");
            m_log.trace("release (out)");
            return;
        }
        if (this.port.isOpen()) {
            this.port.closePort();
        }
        this.port.removeDataReceivedListener(this);
        this.port.removeDeviceAddedListener(this);
        this.port.removeDeviceRemovedListener(this);
        this.port.removeDeviceReattachedListener(this);
        this.internalRelease();
        this.setState(DLSState.RELEASED);
        m_log.trace("release (out)");
    }

    public void removeDeviceErrorListener(DeviceErrorStatusListener del) {
        m_log.trace("removeDeviceErrorListener (in)");
        this.deviceErrorListeners.remove(del);
        m_log.trace("removeDeviceErrorListener (out)");
    }

    public void removeDeviceStatusListener(DeviceErrorStatusListener dsl) {
        m_log.trace("removeDeviceStatusListener (in)");
        boolean re = this.deviceStatusListeners.remove(dsl);
        if (!re) {
            m_log.warn("removeDeviceStatusListener: failed to remove.");
        }
        m_log.trace("removeDeviceStatusListener (out)");
    }

    public void removeDirectIODataListener(DirectIODataListener dl) {
        m_log.trace("removeDirectIODataListener (in)");
        boolean re = this.directIODataListeners.remove(dl);
        if (!re) {
            m_log.warn("removeDirectIODataListener: failed to remove.");
        }
        m_log.trace("removeDirectIODataListener (out)");
    }

    public abstract void reset() throws DLSException;

    public abstract int sendJoin();

    protected int sendMsg(String strMsg) {
        int iRes = 0;
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        m_log.trace("sendMsg (in): " + strMsg);
        StringBuilder msg = new StringBuilder();
        byte b = oInfo.getTxPrefix();
        if (b != 0) {
            msg.append((char)oInfo.getTxPrefix());
        }
        msg.append(strMsg);
        msg.append((char)oInfo.getTxTrailer());
        if (oInfo.getUseBCC()) {
            strMsg = strMsg + (char)oInfo.getTxTrailer();
            msg.append(this.blockCheckCharacter(strMsg));
        }
        iRes = this.port.sendData(msg.toString());
        m_log.trace("sendMsg (out): " + Integer.toString(iRes));
        return iRes;
    }

    @Deprecated
    public abstract int sendReset();

    public void setDeviceInfo(DLSDeviceInfo oInfo) {
        this.info = oInfo;
    }

    public void setLogicalName(String sLogicalName) {
        this.strLogicalName = sLogicalName;
    }

    public synchronized void setState(DLSState nextState) throws DLSException {
        m_log.trace("setState (in): " + nextState.toString());
        switch (nextState) {
            case CLOSED: {
                if (this.deviceState == DLSState.CLOSED) {
                    m_log.info("setState:  state is already " + nextState.toString());
                    m_log.trace("setState (out)");
                    return;
                }
                if (this.deviceState == DLSState.OPENED || this.deviceState == DLSState.RELEASED) break;
                m_log.error("setState: Invalid State Transition, " + this.deviceState.toString() + " --> " + nextState.toString());
                throw new DLSException(-2147483636, "Unable to transition to state: " + nextState.toString());
            }
            case OPENED: {
                if (this.deviceState == DLSState.OPENED) {
                    m_log.info("setState:  state is already " + nextState.toString());
                    m_log.trace("setState (out)");
                    return;
                }
                if (this.deviceState == DLSState.CLOSED) break;
                m_log.error("setState: Invalid State Transition, " + this.deviceState.toString() + " --> " + nextState.toString());
                throw new DLSException(-2147483636, "Unable to transition to state: " + nextState.toString());
            }
            case CLAIMED: {
                if (this.deviceState == DLSState.CLAIMED) {
                    m_log.info("setState:  state is already " + nextState.toString());
                    m_log.trace("setState (out)");
                    return;
                }
                if (this.deviceState == DLSState.OPENED || this.deviceState == DLSState.RELEASED) break;
                m_log.error("setState: Invalid State Transition, " + this.deviceState.toString() + " --> " + nextState.toString());
                throw new DLSException(-2147483636, "Unable to transition to state: " + nextState.toString());
            }
            case ENABLED: {
                if (this.deviceState == DLSState.ENABLED) {
                    m_log.info("setState:  state is already " + nextState.toString());
                    m_log.trace("setState (out)");
                    return;
                }
                if (this.deviceState == DLSState.CLAIMED || this.deviceState == DLSState.DISABLED) break;
                m_log.error("setState: Invalid State Transition, " + this.deviceState.toString() + " --> " + nextState.toString());
                throw new DLSException(-2147483636, "Unable to transition to state: " + nextState.toString());
            }
            case DISABLED: {
                if (this.deviceState == DLSState.DISABLED) {
                    m_log.info("setState:  state is already " + nextState.toString());
                    m_log.trace("setState (out)");
                    return;
                }
                if (this.deviceState == DLSState.ENABLED) break;
                m_log.error("setState: Invalid State Transition, " + this.deviceState.toString() + " --> " + nextState.toString());
                throw new DLSException(-2147483636, "Unable to transition to state: " + nextState.toString());
            }
            case RELEASED: {
                if (this.deviceState == DLSState.RELEASED) {
                    m_log.info("setState:  state is already " + nextState.toString());
                    m_log.trace("setState (out)");
                    return;
                }
                if (this.deviceState == DLSState.DISABLED || this.deviceState == DLSState.CLAIMED) break;
                m_log.error("setState: Invalid State Transition, " + this.deviceState.toString() + " --> " + nextState.toString());
                throw new DLSException(-2147483636, "Unable to transition to state: " + nextState.toString());
            }
            default: {
                m_log.error("setState: Unknown state - " + nextState.toString());
                throw new DLSException(-2147483636, "Unknown state: " + nextState.toString());
            }
        }
        this.deviceState = nextState;
        m_log.info("setState: DEVICE STATE = " + this.deviceState.toString());
        m_log.trace("setState (out)");
    }
}

