/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.Branding;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScannerConfig;
import com.dls.jpos.common.DLSState;
import com.dls.jpos.common.LabelRow;
import com.dls.jpos.interpretation.DLSScanner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSPortalScanner
extends DLSScanner {
    protected int CMD_POS = 0;
    protected static final String enableCmd = "e\u0004";
    protected static final byte enableCmdByte = 101;
    protected static final String enableBeepCmd = "b";
    protected static final String disableCmd = "d\u0001";
    protected static final byte disableCmdByte = 100;
    protected static final String sleepCmd = "z";
    protected static final String shutdownCmd = "o";
    protected static final String posConnectedMessageCmd = "a";
    protected static final String playSoundCmd = "b";
    protected static final String writeConfigCmd = "c";
    protected static final String readConfigCmd = "w";
    protected static final String readConfigParamCmd = "v";
    protected static final String resetPortalScannerCmd = "r";
    protected static final String restartPortalScannerCmd = "u";
    protected static final String requestImageCmd = "q";
    protected static final String transactionStateCmd = "t";
    protected static final String signalItemCmd = "s";
    protected static final String identifyItemCmd = "i";
    protected static final String additionalItemScannedCmd = "x";
    protected static final String scannerIdentificationCmd = "k";
    protected static final String scannerHealthExtendedCmd = "g";
    protected static final String scannerHealthSummaryCmd = "h";
    protected static final String scannerStatisticsCmd = "n";
    protected static final String heartbeatResponseCmd = "y";
    protected static final String setItemIdCmd = "j";
    protected static final String setItemColorCmd = "l";
    protected static final String operatorSignOnCmd = "m";
    protected static final String labelDataMessageCmd = "B";
    protected static final String lightlyCmd = "LIGHTLY";
    protected static final String deeplyCmd = "DEEPLY";
    protected static final int MIN_SOUND_NUMBER = 0;
    protected static final int MAX_SOUND_NUMBER = 17;
    protected int byte0 = 0;
    protected int byte1 = 0;
    protected int byte2 = 0;
    protected int byte3 = 0;
    protected int nWaitingOnEot = 0;
    protected byte[] sohBuf;
    protected final Object objWaitSohBuf = new Object();
    protected boolean bFirmware = false;
    protected boolean bStatMessageSent = false;
    public int deviceNumber = 0;
    protected final Object objWaitAck = new Object();
    String decodeType = null;
    protected final Object dioResp = new Object();
    protected byte[] dioBuff = null;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected boolean bInternalDIO = false;
    private int m_labelMessages = 0;
    private static final Logger m_log = LogManager.getLogger(DLSPortalScanner.class);

    public int getLabelMessageCount() {
        return this.m_labelMessages;
    }

    protected void setLabelMessageCount(int count) {
        this.m_labelMessages = count;
    }

    @Override
    protected int sendMsg(String msg) {
        return this.port.sendData(msg);
    }

    protected int sendMsg(byte[] msg) {
        return this.port.sendData(msg);
    }

    protected int sendMsgToDevice(String msg, int devNum) {
        return this.port.sendData(msg);
    }

    @Override
    public int sendMessage(String sRecord) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendReceiveMsg(String msg) {
        Object object = this.objWaitSohBuf;
        synchronized (object) {
            this.sohBuf = EMPTY_BYTE_ARRAY;
            int x = this.sendMsg(msg);
            try {
                this.objWaitSohBuf.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                m_log.error("Interrupt exception ", (Throwable)ie);
            }
        }
        return this.sohBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendDIO(String cmd) {
        byte[] buf = EMPTY_BYTE_ARRAY;
        boolean resultRetrieved = false;
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        if (DLSJposConst.updateInProgress) {
            return buf;
        }
        try {
            Object object = this.dioResp;
            synchronized (object) {
                this.bInternalDIO = true;
                this.dioBuff = EMPTY_BYTE_ARRAY;
                long cmdTime = System.currentTimeMillis();
                this.sendMsg(cmd);
                try {
                    do {
                        this.dioResp.wait();
                        if (this.dioBuff.length == 0 || this.dioBuff[0] == 88) continue;
                        bStream.write(this.dioBuff, 0, this.dioBuff.length);
                        resultRetrieved = true;
                    } while (this.dioBuff.length != 0 && !resultRetrieved && System.currentTimeMillis() - cmdTime <= (long)this.nTimeout);
                }
                catch (InterruptedException ie) {
                    m_log.error("sendDIO InterruptedException: ", (Throwable)ie);
                }
            }
            buf = bStream.toByteArray();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            m_log.error("doInternalSend exception: ", (Throwable)e);
        }
        this.bInternalDIO = false;
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendDIO(byte[] pdu) {
        byte[] resp = EMPTY_BYTE_ARRAY;
        boolean resultRetrieved = false;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (DLSJposConst.updateInProgress) {
            return resp;
        }
        try {
            Object object = this.dioResp;
            synchronized (object) {
                this.bInternalDIO = true;
                this.dioBuff = EMPTY_BYTE_ARRAY;
                long cmdTime = System.currentTimeMillis();
                this.sendMsg(pdu);
                try {
                    do {
                        this.dioResp.wait();
                        if (this.dioBuff.length == 0 || this.dioBuff[0] == 88) continue;
                        stream.write(this.dioBuff, 0, this.dioBuff.length);
                        resultRetrieved = true;
                    } while (this.dioBuff.length != 0 && !resultRetrieved && System.currentTimeMillis() - cmdTime <= (long)this.nTimeout);
                }
                catch (InterruptedException ie) {
                    m_log.error("sendDIO: Interrupted. ", (Throwable)ie);
                }
                resp = stream.toByteArray();
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            m_log.error("sendDIO: Exception while sending. ", (Throwable)e);
        }
        this.bInternalDIO = false;
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendRecord(String sRecord) {
        m_log.trace("sendRecord (in): " + sRecord);
        Object object = this.objWaitAck;
        synchronized (object) {
            this.bFirmware = true;
            this.nResponse = 255;
            int x = this.sendMsg(sRecord);
            try {
                this.objWaitAck.wait(this.getRecordTimeout());
            }
            catch (InterruptedException ie) {
                m_log.error("Interrupt exception ", (Throwable)ie);
            }
        }
        m_log.trace("sendRecord (out): " + Integer.toString(this.nResponse));
        return this.nResponse;
    }

    @Override
    public void enable() throws DLSException {
        m_log.trace("enable (in)");
        int[] aiResult = new int[10];
        if (DLSJposConst.updateInProgress) {
            m_log.trace("enable (out)");
            return;
        }
        byte[] abResp = this.sendDIO(enableCmd);
        String sMsg = this.parseAck(abResp, aiResult);
        if (aiResult[0] == 65 && sMsg.startsWith("OK")) {
            this.setState(DLSState.ENABLED);
            m_log.debug("Enabled PortalScanner: " + sMsg);
            m_log.trace("enable (out)");
            return;
        }
        m_log.warn("Failed to enable PortalScanner: " + sMsg);
        m_log.trace("enable (out)");
        throw new DLSException(-1, sMsg);
    }

    @Override
    public void disable() throws DLSException {
        m_log.trace("disable (in)");
        int[] aiResult = new int[10];
        if (DLSJposConst.updateInProgress) {
            m_log.trace("disable (out)");
            return;
        }
        if (!this.getDeviceEnabled()) {
            m_log.trace("disable (out)");
            return;
        }
        byte[] abResp = this.sendDIO(disableCmd);
        String sMsg = this.parseAck(abResp, aiResult);
        if (aiResult[0] == 65 && sMsg.startsWith("OK")) {
            this.setState(DLSState.DISABLED);
            m_log.debug("Disabled PortalScanner: " + sMsg);
            m_log.trace("disable (out)");
            return;
        }
        m_log.warn("Failed to disable PortalScanner: " + sMsg);
        m_log.trace("disable (out)");
        throw new DLSException(-1, sMsg);
    }

    @Override
    public void reset() throws DLSException {
        m_log.trace("reset (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("reset (out)");
            return;
        }
        int x = this.sendMsg(resetPortalScannerCmd);
        m_log.trace("reset (out)");
    }

    public void heartBeatResponse() throws DLSException {
    }

    @Override
    public void enableBeep() {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        int x = this.sendMsg("b");
    }

    @Override
    public void disableBeep() {
    }

    public void setDeviceNumber(int devNum) {
        this.deviceNumber = devNum;
    }

    public int getDeviceNumber() {
        return this.deviceNumber;
    }

    public boolean getgetDeleteImageFileAfterRead() {
        return this.scannerConfig.getDeleteImageFileAfterRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSelfTest() {
        m_log.trace("doSelfTest (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("doSelfTest (out)");
            return;
        }
        this.bAlive = true;
        if (this.scannerConfig.getCanAcceptStatisticsCmd()) {
            Object object = this.objWaitSohBuf;
            synchronized (object) {
                this.sohBuf = EMPTY_BYTE_ARRAY;
                this.sendMsg(scannerStatisticsCmd);
                try {
                    this.objWaitSohBuf.wait(this.nTimeout);
                    if (this.sohBuf.length == 0) {
                        this.bAlive = false;
                        this.fireDeviceErrorEvent(-116);
                    }
                }
                catch (InterruptedException ie) {
                    m_log.error("doSelfTest: Interrupted. ", (Throwable)ie);
                }
            }
        }
        m_log.trace("doSelfTest (out)");
    }

    @Override
    public boolean doHealthCheck() throws DLSException {
        m_log.trace("doHealthCheck (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("doHealthCheck (out)");
            return true;
        }
        boolean bRc = true;
        byte[] buf = this.sendReceiveMsg(scannerHealthSummaryCmd);
        if (buf.length != 0) {
            this.logHealthCheck(buf);
        } else {
            m_log.warn("Timeout on HealthCheck");
            bRc = false;
        }
        m_log.trace("doHealthCheck (out): " + Boolean.toString(bRc));
        return bRc;
    }

    @Override
    public boolean isAlive() {
        if (DLSJposConst.updateInProgress) {
            return this.bAlive;
        }
        this.doSelfTest();
        return this.bAlive;
    }

    @Override
    public void setFirmwareBaudRate() {
    }

    @Override
    public void restoreBaudRate() {
    }

    @Override
    public int sendJoin() {
        return 0;
    }

    @Override
    @Deprecated
    public int sendReset() {
        return 0;
    }

    @Override
    public void updateConfiguration() {
    }

    @Override
    public DLSScannerConfig reportConfiguration() {
        return this.scannerConfig;
    }

    protected String parseAck(byte[] resp, int[] data) {
        String sResult = "";
        String sAck = "";
        String sAddl = "";
        int iLen = 0;
        int iAddl = 0;
        StringBuilder oSb = new StringBuilder();
        if (resp == null) {
            m_log.error("parseAck: Invalid response.");
            return "";
        }
        if (data == null) {
            m_log.error("parseAck: Invalid data specified.");
            return "";
        }
        if (resp[0] != 65) {
            m_log.warn("parseAck: response is not an ACK message.");
            data[0] = resp[0];
            return "";
        }
        data[0] = resp[0];
        iLen |= resp[1] << 24;
        iLen |= resp[2] << 16;
        iLen |= resp[3] << 8;
        sAck = sAck + (char)resp[5];
        sResult = sAck = sAck + (char)resp[6];
        if ((iLen |= resp[4]) > 7) {
            iAddl |= resp[7] << 8;
            iAddl |= resp[8];
            for (int i = 0; i < iAddl; ++i) {
                oSb.append((char)resp[9 + i]);
            }
            sResult = sResult + ": " + oSb.toString();
        }
        return sResult;
    }

    @Override
    public void directIO(int command, int[] data, Object object) throws DLSException {
        m_log.trace("directIO (in): " + Integer.toString(command));
        if (DLSJposConst.updateInProgress) {
            m_log.trace("directIO (out)");
            return;
        }
        String strResult = "Invalid Command";
        String objString = object.toString();
        boolean nResp = false;
        switch (command) {
            case 350: {
                strResult = "";
                this.sendMsg(scannerHealthSummaryCmd);
                break;
            }
            case 369: {
                strResult = "";
                this.sendMsg(scannerHealthExtendedCmd);
                break;
            }
            case 351: {
                byte[] result = this.sendDIO("zLIGHTLY");
                strResult = this.parseAck(result, data);
                break;
            }
            case 372: {
                byte[] result = this.sendDIO("zDEEPLY");
                strResult = this.parseAck(result, data);
                break;
            }
            case 356: {
                if (this.getDeviceEnabled()) {
                    strResult = "DirectIO Command Not Supported While Device Enabled";
                    data[0] = -1;
                    m_log.error("directIO:  Device is enabled");
                    break;
                }
                String configString = object.toString();
                this.sendMsg(writeConfigCmd + configString);
                strResult = "Portal Scanner Write Configure";
                break;
            }
            case 357: {
                strResult = "Portal Scanner: Enable command not implemented";
                object = strResult;
                data[0] = -1;
                break;
            }
            case 358: {
                strResult = "Portal Scanner: Disable command not implemented";
                object = strResult;
                data[0] = -1;
                break;
            }
            case 359: {
                byte[] result = this.sendDIO(shutdownCmd);
                strResult = this.parseAck(result, data);
                break;
            }
            case 360: {
                strResult = this.posConnected(data, objString);
                break;
            }
            case 361: {
                byte[] result = this.sendDIO(resetPortalScannerCmd);
                strResult = this.parseAck(result, data);
                break;
            }
            case 362: {
                byte[] result = this.sendDIO(restartPortalScannerCmd);
                strResult = this.parseAck(result, data);
                break;
            }
            case 363: {
                strResult = this.requestImageData(data, objString);
                break;
            }
            case 364: {
                strResult = this.transactionState(data, objString);
                break;
            }
            case 366: {
                strResult = this.identifyItem(data, objString);
                break;
            }
            case 367: {
                strResult = this.additionalItemScanned(data, objString);
                break;
            }
            case 368: {
                byte[] result = this.sendDIO(scannerIdentificationCmd);
                strResult = this.parseAck(result, data);
                break;
            }
            case 370: {
                strResult = this.scannerStatistics(data, objString);
                break;
            }
            case 371: {
                strResult = this.playSound(data, objString);
                break;
            }
            case 352: {
                if (this.getDeviceEnabled()) {
                    strResult = "DirectIO Command Not Supported While Device Enabled";
                    data[0] = -1;
                    m_log.error("directIO:  Device is enabled");
                    break;
                }
                String configNumber = object.toString();
                this.sendMsg(readConfigCmd + configNumber);
                strResult = "Portal Scanner sent read config item: " + configNumber;
                break;
            }
            case 353: {
                if (this.getDeviceEnabled()) {
                    strResult = "DirectIO Command Not Supported While Device Enabled";
                    data[0] = -1;
                    m_log.error("directIO:  Device is enabled");
                    break;
                }
                String configParamNumber = object.toString();
                this.sendMsg(readConfigParamCmd + configParamNumber);
                strResult = "Portal Scanner sent read config item: " + configParamNumber;
                break;
            }
            case 373: {
                if (!this.getDeviceEnabled()) {
                    strResult = "Portal Scanner must be enabled to accept the Set Item ID command.";
                    data[0] = -1;
                    m_log.error("directIO: Device is not enabled.");
                    break;
                }
                strResult = this.setItemId(data, objString);
                break;
            }
            case 374: {
                if (!this.getDeviceEnabled()) {
                    strResult = "Portal Scanner must be enabled to accept the Set Item Color command.";
                    data[0] = -1;
                    m_log.error("directIO: Device is not enabled.");
                    break;
                }
                strResult = this.setItemColor(data, objString);
                break;
            }
            case 375: {
                strResult = this.operatorSignOn(data, objString);
                break;
            }
            case 376: {
                strResult = this.labelDataMessage(data, objString);
                break;
            }
            default: {
                strResult = "Unknown DirectIO Command";
                data[0] = -2;
            }
        }
        if (object instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream oRes = (ByteArrayOutputStream)object;
            oRes.reset();
            try {
                oRes.write(strResult.getBytes());
            }
            catch (IOException oEx) {
                m_log.error("IOException writing results: ", (Throwable)oEx);
            }
        }
        m_log.trace("directIO (out)");
    }

    @Override
    public boolean hasStatisticsReporting() {
        return this.scannerConfig.getCanAcceptStatisticsCmd();
    }

    @Override
    public HashMap<String, Object> getStatistics() throws DLSException {
        String truncated2;
        String truncated;
        StringBuilder oSb = new StringBuilder();
        m_log.trace("getStatistics (in)");
        HashMap<String, Object> table = new HashMap<String, Object>();
        if (DLSJposConst.updateInProgress) {
            m_log.warn("Firmware update in progress. Cannot pull i-h-s data during firmware update.");
            m_log.trace("getStatistics (out)");
            return table;
        }
        if (!this.scannerConfig.getCanAcceptStatisticsCmd()) {
            m_log.warn("Scanner does not support i-h-s data data.");
            m_log.trace("getStatistics (out)");
            return table;
        }
        String[] strInfo = null;
        String str = null;
        int i = 0;
        m_log.debug("Getting idRequestCmd");
        this.bStatMessageSent = true;
        byte[] buf = this.sendReceiveMsg(scannerStatisticsCmd);
        String logData = "";
        for (i = 0; i < buf.length; ++i) {
            oSb.append(" 0x");
            oSb.append(Integer.toHexString(buf[i] & 0xFF));
        }
        logData = oSb.toString();
        m_log.debug("# bytes received[" + buf.length + "]" + logData);
        table.put("RawInfo", "# bytes received[" + buf.length + "]" + logData);
        table.put("GoodScanCount", "NA");
        if (buf.length != 0) {
            strInfo = this.splitMessage(buf);
            block44: for (i = 0; i < strInfo.length; ++i) {
                str = strInfo[i];
                truncated = str.replaceAll("\\p{Cntrl}", "");
                truncated2 = truncated.replaceAll("Sp<", "");
                if (truncated2.length() <= 1) continue;
                switch (truncated2.charAt(0)) {
                    case 'M': {
                        table.put("ModelNumber", truncated2.substring(1));
                        continue block44;
                    }
                    case 'S': {
                        table.put("SerialNumber", truncated2.substring(1));
                        table.put("DeviceID", truncated2.substring(1));
                        continue block44;
                    }
                    case 'm': {
                        table.put("ScannerBoardSerialNumber", truncated2.substring(1));
                        continue block44;
                    }
                    case 'A': {
                        table.put("FirmwareVersionNumber", truncated2.substring(1));
                        continue block44;
                    }
                    case 'R': {
                        table.put("ScannerRevisionNumber", truncated2.substring(1));
                        continue block44;
                    }
                    case 'C': {
                        table.put("ConfigFileVersionNumber", truncated2.substring(1));
                        continue block44;
                    }
                    case 'B': {
                        table.put("ScannerBootROMID", truncated2.substring(1));
                        continue block44;
                    }
                    case 'H': {
                        table.put("HardwareID", truncated2.substring(1));
                        continue block44;
                    }
                    case 'U': {
                        table.put("CometROMID", truncated2.substring(1));
                        continue block44;
                    }
                    case 'u': {
                        table.put("CometBootROMID", truncated2.substring(1));
                        continue block44;
                    }
                    case 'W': {
                        table.put("ScaleInformation", truncated2.substring(1));
                        continue block44;
                    }
                    case 'D': {
                        table.put("DisplayVersion", truncated2.substring(1));
                        continue block44;
                    }
                    case 'E': {
                        table.put("EASVersion", truncated2.substring(1));
                        continue block44;
                    }
                    case 'I': {
                        table.put("ScannerInterface", truncated2.substring(1));
                        continue block44;
                    }
                    case 'r': {
                        table.put("ApplicationRevisionLevel", truncated2.substring(1));
                        continue block44;
                    }
                    case 'L': {
                        table.put("RadioSoftwareVersion", truncated2.substring(1));
                        continue block44;
                    }
                    case 'b': {
                        table.put("RadioBootloaderVersion", truncated2.substring(1));
                        continue block44;
                    }
                    case 'X': {
                        table.put("BaseModelNumber", truncated2.substring(1));
                    }
                }
            }
        }
        m_log.debug("Getting scannerHealthSummaryCmd");
        this.bStatMessageSent = true;
        buf = this.sendReceiveMsg(scannerHealthSummaryCmd);
        logData = "";
        oSb = new StringBuilder();
        for (i = 0; i < buf.length; ++i) {
            oSb.append(" 0x");
            oSb.append(Integer.toHexString(buf[i] & 0xFF));
        }
        logData = logData + oSb.toString();
        m_log.debug("# bytes received[" + buf.length + "]" + logData);
        table.put("RawHealth", "# bytes received[" + buf.length + "]" + logData);
        if (buf.length != 0) {
            strInfo = this.splitMessage(buf);
            block46: for (i = 0; i < strInfo.length; ++i) {
                str = strInfo[i];
                truncated = str.replaceAll("\\p{Cntrl}", "");
                truncated2 = truncated.replaceAll("Sp<", "");
                if (truncated2.length() <= 1) continue;
                switch (truncated2.charAt(0)) {
                    case 'm': {
                        table.put("MotorHealth", truncated2.substring(1));
                        continue block46;
                    }
                    case 'h': {
                        table.put("VerticalLaserHealth", truncated2.substring(1));
                        continue block46;
                    }
                    case 'v': {
                        table.put("HorizontalLaserHealth", truncated2.substring(1));
                        continue block46;
                    }
                    case 's': {
                        table.put("ScaleHealth", truncated2.substring(1));
                        continue block46;
                    }
                    case 'd': {
                        table.put("RemoteDisplayHealth", truncated2.substring(1));
                        continue block46;
                    }
                    case 'e': {
                        table.put("EASHealth", truncated2.substring(1));
                        continue block46;
                    }
                    case 'c': {
                        table.put("CameraHealth", truncated2.substring(1));
                        continue block46;
                    }
                    case 'r': {
                        table.put("RadiolHealth", truncated2.substring(1));
                    }
                }
            }
        }
        m_log.debug("Getting statisticsCmd");
        this.bStatMessageSent = true;
        buf = this.sendReceiveMsg(scannerStatisticsCmd);
        logData = "";
        oSb = new StringBuilder();
        for (i = 0; i < buf.length; ++i) {
            oSb.append(" 0x");
            oSb.append(Integer.toHexString(buf[i] & 0xFF));
        }
        logData = logData + oSb.toString();
        m_log.debug("# bytes received[" + buf.length + "]" + logData);
        table.put("RawStats", "# bytes received[" + buf.length + "]" + logData);
        if (buf.length != 0) {
            strInfo = this.splitMessage(buf);
            block48: for (i = 0; i < strInfo.length; ++i) {
                str = strInfo[i];
                truncated = str.replaceAll("\\p{Cntrl}", "");
                truncated2 = truncated.replaceAll("Sp<", "");
                if (truncated2.length() <= 1) continue;
                switch (truncated2.charAt(0)) {
                    case 'P': {
                        table.put("HoursPoweredCount", truncated2.substring(1));
                        continue block48;
                    }
                    case 'm': {
                        table.put("MotorTime", truncated2.substring(1));
                        continue block48;
                    }
                    case 'l': {
                        table.put("LaserTime", truncated2.substring(1));
                        continue block48;
                    }
                    case 'L': {
                        table.put("GoodScanCount", truncated2.substring(1));
                        continue block48;
                    }
                    case 'z': {
                        table.put("ScaleZeroed", truncated2.substring(1));
                        continue block48;
                    }
                    case 'c': {
                        table.put("ScaleCalibrations", truncated2.substring(1));
                        continue block48;
                    }
                    case 'E': {
                        table.put("EASDeactivations", truncated2.substring(1));
                        continue block48;
                    }
                    case 'e': {
                        table.put("EASManualPresses", truncated2.substring(1));
                        continue block48;
                    }
                    case 'B': {
                        table.put("BatteryChargeCycles", truncated2.substring(1));
                        continue block48;
                    }
                    case 'T': {
                        table.put("TriggerPulls", truncated2.substring(1));
                        continue block48;
                    }
                    case 'K': {
                        table.put("KeyPresses", truncated2.substring(1));
                    }
                }
            }
        }
        if (!table.containsKey("Interface")) {
            table.put("Interface", "TCPIP");
        }
        Branding oBr = Branding.getInstance();
        String sName = oBr.getManufacturerShortName();
        table.put("ManufacturerName", sName);
        table.put("DeviceCategory", "Scanner");
        this.bStatMessageSent = false;
        this.statistics = table;
        m_log.trace("getStatistics (out)");
        return table;
    }

    protected void parseReadConfigMessages(byte[] inBuf, byte endChar) {
        for (int i = 0; i < inBuf.length; ++i) {
            this.bs.write(inBuf[i]);
            if (inBuf[i] != endChar) continue;
            byte[] tmpBuf = this.bs.toByteArray();
            boolean add = this.msgList.add(tmpBuf);
            this.bs.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataReceived(byte[] inBuf, int inLen) {
        stEnum inState = stEnum.ST_IDLE;
        int nType = 0;
        byte[] scanData = null;
        byte[] scanDataLabel = null;
        String labelStr = "";
        boolean bSystemDatatFired = false;
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        if (inBuf == null || inLen == 0) {
            m_log.error("onDataReceived called with null or empty buffer.");
            return;
        }
        switch (inBuf[0]) {
            case 65: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                break;
            }
        }
        if (this.bFirmware) {
            Object object = this.objWaitAck;
            synchronized (object) {
                this.nResponse = inBuf[0];
                this.bFirmware = false;
                m_log.debug("onDataReceived:" + this.nResponse);
                this.objWaitAck.notify();
                return;
            }
        }
        if (this.bInternalDIO) {
            Object object = this.dioResp;
            synchronized (object) {
                this.bInternalDIO = false;
                this.dioBuff = Arrays.copyOf(inBuf, inBuf.length);
                this.dioResp.notifyAll();
            }
        }
        switch (inBuf[0]) {
            case 73: {
                m_log.debug("onDataReceived - ITEM");
                inState = stEnum.ST_ITEM;
                int itemID = 0xFF & inBuf[5];
                itemID = 256 * itemID + inBuf[6];
                itemID = 256 * itemID + inBuf[7];
                itemID = 256 * itemID + inBuf[8];
                nType = -1;
                break;
            }
            case 66: {
                inState = stEnum.ST_LABEL;
                m_log.debug("onDataReceived - LABEL");
                int msgLen = inBuf[1];
                msgLen = 256 * msgLen + inBuf[2];
                msgLen = 256 * msgLen + inBuf[3];
                msgLen = 256 * msgLen + inBuf[4];
                if (msgLen > 1312788 || msgLen < 0) {
                    m_log.warn("msgLen: out of bounds");
                    break;
                }
                int itemID = 0xFF & inBuf[5];
                itemID = 256 * itemID + inBuf[6];
                itemID = 256 * itemID + inBuf[7];
                itemID = 256 * itemID + inBuf[8];
                int imageID = 0xFF & inBuf[9];
                imageID = 256 * imageID + inBuf[10];
                imageID = 256 * imageID + inBuf[11];
                imageID = 256 * imageID + inBuf[12];
                byte labelFormat = inBuf[13];
                int labelLength = 0xFF & inBuf[14];
                labelLength = 256 * labelLength + inBuf[15];
                scanData = new byte[labelLength];
                if (inBuf.length < labelLength + 16) break;
                System.arraycopy(inBuf, 16, scanData, 0, labelLength);
                labelStr = new String(scanData);
                m_log.debug("Label Data: " + itemID + "  Format:" + labelFormat + "  Len:" + labelLength + "  Data:" + labelStr);
                byte[] identifier = new byte[]{scanData[0], scanData[1], scanData[2]};
                LabelRow labelRow = this.extractBarcodeType(identifier);
                nType = labelRow.getUPOSID();
                int identifierLength = labelRow.getIdentifierLength();
                scanDataLabel = new byte[labelLength - identifierLength];
                System.arraycopy(scanData, identifierLength, scanDataLabel, 0, scanDataLabel.length);
                if (labelFormat == 0) {
                    switch (nType) {
                        case 101: {
                            if (scanDataLabel.length <= 12) break;
                            nType = 111;
                            break;
                        }
                        case 102: {
                            if (scanDataLabel.length > 8) {
                                nType = 112;
                            }
                            if (scanDataLabel.length == 8) {
                                nType = 103;
                            }
                            if (scanDataLabel.length == 9) {
                                nType = 103;
                            }
                            if (scanDataLabel.length == 12) {
                                nType = 101;
                            }
                            if (scanDataLabel.length == 13) {
                                nType = 101;
                            }
                            if (scanDataLabel.length != 14) break;
                            nType = 104;
                            break;
                        }
                        case 103: {
                            if (scanDataLabel.length <= 8) break;
                            nType = 118;
                            break;
                        }
                        case 104: {
                            if (scanDataLabel.length <= 13) break;
                            nType = 119;
                        }
                    }
                }
                if (labelFormat == 1) {
                    nType = 0;
                }
                m_log.debug("ScanDataLabel in onDataReceived: " + Arrays.toString(scanDataLabel));
                Branding oBr = Branding.getInstance();
                String sProp = "com." + oBr.getBrandingPrefix() + ".jpos.service.ScannerService.sendCookedData";
                DLSProperties options = DLSProperties.getInstance();
                this.bSendCookedData = options.get(sProp, false);
                if (this.bSendCookedData) {
                    scanData = scanDataLabel;
                }
                this.fireLabelReceivedEvent(inBuf, scanDataLabel, nType);
                break;
            }
            case 80: {
                inState = stEnum.ST_PIC;
                m_log.debug("onDataReceived - IMAGE_DATA");
                break;
            }
            case 76: {
                inState = stEnum.ST_LOC;
                m_log.debug("onDataReceived - ITEM_LOCATION");
                break;
            }
            case 86: {
                inState = stEnum.ST_VOL;
                m_log.debug("onDataReceived - ITEM_VOLUME");
                break;
            }
            case 84: {
                inState = stEnum.ST_TRACKING;
                m_log.debug("onDataReceived - ITEM_TRACKING");
                break;
            }
            case 70: {
                inState = stEnum.ST_FAULT;
                m_log.debug("onDataReceived - FAULT");
                break;
            }
            case 65: {
                inState = stEnum.ST_ACK;
                m_log.debug("onDataReceived - ACK");
                break;
            }
            case 85: {
                inState = stEnum.ST_UPDATE_ITEM;
                m_log.debug("onDataReceived - UPDATE_ITEM");
                this.decodeUpdateItemEvent(inBuf);
                break;
            }
            case 79: {
                inState = stEnum.ST_LABEL_CHOICE;
                m_log.debug("onDataReceived - LABEL_CHOICE");
                this.decodeLabelChoiceMessage(inBuf);
                break;
            }
            case 67: {
                inState = stEnum.ST_CONNECTED;
                m_log.debug("onDataReceived - CONNECTED");
                String connectedMsg = this.hostGetConnect(inBuf);
                String inStr = new String(inBuf);
                String ibuf = oInfo.getImageBuffers();
                String lbuf = oInfo.getLaneNumber();
                String jbuf = oInfo.getJposVersion();
                String servVer = oInfo.getServiceVersion();
                String sSoftwareVersion = "JposVersion: " + jbuf + " Service Version: " + servVer;
                byte iSoftwareVersionLength = (byte)sSoftwareVersion.length();
                byte nLaneIDLength = (byte)lbuf.length();
                m_log.debug("Service Version: " + servVer + "  Jpos Version: " + jbuf + " Lane Number: " + lbuf + " Image Buffers: " + ibuf);
                byte[] bVersion = sSoftwareVersion.getBytes();
                int iMessageLen = 4 + nLaneIDLength + iSoftwareVersionLength;
                byte[] bMessage = new byte[iMessageLen];
                bMessage[0] = 97;
                bMessage[1] = (byte)Integer.parseInt(ibuf);
                bMessage[2] = nLaneIDLength;
                int i = 0;
                byte[] lbufByteArray = lbuf.getBytes();
                for (i = 0; i < lbuf.length(); ++i) {
                    bMessage[i + 3] = lbufByteArray[i];
                }
                bMessage[3 + i] = iSoftwareVersionLength;
                System.arraycopy(bVersion, 0, bMessage, 4 + i, iSoftwareVersionLength);
                this.sendMsg(bMessage);
                break;
            }
            case 75: {
                inState = stEnum.ST_IDENTIFICATION;
                m_log.debug("onDataReceived - IDENTIFICATION");
                break;
            }
            case 72: {
                inState = stEnum.ST_HEALTH_SUMMARY;
                m_log.debug("onDataReceived - HEALTH_SUMMARY");
                break;
            }
            case 71: {
                inState = stEnum.ST_HEALTH_EXTENDED;
                m_log.debug("onDataReceived - HEALTH_EXTENDED");
                break;
            }
            case 78: {
                inState = stEnum.ST_STATISTICS;
                m_log.debug("onDataReceived - STATISTICS");
                break;
            }
            case 87: {
                inState = stEnum.ST_COMNFIGURATION_VALUE;
                m_log.debug("onDataReceived - COMNFIGURATION_VALUE");
                break;
            }
            case 88: {
                inState = stEnum.ST_CHECKCONN;
                m_log.debug("onDataReceived - CHECKCONN");
                try {
                    this.heartBeatResponse();
                }
                catch (DLSException ex) {
                    m_log.error("stEnum.ST_CHECKCONN exception. ", (Throwable)ex);
                }
                break;
            }
            case 69: {
                inState = stEnum.ST_OTHER;
                m_log.debug("onDataReceived: Event message type (E)");
                this.parseEventMessage(inBuf);
                break;
            }
            default: {
                inState = stEnum.ST_IDLE;
            }
        }
        if (inState != stEnum.ST_ACK && inState != stEnum.ST_LABEL && inBuf[0] != 88 && !bSystemDatatFired) {
            this.fireItemReceivedEvent(inBuf);
        }
    }

    private void parseEventMessage(byte[] abMsg) {
        int iLen = 0;
        int iFlags = 0;
        if (abMsg.length < 5) {
            m_log.error("parseEventMessage: Invalid message length.");
            return;
        }
        if (abMsg[0] != 69) {
            m_log.error("parseEventMessage: Invalid message type.");
            return;
        }
        iLen = abMsg[1] << 24;
        iLen |= abMsg[2] << 16;
        iLen |= abMsg[3] << 8;
        if (abMsg.length < (iLen |= abMsg[4]) + 5) {
            m_log.error("parseEventMessage: Message size exceeds length of PDU.");
            return;
        }
        if (abMsg[5] == 73) {
            m_log.info("parseEventMessage: Idle Message");
            if (abMsg.length >= 10) {
                iFlags = abMsg[6] << 24;
                iFlags |= abMsg[7] << 16;
                iFlags |= abMsg[8] << 8;
                m_log.info(String.format("parseEventMessage: Idle Message Flags = 0x%04X", iFlags |= abMsg[9]));
            }
        }
    }

    protected void decodeLabelChoiceMessage(byte[] abPdu) {
        int iLen = 0;
        int iId = 0;
        int iImgId = 0;
        int iAltCodes = 0;
        int iPos = 0;
        byte iBConf = 0;
        byte iBForm = 0;
        int iBLen = 0;
        m_log.trace("decodeLabelChoiceMessage (in): " + new String(abPdu));
        if (abPdu.length < 14) {
            m_log.error("decodeLabelChoiceMessage: Invalid PDU.");
            m_log.trace("decodeLabelChoiceMessage (out)");
            return;
        }
        if (abPdu[0] != 79) {
            m_log.error("decodeLabelChoiceMessage: Invalid Message ID.");
            m_log.trace("decodeLabelChoiceMessage (out)");
            return;
        }
        iLen = abPdu[1] << 24;
        iLen |= abPdu[2] << 16;
        iLen |= abPdu[3] << 8;
        iLen |= abPdu[4];
        iId = abPdu[5] << 24;
        iId |= abPdu[6] << 16;
        iId |= abPdu[7] << 8;
        iImgId = abPdu[9] << 24;
        iImgId |= abPdu[10] << 16;
        iImgId |= abPdu[11] << 8;
        iAltCodes = abPdu[13];
        String sOut = String.format("Label Choice Message - Len: %d, Id: %d, Image Id: %d, Alternative Codes: %d", iLen, iId |= abPdu[8], iImgId |= abPdu[12], iAltCodes);
        m_log.debug("decodeLabelChoiceMessage: " + sOut);
        iPos = 14;
        for (int i = 0; i < iAltCodes; ++i) {
            iBConf = abPdu[iPos];
            iBForm = abPdu[iPos + 1];
            iBLen = abPdu[iPos + 2] << 8;
            byte[] abData = new byte[iBLen |= abPdu[iPos + 3] & 0xFF];
            System.arraycopy(abPdu, iPos + 4, abData, 0, iBLen);
            sOut = String.format("Barcode Confidence: %d, Format: %d, Length: %d", iBConf, (int)iBForm, iBLen);
            m_log.debug("decodeLabelChoiceMessage: " + sOut + " Data: " + new String(abData));
            iPos += 4 + iBLen + 1;
        }
        m_log.trace("decodeLabelChoiceMessage (out)");
    }

    protected void decodeUpdateItemEvent(byte[] abPdu) {
        int iId = 0;
        int iLen = 0;
        int iFlags = 0;
        m_log.trace("decodeUpdateItemEvent (in): " + new String(abPdu));
        if (abPdu.length < 13) {
            m_log.error("decodeUpdateItemEvent: Invalid PDU.");
            m_log.trace("decodeUpdateItemEvent (out)");
            return;
        }
        if (abPdu[0] != 85) {
            m_log.error("decodeUpdateItemEvent: Invalid Message ID.");
            m_log.trace("decodeUpdateItemEvent (out)");
            return;
        }
        iLen = abPdu[1] << 24;
        iLen |= abPdu[2] << 16;
        iLen |= abPdu[3] << 8;
        iLen |= abPdu[4];
        iId = abPdu[5] << 24;
        iId |= abPdu[6] << 16;
        iId |= abPdu[7] << 8;
        iFlags = abPdu[9] << 24;
        iFlags |= abPdu[10] << 16;
        iFlags |= abPdu[11] << 8;
        String sOut = String.format("UPDATE_ITEM - Len: %d, Id: %d, Flags: 0x%04X", iLen, iId |= abPdu[8], iFlags |= abPdu[12]);
        m_log.debug("decodeUpdateItemEvent: " + sOut);
        if (abPdu.length > 13) {
            m_log.debug("decodeUpdateItemEvent: Additional Messages follow.");
            for (int i = 13; i < abPdu.length - 1; i += 2) {
                sOut = String.format("%d Messages of type '%c'.", abPdu[i + 1], abPdu[i]);
                m_log.debug("decodeUpdateItemEvent: " + sOut);
            }
        }
        m_log.trace("decodeUpdateItemEvent (out)");
    }

    public static byte[] stringToBytesUTFCustom(String str) {
        m_log.trace("stringToBytesUTFCustom (in): " + str);
        char[] buffer = str.toCharArray();
        byte[] b = new byte[buffer.length << 1];
        for (int i = 0; i < buffer.length; ++i) {
            int bpos = i << 1;
            b[bpos] = (byte)((buffer[i] & 0xFF00) >> 8);
            b[bpos + 1] = (byte)(buffer[i] & 0xFF);
        }
        m_log.trace("stringToBytesUTFCustom (out): " + new String(b));
        return b;
    }

    private String hostGetConnect(byte[] inBuf) {
        int msgLen = inBuf[1];
        msgLen = 256 * msgLen + inBuf[2];
        msgLen = 256 * msgLen + inBuf[3];
        if ((msgLen = 256 * msgLen + inBuf[4]) < 0 || msgLen > 1312788) {
            return "Not Connected Message";
        }
        int arrayLen = msgLen + 1;
        byte protMajor = inBuf[5];
        byte protMinor = inBuf[6];
        byte currState = inBuf[7];
        int connectedDataLength = inBuf[8];
        connectedDataLength = 256 * connectedDataLength + inBuf[9];
        char[] convertedChar = new char[arrayLen];
        for (int i = 0; i < connectedDataLength; ++i) {
            convertedChar[i] = (char)inBuf[i + 9];
        }
        String connectStr = String.copyValueOf(convertedChar);
        return connectStr;
    }

    public String additionalItemScanned(int[] data, String sArgs) {
        byte tFormat;
        int iSource;
        String ret = "";
        m_log.trace("additionalItemScanned (in): " + Arrays.toString(data) + ", " + sArgs);
        if (sArgs == null || sArgs.equals("")) {
            m_log.error("additionalItemScanned: Invalid arguments specified.");
            m_log.trace("additionalItemScanned (out)");
            return "Invalid arguments specified.";
        }
        String[] asArgs = sArgs.split(",");
        if (asArgs.length != 3) {
            m_log.error("additionalItemScanned: 3 arguments required.");
            m_log.trace("additionalItemScanned (out)");
            return "3 arguments required. \"<Item Source>,<Barcode Format>,<Barcode Data>\"";
        }
        try {
            iSource = Integer.parseInt(asArgs[0]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("additionalItemScanned: Item Source must be numeric.");
            m_log.trace("additionalItemScanned (out)");
            return "Item Source must be numeric";
        }
        if (iSource < 0 || iSource > 255) {
            m_log.error("additionalItemScanned: Item Source out of range.");
            m_log.trace("additionalItemScanned (out)");
            return "Item Source must be between 0 and 255.";
        }
        byte tSource = (byte)(iSource & 0xFF);
        try {
            tFormat = Byte.parseByte(asArgs[1]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("additionalItemScanned: Barcode Format must be numeric.");
            m_log.trace("additionalItemScanned (out)");
            return "Barcode Format must be numeric.";
        }
        m_log.trace("additionalItemScanned (out)");
        return this.additionalItemScanned(data, tSource, tFormat, asArgs[2]);
    }

    public String additionalItemScanned(int[] data, byte tSource, byte tFormat, String sBarcode) {
        String ret = "";
        m_log.trace("additionalItemScanned (in): " + Arrays.toString(data) + ", " + (char)tSource + ", " + (char)tFormat + ", " + sBarcode);
        if (sBarcode == null || sBarcode.equals("")) {
            m_log.error("additionalItemScanned: Invalid barcode specified.");
            m_log.trace("additionalItemScanned (out)");
            return "";
        }
        if (tFormat < 0 || tFormat > 5) {
            m_log.error("additionalItemScanned: Invalid barcode format specified.");
            m_log.trace("additionalItemScanned (out)");
            return "";
        }
        int iBarLen = sBarcode.length();
        byte[] abPdu = new byte[5 + iBarLen];
        abPdu[0] = (byte)additionalItemScannedCmd.charAt(0);
        abPdu[1] = tSource;
        abPdu[2] = tFormat;
        abPdu[3] = (byte)((iBarLen & 0xFF00) >> 8);
        abPdu[4] = (byte)(iBarLen & 0xFF);
        for (int i = 0; i < iBarLen; ++i) {
            abPdu[5 + i] = (byte)sBarcode.charAt(i);
        }
        m_log.debug("additionalItemScanned: Sending additional item with source of " + tSource + " and barcode format " + tFormat + " and a barcode of " + sBarcode);
        byte[] resp = this.sendDIO(abPdu);
        ret = this.parseAck(resp, data);
        m_log.trace("additionalItemScanned (out): " + ret);
        return ret;
    }

    public String identifyItem(int[] data, String sArgs) {
        int addlMsg;
        int itemAccounted;
        int tooLate;
        int transClosed;
        int itemId;
        m_log.trace("identifyItem (in): " + Arrays.toString(data) + ", " + sArgs);
        if (sArgs == null || sArgs.equals("")) {
            m_log.error("identifyItem: Invalid arguments specified.");
            m_log.trace("identifyItem (out)");
            return "Invalid arguments specified.";
        }
        String[] asArgs = sArgs.split(",");
        if (asArgs.length != 5) {
            m_log.error("identifyItem: 5 arguments required.");
            m_log.trace("identifyItem (out)");
            return "5 arguments required. \"<Item ID>,<Transaction Closed>,<Too Late>,<Item Accounted For>,<Number of Additional Messages>\"";
        }
        try {
            itemId = Integer.parseInt(asArgs[0]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("identifyItem: Item Id must be numeric.");
            m_log.trace("identifyItem (out)");
            return "Item Id must be numeric.";
        }
        try {
            transClosed = Integer.parseInt(asArgs[1]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("identifyItem: Transaction Closed must be either 0 or 1.");
            m_log.trace("identifyItem (out)");
            return "Transaction Closed must be either 0 or 1.";
        }
        try {
            tooLate = Integer.parseInt(asArgs[2]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("identifyItem: Too Late must be either 0 or 1.");
            m_log.trace("identifyItem (out)");
            return "Too Late must be either 0 or 1.";
        }
        try {
            itemAccounted = Integer.parseInt(asArgs[3]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("identifyItem: Item Accounted For must be either 0 or 1.");
            m_log.trace("identifyItem (out)");
            return "Item Accounted For must be either 0 or 1.";
        }
        try {
            addlMsg = Integer.parseInt(asArgs[4]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("identifyItem: Additional Items must be numeric.");
            m_log.trace("identifyItem (out)");
            return "Additional Items must be numeric.";
        }
        m_log.trace("identifyItem (out)");
        return this.identifyItem(data, itemId, transClosed == 1, tooLate == 1, itemAccounted == 1, addlMsg);
    }

    public String identifyItem(int[] data, int itemId, boolean bTransClosed, boolean bTooLate, boolean bItemAccounted, int addlMsg) {
        byte[] abPdu = new byte[11];
        String ret = "";
        m_log.trace("identifyItem (in): " + Arrays.toString(data) + ", " + Integer.toString(itemId) + ", " + Boolean.toString(bTransClosed) + ", " + Boolean.toString(bTooLate) + ", " + Boolean.toString(bItemAccounted) + ", " + Integer.toString(addlMsg));
        abPdu[0] = (byte)identifyItemCmd.charAt(0);
        abPdu[1] = (byte)((itemId & 0xFF000000) >> 24);
        abPdu[2] = (byte)((itemId & 0xFF0000) >> 16);
        abPdu[3] = (byte)((itemId & 0xFF00) >> 8);
        abPdu[4] = (byte)(itemId & 0xFF);
        abPdu[5] = 0;
        abPdu[6] = 0;
        abPdu[7] = 0;
        abPdu[8] = 0;
        abPdu[8] = (byte)(abPdu[8] | (bItemAccounted ? 4 : 0));
        abPdu[8] = (byte)(abPdu[8] | (bTooLate ? 2 : 0));
        abPdu[8] = (byte)(abPdu[8] | (bTransClosed ? (byte)1 : 0));
        abPdu[9] = (byte)labelDataMessageCmd.charAt(0);
        abPdu[10] = (byte)(addlMsg & 0xFF);
        m_log.debug("identifyItem: Sending Identify Item command with Item Id of " + itemId + " and the following flags: " + (bItemAccounted ? "Item Accounted For " : "") + (bTooLate ? "Too Late " : "") + (bTransClosed ? "Transaction Closed " : "") + "and " + addlMsg + " additional messages.");
        if (addlMsg == 0) {
            byte[] resp = this.sendDIO(abPdu);
            ret = this.parseAck(resp, data);
        } else {
            this.setLabelMessageCount(addlMsg);
            this.sendMsg(abPdu);
            ret = "Awaiting Label Data messages.";
        }
        m_log.trace("identifyItem (out): " + ret);
        return ret;
    }

    public String labelDataMessage(int[] data, String sArgs) {
        byte tFormat;
        int imageId;
        int itemId;
        m_log.trace("labelDataMessage (in): " + Arrays.toString(data) + ", " + sArgs);
        if (sArgs == null || sArgs.equals("")) {
            m_log.error("labelDataMessage: Invalid arguments specified.");
            m_log.trace("labelDataMessage (out)");
            return "Invalid arguments specified.";
        }
        String[] asArgs = sArgs.split(",");
        if (asArgs.length != 4) {
            m_log.error("labelDataMessage: 4 arguments required.");
            m_log.trace("labelDataMessage (out)");
            return "4 arguments required. \"<Item ID>,<Image ID>,<Barcode Format>,<Barcode Data>\"";
        }
        try {
            itemId = Integer.parseInt(asArgs[0]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("labelDataMessage: Item Id must be numeric.");
            m_log.trace("labelDataMessage (out)");
            return "Item Id must be numeric.";
        }
        try {
            imageId = Integer.parseInt(asArgs[1]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("labelDataMessage: Image Id must be numeric.");
            return "Image Id must be numeric.";
        }
        try {
            tFormat = Byte.parseByte(asArgs[2]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("labelDataMessage: Barcode Format must be numeric.");
            m_log.trace("labelDataMessage (out)");
            return "Barcode Format must be numeric.";
        }
        m_log.trace("labelDataMessage (out)");
        return this.labelDataMessage(data, itemId, imageId, tFormat, asArgs[3]);
    }

    public String labelDataMessage(int[] data, int itemId, int imageId, byte tFormat, String sBarcode) {
        String ret = "";
        m_log.trace("labelDataMessage (in): " + Arrays.toString(data) + ", " + Integer.toString(itemId) + ", " + Integer.toString(imageId) + ", " + (char)tFormat + ", " + sBarcode);
        if (sBarcode == null) {
            m_log.error("labelDataMessage: Invalid (null) Barcode specified.");
            m_log.trace("labelDataMessage (out)");
            return "Invalid (null) Barcode specified.";
        }
        int iBarcodeLen = sBarcode.length();
        if (tFormat < 0 || tFormat > 5) {
            m_log.error("labelDataMessage: Invalid Barcode Format specified.");
            m_log.trace("labelDataMessage (out)");
            return "Invalid Barcode Format specified.";
        }
        byte[] abPdu = new byte[iBarcodeLen + 12];
        abPdu[0] = (byte)labelDataMessageCmd.charAt(0);
        abPdu[1] = (byte)((itemId & 0xFF000000) >> 24);
        abPdu[2] = (byte)((itemId & 0xFF0000) >> 16);
        abPdu[3] = (byte)((itemId & 0xFF00) >> 8);
        abPdu[4] = (byte)(itemId & 0xFF);
        abPdu[5] = (byte)((imageId & 0xFF000000) >> 24);
        abPdu[6] = (byte)((imageId & 0xFF0000) >> 16);
        abPdu[7] = (byte)((imageId & 0xFF00) >> 8);
        abPdu[8] = (byte)(imageId & 0xFF);
        abPdu[9] = tFormat;
        abPdu[10] = (byte)((iBarcodeLen & 0xFF00) >> 8);
        abPdu[11] = (byte)(iBarcodeLen & 0xFF);
        for (int i = 0; i < iBarcodeLen; ++i) {
            abPdu[12 + i] = (byte)sBarcode.charAt(i);
        }
        m_log.debug("labelDataMessage: Sending Label Data Message for Item " + itemId + ", Image Id " + imageId + " with Barcode Format of " + tFormat + " and a Barcode of " + sBarcode);
        int iCt = this.getLabelMessageCount();
        if (iCt > 1) {
            this.sendMsg(abPdu);
            ret = "Awaiting " + --iCt + " further Label Data Messages";
            this.setLabelMessageCount(iCt);
        } else {
            byte[] resp = this.sendDIO(abPdu);
            ret = this.parseAck(resp, data);
            this.setLabelMessageCount(0);
        }
        m_log.trace("labelDataMessage (out): " + ret);
        return ret;
    }

    public String operatorSignOn(int[] data, String sArgs) {
        int iOn;
        m_log.trace("operatorSignOn (in): " + Arrays.toString(data) + ", " + sArgs);
        if (sArgs == null || sArgs.equals("")) {
            m_log.error("operatorSignOn: Invalid arguments specified.");
            m_log.trace("operatorSignOn (out)");
            return "Invalid arguments specified.";
        }
        String[] asArgs = sArgs.split(",");
        if (asArgs.length != 3) {
            m_log.error("operatorSignOn: 3 arguments required.");
            m_log.trace("operatorSignOn (out)");
            return "3 arguments required. \"<User State>,<Store ID>,<User ID>\"";
        }
        try {
            iOn = Integer.parseInt(asArgs[0]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("operatorSignOn: On or Off must be a 0 or 1.");
            m_log.trace("operatorSignOn (out)");
            return "On or Off must be a 0 or 1.";
        }
        m_log.trace("operatorSignOn (out)");
        return this.operatorSignOn(data, iOn == 1, asArgs[1], asArgs[2]);
    }

    public String operatorSignOn(int[] data, boolean bOn, String sStoreId, String sUserId) {
        int i;
        int iStoreLen = 0;
        int iUserLen = 0;
        String ret = "";
        m_log.trace("operatorSignOn (in): " + Arrays.toString(data) + ", " + Boolean.toString(bOn) + ", " + sStoreId + ", " + sUserId);
        if (sStoreId == null) {
            sStoreId = "";
        }
        if (sUserId == null) {
            sUserId = "";
        }
        iStoreLen = sStoreId.length();
        iUserLen = sUserId.length();
        byte[] abPdu = new byte[iStoreLen + iUserLen + 4];
        abPdu[0] = (byte)operatorSignOnCmd.charAt(0);
        abPdu[1] = (byte)(bOn ? 1 : 0);
        abPdu[2] = (byte)(iStoreLen & 0xFF);
        for (i = 0; i < iStoreLen; ++i) {
            abPdu[3 + i] = (byte)sStoreId.charAt(i);
        }
        abPdu[3 + iStoreLen] = (byte)(iUserLen & 0xFF);
        for (i = 0; i < iUserLen; ++i) {
            abPdu[4 + iStoreLen + i] = (byte)sUserId.charAt(i);
        }
        m_log.debug("operatorSignOn: Signing " + (bOn ? "on" : "off") + " using Store Id of " + sStoreId + " and User Id of " + sUserId);
        byte[] resp = this.sendDIO(abPdu);
        ret = this.parseAck(resp, data);
        m_log.trace("operatorSignOn (out): " + ret);
        return ret;
    }

    public String playSound(int[] data, String sArgs) {
        int iVolume;
        int iSound;
        m_log.trace("playSound (in): " + Arrays.toString(data) + ", " + sArgs);
        if (sArgs == null || sArgs.equals("")) {
            m_log.error("playSound: Invalid arguments specified.");
            m_log.trace("playSound (out)");
            return "Invalid arguments specified.";
        }
        String[] asArgs = sArgs.split(",");
        if (asArgs.length != 2) {
            m_log.error("playSound: 2 arguments required.");
            m_log.trace("playSound (out)");
            return "2 arguments required. \"<Sound Index>,<Volume Level>\"";
        }
        try {
            iSound = Integer.parseInt(asArgs[0]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("playSound: Sound Index must be numeric. ", (Throwable)nfe);
            m_log.trace("playSound (out)");
            return "Sound Index must be numeric.";
        }
        try {
            iVolume = Integer.parseInt(asArgs[1]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("playSound: Volume Level must be numeric.", (Throwable)nfe);
            m_log.trace("playSound (out)");
            return "Volume Level must be numeric.";
        }
        m_log.trace("playSound (out)");
        return this.playSound(data, iSound, iVolume);
    }

    public String playSound(int[] data, int sound, int volume) {
        String ret = "";
        m_log.trace("playSound (in): " + Arrays.toString(data) + ", " + Integer.toString(sound) + ", " + Integer.toString(volume));
        if (sound < 0 || sound > 17) {
            m_log.error("playSound: Invalid Sound Index specified.");
            m_log.trace("playSound (out)");
            return "Invalid Sound Index specified.";
        }
        if (volume < 0 || volume > 100) {
            m_log.error("playSound: Invalid Volume Level specified.");
            m_log.trace("playSound (out)");
            return "Invalid Volume Level specified.";
        }
        String sPdu = String.format("%s%02d%03d", "b", sound, volume);
        m_log.debug("playSound: Playing sound " + sound + " at volume " + volume);
        byte[] resp = this.sendDIO(sPdu);
        ret = this.parseAck(resp, data);
        m_log.trace("playSound (out): " + ret);
        return ret;
    }

    public String posConnected(int[] data, String sArgs) {
        int imageBufs;
        m_log.trace("posConnected (in): " + Arrays.toString(data) + ", " + sArgs);
        if (sArgs == null || sArgs.equals("")) {
            m_log.error("posConnected: Invalid arguments specified.");
            m_log.trace("posConnected (out)");
            return "Invalid arguments specified.";
        }
        String[] asArgs = sArgs.split(",");
        if (asArgs.length != 3) {
            m_log.error("posConnected: 3 arguments required.");
            m_log.trace("posConnected (out)");
            return "3 arguments required. \"<POS Image Buffers>,<Lane ID>,<Software Version String>\"";
        }
        try {
            imageBufs = Integer.parseInt(asArgs[0]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("posConnected: Image Buffers must be numeric.");
            m_log.trace("posConnected (out)");
            return "Image Buffers must be numeric.";
        }
        m_log.trace("posConnected (out)");
        return this.posConnected(data, imageBufs, asArgs[1], asArgs[2]);
    }

    public String posConnected(int[] data, int imageBufs, String laneId, String version) {
        int i;
        String ret = "";
        m_log.trace("posConnected (in): " + Arrays.toString(data) + ", " + Integer.toString(imageBufs) + ", " + laneId + ", " + version);
        if (laneId == null || laneId.equals("")) {
            m_log.error("posConnected: Invalid Lane Id specified.");
            m_log.trace("posConnected (out)");
            return "Invalid Lane Id specified.";
        }
        if (version == null || version.equals("")) {
            m_log.error("posConnected: Invalid version specified.");
            m_log.trace("posConnected (out)");
            return "Invalid version specified.";
        }
        if (imageBufs < 0 || imageBufs > 255) {
            m_log.error("posConnected: Image Buffers out of range.");
            m_log.trace("posConnected (out)");
            return "Image Buffers out of range.";
        }
        int iLaneLen = laneId.length();
        int iVerLen = version.length();
        byte[] abPdu = new byte[4 + iLaneLen + iVerLen];
        abPdu[0] = (byte)posConnectedMessageCmd.charAt(0);
        abPdu[1] = (byte)(imageBufs & 0xFF);
        abPdu[2] = (byte)(iLaneLen & 0xFF);
        for (i = 0; i < iLaneLen; ++i) {
            abPdu[3 + i] = (byte)laneId.charAt(i);
        }
        abPdu[3 + iLaneLen] = (byte)(iVerLen & 0xFF);
        for (i = 0; i < iVerLen; ++i) {
            abPdu[4 + iLaneLen + i] = (byte)version.charAt(i);
        }
        m_log.debug("posConnected: Sending POS Connected with " + imageBufs + " Image Buffers, a Lane Id of " + laneId + " and Software Version of " + version + ".");
        byte[] resp = this.sendDIO(abPdu);
        ret = this.parseAck(resp, data);
        m_log.trace("posConnected (out): " + ret);
        return ret;
    }

    public String requestImageData(int[] data, String sArgs) {
        int imageId;
        m_log.trace("requestImageData (in): " + Arrays.toString(data) + ", " + sArgs);
        if (sArgs == null || sArgs.equals("")) {
            m_log.error("requestImageData: Invalid argument specified.");
            m_log.trace("requestImageData (out)");
            return "Invalid argument specified.";
        }
        try {
            imageId = Integer.parseInt(sArgs);
        }
        catch (NumberFormatException nfe) {
            m_log.error("requestImageData: Image Id must be numeric.");
            m_log.trace("requestImageData (out)");
            return "Image Id must be numeric.";
        }
        m_log.trace("requestImageData (out)");
        return this.requestImageData(data, imageId);
    }

    public String requestImageData(int[] data, int imageId) {
        byte[] abPdu = new byte[5];
        String ret = "";
        m_log.trace("requestImageData (in): " + Arrays.toString(data) + ", " + Integer.toString(imageId));
        abPdu[0] = (byte)requestImageCmd.charAt(0);
        abPdu[1] = (byte)((imageId & 0xFF000000) >> 24);
        abPdu[2] = (byte)((imageId & 0xFF0000) >> 16);
        abPdu[3] = (byte)((imageId & 0xFF00) >> 8);
        abPdu[4] = (byte)(imageId & 0xFF);
        m_log.debug("requestImageData: Requesting image " + imageId);
        byte[] resp = this.sendDIO(abPdu);
        ret = this.parseAck(resp, data);
        m_log.trace("requestImageData (out): " + ret);
        return ret;
    }

    public String scannerStatistics(int[] data, String sArg) {
        byte setAge;
        byte statSet;
        m_log.trace("scannerStatistics (in): " + Arrays.toString(data) + ", " + sArg);
        if (sArg == null) {
            m_log.error("scannerStatistics: Invalid arguments specified.");
            m_log.trace("scannerStatistics (out)");
            return "Invalid arguments specified.";
        }
        if (sArg.equals("")) {
            statSet = 48;
            setAge = 48;
        } else {
            String[] asArgs = sArg.split(",");
            if (asArgs.length != 2) {
                m_log.error("scannerStatistics: 2 arguments required.");
                m_log.trace("scannerStatistics (out)");
                return "2 arguments required. \"<Statistics Set>,<Set Age>\"";
            }
            if (asArgs[0].length() != 1 || asArgs[1].length() != 1) {
                m_log.error("scannerStatistics: Arguments must be one byte.");
                m_log.trace("scannerStatistics (out)");
                return "Arguments must be one byte each.";
            }
            statSet = (byte)asArgs[0].charAt(0);
            setAge = (byte)asArgs[1].charAt(0);
        }
        m_log.trace("scannerStatistics (out)");
        return this.scannerStatistics(data, statSet, setAge);
    }

    public String scannerStatistics(int[] data, byte statSet, byte setAge) {
        byte[] abPdu = new byte[3];
        String res = "";
        m_log.trace("scannerStatistics (in): " + Arrays.toString(data) + ", " + (char)statSet + ", " + (char)setAge);
        if (statSet != 48 && statSet != 49) {
            m_log.error("scannerStatistics: Statistics Set must be '0' or '1'.");
            data[0] = -1;
            m_log.trace("scannerStatistics (out)");
            return "Statistics Set must be 0 or 1.";
        }
        if (setAge != 48 && setAge != 49 && setAge != 50 && setAge != 90) {
            m_log.error("scannerStatistics: Set Age must be '0', '1', '2' or 'Z'.");
            data[0] = -1;
            m_log.trace("scannerStatistics (out)");
            return "Set Age must be '0', '1', '2', or 'Z'.";
        }
        abPdu[0] = (byte)scannerStatisticsCmd.charAt(0);
        abPdu[1] = statSet;
        abPdu[2] = setAge;
        byte[] resp = this.sendDIO(abPdu);
        res = this.parseAck(resp, data);
        m_log.trace("scannerStatistics (out): " + res);
        return res;
    }

    public String setItemColor(int[] data, String sArgs) {
        int color;
        int itemId;
        m_log.trace("setItemColor (in): " + Arrays.toString(data) + sArgs);
        if (sArgs == null || sArgs.equals("")) {
            m_log.error("setItemColor: Invalid arguments specified.");
            m_log.trace("setItemColor (out)");
            return "Invalid arguments specified.";
        }
        String[] asArgs = sArgs.split(",");
        if (asArgs.length != 2) {
            m_log.error("setItemColor: 2 arguments required.");
            m_log.trace("setItemColor (out)");
            return "2 arguments required. \"<Item ID>,<Color Index>\"";
        }
        try {
            itemId = Integer.parseInt(asArgs[0]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("setItemColor: Item Id must be numeric. ", (Throwable)nfe);
            return "Item Id must be numeric.";
        }
        try {
            color = Integer.parseInt(asArgs[1]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("setItemColor: Color must be numeric. ", (Throwable)nfe);
            m_log.trace("setItemColor (out)");
            return "Color must be numeric.";
        }
        m_log.trace("setItemColor (out)");
        return this.setItemColor(data, itemId, color);
    }

    public String setItemColor(int[] data, int itemId, int color) {
        byte[] abPdu = new byte[7];
        String ret = "";
        m_log.trace("setItemColor (in): " + Arrays.toString(data) + ", " + Integer.toString(itemId) + ", " + Integer.toString(color));
        if (color < 1 || color > 20) {
            m_log.error("setItemColor: Color value out of range.");
            m_log.trace("setItemColor (out)");
            return "Color value out of range.";
        }
        String sColor = String.format("%02d", color);
        abPdu[0] = (byte)setItemColorCmd.charAt(0);
        abPdu[1] = (byte)((itemId & 0xFF000000) >> 24);
        abPdu[2] = (byte)((itemId & 0xFF0000) >> 16);
        abPdu[3] = (byte)((itemId & 0xFF00) >> 8);
        abPdu[4] = (byte)(itemId & 0xFF);
        abPdu[5] = (byte)sColor.charAt(0);
        abPdu[6] = (byte)sColor.charAt(1);
        m_log.debug("setItemColor: Setting item color for item " + itemId + " to color " + sColor);
        byte[] resp = this.sendDIO(abPdu);
        ret = this.parseAck(resp, data);
        m_log.trace("setItemColor (out): " + ret);
        return ret;
    }

    public String setItemId(int[] data, String sArgs) {
        int itemId;
        m_log.trace("setItemId (in): " + Arrays.toString(data) + ", " + sArgs);
        if (sArgs == null || sArgs.equals("")) {
            m_log.error("setItemId: Invalid arguments specified.");
            m_log.trace("setItemId (out)");
            return "Invalid arguments specified.";
        }
        try {
            itemId = Integer.parseInt(sArgs);
        }
        catch (NumberFormatException nfe) {
            m_log.error("setItemId: Item Id must be numeric.");
            m_log.trace("setItemId (out)");
            return "Item Id must be numeric.";
        }
        m_log.trace("setItemId (out)");
        return this.setItemId(data, itemId);
    }

    public String setItemId(int[] data, int itemId) {
        byte[] abPdu = new byte[5];
        String ret = "";
        m_log.trace("setItemId (in): " + Arrays.toString(data) + ", " + Integer.toString(itemId));
        abPdu[0] = (byte)setItemIdCmd.charAt(0);
        abPdu[1] = (byte)((itemId & 0xFF000000) >> 24);
        abPdu[2] = (byte)((itemId & 0xFF0000) >> 16);
        abPdu[3] = (byte)((itemId & 0xFF00) >> 8);
        abPdu[4] = (byte)(itemId & 0xFF);
        m_log.debug("setItemId: Setting Item Id to " + itemId);
        byte[] resp = this.sendDIO(abPdu);
        ret = this.parseAck(resp, data);
        m_log.trace("setItemId (out): " + ret);
        return ret;
    }

    public String transactionState(int[] data, String sArgs) {
        int iState;
        m_log.trace("transactionState (in): " + Arrays.toString(data) + ", " + sArgs);
        if (sArgs == null || sArgs.equals("")) {
            m_log.error("transactionState: Invalid arguments specified.");
            m_log.trace("transactionState (out)");
            return "Invalid arguments specified.";
        }
        String[] asArgs = sArgs.split(",");
        if (asArgs.length != 3) {
            m_log.error("transactionState: 3 arguments required.");
            m_log.trace("transactionState (out)");
            return "3 arguments required. \"<Transaction State>,<Lane ID>,<Transaction Id>\"";
        }
        try {
            iState = Integer.parseInt(asArgs[0]);
        }
        catch (NumberFormatException nfe) {
            m_log.error("transactionState: Transaction State must be numeric.");
            m_log.trace("transactionState (out)");
            return "Transaction State must be numeric.";
        }
        m_log.trace("transactionState (out)");
        return this.transactionState(data, iState, asArgs[1], asArgs[2]);
    }

    public String transactionState(int[] data, int iState, String laneId, String transId) {
        int i;
        String ret = "";
        m_log.trace("transactionState (in): " + Arrays.toString(data) + ", " + Integer.toString(iState) + ", " + laneId + ", " + transId);
        if (iState != 0 && iState != 1) {
            m_log.error("transactionState: Invalid state specified.");
            m_log.trace("transactionState (out)");
            return "Invalid state specified.";
        }
        if (laneId == null || laneId.equals("")) {
            m_log.error("transactionState: Invalid Lane Id.");
            m_log.trace("transactionState (out)");
            return "Invalid Lane Id.";
        }
        if (transId == null || transId.equals("")) {
            m_log.error("transactionState: Invalid Transaction Id.");
            m_log.trace("transactionState (out)");
            return "Invalid Transaction Id.";
        }
        int iLaneLen = laneId.length();
        int iTransLen = transId.length();
        byte[] abPdu = new byte[5 + iLaneLen + iTransLen];
        abPdu[0] = (byte)transactionStateCmd.charAt(0);
        abPdu[1] = 0;
        abPdu[2] = (byte)(iState & 0xFF);
        abPdu[3] = (byte)(iLaneLen & 0xFF);
        for (i = 0; i < iLaneLen; ++i) {
            abPdu[4 + i] = (byte)laneId.charAt(i);
        }
        abPdu[4 + iLaneLen] = (byte)(iTransLen & 0xFF);
        for (i = 0; i < iTransLen; ++i) {
            abPdu[5 + iLaneLen + i] = (byte)transId.charAt(i);
        }
        m_log.debug("transactionState: Transaction State of " + (iState == 0 ? "beginning" : "end") + " on Lane " + laneId + " for transaction " + transId);
        byte[] resp = this.sendDIO(abPdu);
        ret = this.parseAck(resp, data);
        m_log.trace("transactionState (out): " + ret);
        return ret;
    }

    static enum stEnum {
        ST_IDLE,
        ST_SIG1,
        ST_ACK,
        ST_ITEM,
        ST_PIC,
        ST_LABEL,
        ST_LOC,
        ST_VOL,
        ST_TRACKING,
        ST_FAULT,
        ST_CONNECTED,
        ST_CHECKCONN,
        ST_UPDATE_ITEM,
        ST_LABEL_CHOICE,
        ST_HEALTH_SUMMARY,
        ST_HEALTH_EXTENDED,
        ST_IDENTIFICATION,
        ST_STATISTICS,
        ST_COMNFIGURATION_VALUE,
        ST_OTHER;

    }
}

