/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSState;
import com.dls.jpos.common.FunctionLib;
import com.dls.jpos.interpretation.DLSScale;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSSCSerialScale
extends DLSScale {
    private int DST_POS = 1;
    private int CMD_POS = 2;
    private static final String getWeightCmd = "11";
    private static final String cancelCmd = "12";
    private static final String statusCmd = "13";
    private static final String monitorCmd = "14";
    private static final String hardResetCmd = "00";
    private static final String shutDownCmd = "335";
    private static final String displayStatusCmd = "23";
    private final Object objResponse = new Object();
    private byte[] respBuf = null;
    private final Object statusResponse = new Object();
    private byte[] statusBuf = null;
    private final Object monitorResponse = new Object();
    private byte[] monitorBuf = null;
    private boolean bGetWeight = false;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Logger m_log = LogManager.getLogger(DLSSCSerialScale.class);

    @Override
    public boolean canZeroScale() {
        return false;
    }

    @Override
    public void clearDisplay() {
    }

    @Override
    public void directIO(int command, int[] data, Object object) {
        m_log.trace("directIO (in): " + Integer.toString(command));
        if (DLSJposConst.updateInProgress) {
            m_log.trace("directIO (out)");
            return;
        }
        String strResult = "Invalid command";
        byte[] buf = EMPTY_BYTE_ARRAY;
        switch (command) {
            case 21: {
                this.sendMsg(hardResetCmd);
                strResult = "Scale reset";
                break;
            }
            case 27: 
            case 601: {
                buf = this.sendReceiveStatusMsg(statusCmd);
                if (buf.length < 8) {
                    strResult = "Invalid response from scale.";
                    break;
                }
                strResult = buf[3] == 48 ? "English," : "Metric,";
                strResult = buf[4] == 48 ? strResult + "Enabled," : strResult + "Disabled,";
                switch (buf[7]) {
                    case 48: {
                        strResult = strResult + "Scale is not ready";
                        break;
                    }
                    case 49: {
                        strResult = strResult + "Non-stable weight";
                        break;
                    }
                    case 50: {
                        strResult = strResult + "Stable Overweight";
                        break;
                    }
                    case 51: {
                        strResult = strResult + "Stable zero weight";
                        break;
                    }
                    case 52: {
                        strResult = strResult + "Stable non-zero weight";
                        break;
                    }
                    case 53: {
                        strResult = strResult + "Current stable non-zero weight";
                        break;
                    }
                    case 112: {
                        strResult = strResult + "Calibration Phase 1 (Empty scale and press scale calibration button)";
                        break;
                    }
                    case 113: {
                        strResult = strResult + "Calibration Phase 2 (Calibrating zero weight)";
                        break;
                    }
                    case 114: {
                        strResult = strResult + "Calibration Phase 3 (Add high calibration weight and press scale button)";
                        break;
                    }
                    case 115: {
                        strResult = strResult + "Calibration Phase 4 (Calibrating high weight)";
                        break;
                    }
                    case 116: {
                        strResult = strResult + "Calibration Phase 5 (Calibration done. Press scale button)";
                        break;
                    }
                    case 117: {
                        strResult = strResult + "Recalibration required";
                    }
                }
                break;
            }
            case 26: 
            case 604: {
                buf = this.sendReceiveMonitorMsg(monitorCmd);
                if (buf.length == 0 || buf[1] != 49 || buf[2] != 52) break;
                switch (buf[3]) {
                    case 48: {
                        strResult = "Scale not ready";
                        break;
                    }
                    case 49: {
                        strResult = "Scale unstable";
                        break;
                    }
                    case 50: {
                        strResult = "Scale over capacity";
                        break;
                    }
                    case 51: {
                        strResult = "000";
                        break;
                    }
                    case 52: {
                        strResult = "";
                        StringBuilder oSb = new StringBuilder();
                        for (int i = 4; i < buf.length - 1; ++i) {
                            oSb.append(buf[i] - 48);
                        }
                        strResult = oSb.toString();
                        break;
                    }
                    case 53: {
                        strResult = "Scale under zero";
                        break;
                    }
                    case 112: {
                        strResult = "Calibration Phase 1 (Empty scale and press scale calibration button)";
                        break;
                    }
                    case 113: {
                        strResult = "Calibration Phase 2 (Calibrating zero weight)";
                        break;
                    }
                    case 114: {
                        strResult = "Calibration Phase 3 (Add high calibration weight and press scale button)";
                        break;
                    }
                    case 115: {
                        strResult = "Calibration Phase 4 (Calibrating high weight)";
                        break;
                    }
                    case 116: {
                        strResult = "Calibration Phase 5 (Calibration done. Press scale button)";
                        break;
                    }
                    case 117: {
                        strResult = "Recalibration required";
                    }
                }
                break;
            }
            case 28: {
                buf = this.sendReceiveStatusMsg(displayStatusCmd);
                if (buf.length < 4) {
                    strResult = "Response error";
                    break;
                }
                if (buf[3] == 48) {
                    strResult = "Price/Weight,";
                    break;
                }
                if (buf[3] == 49) {
                    strResult = "Weight";
                    break;
                }
                strResult = "Alphanumeric";
                break;
            }
            case 29: {
                this.sendMsg(shutDownCmd);
                strResult = "Soft power down";
                break;
            }
            case 41: {
                strResult = "RS232-SC";
            }
        }
        try {
            ByteArrayOutputStream oBs = (ByteArrayOutputStream)object;
            oBs.write(strResult.getBytes());
        }
        catch (Exception e) {
            m_log.error("Unable to return data to DIO caller - Are you passing in a ByteArrayOuputStream object? ", (Throwable)e);
        }
        m_log.trace("directIO (out)");
    }

    @Override
    public void disable() throws DLSException {
        m_log.trace("disable (in)");
        if (this.getStatusNotify() == 2) {
            this.stopLiveWeight();
        }
        this.setState(DLSState.DISABLED);
        m_log.trace("disable (out)");
    }

    @Override
    public boolean doHealthCheck() throws DLSException {
        m_log.trace("doHealthCheck (in)");
        boolean bRc = true;
        bRc = this.isAlive();
        m_log.trace("doHealthCheck (out): " + Boolean.toString(bRc));
        return bRc;
    }

    @Override
    public void doSelfTest() {
        m_log.trace("doSelfTest (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.error("Firmware update in progress.");
            m_log.trace("doSelfTest (out)");
            return;
        }
        this.bAlive = true;
        byte[] resp = this.sendReceiveStatusMsg(statusCmd);
        if (resp.length == 0) {
            this.bAlive = false;
            m_log.debug("firing device error event");
            this.fireDeviceErrorEvent(-116);
        }
        m_log.trace("doSelfTest (out)");
    }

    @Override
    public void enable() throws DLSException {
        m_log.trace("enable (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.error("Firmware update in progress.");
            return;
        }
        this.setState(DLSState.ENABLED);
        if (this.getStatusNotify() == 2) {
            this.startLiveWeight();
        }
        m_log.trace("enable (out)");
    }

    @Override
    public HashMap<String, Object> getStatistics() throws DLSException {
        m_log.trace("getStatistics (in)");
        HashMap<String, Object> table = new HashMap<String, Object>();
        String put = table.put("DeviceCategory", "Scale");
        put = table.put("GoodWeightReadCount", "NA");
        put = table.put("Interface", "RS232-SC");
        this.statistics = table;
        m_log.trace("getStatistics (out)");
        return table;
    }

    @Override
    public boolean isAlive() {
        m_log.trace("isAlive (in)");
        boolean bRc = true;
        this.doSelfTest();
        m_log.trace("isAlive (out): " + Boolean.toString(this.bAlive));
        return this.bAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataReceived(byte[] inBuf, int len) {
        m_log.trace("onDataReceived (in): " + Integer.toString(len));
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        if (inBuf == null || len == 0) {
            m_log.error("onDataReceived() called with null or empty buffer.");
            m_log.trace("onDataReceived (out)");
            return;
        }
        m_log.debug("onDataReceived: inBuf = " + new String(inBuf));
        String rawBytes = FunctionLib.byteArrayToString(inBuf);
        m_log.debug("# bytes received" + rawBytes);
        this.parseMessages(inBuf, oInfo.getRxTrailer(), oInfo.getUseBCC());
        for (byte[] tmpBuf : this.msgList) {
            if (tmpBuf.length <= this.CMD_POS || tmpBuf[this.DST_POS] != 49 && tmpBuf[this.DST_POS] != 50) continue;
            switch (tmpBuf[this.CMD_POS]) {
                case 49: {
                    String strWeight = "";
                    StringBuilder oSb = new StringBuilder();
                    for (int i = this.CMD_POS + 1; i < tmpBuf.length - 1; ++i) {
                        oSb.append(tmpBuf[i] - 48);
                    }
                    strWeight = oSb.toString();
                    int nWeight = Integer.parseInt(strWeight);
                    if (!this.getMetricMode()) {
                        nWeight *= 10;
                    }
                    this.fireWeightReceivedEvent(nWeight);
                    break;
                }
                case 50: 
                case 51: {
                    Object object = this.statusResponse;
                    synchronized (object) {
                        this.statusBuf = tmpBuf;
                        this.statusResponse.notifyAll();
                        break;
                    }
                }
                case 52: {
                    int nWeight;
                    StringBuilder oSb;
                    Object object = this.monitorResponse;
                    synchronized (object) {
                        this.monitorBuf = tmpBuf;
                        this.monitorResponse.notifyAll();
                    }
                    if (this.bGetWeight) {
                        switch (tmpBuf[3]) {
                            case 48: {
                                this.fireDeviceErrorEvent(-112);
                                break;
                            }
                            case 49: {
                                this.fireDeviceErrorEvent(-101);
                                break;
                            }
                            case 50: {
                                this.fireDeviceErrorEvent(-107);
                                break;
                            }
                            case 51: {
                                if (!this.getZeroValid()) {
                                    this.fireDeviceErrorEvent(-117);
                                    break;
                                }
                                String strResult = "";
                                oSb = new StringBuilder();
                                for (int i = 4; i < tmpBuf.length - 1; ++i) {
                                    oSb.append(tmpBuf[i] - 48);
                                }
                                strResult = oSb.toString();
                                nWeight = strResult.length() == 0 ? 0 : Integer.parseInt(strResult);
                                if (!this.getMetricMode()) {
                                    nWeight *= 10;
                                }
                                this.fireWeightReceivedEvent(nWeight);
                                break;
                            }
                            case 52: {
                                oSb = new StringBuilder();
                                for (int i = 4; i < tmpBuf.length - 1; ++i) {
                                    oSb.append(tmpBuf[i] - 48);
                                }
                                nWeight = Integer.parseInt(oSb.toString());
                                if (!this.getMetricMode()) {
                                    nWeight *= 10;
                                }
                                this.fireWeightReceivedEvent(nWeight);
                                break;
                            }
                            case 53: {
                                this.fireDeviceErrorEvent(-118);
                                break;
                            }
                            case 117: {
                                this.fireDeviceErrorEvent(-108);
                            }
                        }
                    }
                    this.bGetWeight = false;
                    break;
                }
                default: {
                    Object object = this.objResponse;
                    synchronized (object) {
                        this.respBuf = tmpBuf;
                        this.objResponse.notifyAll();
                        break;
                    }
                }
            }
        }
        this.msgList.clear();
        m_log.trace("onDataReceived (out)");
    }

    @Override
    public void onStatusUpdate(int nStatus) {
        this.fireDeviceStatusEvent(nStatus);
    }

    @Override
    public void open(String strLogicalName) throws DLSException {
        m_log.trace("open (in): " + strLogicalName);
        super.open(strLogicalName);
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        byte b = oInfo.getRxPrefix();
        if (b == 0) {
            this.CMD_POS = 1;
            this.DST_POS = 0;
        } else {
            this.CMD_POS = 2;
            this.DST_POS = 1;
        }
        m_log.trace("open (out)");
    }

    @Override
    public void readEnglishWeight() {
        m_log.trace("readEnglishWeight (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("readEnglishWeight (out)");
            return;
        }
        this.bGetWeight = true;
        this.sendMsg(monitorCmd);
        m_log.trace("readEnglishWeight (out)");
    }

    @Override
    public void readMetricWeight() {
        m_log.trace("readMetricWeight (in)");
        if (DLSJposConst.updateInProgress) {
            return;
        }
        this.bGetWeight = true;
        this.sendMsg(monitorCmd);
        m_log.trace("readMetricWeight (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readStatusWeight() throws DLSException {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        Object object = this.monitorResponse;
        synchronized (object) {
            this.monitorBuf = EMPTY_BYTE_ARRAY;
            this.sendMsg(monitorCmd);
            try {
                this.monitorResponse.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                throw new DLSException(-2147483640, "readStatusWeight: interrupted.");
            }
            catch (NullPointerException npe) {
                m_log.error("readStatusWeight: Exception. ", (Throwable)npe);
            }
        }
        if (this.monitorBuf.length == 0) {
            throw new DLSException(-2147483640, "readStatusWeight timeout");
        }
        int nCurStatus = 0;
        int nCurWeight = 0;
        switch (this.monitorBuf[3]) {
            case 48: {
                nCurStatus = 15;
                break;
            }
            case 49: {
                nCurStatus = 12;
                break;
            }
            case 50: {
                nCurStatus = 14;
                break;
            }
            case 51: {
                nCurStatus = 13;
                break;
            }
            case 53: {
                nCurStatus = 16;
                break;
            }
            case 52: {
                nCurStatus = 11;
                String strResult = "";
                StringBuilder oSb = new StringBuilder();
                for (int i = 4; i < this.monitorBuf.length - 1; ++i) {
                    oSb.append(this.monitorBuf[i] - 48);
                }
                strResult = oSb.toString();
                nCurWeight = Integer.parseInt(strResult);
                if (this.getMetricMode()) break;
                nCurWeight *= 10;
            }
        }
        if (nCurStatus != this.getStatusValue() || nCurWeight != this.getLiveWeight() && nCurStatus == 11) {
            this.setStatusValue(nCurStatus);
            if (nCurStatus == 11) {
                this.setLiveWeight(nCurWeight);
            }
            this.onStatusUpdate(nCurStatus);
        }
    }

    @Override
    public void reportConfiguration() {
    }

    @Override
    public void reset() throws DLSException {
        m_log.trace("reset (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("reset (out)");
            return;
        }
        this.sendMsg(hardResetCmd);
        m_log.trace("reset (out)");
    }

    @Override
    public int sendJoin() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendReceiveMonitorMsg(String strMsg) {
        m_log.trace("sendReceiveMonitorMsg (in): " + strMsg);
        this.monitorBuf = EMPTY_BYTE_ARRAY;
        Object object = this.monitorResponse;
        synchronized (object) {
            this.sendMsg(strMsg);
            try {
                this.monitorResponse.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                m_log.error("sendReceiveMonitorMsg: Interrupted. ", (Throwable)ie);
            }
        }
        m_log.trace("sendReceiveMonitorMsg (out)");
        return this.monitorBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendReceiveStatusMsg(String strMsg) {
        m_log.trace("sendReceiveMsg (in): " + strMsg);
        this.statusBuf = EMPTY_BYTE_ARRAY;
        Object object = this.statusResponse;
        synchronized (object) {
            this.sendMsg(strMsg);
            try {
                this.statusResponse.wait(this.nTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        m_log.trace("sendReceiveMsg (out)");
        return this.statusBuf;
    }

    @Override
    @Deprecated
    public int sendReset() {
        return 0;
    }

    @Override
    public void updateConfiguration() {
    }

    @Override
    public void zeroScale() {
    }
}

