/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.Branding;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScannerConfig;
import com.dls.jpos.common.DLSState;
import com.dls.jpos.common.FunctionLib;
import com.dls.jpos.common.LabelParser;
import com.dls.jpos.common.LabelRow;
import com.dls.jpos.interpretation.DLSScanner;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSSCSerialScanner
extends DLSScanner {
    private int DST_POS = 1;
    private int CMD_POS = 2;
    private int RSP_POS = 2;
    private static final String enableCmd = "01";
    private static final String disableCmd = "02";
    private static final String hardResetCmd = "00";
    private static final String statusCmd = "03";
    private static final String switchReadCmd = "04";
    private static final String disableLED = "06";
    private static final String spDisplayData = "21";
    private static final String spDisplayStatus = "23";
    private static final String spScannerNotOnFile = "33F";
    private static final String spSoftResetCmd = "320";
    private static final String spSetDefaultsCmd = "32C";
    private static final String spEnableToneCmd = "32F";
    private static final String spBeepGoodToneCmd = "334";
    private static final String spShutDownCmd = "335";
    private static final String spStatusCmd = "336";
    private static final String spHealthCmd = "3p=";
    private static final String spIdentificationCmd = "3p<";
    private static final String spStatisticsCmd = "3p>";
    private static final String spFirmwareUpdateCmd = "3p0";
    private static final String spSaveAndResetCmd = "337";
    private static final String spDisableToneCmd = "339";
    private static final String spEnterToadModeCmd = "33A";
    private static final String spReadPacesetterCmd = "3=2";
    private static final String spResetPacesetterCmd = "3=<";
    private static final String spEnablePacesetterPlusTrailerCmd = "3=>>";
    private static final String spDisablePacesetterPlusTrailerCmd = "3=??";
    private final Object objSpecial = new Object();
    private byte[] specialBuf = null;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Logger m_log = LogManager.getLogger(DLSSCSerialScanner.class);

    @Override
    public void open(String strLogicalName) throws DLSException {
        m_log.trace("open (in): " + strLogicalName);
        super.open(strLogicalName);
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        byte b = oInfo.getRxPrefix();
        if (b == 0) {
            this.CMD_POS = 1;
            this.DST_POS = 0;
            this.RSP_POS = 1;
        } else {
            this.CMD_POS = 2;
            this.DST_POS = 1;
            this.RSP_POS = 3;
        }
        m_log.trace("open (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] sendSpecialMsg(String strMsg) {
        m_log.trace("sendSpecialMsg (in): " + strMsg);
        int iSent = 0;
        Object object = this.objSpecial;
        synchronized (object) {
            this.specialBuf = EMPTY_BYTE_ARRAY;
            iSent = this.sendMsg(strMsg);
            try {
                this.objSpecial.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                m_log.error("Interrupt exception ", (Throwable)ie);
            }
        }
        m_log.trace("sendSpecialMsg (out)");
        return Arrays.copyOf(this.specialBuf, this.specialBuf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendRecord(String sRecord) {
        m_log.trace("sendRecord (in): " + sRecord);
        Object object = this.objSpecial;
        synchronized (object) {
            this.nResponse = 255;
            this.specialBuf = EMPTY_BYTE_ARRAY;
            this.sendMsg(spFirmwareUpdateCmd + sRecord);
            try {
                this.objSpecial.wait(this.getRecordTimeout());
                if (this.specialBuf.length != 0) {
                    this.nResponse = this.specialBuf[this.RSP_POS] == 48 ? 6 : (this.specialBuf[this.RSP_POS] == 49 ? 21 : (this.specialBuf[this.RSP_POS] == 50 ? 7 : (this.specialBuf[this.RSP_POS] == 51 ? 7 : 239)));
                }
            }
            catch (InterruptedException ie) {
                m_log.error("sendRecord: Interrupted. ", (Throwable)ie);
                this.nResponse = 255;
            }
        }
        m_log.trace("sendRecord (out): " + Integer.toString(this.nResponse));
        return this.nResponse;
    }

    @Override
    public void enable() throws DLSException {
        m_log.trace("enable (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("enable (out)");
            return;
        }
        this.sendMsg(enableCmd);
        this.setState(DLSState.ENABLED);
        m_log.trace("enable (out)");
    }

    @Override
    public void disable() throws DLSException {
        m_log.trace("disable (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("disable (out)");
            return;
        }
        this.sendMsg(disableLED);
        this.setState(DLSState.DISABLED);
        m_log.trace("disable (out)");
    }

    @Override
    public void reset() throws DLSException {
        m_log.trace("reset (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("reset (out)");
            return;
        }
        this.sendMsg(hardResetCmd);
        m_log.trace("reset (out)");
    }

    @Override
    public void enableBeep() {
        m_log.trace("enableBeep (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("enableBeep (out)");
            return;
        }
        this.sendMsg(spEnableToneCmd);
        m_log.trace("enableBeep (out)");
    }

    @Override
    public void disableBeep() {
        m_log.trace("disableBeep (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("disableBeep (out)");
            return;
        }
        this.sendMsg(spDisableToneCmd);
        m_log.trace("disableBeep (out)");
    }

    @Override
    public int sendJoin() {
        return 0;
    }

    @Override
    @Deprecated
    public int sendReset() {
        return 0;
    }

    @Override
    public void doSelfTest() {
        m_log.trace("doSelfTest (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("doSelfTest (out)");
            return;
        }
        this.bAlive = true;
        byte[] buf = this.sendSpecialMsg(spStatusCmd);
        if (buf.length == 0) {
            this.bAlive = false;
            this.fireDeviceErrorEvent(-2147483638);
        }
        m_log.trace("doSelfTest (out)");
    }

    @Override
    public boolean doHealthCheck() throws DLSException {
        m_log.trace("doHealthCheck (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("doHealthCheck (out): true");
            return true;
        }
        boolean bRc = true;
        byte[] buf = this.sendSpecialMsg(spHealthCmd);
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] == 1) {
                buf[i] = 2;
            }
            if (buf[i] != 4) continue;
            buf[i] = 3;
        }
        try {
            this.logHealthCheck(buf);
        }
        catch (DLSException psce) {
            m_log.error("doHealthCheck: ", (Throwable)psce);
            throw psce;
        }
        m_log.trace("doHealthCheck (out): " + Boolean.toString(bRc));
        return bRc;
    }

    @Override
    public boolean isAlive() {
        m_log.trace("isAlive (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("isAlive (out): " + Boolean.toString(this.bAlive));
            return this.bAlive;
        }
        this.doSelfTest();
        m_log.trace("isAlive (out): " + Boolean.toString(this.bAlive));
        return this.bAlive;
    }

    @Override
    public void setFirmwareBaudRate() {
        m_log.trace("setFirmwareBaudRate (in)");
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        int nOrigBaud = oInfo.getBaud();
        int nBaud = this.scannerConfig.getUpdateBaudRate();
        if (nBaud > nOrigBaud) {
            this.port.changeBaudRate(nBaud);
            if (!this.isAlive()) {
                this.port.changeBaudRate(nOrigBaud);
            }
        }
        m_log.trace("setFirmwareBaudRate (out)");
    }

    @Override
    public void restoreBaudRate() {
        m_log.trace("restoreBaudRate (in)");
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        int nOrigBaud = oInfo.getBaud();
        int nBaud = this.scannerConfig.getUpdateBaudRate();
        if (nBaud != nOrigBaud) {
            this.port.changeBaudRate(nOrigBaud);
        }
        m_log.trace("restoreBaudRate (out)");
    }

    @Override
    public void updateConfiguration() {
    }

    @Override
    public DLSScannerConfig reportConfiguration() {
        m_log.trace("reportConfiguration (in)");
        m_log.trace("reportConfiguration (out)");
        return this.scannerConfig;
    }

    @Override
    public void directIO(int command, int[] data, Object object) throws DLSException {
        m_log.trace("directIO (in): " + Integer.toString(command));
        if (DLSJposConst.updateInProgress) {
            m_log.trace("directIO (out)");
            return;
        }
        byte[] buf = EMPTY_BYTE_ARRAY;
        Object strInfo = null;
        Object str = null;
        String strResult = "Invalid Command";
        block1 : switch (command) {
            case 1: 
            case 502: {
                this.sendMsg(hardResetCmd);
                strResult = "Scanner reset";
                break;
            }
            case 2: 
            case 503: {
                buf = this.sendSpecialMsg(statusCmd);
                strResult = "Scanner status: ";
                if (buf.length >= 4) {
                    if (buf[this.RSP_POS] == 48 && buf[this.RSP_POS + 1] == 49 && buf[this.RSP_POS + 3] == 48) {
                        switch (buf[this.RSP_POS + 2]) {
                            case 48: {
                                strResult = strResult + "Disabled";
                                break block1;
                            }
                            case 49: {
                                strResult = strResult + "Enabled";
                                break block1;
                            }
                        }
                        strResult = strResult + "unknown";
                        break;
                    }
                    strResult = strResult + "unknown";
                    break;
                }
                strResult = strResult + "Failed";
                break;
            }
            case 3: {
                this.sendMsg(switchReadCmd);
                strResult = "Scanner switch read";
                break;
            }
            case 4: 
            case 508: {
                this.sendMsg(spScannerNotOnFile);
                strResult = "Scanner Not on File";
                break;
            }
            case 5: {
                this.sendMsg(disableLED);
                strResult = "Disable with Red Light flashing";
                break;
            }
            case 8: {
                buf = this.sendSpecialMsg(spDisplayData + Arrays.toString(data));
                strResult = "Display data: ";
                if (buf.length != 0) {
                    strResult = strResult + "Accepted";
                    break;
                }
                strResult = strResult + "Failed";
                break;
            }
            case 9: {
                buf = this.sendSpecialMsg(spDisplayStatus);
                strResult = "Display status: ";
                if (buf.length != 0) {
                    switch (buf[this.RSP_POS]) {
                        case 48: {
                            strResult = strResult + "Price and Weight";
                            break block1;
                        }
                        case 49: {
                            strResult = strResult + "Weight Only";
                            break block1;
                        }
                        case 50: {
                            strResult = strResult + "Alpha Numeric (unsupported)";
                            break block1;
                        }
                    }
                    strResult = strResult + "unknown";
                    break;
                }
                strResult = strResult + "Failed";
                break;
            }
            case 10: {
                this.sendMsg(spEnableToneCmd);
                strResult = "Enable tone";
                break;
            }
            case 11: 
            case 501: {
                this.sendMsg(spBeepGoodToneCmd);
                strResult = "Scanner beep";
                break;
            }
            case 12: {
                this.sendMsg(spShutDownCmd);
                strResult = "Soft Power down";
                break;
            }
            case 13: {
                this.sendMsg(spDisableToneCmd);
                strResult = "Scanner disable tone";
                break;
            }
            case 14: {
                this.sendMsg(spEnterToadModeCmd);
                strResult = "Enter Tode";
                break;
            }
            case 15: 
            case 506: {
                String sData = Integer.toString(data[0]);
                String sMsg = spReadPacesetterCmd + sData;
                this.sendMsg(sMsg);
                strResult = "Read Pacesetter";
                break;
            }
            case 16: {
                this.sendMsg(spResetPacesetterCmd);
                strResult = "Reset Pacesetter";
                break;
            }
            case 17: {
                this.sendMsg(spEnablePacesetterPlusTrailerCmd);
                strResult = "Enable Pacesetter";
                break;
            }
            case 18: {
                this.sendMsg(spDisablePacesetterPlusTrailerCmd);
                strResult = "Disable Pacesetter";
                break;
            }
            case 19: {
                this.sendMsg(spSoftResetCmd);
                strResult = "Scanner Soft Reset";
                break;
            }
            case 20: {
                buf = this.sendSpecialMsg(spIdentificationCmd);
                strResult = new String(buf);
                break;
            }
            case 21: {
                buf = this.sendSpecialMsg(spHealthCmd);
                strResult = new String(buf);
                break;
            }
            case 22: {
                buf = this.sendSpecialMsg(spStatisticsCmd);
                strResult = new String(buf);
            }
        }
        try {
            ByteArrayOutputStream oBs = (ByteArrayOutputStream)object;
            oBs.write(strResult.getBytes());
        }
        catch (Exception e) {
            m_log.error("Unable to return data to DIO caller - Are you passing in a ByteArrayOuputStream object? ", (Throwable)e);
        }
        m_log.trace("directIO (out)");
    }

    @Override
    protected LabelRow extractBarcodeType(byte[] identifier) {
        LabelParser labelParser = LabelParser.getInstance();
        labelParser.setDecodeType("sc");
        LabelRow labelRow = labelParser.extractBarcodeType(identifier);
        if (labelRow.getUPOSID() == 0) {
            byte[] oneByteIdentifier = new byte[]{identifier[0]};
            if (identifier.length > 2) {
                byte[] twoByteIdentifier = new byte[]{identifier[0], identifier[1]};
                labelRow = labelParser.extractBarcodeType(twoByteIdentifier);
            } else {
                labelRow = labelParser.extractBarcodeType(oneByteIdentifier);
            }
            if (labelRow.getUPOSID() == 0 && identifier.length > 2) {
                labelRow = labelParser.extractBarcodeType(oneByteIdentifier);
            }
        }
        return labelRow;
    }

    @Override
    public boolean hasStatisticsReporting() {
        return this.scannerConfig.getCanAcceptStatisticsCmd();
    }

    @Override
    public HashMap<String, Object> getStatistics() throws DLSException {
        m_log.trace("getStatistics (in)");
        HashMap<String, Object> table = new HashMap<String, Object>();
        if (DLSJposConst.updateInProgress) {
            m_log.warn("Firmware update in progress. Cannot pull i-h-s data during firmware update.");
            m_log.trace("getStatistics (out)");
            return table;
        }
        if (!this.scannerConfig.getCanAcceptStatisticsCmd()) {
            m_log.warn("Scanner does not support statistical data.");
            m_log.trace("getStatistics (out)");
            return table;
        }
        Object put = table.put("GoodScanCount", "NA");
        String strInfoString = "";
        String[] strInfo = null;
        String str = null;
        int i = 0;
        if (this.hasStatisticsReporting()) {
            String truncated2;
            String truncated;
            m_log.debug("Getting identificationCmd");
            byte[] buf = this.sendSpecialMsg(spIdentificationCmd);
            if (buf.length == 0) {
                throw new DLSException(-2147483640, "Error retrieving Information");
            }
            String rawBytes = "";
            rawBytes = FunctionLib.byteArrayToString(buf);
            m_log.debug("# bytes received" + rawBytes);
            put = table.put("RawInfo", "# bytes received" + rawBytes);
            strInfoString = new String(buf);
            strInfo = strInfoString.split("\u0004");
            block66: for (i = 0; i < strInfo.length; ++i) {
                str = strInfo[i];
                truncated = str.replaceAll("\\p{Cntrl}", "");
                truncated2 = truncated.replaceAll("Sp<", "");
                if (truncated2.equals("")) continue;
                switch (truncated2.charAt(0)) {
                    case 'M': {
                        put = table.put("ModelNumber", truncated2.substring(1));
                        continue block66;
                    }
                    case 'S': {
                        put = table.put("SerialNumber", truncated2.substring(1));
                        put = table.put("DeviceID", truncated2.substring(1));
                        continue block66;
                    }
                    case 'm': {
                        put = table.put("ScannerBoardSerialNumber", truncated2.substring(1));
                        continue block66;
                    }
                    case 'A': {
                        put = table.put("FirmwareVersionNumber", truncated2.substring(1));
                        continue block66;
                    }
                    case 'R': {
                        put = table.put("ScannerRevisionNumber", truncated2.substring(1));
                        continue block66;
                    }
                    case 'C': {
                        put = table.put("ConfigFileVersionNumber", truncated2.substring(1));
                        continue block66;
                    }
                    case 'B': {
                        put = table.put("ScannerBootROMID", truncated2.substring(1));
                        continue block66;
                    }
                    case 'U': {
                        put = table.put("CometROMID", truncated2.substring(1));
                        continue block66;
                    }
                    case 'u': {
                        put = table.put("CometBootROMID", truncated2.substring(1));
                        continue block66;
                    }
                    case 'W': {
                        put = table.put("ScaleInformation", truncated2.substring(1));
                        continue block66;
                    }
                    case 'D': {
                        put = table.put("DisplayVersion", truncated2.substring(1));
                        continue block66;
                    }
                    case 'E': {
                        put = table.put("EASVersion", truncated2.substring(1));
                        continue block66;
                    }
                    case 'I': {
                        put = table.put("ScannerInterface", truncated2.substring(1));
                        continue block66;
                    }
                    case 'r': {
                        put = table.put("RadiolHardwareVersion", truncated2.substring(1));
                        continue block66;
                    }
                    case 'b': {
                        put = table.put("RadioBootloaderVersion", truncated2.substring(1));
                        continue block66;
                    }
                    case 'x': {
                        put = table.put("BaseModelNumber", truncated2.substring(1));
                        continue block66;
                    }
                    case 'F': {
                        put = table.put("FPGAVersion", truncated2.substring(1));
                        continue block66;
                    }
                    case 'P': {
                        put = table.put("IPEAppVersion", truncated2.substring(1));
                        continue block66;
                    }
                    case 'L': {
                        put = table.put("USBLoaderVersion", truncated2.substring(1));
                        continue block66;
                    }
                    case 'Q': {
                        put = table.put("SDRAMCfgVersion", truncated2.substring(1));
                    }
                }
            }
            buf = this.sendSpecialMsg(spHealthCmd);
            if (buf.length == 0) {
                throw new DLSException(-2147483640, "Error retrieving Health");
            }
            rawBytes = FunctionLib.byteArrayToString(buf);
            m_log.debug("# bytes received" + rawBytes);
            put = table.put("RawHealth", "# bytes received" + rawBytes);
            strInfoString = new String(buf);
            strInfo = strInfoString.split("\u0004");
            block67: for (i = 0; i < strInfo.length; ++i) {
                str = strInfo[i];
                truncated = str.replaceAll("\\p{Cntrl}", "");
                truncated2 = truncated.replaceAll("Sp=", "");
                if (truncated2.equals("")) continue;
                switch (truncated2.charAt(0)) {
                    case 'm': {
                        put = table.put("MotorHealth", truncated2.substring(1));
                        continue block67;
                    }
                    case 'h': {
                        put = table.put("VerticalLaserHealth", truncated2.substring(1));
                        continue block67;
                    }
                    case 'v': {
                        put = table.put("HorizontalLaserHealth", truncated2.substring(1));
                        continue block67;
                    }
                    case 's': {
                        put = table.put("ScaleHealth", truncated2.substring(1));
                        continue block67;
                    }
                    case 'd': {
                        put = table.put("RemoteDisplayHealth", truncated2.substring(1));
                        continue block67;
                    }
                    case 'e': {
                        put = table.put("EASHealth", truncated2.substring(1));
                        continue block67;
                    }
                    case 'c': {
                        put = table.put("CameraHealth", truncated2.substring(1));
                        continue block67;
                    }
                    case 'r': {
                        put = table.put("RadiolHealth", truncated2.substring(1));
                        continue block67;
                    }
                    case 'D': {
                        put = table.put("USBSerialDongleConnected", truncated2.substring(1));
                        continue block67;
                    }
                    case '0': {
                        put = table.put("IPE0Health", truncated2.substring(1));
                        continue block67;
                    }
                    case '1': {
                        put = table.put("IPE1Health", truncated2.substring(1));
                        continue block67;
                    }
                    case '2': {
                        put = table.put("IPE2Health", truncated2.substring(1));
                        continue block67;
                    }
                    case '3': {
                        put = table.put("IPE3Health", truncated2.substring(1));
                        continue block67;
                    }
                    case 'S': {
                        put = table.put("ScaleSentryHealth", truncated2.substring(1));
                    }
                }
            }
            buf = this.sendSpecialMsg(spStatisticsCmd);
            if (buf.length == 0) {
                throw new DLSException(-2147483640, "Error retrieving Statistics");
            }
            rawBytes = FunctionLib.byteArrayToString(buf);
            m_log.debug("# bytes received" + rawBytes);
            put = table.put("RawStats", "# bytes received" + rawBytes);
            strInfoString = new String(buf);
            strInfo = strInfoString.split("\u0004");
            block68: for (i = 0; i < strInfo.length; ++i) {
                str = strInfo[i];
                truncated = str.replaceAll("\\p{Cntrl}", "");
                truncated2 = truncated.replaceAll("Sp>", "");
                if (truncated2.equals("")) continue;
                switch (truncated2.charAt(0)) {
                    case 'P': {
                        put = table.put("HoursPoweredCount", truncated2.substring(1));
                        continue block68;
                    }
                    case 'm': {
                        put = table.put("MotorTime", truncated2.substring(1));
                        continue block68;
                    }
                    case 'l': {
                        put = table.put("LaserTime", truncated2.substring(1));
                        continue block68;
                    }
                    case 'L': {
                        put = table.put("GoodScanCount", truncated2.substring(1));
                        continue block68;
                    }
                    case 'z': {
                        put = table.put("ScaleZeroed", truncated2.substring(1));
                        continue block68;
                    }
                    case 'c': {
                        put = table.put("ScaleCalibrations", truncated2.substring(1));
                        continue block68;
                    }
                    case 'C': {
                        put = table.put("CustomData", truncated2.substring(1));
                        continue block68;
                    }
                    case 'E': {
                        put = table.put("EASDeactivations", truncated2.substring(1));
                        continue block68;
                    }
                    case 'e': {
                        put = table.put("EASManualPresses", truncated2.substring(1));
                        continue block68;
                    }
                    case 'B': {
                        put = table.put("BatteryChargeCycles", truncated2.substring(1));
                        continue block68;
                    }
                    case 'T': {
                        put = table.put("TriggerPulls", truncated2.substring(1));
                        continue block68;
                    }
                    case 'K': {
                        put = table.put("KeyPresses", truncated2.substring(1));
                        continue block68;
                    }
                    case 'R': {
                        put = table.put("TotalResets", truncated2.substring(1));
                        continue block68;
                    }
                    case 'r': {
                        put = table.put("ErrorResets", truncated2.substring(1));
                        continue block68;
                    }
                    case 'V': {
                        put = table.put("VerticalIPEForcedResets", truncated2.substring(1));
                        continue block68;
                    }
                    case 'H': {
                        put = table.put("HorizontalIPEForcedResets", truncated2.substring(1));
                        continue block68;
                    }
                    case 'D': {
                        put = table.put("Forced2DResets", truncated2.substring(1));
                        continue block68;
                    }
                    case 'Q': {
                        put = table.put("TDRForcedResets", truncated2.substring(1));
                        continue block68;
                    }
                    case 'v': {
                        put = table.put("VertExcessiveResets", truncated2.substring(1));
                        continue block68;
                    }
                    case 'h': {
                        put = table.put("HorzExcessiveResets", truncated2.substring(1));
                        continue block68;
                    }
                    case 'd': {
                        put = table.put("2DExcessiveResets", truncated2.substring(1));
                        continue block68;
                    }
                    case 'q': {
                        put = table.put("TRDExcessiveResets", truncated2.substring(1));
                        continue block68;
                    }
                    case 'Z': {
                        put = table.put("POSZeroRequests", truncated2.substring(1));
                        continue block68;
                    }
                    case 'X': {
                        put = table.put("EnforcedZeroEvents", truncated2.substring(1));
                        continue block68;
                    }
                    case 'S': {
                        put = table.put("ScaleSentryEvents", truncated2.substring(1));
                        continue block68;
                    }
                    case 'Y': {
                        put = table.put("EASRuntimeFaults", truncated2.substring(1));
                    }
                }
            }
        }
        put = table.put("DeviceCategory", "Scanner");
        put = table.put("Interface", "RS232-SC");
        this.statistics = table;
        m_log.trace("getStatistics (out)");
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataReceived(byte[] inBuf, int inLen) {
        m_log.trace("onDataReceived (in): " + Integer.toString(inLen));
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        if (inBuf == null || inLen == 0) {
            m_log.error("onDataReceived called with zero length data packet");
            m_log.trace("onDataReceived (out)");
            return;
        }
        m_log.debug("onDataReceived: inBuf = " + new String(inBuf));
        this.parseMessages(inBuf, oInfo.getRxTrailer(), oInfo.getUseBCC());
        String decodeType = oInfo.getDecodingType();
        for (byte[] tmpBuf : this.msgList) {
            Object object;
            if (tmpBuf.length <= this.CMD_POS) continue;
            if (tmpBuf[this.DST_POS] == 51 || tmpBuf[this.DST_POS] == 50 || tmpBuf[1] == 112) {
                object = this.objSpecial;
                synchronized (object) {
                    this.specialBuf = tmpBuf;
                    this.objSpecial.notifyAll();
                    continue;
                }
            }
            if (tmpBuf[this.DST_POS] != 48) continue;
            switch (tmpBuf[this.CMD_POS]) {
                case 48: {
                    break;
                }
                case 51: {
                    object = this.objSpecial;
                    synchronized (object) {
                        this.specialBuf = tmpBuf;
                        this.objSpecial.notifyAll();
                        break;
                    }
                }
                case 56: {
                    byte[] identifier = new byte[]{tmpBuf[this.CMD_POS + 1], tmpBuf[this.CMD_POS + 2], tmpBuf[this.CMD_POS + 3]};
                    LabelRow labelRow = this.extractBarcodeType(identifier);
                    int type = labelRow.getUPOSID();
                    int identifierLength = labelRow.getIdentifierLength();
                    byte[] barcode = this.extractBarcodeLabel(tmpBuf, this.CMD_POS + 1 + identifierLength);
                    type = LabelParser.addOns(barcode, type);
                    Branding oBr = Branding.getInstance();
                    String sProp = "com." + oBr.getBrandingPrefix() + ".jpos.service.ScannerService.sendCookedData";
                    DLSProperties options = DLSProperties.getInstance();
                    this.bSendCookedData = options.get(sProp, false);
                    if (this.bSendCookedData) {
                        tmpBuf = barcode;
                    }
                    this.fireLabelReceivedEvent(tmpBuf, barcode, type);
                }
            }
        }
        String rawBytes = FunctionLib.byteArrayToString(inBuf);
        m_log.debug("# bytes received" + rawBytes);
        this.msgList.clear();
        m_log.trace("onDataReceived (out)");
    }

    @Override
    public int sendMessage(String sRecord) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

