/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.Branding;
import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScaleConfig;
import com.dls.jpos.common.DLSState;
import com.dls.jpos.interpretation.DLSDevice;
import com.dls.jpos.interpretation.WeightReceivedListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DLSScale
extends DLSDevice {
    boolean bMetricMode = false;
    private int nLiveWeight = 0;
    private int nPollRate = 500;
    int nStatusNotify = 1;
    private int nStatusValue = 0;
    DLSScaleConfig scaleConfig = null;
    ArrayList<Object> weightReceivedListeners;
    private static final Logger m_log = LogManager.getLogger(DLSScale.class);
    private final ScheduledExecutorService m_scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> m_liveWeight = null;
    private boolean m_lwActive = false;

    public DLSScale() {
        this.weightReceivedListeners = new ArrayList();
    }

    public void addWeightReceivedListener(WeightReceivedListener wrl) {
        m_log.trace("addWeightReceivedListener (in)");
        this.weightReceivedListeners.add(wrl);
        m_log.trace("addWeightReceivedListener (out)");
    }

    public boolean canStatusUpdate() {
        return this.scaleConfig.getCanStatusUpdate();
    }

    public abstract boolean canZeroScale();

    @Override
    public void claim(long lTimeout) throws DLSException {
        m_log.trace("claim (in): " + Long.toString(lTimeout));
        super.claim(lTimeout);
        this.enable3ByteStatus();
        Branding oBr = Branding.getInstance();
        String sProp = "com." + oBr.getBrandingPrefix() + ".jpos.interpretation.autoLoadConfig";
        DLSProperties options = DLSProperties.getInstance();
        if (options.get(sProp, false)) {
            this.updateConfiguration();
        }
        this.reportConfiguration();
        m_log.trace("claim (out)");
    }

    public abstract void clearDisplay() throws DLSException;

    @Override
    public abstract void directIO(int var1, int[] var2, Object var3) throws DLSException;

    protected void enable3ByteStatus() {
    }

    protected void fireWeightReceivedEvent(int weight) {
        m_log.trace("fireWeightReceivedEvent (in): " + Integer.toString(weight));
        Enumeration<Object> e = Collections.enumeration(this.weightReceivedListeners);
        while (e.hasMoreElements()) {
            WeightReceivedListener listener = (WeightReceivedListener)e.nextElement();
            listener.onWeightReceived(weight);
        }
        m_log.trace("fireWeightReceivedEvent (out)");
    }

    @Override
    public DLSCConfig getConfiguration() {
        return this.scaleConfig;
    }

    public synchronized int getLiveWeight() {
        return this.nLiveWeight;
    }

    public boolean getMetricMode() {
        return this.bMetricMode;
    }

    public int getPollRate() {
        return this.nPollRate;
    }

    public int getStatusNotify() {
        return this.nStatusNotify;
    }

    protected synchronized int getStatusValue() {
        return this.nStatusValue;
    }

    public boolean getZeroValid() {
        return this.scaleConfig.getZeroValid();
    }

    public boolean isLiveWeight() {
        return this.m_lwActive;
    }

    public abstract void onStatusUpdate(int var1);

    @Override
    public void open(String strLogicalName) throws DLSException {
        m_log.trace("open (in): " + strLogicalName);
        super.open(strLogicalName);
        this.scaleConfig = new DLSScaleConfig();
        this.scaleConfig.loadConfiguration(strLogicalName);
        this.nPollRate = this.scaleConfig.getLiveWeightPoll();
        this.bMetricMode = this.scaleConfig.getMetricWeightMode();
        this.setState(DLSState.OPENED);
        m_log.trace("open (out)");
    }

    public abstract void readEnglishWeight() throws DLSException;

    public abstract void readMetricWeight() throws DLSException;

    public abstract void readStatusWeight() throws DLSException;

    public void removeWeightReceivedListener(WeightReceivedListener wrl) {
        m_log.trace("removeWeightReceivedListener (in)");
        this.weightReceivedListeners.remove(wrl);
        m_log.trace("removeWeightReceivedListener (out)");
    }

    public abstract void reportConfiguration() throws DLSException;

    protected synchronized void setLiveWeight(int nWeight) {
        this.nLiveWeight = nWeight;
    }

    public void setMetricMode(boolean bValue) {
        m_log.trace("setMetricMode (in): " + Boolean.toString(bValue));
        this.bMetricMode = bValue;
        m_log.trace("setMetricMode (out)");
    }

    public void setStatusNotify(int nValue) {
        m_log.trace("setStatusNotify (in): " + Integer.toString(nValue));
        if (this.nStatusNotify != nValue && this.m_lwActive) {
            this.m_liveWeight.cancel(true);
        }
        this.nStatusNotify = nValue;
        m_log.trace("setStatusNotify (out)");
    }

    protected synchronized void setStatusValue(int nStatus) {
        this.nStatusValue = nStatus;
    }

    public void setZeroValid(boolean zeroValid) {
        this.scaleConfig.setZeroValid(zeroValid);
    }

    protected void startLiveWeight() {
        m_log.trace("startLiveWeight (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.error("startLiveWeight: Cannot start live weight while firmware update is in progress.");
            m_log.trace("startLiveWeight (out)");
            return;
        }
        Runnable lwThread = new Runnable(){

            @Override
            public void run() {
                try {
                    DLSScale.this.readStatusWeight();
                }
                catch (DLSException ex) {
                    m_log.error("Exception reading Live Weight. ", (Throwable)ex);
                }
            }
        };
        this.m_liveWeight = this.m_scheduler.scheduleAtFixedRate(lwThread, this.nPollRate, this.nPollRate, TimeUnit.MILLISECONDS);
        this.m_lwActive = true;
        m_log.trace("startLiveWeight (out)");
    }

    protected void stopLiveWeight() {
        m_log.trace("stopLiveWeight (in)");
        if (this.m_lwActive) {
            this.m_liveWeight.cancel(true);
            this.m_lwActive = false;
        }
        m_log.trace("stopLiveWeight (out)");
    }

    public abstract void updateConfiguration() throws DLSException;

    public abstract void zeroScale() throws DLSException;
}

