/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.Branding;
import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScannerConfig;
import com.dls.jpos.common.DLSState;
import com.dls.jpos.common.LabelParser;
import com.dls.jpos.common.LabelRow;
import com.dls.jpos.interpretation.DLSDevice;
import com.dls.jpos.interpretation.ItemReceivedListener;
import com.dls.jpos.interpretation.LabelReceivedListener;
import com.dls.jpos.interpretation.SystemDataReceivedListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import jpos.JposException;
import jpos.ScannerConst;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DLSScanner
extends DLSDevice
implements ScannerConst {
    @Deprecated
    public static final int ACK = 6;
    @Deprecated
    public static final int NAK = 21;
    @Deprecated
    public static final int CAN = 24;
    @Deprecated
    public static final int BEL = 7;
    @Deprecated
    public static final int UNKWN = 239;
    @Deprecated
    public static final int NRESP = 255;
    @Deprecated
    public int nRecordTimeout;
    int nResponse;
    DLSScannerConfig scannerConfig;
    ArrayList<Object> labelReceivedListeners;
    ArrayList<Object> itemReceivedListeners;
    ArrayList<Object> systemDataReceivedListeners;
    boolean bSendCookedData;
    boolean bConvertBCDtoASCII;
    private static final Logger m_log = LogManager.getLogger(DLSScanner.class);

    public DLSScanner() {
        this.nRecordTimeout = this.nTimeout;
        this.nResponse = 0;
        this.scannerConfig = null;
        this.labelReceivedListeners = new ArrayList();
        this.itemReceivedListeners = new ArrayList();
        this.systemDataReceivedListeners = new ArrayList();
        this.bSendCookedData = false;
        this.bConvertBCDtoASCII = true;
    }

    @Override
    public void open(String strLogicalName) throws DLSException {
        m_log.trace("open (in): " + strLogicalName);
        super.open(strLogicalName);
        this.scannerConfig = new DLSScannerConfig();
        this.scannerConfig.loadConfiguration(strLogicalName);
        this.setState(DLSState.OPENED);
        m_log.trace("open (out)");
    }

    @Override
    public void claim(long lTimeout) throws DLSException {
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        m_log.trace("claim (in): " + Long.toString(lTimeout));
        super.claim(lTimeout);
        Branding oBr = Branding.getInstance();
        String sProp = "com." + oBr.getBrandingPrefix() + ".jpos.interpretation.autoLoadConfig";
        DLSProperties options = DLSProperties.getInstance();
        String sBus = oInfo.getDeviceBus();
        if (sBus != null && sBus.contains("USB") && options.get(sProp, false) && oInfo.getConfigOnClaim()) {
            this.updateConfiguration();
            this.reportConfiguration();
        }
        m_log.trace("claim (out)");
    }

    public abstract void enableBeep() throws DLSException;

    public abstract void disableBeep() throws DLSException;

    public abstract void updateConfiguration() throws DLSException;

    public abstract DLSScannerConfig reportConfiguration() throws DLSException;

    public abstract int sendRecord(String var1);

    public abstract int sendMessage(String var1);

    public abstract void setFirmwareBaudRate();

    public void setRecordTimeout(int timeout) {
        this.nRecordTimeout = timeout;
    }

    public abstract void restoreBaudRate();

    @Override
    public DLSCConfig getConfiguration() {
        return this.scannerConfig;
    }

    public int getRecordTimeout() {
        return this.nRecordTimeout;
    }

    public DLSScannerConfig getScannerConfig() {
        return this.scannerConfig;
    }

    public boolean getCanCompareFirmwareVersion() {
        if (this.scannerConfig == null) {
            return false;
        }
        return this.scannerConfig.getCanCompareFirmwareVersion();
    }

    public boolean getDeleteImageFileAfterRead() throws JposException {
        return this.scannerConfig.getDeleteImageFileAfterRead();
    }

    public void setDeleteImageFileAfterRead(boolean bDeleteAfterImageFileRead) {
        m_log.trace("setDeleteImageFileAfterRead (in): " + bDeleteAfterImageFileRead);
        this.scannerConfig.setDeleteImageFileAfterRead(bDeleteAfterImageFileRead);
        m_log.trace("setDeleteAfterImageFileRead (out)");
    }

    public boolean getCanUpdateFirmware() {
        if (this.scannerConfig == null) {
            return false;
        }
        return this.scannerConfig.getCanUpdateFirmware();
    }

    protected byte[] extractBarcodeLabel(byte[] inBuf, int offset) {
        byte[] buf = new byte[inBuf.length - 1 - offset];
        System.arraycopy(inBuf, offset, buf, 0, inBuf.length - (1 + offset));
        return buf;
    }

    protected LabelRow extractBarcodeType(byte[] identifier) {
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        String decodeType = oInfo.getDecodingType();
        LabelParser labelParser = LabelParser.getInstance();
        labelParser.setDecodeType(decodeType);
        LabelRow labelRow = labelParser.extractBarcodeType(identifier);
        if (labelRow.getUPOSID() == 0) {
            byte[] oneByteIdentifier = new byte[]{identifier[0]};
            if (identifier.length > 2) {
                byte[] twoByteIdentifier = new byte[]{identifier[0], identifier[1]};
                labelRow = labelParser.extractBarcodeType(twoByteIdentifier);
            } else {
                labelRow = labelParser.extractBarcodeType(oneByteIdentifier);
            }
            if (labelRow.getUPOSID() == 0 && identifier.length > 2) {
                labelRow = labelParser.extractBarcodeType(oneByteIdentifier);
            }
        }
        return labelRow;
    }

    public void addLabelReceivedListener(LabelReceivedListener drl) {
        m_log.trace("addLabelReceivedListener (in)");
        this.labelReceivedListeners.add(drl);
        m_log.trace("addLabelReceivedListener (out)");
    }

    public void removeLabelReceivedListener(LabelReceivedListener drl) {
        m_log.trace("removeLabelReceivedListener (in)");
        this.labelReceivedListeners.remove(drl);
        m_log.trace("removeLabelReceivedListener (out)");
    }

    public void addItemReceivedListener(ItemReceivedListener drl) {
        m_log.trace("addItemReceivedListener (in)");
        this.itemReceivedListeners.add(drl);
        m_log.trace("addItemReceivedListener (out)");
    }

    public void removeItemReceivedListener(ItemReceivedListener drl) {
        m_log.trace("removeItemReceivedListener (in)");
        this.itemReceivedListeners.remove(drl);
        m_log.trace("removeItemReceivedListener (out)");
    }

    public void addSystemDataReceivedListener(SystemDataReceivedListener drl) {
        m_log.trace("addSystemDataReceivedListener (in)");
        this.systemDataReceivedListeners.add(drl);
        m_log.trace("addSystemDataReceivedListener (out)");
    }

    public void removeSystemDataReceivedListener(SystemDataReceivedListener drl) {
        m_log.trace("removeSystemDataReceivedListener (in)");
        this.systemDataReceivedListeners.remove(drl);
        m_log.trace("removeSystemReceivedListener (out)");
    }

    protected void fireLabelReceivedEvent(byte[] rawLabel, byte[] decodeLabel, int nType) {
        byte[] decodeLabelData;
        byte[] rawLabelData;
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        m_log.trace("fireLabelReceivedEvent (in): " + new String(rawLabel) + ", " + new String(decodeLabel) + ", " + Integer.toString(nType));
        byte prefix = oInfo.getDataPrefix();
        byte suffix = oInfo.getDataSuffix();
        if (prefix != 0 && suffix != 0) {
            rawLabelData = new byte[rawLabel.length + 2];
            decodeLabelData = new byte[decodeLabel.length + 2];
            System.arraycopy(rawLabel, 0, rawLabelData, 1, rawLabel.length);
            System.arraycopy(decodeLabel, 0, decodeLabelData, 1, decodeLabel.length);
            rawLabelData[0] = prefix;
            decodeLabelData[0] = prefix;
            rawLabelData[rawLabel.length + 1] = suffix;
            decodeLabelData[decodeLabel.length + 1] = suffix;
        } else if (prefix != 0 || suffix != 0) {
            rawLabelData = new byte[rawLabel.length + 1];
            decodeLabelData = new byte[decodeLabel.length + 1];
            if (prefix != 0) {
                System.arraycopy(rawLabel, 0, rawLabelData, 1, rawLabel.length);
                System.arraycopy(decodeLabel, 0, decodeLabelData, 1, decodeLabel.length);
                rawLabelData[0] = prefix;
                decodeLabelData[0] = prefix;
            } else {
                System.arraycopy(rawLabel, 0, rawLabelData, 0, rawLabel.length);
                System.arraycopy(decodeLabel, 0, decodeLabelData, 0, decodeLabel.length);
                rawLabelData[rawLabel.length] = suffix;
                decodeLabelData[decodeLabel.length] = suffix;
            }
        } else {
            rawLabelData = new byte[rawLabel.length];
            decodeLabelData = new byte[decodeLabel.length];
            System.arraycopy(rawLabel, 0, rawLabelData, 0, rawLabel.length);
            System.arraycopy(decodeLabel, 0, decodeLabelData, 0, decodeLabel.length);
        }
        Enumeration<Object> e = Collections.enumeration(this.labelReceivedListeners);
        while (e.hasMoreElements()) {
            LabelReceivedListener listener = (LabelReceivedListener)e.nextElement();
            listener.onLabelReceived(rawLabelData, decodeLabelData, nType);
        }
        m_log.trace("fireLabelReceivedEvent (out)");
    }

    protected void fireItemReceivedEvent(byte[] rawItemData) {
        m_log.trace("fireItemReceivedEvent (in)");
        Enumeration<Object> e = Collections.enumeration(this.itemReceivedListeners);
        while (e.hasMoreElements()) {
            ItemReceivedListener listener = (ItemReceivedListener)e.nextElement();
            listener.onItemReceived(rawItemData);
        }
        m_log.trace("fireItemReceivedEvent (out)");
    }

    protected void fireSystemDataReceivedEvent(byte[] rawSystemData) {
        m_log.trace("fireItemReceivedEvent (in)");
        Enumeration<Object> e = Collections.enumeration(this.systemDataReceivedListeners);
        while (e.hasMoreElements()) {
            SystemDataReceivedListener listener = (SystemDataReceivedListener)e.nextElement();
            listener.onSystemDataReceived(rawSystemData);
        }
        m_log.trace("fireItemReceivedEvent (out)");
    }

    public String[] splitMessage(byte[] inBuf) {
        String str = "";
        StringBuilder oSb = new StringBuilder();
        this.parseMessages(inBuf, (byte)3);
        for (byte[] buf : this.msgList) {
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(buf[i] == 3 ? 44 : buf[i]);
                if (buf[i] < 32 && buf[i] > 126) continue;
                oSb.append((char)buf[i]);
            }
        }
        str = oSb.toString();
        this.bs.reset();
        this.msgList.clear();
        return str.split(",");
    }

    protected void logHealthCheck(byte[] sohBuf) throws DLSException {
        String str = "";
        String strDevice = "";
        String strResp = "";
        StringBuilder oSb = new StringBuilder();
        m_log.trace("logHealthCheck (in)");
        for (int i = 0; i < sohBuf.length; ++i) {
            if (sohBuf[i] != 2) continue;
            ++i;
            str = "";
            while (sohBuf[i] != 3) {
                oSb.append((char)sohBuf[i]);
                ++i;
            }
            str = oSb.toString();
            if (str.length() <= 1) continue;
            switch (str.charAt(0)) {
                case 'm': {
                    m_log.info("logHealthCheck: motor=" + str.substring(1));
                    strDevice = "motor";
                    break;
                }
                case 'h': {
                    m_log.info("logHealthCheck: H laser=" + str.substring(1));
                    strDevice = "Horizontal Laser";
                    break;
                }
                case 'v': {
                    m_log.info("logHealthCheck: V laser=" + str.substring(1));
                    strDevice = "Vertical Laser";
                    break;
                }
                case 's': {
                    m_log.info("logHealthCheck: scale=" + str.substring(1));
                    strDevice = "Scale";
                    break;
                }
                case 'd': {
                    m_log.info("logHealthCheck: display=" + str.substring(1));
                    strDevice = "Display";
                    break;
                }
                case 'e': {
                    m_log.info("logHealthCheck: EAS=" + str.substring(1));
                    strDevice = "EAS";
                    break;
                }
                case 'c': {
                    m_log.info("logHealthCheck: camera=" + str.substring(1));
                    strDevice = "Camera";
                    break;
                }
                default: {
                    m_log.info("logHealthCheck: unknown=" + str.substring(1));
                }
            }
            strResp = str.substring(1);
            if (!strResp.equals("FAIL")) continue;
            m_log.error("logHealthCheck: Device error in check health: " + strDevice);
            throw new DLSException(-2147483639, "Scanner: " + strDevice);
        }
        m_log.trace("logHealthCheck (out)");
    }

    public void onStatusUpdate(int nStatus) {
        m_log.trace("onStatusUpdate (in)");
        this.fireDeviceStatusEvent(nStatus);
        switch (nStatus) {
            case 2004: {
                m_log.trace("onStatusUpdate: JPOS_SUE_POWER_OFF_OFFLINE.");
                this.onDeviceRemoved();
                break;
            }
            case 2001: {
                m_log.trace("onStatusUpdate: JPOS_SUE_POWER_ONLINE.");
                this.onDeviceReattached();
            }
        }
        m_log.trace("onStatusUpdate (out)");
    }
}

