/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSState;
import com.dls.jpos.common.FunctionLib;
import com.dls.jpos.interpretation.DLSScale;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSSerialScale
extends DLSScale {
    private int CMD_POS = 1;
    protected boolean bConfidenceTest = false;
    protected boolean bGetWeight = false;
    private boolean bZeroValid = false;
    protected byte confidenceByte = 0;
    protected final Object confidenceTest = new Object();
    protected byte[] dataBuf = null;
    protected final Object dataReceived = new Object();
    protected static final String enterEchoModeCmd = "E";
    protected static final String exitEchoModeCmd = "F";
    protected static final String getConfidenceTestResultsCmd = "B";
    protected static final String getWeightCmd = "W";
    protected static final String initiateConfidenceTestCmd = "A";
    protected static final String zeroScaleCmd = "Z";
    protected int timeOut = 2000;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Logger m_log = LogManager.getLogger(DLSSerialScale.class);

    @Override
    public boolean canZeroScale() {
        return true;
    }

    @Override
    public void clearDisplay() {
    }

    @Override
    public void directIO(int command, int[] data, Object object) throws DLSException {
        m_log.trace("directIO (in): " + Integer.toString(command));
        if (DLSJposConst.updateInProgress) {
            m_log.trace("directIO (out)");
            return;
        }
        String strResult = "Invalid Command";
        switch (command) {
            case 27: {
                this.sendMsg(getWeightCmd, true);
                strResult = "Status ";
                if (this.dataBuf.length != 0) {
                    if (this.dataBuf[this.CMD_POS] == 63) {
                        byte status = this.dataBuf[this.CMD_POS + 1];
                        if ((status & 4) == 4) {
                            strResult = strResult + ", under zero";
                        }
                        if ((status & 2) == 2) {
                            strResult = strResult + ", overweight";
                        }
                        if ((status & 1) == 1) {
                            strResult = strResult + ", in motion";
                        }
                        if ((status & 8) == 8) {
                            strResult = strResult + ", out of zero capture range";
                        }
                        if ((status & 0x10) != 16) break;
                        strResult = strResult + ", zero weight";
                        break;
                    }
                    StringBuilder oSb = new StringBuilder("Weight - ");
                    for (int i = 1; i < this.dataBuf.length - 1; ++i) {
                        if (this.dataBuf[i] < 48 || this.dataBuf[i] > 57) continue;
                        oSb.append(this.dataBuf[i] - 48);
                    }
                    strResult = oSb.toString();
                    break;
                }
                strResult = strResult + ", no response";
                break;
            }
            case 30: {
                if (this.isAlive()) {
                    strResult = "Selftest - ";
                    strResult = strResult + ((this.confidenceByte & 8) == 8 ? "processor passed, " : "processor FAILED, ");
                    strResult = strResult + ((this.confidenceByte & 0x10) == 16 ? "ROM passed, " : "ROM FAILED, ");
                    strResult = strResult + ((this.confidenceByte & 4) == 4 ? "RAM passed, " : "RAM FAILED, ");
                    strResult = strResult + ((this.confidenceByte & 1) == 1 ? "EEPROM1 passed, " : "EEPROM1 FAILED, ");
                    strResult = strResult + ((this.confidenceByte & 2) == 2 ? "EEPROM2 passed" : "EEPROM2 FAILED");
                    break;
                }
                strResult = "Device not responding";
                break;
            }
            case 41: {
                strResult = "RS232 - SASI";
            }
        }
        try {
            ByteArrayOutputStream oBs = (ByteArrayOutputStream)object;
            oBs.write(strResult.getBytes());
        }
        catch (Exception e) {
            m_log.error("Unable to return data to DIO caller - Are you passing in a ByteArrayOuputStream object? ", (Throwable)e);
        }
        m_log.trace("directIO (out)");
    }

    @Override
    public void disable() throws DLSException {
        m_log.trace("disable (in)");
        this.stopLiveWeight();
        this.setState(DLSState.DISABLED);
        m_log.trace("disable (out)");
    }

    @Override
    public boolean doHealthCheck() throws DLSException {
        m_log.trace("doHealthCheck (in)");
        boolean bRc = this.isAlive();
        if ((this.confidenceByte & 1) != 1) {
            throw new DLSException(-2147483639, "EEPROM 1 Test failed");
        }
        if ((this.confidenceByte & 2) != 2) {
            throw new DLSException(-2147483639, "EEPROM 2 Test failed");
        }
        if ((this.confidenceByte & 4) != 4) {
            throw new DLSException(-2147483639, "RAM Test failed");
        }
        if ((this.confidenceByte & 8) != 8) {
            throw new DLSException(-2147483639, "Processor RAM Test failed");
        }
        if ((this.confidenceByte & 0x10) != 16) {
            throw new DLSException(-2147483639, "ROM Test failed");
        }
        m_log.trace("doHealthCheck (out): " + Boolean.toString(bRc));
        return bRc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSelfTest() {
        m_log.trace("doSelfTest (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.warn("Firmware update in progress.");
            m_log.trace("doSelfTest (out)");
            return;
        }
        this.sendMsg(initiateConfidenceTestCmd, true);
        Object object = this.confidenceTest;
        synchronized (object) {
            this.bAlive = false;
            this.bConfidenceTest = true;
            this.confidenceByte = 0;
            this.sendMsg(getConfidenceTestResultsCmd);
            try {
                this.confidenceTest.wait(this.nTimeout);
                if ((this.confidenceByte & 0x1F) == 31) {
                    this.bAlive = true;
                } else if (this.confidenceByte == 0) {
                    this.fireDeviceErrorEvent(-116);
                }
            }
            catch (InterruptedException e) {
                m_log.error("doSelfTest: Interrupted. ", (Throwable)e);
            }
        }
        m_log.trace("doSelfTest (out)");
    }

    @Override
    public void enable() throws DLSException {
        m_log.trace("enable (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.warn("Firmware update in progress.");
            m_log.trace("enable (out)");
            return;
        }
        this.setState(DLSState.ENABLED);
        if (this.getStatusNotify() == 2) {
            this.startLiveWeight();
        }
        m_log.trace("enable (out)");
    }

    @Override
    public HashMap<String, Object> getStatistics() throws DLSException {
        m_log.trace("getStatistics (in)");
        HashMap<String, Object> table = new HashMap<String, Object>();
        Object put = new Object();
        put = table.put("DeviceCategory", "Scale");
        put = table.put("GoodWeightReadCount", "NA");
        put = table.put("Interface", "RS232");
        this.statistics = table;
        m_log.trace("getStatistics (out)");
        return table;
    }

    @Override
    public boolean isAlive() {
        m_log.trace("isAlive (in)");
        this.doSelfTest();
        m_log.trace("isAlive (out): " + Boolean.toString(this.bAlive));
        return this.bAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataReceived(byte[] inBuf, int len) {
        m_log.trace("onDataReceived (in): " + Integer.toString(len));
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        if (inBuf == null || len == 0) {
            m_log.error("onDataReceived() called with null or empty buffer.");
            m_log.trace("onDataReceived (out)");
            return;
        }
        m_log.debug("onDataReceived: inBuf = " + new String(inBuf));
        String rawBytes = FunctionLib.byteArrayToString(inBuf);
        m_log.debug("# bytes received" + rawBytes);
        this.parseMessages(inBuf, oInfo.getRxTrailer());
        for (byte[] tmpBuf : this.msgList) {
            Object object = this.dataReceived;
            synchronized (object) {
                this.dataBuf = tmpBuf;
                this.dataReceived.notifyAll();
            }
            if (this.isLiveWeight() && !this.bGetWeight && !this.bConfidenceTest) break;
            this.bGetWeight = false;
            this.bZeroValid = super.getZeroValid();
            if (tmpBuf.length <= this.CMD_POS) continue;
            byte pre = oInfo.getRxPrefix();
            this.CMD_POS = pre == tmpBuf[0] ? 1 : 0;
            switch (tmpBuf[this.CMD_POS]) {
                case 63: {
                    int nWeight;
                    int i;
                    int ndxPeriod;
                    StringBuilder oSb;
                    byte status = tmpBuf[this.CMD_POS + 1];
                    Object object2 = this.confidenceTest;
                    synchronized (object2) {
                        if (this.bConfidenceTest) {
                            this.bConfidenceTest = false;
                            this.confidenceByte = status;
                            this.confidenceTest.notifyAll();
                        } else if ((status & 1) == 1) {
                            this.fireDeviceErrorEvent(-101);
                        } else if ((status & 2) == 2) {
                            this.fireDeviceErrorEvent(-107);
                        } else if ((status & 4) == 4) {
                            this.fireDeviceErrorEvent(-118);
                        } else if ((status & 0x10) == 16) {
                            if (this.bZeroValid) {
                                if (tmpBuf.length < 3) {
                                    break;
                                }
                                oSb = new StringBuilder();
                                ndxPeriod = 0;
                                for (i = this.CMD_POS; i < tmpBuf.length; ++i) {
                                    if (tmpBuf[i] == 46) {
                                        ndxPeriod = i;
                                    }
                                    if (tmpBuf[i] < 48 || tmpBuf[i] > 57) continue;
                                    oSb.append(tmpBuf[i] - 48);
                                }
                                nWeight = Integer.parseInt(oSb.toString());
                                if (nWeight == 0 && !this.bZeroValid) {
                                    this.fireDeviceErrorEvent(-117);
                                } else {
                                    if (ndxPeriod == 4) {
                                        nWeight *= 10;
                                    }
                                    try {
                                        this.fireWeightReceivedEvent(nWeight);
                                    }
                                    catch (NumberFormatException e) {
                                        m_log.error("Number format exception in weight read: ", (Throwable)e);
                                    }
                                }
                            } else {
                                this.fireDeviceErrorEvent(-117);
                            }
                        }
                        break;
                    }
                }
                default: {
                    int i;
                    if (tmpBuf.length < 3) break;
                    String strWeight = "";
                    StringBuilder oSb = new StringBuilder();
                    int ndxPeriod = 0;
                    for (i = this.CMD_POS; i < tmpBuf.length; ++i) {
                        if (tmpBuf[i] == 46) {
                            ndxPeriod = i;
                        }
                        if (tmpBuf[i] < 48 || tmpBuf[i] > 57) continue;
                        oSb.append(tmpBuf[i] - 48);
                    }
                    int nWeight = Integer.parseInt(oSb.toString());
                    if (nWeight == 0 && !this.bZeroValid) {
                        this.fireDeviceErrorEvent(-117);
                        break;
                    }
                    if (ndxPeriod == 4) {
                        nWeight *= 10;
                    }
                    try {
                        this.fireWeightReceivedEvent(nWeight);
                        break;
                    }
                    catch (NumberFormatException e) {
                        m_log.error("Number format exception in weight read: ", (Throwable)e);
                    }
                }
            }
        }
        this.msgList.clear();
        m_log.trace("onDataReceived (out)");
    }

    @Override
    public void onStatusUpdate(int nStatus) {
        this.fireDeviceStatusEvent(nStatus);
    }

    @Override
    public void readEnglishWeight() {
        m_log.trace("readEnglishWeight (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("readEnglishWeight (out)");
            return;
        }
        this.bGetWeight = true;
        this.sendMsg(getWeightCmd);
        m_log.trace("readEnglishWeight (out)");
    }

    @Override
    public void readMetricWeight() {
        m_log.trace("readMetricWeight (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("readMetricWeight (out)");
            return;
        }
        this.bGetWeight = true;
        this.sendMsg(getWeightCmd);
        m_log.trace("readMetricWeight (out)");
    }

    @Override
    public void readStatusWeight() throws DLSException {
        m_log.trace("readStatusWeight (in)");
        if (DLSJposConst.updateInProgress) {
            return;
        }
        byte[] sendMsg = this.sendMsg(getWeightCmd, true);
        if (this.dataBuf.length == 0) {
            throw new DLSException(-2147483640, "readStatusWeight timeout");
        }
        int nCurStatus = 0;
        int nCurWeight = 0;
        if (this.dataBuf[this.CMD_POS] == 63) {
            byte status = this.dataBuf[this.CMD_POS + 1];
            if ((status & 4) == 4) {
                nCurStatus = 16;
            } else if ((status & 2) == 2) {
                nCurStatus = 14;
            } else if ((status & 1) == 1) {
                nCurStatus = 12;
            } else if ((status & 8) == 8) {
                nCurStatus = 15;
            } else if ((status & 0x10) == 16) {
                nCurStatus = 13;
            }
        } else {
            nCurStatus = 11;
            StringBuilder oSb = new StringBuilder();
            int ndxPeriod = 0;
            if (this.dataBuf.length < 3) {
                throw new DLSException(-2147483639, "Live Weight invalid.");
            }
            for (int i = this.CMD_POS; i < this.dataBuf.length; ++i) {
                if (this.dataBuf[i] == 46) {
                    ndxPeriod = i;
                }
                if (this.dataBuf[i] < 48 || this.dataBuf[i] > 57) continue;
                oSb.append(this.dataBuf[i] - 48);
            }
            nCurWeight = Integer.parseInt(oSb.toString());
            if (ndxPeriod == 4) {
                nCurWeight *= 10;
            }
        }
        if (nCurStatus != this.getStatusValue() || nCurWeight != this.getLiveWeight() && nCurStatus == 11) {
            this.setStatusValue(nCurStatus);
            if (nCurStatus == 11) {
                this.setLiveWeight(nCurWeight);
            }
            this.onStatusUpdate(nCurStatus);
        }
        m_log.trace("readStatusWeight (out)");
    }

    @Override
    public void reportConfiguration() {
    }

    @Override
    public void reset() throws DLSException {
    }

    @Override
    public int sendJoin() {
        return 0;
    }

    @Override
    protected int sendMsg(String msg) {
        return this.port.sendData(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendMsg(String msg, boolean bWait) {
        Object object = this.dataReceived;
        synchronized (object) {
            this.dataBuf = EMPTY_BYTE_ARRAY;
            this.sendMsg(msg);
            try {
                this.dataReceived.wait(this.nTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return this.dataBuf;
    }

    @Override
    @Deprecated
    public int sendReset() {
        return 0;
    }

    @Override
    public void updateConfiguration() {
    }

    @Override
    public void zeroScale() {
        m_log.trace("zeroScale (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("zeroScale (out)");
            return;
        }
        this.sendMsg(zeroScaleCmd);
        m_log.trace("zeroScale (out)");
    }
}

