/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.Branding;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScannerConfig;
import com.dls.jpos.common.DLSState;
import com.dls.jpos.common.DevWatcher;
import com.dls.jpos.common.DirWatcher;
import com.dls.jpos.common.FunctionLib;
import com.dls.jpos.common.LabelParser;
import com.dls.jpos.common.LabelRow;
import com.dls.jpos.interpretation.DLSScanner;
import com.dls.jpos.interpretation.DeviceErrorStatusListener;
import com.dls.jpos.transport.DLSSerialPort;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xerces.impl.dv.util.Base64;

public class DLSSerialScanner
extends DLSScanner {
    int CMD_POS = 0;
    private static final String enableCmd = "E";
    private static final String disableCmd = "D";
    private static final String resetCmd = "R";
    private static final String notOnFileBeepCmd = "F";
    private static final String enableBeepCmd = "\u0007";
    private static final String beepIfBeepEnabledCmd = "B";
    private static final String forceBeepCmd = "\u0001";
    private static final String idRequestCmd = "i";
    static final String healthRequestCmd = "h";
    private static final String statisticsCmd = "s";
    private static final String readConfigCmd = "$c";
    private static final String writeConfigCmd = "$C";
    private static final String commitConfigCmd = "$As";
    private static final byte[] getMaxNumberStats = new byte[]{48, 0, 117, 0, 0};
    private static final byte[] getStat = new byte[]{48, 0, 117, 1};
    private static final byte[] getStatN = new byte[]{48, 0, 117, 2};
    private static final byte[] getLastStat = new byte[]{48, 0, 117, 3, 0};
    private static final byte[] cellPhoneModeControl = new byte[]{80, 1, 67};
    private boolean bDIOCPMInProgress = false;
    private boolean bDIOWriteConfigInProgress = false;
    private boolean bDIOReadConfigInProgress = false;
    private boolean bDIOCommitConfigInProgress = false;
    private final Object objWaitDIOCPMResp = new Object();
    private final Object objWaitDIOWriteConfigResp = new Object();
    private final Object objWaitDIOReadConfigResp = new Object();
    private final Object objWaitDIOCommitConfigResp = new Object();
    private byte[] picTakingControl = new byte[]{80, 4, 112, 83, 66, 67};
    private byte[] picTakingCtrl9x00 = new byte[]{80, 6, 112, 83, 66, 67, 84, 70};
    private boolean bDIOPTCInProgress = false;
    private boolean bDIOPTCStartInProgress = false;
    private boolean bDIOPTCTransInProgress = false;
    private boolean bDIOImageInProgress = false;
    private boolean bDIOImageStartInProgress = false;
    private boolean bDIOImageTransInProgress = false;
    private boolean bLengthMoreThanResponse = false;
    protected final Object objWaitDIOPTCTrans = new Object();
    private long nPicFileSize = 0L;
    private int nPicFileImageSize = 0;
    private long nPicFileWritten = 0L;
    private int nPicFileImageWritten = 0;
    private long nBaudDelay;
    private int byte0 = 0;
    private int byte1 = 0;
    private int byte2 = 0;
    private int byte3 = 0;
    private boolean emptyBuf = false;
    private String picFileName;
    private FileOutputStream picFile;
    private ByteArrayOutputStream picBuf;
    private int nWaitingOnEot = 0;
    byte[] sohBuf;
    final Object objWaitSohBuf = new Object();
    boolean bFirmware = false;
    private boolean bReadConfigInProgress = false;
    boolean bStatMessageSent = false;
    final Object objWaitAck = new Object();
    private HashMap hMap;
    private String ImageFolderFileName = null;
    private String extension = "JPG";
    private int imageCount = 0;
    String decodeType = null;
    private DirWatcher dw;
    private DevWatcher sdw = null;
    private Thread monitor = null;
    private static final byte[] imagecaputurenow = new byte[]{120, 48, 48, 56, 48, 48, 48, 48, 48, 48, 48, 48, 48, 13};
    private static final byte[] imagenexttrigger = new byte[]{120, 48, 49, 56, 48, 48, 48, 48, 48, 48, 48, 48, 48, 13};
    private static final byte[] imageontrigger = new byte[]{120, 48, 49, 57, 48, 48, 48, 48, 48, 48, 48, 48, 48, 13};
    private static final byte[] imageonnextdecode = new byte[]{120, 48, 50, 56, 48, 48, 48, 48, 48, 48, 48, 48, 48, 13};
    private static final byte[] imageondecode = new byte[]{120, 48, 50, 57, 48, 48, 48, 48, 48, 48, 48, 48, 48, 13};
    private static final byte[] exitImageCapture = new byte[]{120, 48, 52, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 13};
    private DLSProperties options = DLSProperties.getInstance();
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Logger m_log = LogManager.getLogger(DLSSerialScanner.class);

    @Override
    public void removeDeviceStatusListener(DeviceErrorStatusListener dsl) {
        m_log.trace("removeDeviceStatusListener (in)");
        this.deviceStatusListeners.remove(dsl);
        if (this.sdw != null) {
            this.sdw.postDestroy();
            try {
                this.monitor.join(1000L);
            }
            catch (InterruptedException no) {
                m_log.error("removeDeviceStatusListener interrupted: ", (Throwable)no);
            }
            this.sdw = null;
            this.monitor = null;
        }
        m_log.trace("removeDeviceStatusListener (out)");
    }

    @Override
    protected int sendMsg(String msg) {
        return this.port.sendData(msg);
    }

    public boolean findPort() {
        DLSSerialPort serialPort = (DLSSerialPort)this.port;
        return serialPort.findPort();
    }

    public void openPort() {
        this.port.openPort();
    }

    public void closePort() {
        this.port.closePort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendReceiveMsg(String msg) {
        m_log.trace("sendReceiveMsg (in): " + msg);
        Object object = this.objWaitSohBuf;
        synchronized (object) {
            this.sohBuf = EMPTY_BYTE_ARRAY;
            try {
                this.sendMsg(msg);
                this.objWaitSohBuf.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                m_log.error("Interrupt exception caught in sendReceiveMsg(): ", (Throwable)ie);
            }
        }
        m_log.trace("sendReceiveMsg (out)");
        return this.sohBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendReceiveMsg(String msg, int iTimeout) {
        m_log.trace("sendReceiveMsg (in): " + msg + ", " + Integer.toString(iTimeout));
        Object object = this.objWaitSohBuf;
        synchronized (object) {
            this.sohBuf = EMPTY_BYTE_ARRAY;
            this.sendMsg(msg);
            try {
                this.objWaitSohBuf.wait(iTimeout);
            }
            catch (InterruptedException ie) {
                m_log.error("Interrupt exception ", (Throwable)ie);
            }
        }
        m_log.trace("sendReceiveMsg (out)");
        return this.sohBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendRecord(String sRecord) {
        m_log.trace("sendRecord (in): " + sRecord);
        int iSent = 0;
        Object object = this.objWaitAck;
        synchronized (object) {
            this.bFirmware = true;
            this.nResponse = 255;
            iSent = this.sendMsg(sRecord);
            m_log.debug("sendRecord: Sent " + Integer.toString(iSent) + " bytes as a record.");
            try {
                m_log.debug("sendRecord: Waiting for " + Integer.toString(this.getRecordTimeout()) + "ms");
                this.objWaitAck.wait(this.getRecordTimeout());
            }
            catch (InterruptedException ie) {
                m_log.error("sendRecord: Interrupt exception ", (Throwable)ie);
            }
            m_log.debug("sendRecord: Record sent.");
        }
        m_log.trace("sendRecord (out): " + Integer.toString(this.nResponse));
        return this.nResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendDIOCPMCommand(String sDIOCmnd) {
        m_log.trace("sendDIOCPMCommand (in): " + sDIOCmnd);
        Object object = this.objWaitDIOCPMResp;
        synchronized (object) {
            this.bDIOCPMInProgress = true;
            this.nResponse = 255;
            this.sendMsg(sDIOCmnd);
            try {
                this.objWaitDIOCPMResp.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                m_log.error("Interrupt exception ", (Throwable)ie);
            }
        }
        m_log.trace("sendDIOCPMCommand (out): " + Integer.toString(this.nResponse));
        return this.nResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendCommitConfigItems(String commitCfgCmd) {
        m_log.trace("sendCommitConfigItems (in): " + commitCfgCmd);
        Object object = this.objWaitDIOCommitConfigResp;
        synchronized (object) {
            this.bDIOCommitConfigInProgress = true;
            this.nResponse = 255;
            this.sendMsg(commitCfgCmd + "\r");
            try {
                this.objWaitDIOCommitConfigResp.wait(this.nTimeout / 50);
            }
            catch (InterruptedException ie) {
                m_log.error("Interrupt exception ", (Throwable)ie);
            }
        }
        m_log.trace("sendCommitConfigItems (out): " + Integer.toString(this.nResponse));
        return this.nResponse;
    }

    public byte[] sendReadConfigCommand(String readCfgCmd, int[] data, Object object) {
        m_log.trace("sendReadConfigCommand (in): " + readCfgCmd);
        this.bReadConfigInProgress = true;
        ByteArrayOutputStream bsReturn = (ByteArrayOutputStream)object;
        String configItem = bsReturn.toString();
        String outCommand = readCfgCmd + configItem + "\r";
        this.nResponse = 255;
        byte[] myResponse = this.sendReceiveMsg(outCommand, 100);
        if (myResponse.length == 0) {
            myResponse = new byte[]{(byte)this.nResponse};
        }
        m_log.trace("sendReadConfigCommand (out): " + new String(myResponse));
        return myResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendWriteConfigCommand(String commitCfgCmd, int[] data, Object object) {
        m_log.trace("sendWriteConfigCommand (in): " + commitCfgCmd);
        String item_data = (String)object;
        String itemComponent = item_data.substring(0, 4);
        String dataComponent = item_data.substring(4, item_data.length());
        String outCommand = dataComponent.charAt(0) == '0' && dataComponent.charAt(1) == '0' ? commitCfgCmd + itemComponent + dataComponent.substring(2) + "\r" : commitCfgCmd + itemComponent + dataComponent + "\r";
        Object object2 = this.objWaitDIOWriteConfigResp;
        synchronized (object2) {
            this.bDIOWriteConfigInProgress = true;
            this.nResponse = 255;
            this.sendMsg(outCommand);
            try {
                this.objWaitDIOWriteConfigResp.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                m_log.error("Interrupt exception ", (Throwable)ie);
            }
        }
        m_log.trace("sendWriteConfigCommand (out): " + Integer.toString(this.nResponse));
        return this.nResponse;
    }

    public byte[] sendGetStatsCountCommand(String statsCmd, int[] data, Object object) {
        m_log.trace("sendGetStatsCountCommand (in): " + statsCmd);
        byte[] count = this.sendReceiveMsg(statsCmd);
        m_log.trace("sendGetStatsCountCommand (out)");
        return count;
    }

    public byte[] sendGetStatCommand(String statsCmd, int[] data, Object object) {
        m_log.trace("sendGetStatCommand (in): " + statsCmd);
        String outCommand = statsCmd + data[0];
        byte[] myResponse = this.sendReceiveMsg(outCommand);
        m_log.trace("sendGetStatCommand (out)");
        return myResponse;
    }

    public byte[] sendGetStatNCommand(String statsCmd, int[] data, Object object) {
        m_log.trace("sendGetStatNCommand (in): " + statsCmd);
        String outCommand = statsCmd + data[0];
        byte[] myResponse = this.sendReceiveMsg(outCommand);
        m_log.trace("sendGetStatNCommand (out)");
        return myResponse;
    }

    public byte[] sendGetLastStatCommand(String statsCmd, int[] data, Object object) {
        m_log.trace("sendGetLastStatCommand (in): " + statsCmd);
        this.bReadConfigInProgress = true;
        String outCommand = statsCmd + data[0];
        byte[] myResponse = this.sendReceiveMsg(outCommand);
        m_log.trace("sendGetLastStatCommand (out)");
        return myResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendDIOPTCCommand(String sDIOCmnd) {
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        String tempDir = this.options.getTempDir();
        long maxFileSize = 500000L;
        m_log.trace("sendDIOPTCCommand (in): " + sDIOCmnd);
        this.bDIOPTCInProgress = true;
        this.bDIOPTCTransInProgress = false;
        this.bDIOPTCStartInProgress = false;
        this.picBuf = new ByteArrayOutputStream();
        char resType = sDIOCmnd.charAt(3);
        if (resType == '0') {
            maxFileSize = 250000L;
        } else if (resType == '1') {
            maxFileSize = 400000L;
        } else if (resType == '2') {
            maxFileSize = 900000L;
        } else if (resType == '3') {
            maxFileSize = 70000L;
        } else if (resType == 'S') {
            maxFileSize = 500000L;
        }
        this.nBaudDelay = maxFileSize / (long)(oInfo.getBaud() / 10) * 1000L;
        this.nPicFileWritten = 0L;
        this.nResponse = 255;
        this.sendMsg(sDIOCmnd);
        Object object = this.objWaitDIOPTCTrans;
        synchronized (object) {
            try {
                this.objWaitDIOPTCTrans.wait(this.nBaudDelay);
                if (this.nPicFileWritten < this.nPicFileSize) {
                    this.nResponse = 21;
                }
                try {
                    this.picBuf.flush();
                    this.picFile = new FileOutputStream(tempDir + this.picFileName, false);
                    this.picFile.write(this.picBuf.toByteArray(), 0, this.picBuf.size());
                    this.picFile.flush();
                    this.picFile.close();
                }
                catch (IOException e) {
                    m_log.error("sendDIOPTCCommand Exception: ", (Throwable)e);
                }
            }
            catch (InterruptedException ie2) {
                m_log.error("Interrupt exception ", (Throwable)ie2);
            }
        }
        m_log.trace("sendDIOPTCCommand (out): " + Integer.toString(this.nResponse));
        return this.nResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendDIOImageCommand(String sDIOCmnd) {
        String tempDir = this.options.getTempDir();
        long maxFileSize = 500000L;
        m_log.trace("sendImageCommand (in): " + sDIOCmnd);
        this.bDIOImageInProgress = true;
        this.bDIOImageTransInProgress = false;
        this.bDIOImageStartInProgress = false;
        this.picBuf = new ByteArrayOutputStream(40000);
        this.nBaudDelay = maxFileSize / 960L * 1000L;
        this.nPicFileImageWritten = 0;
        this.nResponse = 255;
        this.sendMsg(sDIOCmnd);
        Object object = this.objWaitDIOPTCTrans;
        synchronized (object) {
            block9: {
                try {
                    this.objWaitDIOPTCTrans.wait(10000L);
                    if (this.nPicFileImageWritten < this.nPicFileImageSize) {
                        this.nResponse = 21;
                    }
                    try {
                        this.picBuf.flush();
                        this.picFile = new FileOutputStream(tempDir + this.picFileName + this.imageCount + "." + this.extension, false);
                        this.ImageFolderFileName = tempDir + this.picFileName + this.imageCount + "." + this.extension;
                        ++this.imageCount;
                        if (this.picBuf.size() == 0) {
                            this.emptyBuf = true;
                            this.ImageFolderFileName = "    image not created";
                            this.sendMsg(new String(exitImageCapture));
                            break block9;
                        }
                        String imageDataString = Base64.encode(this.picBuf.toByteArray());
                        byte[] imageByteArray = Base64.decode(imageDataString);
                        FileOutputStream imageOutFile = this.picFile;
                        imageOutFile.write(imageByteArray);
                        imageOutFile.close();
                    }
                    catch (IOException e) {
                        m_log.error("sendDIOImageCommand exception: ", (Throwable)e);
                    }
                }
                catch (InterruptedException ie2) {
                    m_log.error("Interrupt exception ", (Throwable)ie2);
                }
            }
        }
        m_log.trace("sendDIOIamgeCommand (out): " + Integer.toString(this.nResponse));
        return this.nResponse;
    }

    public byte[] sendGeneralCmd(String sCmd) {
        m_log.trace("sendGeneralCmd (in): " + sCmd);
        this.bReadConfigInProgress = true;
        String outCommand = sCmd;
        byte[] myResponse = this.sendReceiveMsg(outCommand, 500);
        m_log.trace("sendGetLastStatCommand (out): " + Integer.toString(this.nResponse));
        return myResponse;
    }

    @Override
    public void enable() throws DLSException {
        m_log.trace("enable (in)");
        if (DLSJposConst.updateInProgress) {
            return;
        }
        this.sendMsg(enableCmd);
        this.setState(DLSState.ENABLED);
        m_log.trace("enable (out)");
    }

    @Override
    public void disable() throws DLSException {
        m_log.trace("disable (in)");
        if (DLSJposConst.updateInProgress) {
            return;
        }
        this.sendMsg(disableCmd);
        this.setState(DLSState.DISABLED);
        m_log.trace("disable (out)");
    }

    public boolean isEnabled() {
        return this.getDeviceEnabled();
    }

    @Override
    public void reset() throws DLSException {
        m_log.trace("reset (in)");
        if (DLSJposConst.updateInProgress) {
            return;
        }
        this.sendMsg(resetCmd);
        m_log.trace("reset (out)");
    }

    @Override
    public void enableBeep() {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        this.sendMsg(enableBeepCmd);
    }

    @Override
    public void disableBeep() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSelfTest() {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        this.bAlive = true;
        if (this.scannerConfig.getCanAcceptStatisticsCmd()) {
            Object object = this.objWaitSohBuf;
            synchronized (object) {
                this.sohBuf = EMPTY_BYTE_ARRAY;
                this.bStatMessageSent = true;
                this.sendMsg(statisticsCmd);
                try {
                    this.objWaitSohBuf.wait(this.nTimeout);
                    if (this.sohBuf.length == 0) {
                        this.bAlive = false;
                        this.fireDeviceErrorEvent(-116);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean doHealthCheck() throws DLSException {
        m_log.trace("doHealthCheck (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.trace("doHealthCheck (out): true");
            return true;
        }
        boolean bRc = true;
        this.bStatMessageSent = true;
        byte[] buf = this.sendReceiveMsg(healthRequestCmd);
        if (buf.length != 0) {
            this.logHealthCheck(buf);
        } else {
            m_log.error("doHealthCheck: Timeout on HealthCheck");
            bRc = false;
        }
        m_log.trace("doHealthCheck (out): " + Boolean.toString(bRc));
        return bRc;
    }

    @Override
    public boolean isAlive() {
        if (DLSJposConst.updateInProgress) {
            return this.bAlive;
        }
        this.doSelfTest();
        return this.bAlive;
    }

    @Override
    public void setFirmwareBaudRate() {
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        m_log.trace("setFirmwareBaudRate (in)");
        int nOrigBaud = oInfo.getBaud();
        int nBaud = this.scannerConfig.getUpdateBaudRate();
        if (nBaud > nOrigBaud) {
            this.port.changeBaudRate(nBaud);
            if (!this.isAlive()) {
                this.port.changeBaudRate(nOrigBaud);
            }
        }
        m_log.trace("setFirmwareBaudRate (out)");
    }

    @Override
    public void restoreBaudRate() {
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        m_log.trace("restoreBaudRate (in)");
        int nOrigBaud = oInfo.getBaud();
        int nBaud = this.scannerConfig.getUpdateBaudRate();
        if (nBaud != nOrigBaud) {
            this.port.changeBaudRate(nOrigBaud);
        }
        m_log.trace("restoreBaudRate (out)");
    }

    @Override
    public int sendJoin() {
        return 0;
    }

    @Override
    @Deprecated
    public int sendReset() {
        return 0;
    }

    @Override
    public void updateConfiguration() {
    }

    @Override
    public DLSScannerConfig reportConfiguration() {
        return this.scannerConfig;
    }

    @Override
    public void directIO(int command, int[] data, Object object) throws DLSException {
        m_log.trace("directIO (in): " + command);
        if (DLSJposConst.updateInProgress) {
            return;
        }
        String strResult = "Invalid Command";
        int nResp = 0;
        switch (command) {
            case 1: {
                this.sendMsg(resetCmd);
                strResult = "Scanner reset";
                break;
            }
            case 11: {
                this.sendMsg(beepIfBeepEnabledCmd);
                strResult = "Scanner beeped";
                break;
            }
            case 12: {
                this.sendMsg(notOnFileBeepCmd);
                strResult = "Not On File Beep";
                break;
            }
            case 342: {
                byte[] myResponse = this.sendReadConfigCommand(readConfigCmd, data, object);
                if (myResponse.length == 0) {
                    data[0] = 21;
                    strResult = "ERROR: Read Config Item failed";
                    break;
                }
                strResult = new String(myResponse);
                if (myResponse.length == 1) {
                    nResp = myResponse[0];
                }
                if (nResp != 0) {
                    switch (nResp) {
                        case 7: {
                            data[0] = 7;
                            strResult = "ERROR: Invalid config item or data out of range";
                            break;
                        }
                        case 21: {
                            data[0] = 21;
                            strResult = "ERROR: Malformed config item and/or data";
                        }
                    }
                    break;
                }
                data[0] = 6;
                break;
            }
            case 343: {
                nResp = this.sendWriteConfigCommand(writeConfigCmd, data, object);
                strResult = "Write Config Iterm:";
                if (nResp == 0) break;
                switch (nResp) {
                    case 7: {
                        data[0] = 7;
                        strResult = "ERROR: Config item does not exist";
                        break;
                    }
                    case 21: {
                        data[0] = 21;
                        strResult = "ERROR: Invalid config item or data out of range";
                        break;
                    }
                    case 6: {
                        data[0] = 6;
                        strResult = "OK: Config item accepted";
                        break;
                    }
                    case 24: {
                        data[0] = 24;
                        strResult = "ERROR: Malformed config item and/or data";
                    }
                }
                break;
            }
            case 344: {
                strResult = "Config commited to scanner memory";
                nResp = this.sendCommitConfigItems(commitConfigCmd);
                strResult = "Config Items commited";
                if (nResp == 0) break;
                switch (nResp) {
                    case 6: {
                        data[0] = 6;
                        strResult = "OK: Commit accepted";
                        break;
                    }
                    case 7: {
                        data[0] = 7;
                        strResult = "ERROR: Commit failed";
                    }
                }
                break;
            }
            case 340: {
                nResp = this.sendDIOCPMCommand(new String(cellPhoneModeControl));
                strResult = "Cell phone mode control";
                if (nResp == 0) break;
                switch (nResp) {
                    case 7: {
                        data[0] = 7;
                        strResult = "ERROR: Cell phone mode not configured";
                        break;
                    }
                    case 23: {
                        data[0] = 23;
                        strResult = "ERROR: Scanner currently taking picture";
                        break;
                    }
                    case 21: {
                        data[0] = 21;
                        strResult = "ERROR: Cell phone mode active and in progress";
                        break;
                    }
                    case 6: {
                        data[0] = 6;
                        strResult = "OK: One-shot cell phone mode activated";
                        break;
                    }
                    case 84: {
                        data[0] = 84;
                        strResult = "OK: Toggle mode activated";
                        break;
                    }
                    case 116: {
                        data[0] = 116;
                        strResult = "OK: Toggle mode deactivated";
                    }
                }
                break;
            }
            case 373: {
                break;
            }
            case 374: {
                break;
            }
            case 375: {
                nResp = this.sendDIOCPMCommand(new String(cellPhoneModeControl));
                strResult = "Cell phone mode enter";
                if (nResp == 0) break;
                switch (nResp) {
                    case 7: {
                        data[0] = 7;
                        strResult = "ERROR: Cell phone mode not configured";
                        break;
                    }
                    case 23: {
                        data[0] = 23;
                        strResult = "ERROR: Scanner currently taking picture";
                        break;
                    }
                    case 21: {
                        data[0] = 21;
                        strResult = "ERROR: Cell phone mode active and in progress";
                        break;
                    }
                    case 6: {
                        data[0] = 6;
                        strResult = "OK: One-shot cell phone mode activated";
                        break;
                    }
                    case 84: {
                        data[0] = 84;
                        strResult = "Cell mode mode activated";
                        data[0] = 6;
                        break;
                    }
                    case 116: {
                        data[0] = 116;
                        nResp = this.sendDIOCPMCommand(new String(cellPhoneModeControl));
                        strResult = "Cell mode mode activated";
                        data[0] = 6;
                    }
                }
                break;
            }
            case 376: {
                nResp = this.sendDIOCPMCommand(new String(cellPhoneModeControl));
                strResult = "Cell phone mode exit";
                if (nResp == 0) break;
                switch (nResp) {
                    case 7: {
                        data[0] = 7;
                        strResult = "ERROR: Cell phone mode not configured";
                        break;
                    }
                    case 23: {
                        data[0] = 23;
                        strResult = "ERROR: Scanner currently taking picture";
                        break;
                    }
                    case 21: {
                        data[0] = 21;
                        strResult = "ERROR: Cell phone mode active and in progress";
                        break;
                    }
                    case 6: {
                        data[0] = 6;
                        strResult = "OK: One-shot cell phone mode activated";
                        break;
                    }
                    case 84: {
                        data[0] = 84;
                        nResp = this.sendDIOCPMCommand(new String(cellPhoneModeControl));
                        data[0] = 6;
                        strResult = "Cell mode mode deactivated";
                        break;
                    }
                    case 116: {
                        data[0] = 6;
                        strResult = "Cell mode mode deactivated";
                    }
                }
                break;
            }
            case 341: {
                this.picTakingControl[3] = (byte)object.toString().charAt(0);
                this.picTakingControl[4] = (byte)object.toString().charAt(1);
                this.picTakingControl[5] = (byte)object.toString().charAt(2);
                this.picFileName = object.toString();
                this.picFileName = this.picFileName.substring(3);
                if (this.picFileName.length() == 0) {
                    this.picFileName = "temp.jpg";
                }
                nResp = this.sendDIOPTCCommand(new String(this.picTakingControl));
                strResult = "Picture Taking Control";
                if (nResp == 0) break;
                switch (nResp) {
                    case 7: {
                        data[0] = 7;
                        strResult = "ERROR: Picture taking not configured";
                        break;
                    }
                    case 6: {
                        data[0] = 6;
                        strResult = "OK: Picture saved as " + this.picFileName;
                        break;
                    }
                    case 21: {
                        data[0] = 21;
                        strResult = "ERROR: Picture transfer incomplete";
                    }
                }
                break;
            }
            case 382: {
                String sInp = object.toString();
                this.picTakingCtrl9x00[3] = (byte)sInp.charAt(0);
                this.picTakingCtrl9x00[4] = (byte)sInp.charAt(1);
                this.picTakingCtrl9x00[5] = (byte)sInp.charAt(2);
                this.picTakingCtrl9x00[6] = (byte)sInp.charAt(3);
                this.picTakingCtrl9x00[7] = (byte)sInp.charAt(4);
                this.picFileName = sInp.substring(5);
                if (this.picFileName.length() == 0) {
                    this.picFileName = "temp.jpg";
                }
                nResp = this.sendDIOPTCCommand(new String(this.picTakingCtrl9x00));
                strResult = "Picture Taking Control (9x00)";
                if (nResp == 0) break;
                switch (nResp) {
                    case 7: {
                        data[0] = 7;
                        strResult = "ERROR: Picture taking not configured.";
                        break;
                    }
                    case 6: {
                        data[0] = 6;
                        strResult = "OK: Picture saved as " + this.picFileName;
                        break;
                    }
                    case 21: {
                        data[0] = 21;
                        strResult = "ERROR: Picture transfer incomplete.";
                    }
                }
                break;
            }
            case 2466: {
                m_log.debug("directIO: Image on next trigger");
                this.picFileName = "Image_";
                nResp = this.sendDIOImageCommand(new String(imagenexttrigger));
                if (this.emptyBuf) {
                    strResult = this.ImageFolderFileName;
                    this.emptyBuf = false;
                    break;
                }
                strResult = "  Image create in : " + this.ImageFolderFileName;
                break;
            }
            case 2467: {
                m_log.debug("directIO: Image on next decode");
                this.picFileName = "Image_";
                nResp = this.sendDIOImageCommand(new String(imageonnextdecode));
                if (this.emptyBuf) {
                    strResult = this.ImageFolderFileName;
                    this.emptyBuf = false;
                    break;
                }
                strResult = "  Image create in : " + this.ImageFolderFileName;
                break;
            }
            case 2465: {
                m_log.debug("directIO: Image capture now");
                this.picFileName = "Image_";
                nResp = this.sendDIOImageCommand(new String(imagecaputurenow));
                if (this.emptyBuf) {
                    strResult = this.ImageFolderFileName;
                    this.emptyBuf = false;
                    break;
                }
                strResult = "  Image create in : " + this.ImageFolderFileName;
                break;
            }
            case 2470: {
                m_log.debug("directIO: Disable Image Mode");
                nResp = this.sendDIOImageCommand(new String(exitImageCapture));
                break;
            }
            case 999: {
                m_log.debug("directIO: General DIO Cmd");
                strResult = "General cmd exit";
                String inString = object.toString();
                byte[] myResponse = this.sendGeneralCmd(inString + "\n\r");
                if (nResp != 0) break;
                data[0] = 6;
                strResult = myResponse.length != 0 ? FunctionLib.byteArrayToStringImage(myResponse) : "Invalid command";
            }
        }
        if (object instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)object).reset();
            try {
                ((ByteArrayOutputStream)object).write(strResult.getBytes());
            }
            catch (IOException ex) {
                m_log.error("directIO: ByteArrayOutputStream object write exception: ", (Throwable)ex);
            }
        }
        m_log.trace("directIO (out)");
    }

    @Override
    public boolean hasStatisticsReporting() {
        return this.scannerConfig.getCanAcceptStatisticsCmd();
    }

    @Override
    protected void internalRelease() {
        m_log.trace("internalRelease (in)");
        if (null != this.sdw) {
            m_log.debug("internalRelease: Killing DevWatcher");
            this.sdw.CloseWindow();
            try {
                this.monitor.join(1000L);
            }
            catch (InterruptedException ex) {
                m_log.error("Error in internalRelease(): ", (Throwable)ex);
            }
            this.monitor = null;
            this.sdw = null;
        }
        m_log.trace("internalRelease (out)");
    }

    @Override
    protected void internalClaim() {
        m_log.trace("internalClaim (in)");
        if (File.separatorChar == '\\' && null == this.sdw) {
            m_log.debug("internalClaim: Starting DevWatcher");
            this.sdw = new DevWatcher(this);
            m_log.debug("internalClaim: SDW:" + this.sdw + " Hash Code:" + this.sdw.hashCode());
            this.monitor = new Thread(this.sdw);
            this.monitor.start();
        }
        m_log.trace("internalClaim (out)");
    }

    @Override
    public HashMap<String, Object> getStatistics() throws DLSException {
        String truncated2;
        String truncated;
        m_log.trace("getStatistics (in)");
        HashMap<String, Object> table = new HashMap<String, Object>();
        if (DLSJposConst.updateInProgress) {
            m_log.warn("Firmware update in progress. Cannot pull i-h-s data during firmware update.");
            m_log.trace("getStatistics (out)");
            return table;
        }
        if (!this.scannerConfig.getCanAcceptStatisticsCmd()) {
            m_log.warn("Scanner does not support i-h-s data data.");
            m_log.trace("getStatistics (out)");
            return table;
        }
        Object put = table.put("GoodScanCount", "NA");
        String[] strInfo = null;
        String str = null;
        int i = 0;
        m_log.debug("getStatistics: Getting idRequestCmd");
        this.bStatMessageSent = true;
        byte[] buf = this.sendReceiveMsg(idRequestCmd);
        if (buf.length == 0) {
            throw new DLSException(-2147483640, "Error retrieving Information");
        }
        String rawBytes = "";
        rawBytes = FunctionLib.byteArrayToString(buf);
        m_log.debug("getStatistics: # bytes received" + rawBytes);
        put = table.put("RawInfo", "# bytes received" + rawBytes);
        strInfo = this.splitMessage(buf);
        block72: for (i = 0; i < strInfo.length; ++i) {
            str = strInfo[i];
            truncated = str.replaceAll("\\p{Cntrl}", "");
            truncated2 = truncated.replaceAll("Sp<", "");
            if (truncated2.length() <= 1) continue;
            switch (truncated2.charAt(0)) {
                case 'M': {
                    put = table.put("ModelNumber", truncated2.substring(1));
                    continue block72;
                }
                case 'S': {
                    put = table.put("SerialNumber", truncated2.substring(1));
                    put = table.put("DeviceID", truncated2.substring(1));
                    continue block72;
                }
                case 'm': {
                    put = table.put("ScannerBoardSerialNumber", truncated2.substring(1));
                    continue block72;
                }
                case 'A': {
                    put = table.put("FirmwareVersionNumber", truncated2.substring(1));
                    continue block72;
                }
                case 'R': {
                    put = table.put("ScannerRevisionNumber", truncated2.substring(1));
                    continue block72;
                }
                case 'C': {
                    put = table.put("ConfigFileVersionNumber", truncated2.substring(1));
                    continue block72;
                }
                case 'B': {
                    put = table.put("ScannerBootROMID", truncated2.substring(1));
                    continue block72;
                }
                case 'H': {
                    put = table.put("HardwareID", truncated2.substring(1));
                    continue block72;
                }
                case 'U': {
                    put = table.put("CometROMID", truncated2.substring(1));
                    continue block72;
                }
                case 'u': {
                    put = table.put("CometBootROMID", truncated2.substring(1));
                    continue block72;
                }
                case 'W': {
                    put = table.put("ScaleInformation", truncated2.substring(1));
                    continue block72;
                }
                case 'D': {
                    put = table.put("DisplayVersion", truncated2.substring(1));
                    continue block72;
                }
                case 'E': {
                    put = table.put("EASVersion", truncated2.substring(1));
                    continue block72;
                }
                case 'I': {
                    put = table.put("ScannerInterface", truncated2.substring(1));
                    continue block72;
                }
                case 'r': {
                    put = table.put("ApplicationRevisionLevel", truncated2.substring(1));
                    continue block72;
                }
                case 'X': {
                    put = table.put("BaseModelNumber", truncated2.substring(1));
                    continue block72;
                }
                case 'F': {
                    put = table.put("FPGAVersion", truncated2.substring(1));
                    continue block72;
                }
                case 'P': {
                    put = table.put("IPEAppVersion", truncated2.substring(1));
                    continue block72;
                }
                case 'l': {
                    put = table.put("USBLoaderVersion", truncated2.substring(1));
                    continue block72;
                }
                case 'Q': {
                    put = table.put("SDRAMCfgVersion", truncated2.substring(1));
                    continue block72;
                }
                case 'V': {
                    put = table.put("VisionLibraryVersion", truncated2.substring(1));
                    continue block72;
                }
                case 'v': {
                    put = table.put("VirtualScanLineLibraryVersion", truncated2.substring(1));
                    continue block72;
                }
                case 'Y': {
                    put = table.put("BaseSerialNumber", truncated2.substring(1));
                    continue block72;
                }
                case 'Z': {
                    put = table.put("BaseSoftwareVersion", truncated2.substring(1));
                    continue block72;
                }
                case 'L': {
                    put = table.put("GunSoftwareVersion", truncated2.substring(1));
                    continue block72;
                }
                case 'b': {
                    put = table.put("GunBootloaderVersion", truncated2.substring(1));
                }
            }
        }
        m_log.debug("getStatistics: Getting healthRequestCmd");
        this.bStatMessageSent = true;
        buf = this.sendReceiveMsg(healthRequestCmd);
        if (buf.length == 0) {
            throw new DLSException(-2147483640, "Error retrieving Health");
        }
        rawBytes = FunctionLib.byteArrayToString(buf);
        m_log.debug("getStatistics: # bytes received" + rawBytes);
        put = table.put("RawHealth", "# bytes received" + rawBytes);
        strInfo = this.splitMessage(buf);
        block73: for (i = 0; i < strInfo.length; ++i) {
            str = strInfo[i];
            truncated = str.replaceAll("\\p{Cntrl}", "");
            truncated2 = truncated.replaceAll("Sp<", "");
            if (truncated2.length() <= 1) continue;
            switch (truncated2.charAt(0)) {
                case 'm': {
                    put = table.put("MotorHealth", truncated2.substring(1));
                    continue block73;
                }
                case 'h': {
                    put = table.put("VerticalLaserHealth", truncated2.substring(1));
                    continue block73;
                }
                case 'v': {
                    put = table.put("HorizontalLaserHealth", truncated2.substring(1));
                    continue block73;
                }
                case 's': {
                    put = table.put("ScaleHealth", truncated2.substring(1));
                    continue block73;
                }
                case 'd': {
                    put = table.put("RemoteDisplayHealth", truncated2.substring(1));
                    continue block73;
                }
                case 'e': {
                    put = table.put("EASHealth", truncated2.substring(1));
                    continue block73;
                }
                case 'c': {
                    put = table.put("CameraHealth", truncated2.substring(1));
                    continue block73;
                }
                case 'r': {
                    put = table.put("RadiolHealth", truncated2.substring(1));
                    continue block73;
                }
                case 'H': {
                    put = table.put("USBHandheldConnected", truncated2.substring(1));
                    continue block73;
                }
                case 'D': {
                    put = table.put("USBSerialDongleConnected", truncated2.substring(1));
                    continue block73;
                }
                case '0': {
                    put = table.put("IPE0Health", truncated2.substring(1));
                    continue block73;
                }
                case '1': {
                    put = table.put("IPE1Health", truncated2.substring(1));
                    continue block73;
                }
                case '2': {
                    put = table.put("IPE2Health", truncated2.substring(1));
                    continue block73;
                }
                case '3': {
                    put = table.put("IPE3Health", truncated2.substring(1));
                }
            }
        }
        m_log.debug("getStatistics: Getting statisticsCmd");
        this.bStatMessageSent = true;
        buf = this.sendReceiveMsg(statisticsCmd);
        if (buf.length == 0) {
            throw new DLSException(-2147483640, "Error retrieving i-h-s data.");
        }
        rawBytes = FunctionLib.byteArrayToString(buf);
        m_log.debug("getStatistics: # bytes received" + rawBytes);
        put = table.put("RawStats", "# bytes received" + rawBytes);
        strInfo = this.splitMessage(buf);
        block74: for (i = 0; i < strInfo.length; ++i) {
            str = strInfo[i];
            truncated = str.replaceAll("\\p{Cntrl}", "");
            truncated2 = truncated.replaceAll("Sp<", "");
            if (truncated2.length() <= 1) continue;
            switch (truncated2.charAt(0)) {
                case 'P': {
                    put = table.put("HoursPoweredCount", truncated2.substring(1));
                    continue block74;
                }
                case 'm': {
                    put = table.put("MotorTime", truncated2.substring(1));
                    continue block74;
                }
                case 'l': {
                    put = table.put("LaserTime", truncated2.substring(1));
                    continue block74;
                }
                case 'L': {
                    put = table.put("GoodScanCount", truncated2.substring(1));
                    continue block74;
                }
                case 'z': {
                    put = table.put("ScaleZeroed", truncated2.substring(1));
                    continue block74;
                }
                case 'c': {
                    put = table.put("ScaleCalibrations", truncated2.substring(1));
                    continue block74;
                }
                case 'E': {
                    put = table.put("EASDeactivations", truncated2.substring(1));
                    continue block74;
                }
                case 'e': {
                    put = table.put("EASManualPresses", truncated2.substring(1));
                    continue block74;
                }
                case 'B': {
                    put = table.put("BatteryChargeCycles", truncated2.substring(1));
                    continue block74;
                }
                case 'T': {
                    put = table.put("TriggerPulls", truncated2.substring(1));
                    continue block74;
                }
                case 'K': {
                    put = table.put("KeyPresses", truncated2.substring(1));
                    continue block74;
                }
                case 'R': {
                    put = table.put("TotalResets", truncated2.substring(1));
                    continue block74;
                }
                case 'r': {
                    put = table.put("ErrorResets", truncated2.substring(1));
                    continue block74;
                }
                case 'V': {
                    put = table.put("VerticalIPEForcedResets", truncated2.substring(1));
                    continue block74;
                }
                case 'H': {
                    put = table.put("HorizontalIPEForcedResets", truncated2.substring(1));
                    continue block74;
                }
                case 'D': {
                    put = table.put("Forced2DResets", truncated2.substring(1));
                    continue block74;
                }
                case 'Q': {
                    put = table.put("TDRForcedResets", truncated2.substring(1));
                    continue block74;
                }
                case 'v': {
                    put = table.put("VertExcessiveResets", truncated2.substring(1));
                    continue block74;
                }
                case 'h': {
                    put = table.put("HorzExcessiveResets", truncated2.substring(1));
                    continue block74;
                }
                case 'd': {
                    put = table.put("2DExcessiveResets", truncated2.substring(1));
                    continue block74;
                }
                case 'q': {
                    put = table.put("TRDExcessiveResets", truncated2.substring(1));
                    continue block74;
                }
                case 'Z': {
                    put = table.put("POSZeroRequests", truncated2.substring(1));
                    continue block74;
                }
                case 'X': {
                    put = table.put("EnforcedZeroEvents", truncated2.substring(1));
                    continue block74;
                }
                case 'S': {
                    put = table.put("ScaleSentryEvents", truncated2.substring(1));
                    continue block74;
                }
                case 'Y': {
                    put = table.put("EASRuntimeFaults", truncated2.substring(1));
                    continue block74;
                }
                case 'p': {
                    put = table.put("BaseHoursPoweredCount", truncated2.substring(1));
                }
            }
        }
        if (!table.containsKey("Interface")) {
            put = table.put("Interface", "RS232");
        }
        Branding oBr = Branding.getInstance();
        String sName = oBr.getManufacturerShortName();
        put = table.put("ManufacturerName", sName);
        put = table.put("DeviceCategory", "Scanner");
        this.bStatMessageSent = false;
        this.statistics = table;
        m_log.trace("getStatistics (out)");
        return table;
    }

    protected void parseReadConfigMessages(byte[] inBuf, byte endChar) {
        for (int i = 0; i < inBuf.length; ++i) {
            this.bs.write(inBuf[i]);
            if (inBuf[i] != endChar) continue;
            byte[] tmpBuf = this.bs.toByteArray();
            boolean add = this.msgList.add(tmpBuf);
            this.bs.reset();
        }
    }

    @Override
    public void onStatusUpdate(int nStatus) {
        this.fireDeviceStatusEvent(nStatus);
    }

    @Override
    public void onDeviceRemoved() {
        m_log.trace("onDeviceRemoved (in)");
        this.fireDeviceErrorEvent(-116);
        m_log.trace("onDeviceRemoved (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataReceived(byte[] inBuf, int inLen) {
        String rawBytes;
        String rawBytes2;
        Object object;
        m_log.trace("onDataReceived (in): " + Integer.toString(inLen));
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        if (inBuf == null || inBuf.length == 0) {
            m_log.warn("onDataReceived() called with null or empty buffer.");
            m_log.trace("onDataReceived (out)");
            return;
        }
        m_log.debug("onDataReceived: inBuf = " + new String(inBuf));
        if (this.bFirmware) {
            Object object2 = this.objWaitAck;
            synchronized (object2) {
                this.nResponse = inBuf[0];
                this.bFirmware = false;
                m_log.debug("onDataReceived: bFirmware: " + this.nResponse);
                this.objWaitAck.notify();
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        if (this.bDIOCPMInProgress) {
            m_log.debug("onDataReceived bDIOCPMInProgress");
            Object object3 = this.objWaitDIOCPMResp;
            synchronized (object3) {
                this.nResponse = inBuf[0];
                this.bDIOCPMInProgress = false;
                m_log.debug("onDataReceived:" + this.nResponse);
                this.objWaitDIOCPMResp.notify();
                String rawBytes3 = FunctionLib.byteArrayToString(inBuf);
                m_log.debug("onDataReceived: # bytes received" + rawBytes3);
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        if (this.bDIOPTCInProgress) {
            m_log.debug("onDataReceived bDIOPTCInProgress");
            object = this.objWaitDIOPTCTrans;
            synchronized (object) {
                this.nResponse = inBuf[0];
                if (this.nResponse == 6) {
                    this.bLengthMoreThanResponse = inLen > 1;
                    this.bDIOPTCStartInProgress = true;
                } else {
                    this.objWaitDIOPTCTrans.notify();
                }
                m_log.debug("onDataReceived:" + this.nResponse);
                this.bDIOPTCInProgress = false;
                if (!this.bLengthMoreThanResponse) {
                    m_log.trace("onDataReceived (out)");
                    return;
                }
            }
        }
        if (this.bDIOPTCStartInProgress) {
            m_log.debug("onDataReceived bDIOPTCStartInProgress");
            object = this.objWaitDIOPTCTrans;
            synchronized (object) {
                byte[] bArr = this.bLengthMoreThanResponse ? new byte[]{inBuf[1], inBuf[2], inBuf[3], inBuf[4]} : new byte[]{inBuf[0], inBuf[1], inBuf[2], inBuf[3]};
                this.nPicFileSize = ByteBuffer.wrap(bArr).getInt();
                if (this.nPicFileSize != 0L) {
                    this.bDIOPTCTransInProgress = true;
                    if (this.bLengthMoreThanResponse) {
                        if (inLen - 5 > 0) {
                            this.picBuf.write(inBuf, 5, inLen - 5);
                        }
                        this.bLengthMoreThanResponse = false;
                    } else {
                        this.picBuf.write(inBuf, 4, inLen - 4);
                    }
                    this.nPicFileWritten += (long)(inLen - 4);
                } else {
                    this.nResponse = 21;
                    this.objWaitDIOPTCTrans.notify();
                }
                this.bDIOPTCStartInProgress = false;
                this.nResponse = 6;
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        if (this.bDIOPTCTransInProgress) {
            object = this.objWaitDIOPTCTrans;
            synchronized (object) {
                this.picBuf.write(inBuf, 0, inLen);
                this.nPicFileWritten += (long)inLen;
                if (this.nPicFileWritten >= this.nPicFileSize) {
                    this.bDIOPTCTransInProgress = false;
                    this.objWaitDIOPTCTrans.notify();
                }
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        if (this.bDIOImageInProgress) {
            m_log.debug("onDataReceived bDIOImageInProgress");
            object = this.objWaitDIOPTCTrans;
            synchronized (object) {
                rawBytes2 = FunctionLib.byteArrayToStringImage(inBuf);
                m_log.debug("onDataReceived: # bytes received image " + rawBytes2);
                if (rawBytes2.startsWith("$i")) {
                    if (inLen == 17) {
                        this.bLengthMoreThanResponse = true;
                        String ext = rawBytes2.substring(3);
                        if (ext.length() > 1) {
                            switch (ext.charAt(0)) {
                                case '0': {
                                    this.extension = "BMP";
                                    break;
                                }
                                case '1': {
                                    this.extension = "JPG";
                                }
                            }
                        }
                    } else {
                        this.bLengthMoreThanResponse = false;
                    }
                    this.bDIOImageStartInProgress = true;
                } else {
                    this.bDIOImageInProgress = true;
                    if (!this.bLengthMoreThanResponse) {
                        m_log.trace("onDataReceived (out)");
                        return;
                    }
                }
                m_log.debug("onDataReceivedImage:" + this.nResponse);
                this.bDIOImageInProgress = false;
                if (!this.bLengthMoreThanResponse) {
                    m_log.trace("onDataReceived (out)");
                    return;
                }
            }
        }
        if (this.bDIOImageStartInProgress) {
            m_log.debug("onDataReceived bDIOImageStartInProgress");
            object = this.objWaitDIOPTCTrans;
            synchronized (object) {
                if (this.bLengthMoreThanResponse) {
                    String size;
                    String strTemp = FunctionLib.byteArrayToStringImage(inBuf);
                    String hex = size = strTemp.substring(8, 12);
                    this.nPicFileImageSize = Integer.parseInt(hex, 16);
                }
                if (this.nPicFileImageSize != 0) {
                    this.bDIOImageTransInProgress = true;
                    this.bLengthMoreThanResponse = false;
                    this.nPicFileImageWritten += inLen;
                } else {
                    this.nResponse = 21;
                    this.objWaitDIOPTCTrans.notify();
                }
                this.bDIOImageStartInProgress = false;
                this.nResponse = 6;
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        if (this.bDIOImageTransInProgress) {
            m_log.debug("onDataReceived bDIOImageTransInProgress");
            object = this.objWaitDIOPTCTrans;
            synchronized (object) {
                this.picBuf.write(inBuf, 0, inLen);
                this.nPicFileImageWritten += inLen;
                this.bDIOImageTransInProgress = false;
                this.objWaitDIOPTCTrans.notify();
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        if (this.bReadConfigInProgress) {
            m_log.debug("onDataReceived Read Config");
            object = this.objWaitSohBuf;
            synchronized (object) {
                this.nResponse = inBuf[0];
                this.msgList.clear();
                this.parseReadConfigMessages(inBuf, oInfo.getRxTrailer());
                if (this.msgList.size() > 0) {
                    this.sohBuf = (byte[])this.msgList.get(0);
                }
                this.bReadConfigInProgress = false;
                rawBytes2 = FunctionLib.byteArrayToString(inBuf);
                m_log.debug("onDataReceived: # bytes received" + rawBytes2);
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        if (this.bDIOWriteConfigInProgress) {
            m_log.debug("onDataReceived bDIOWriteConfigInProgress");
            object = this.objWaitDIOWriteConfigResp;
            synchronized (object) {
                this.nResponse = inBuf[0];
                this.bDIOWriteConfigInProgress = false;
                m_log.debug("onDataReceived:" + this.nResponse);
                this.objWaitDIOWriteConfigResp.notify();
                rawBytes2 = FunctionLib.byteArrayToString(inBuf);
                m_log.debug("onDataReceived: # bytes received" + rawBytes2);
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        if (this.bDIOCommitConfigInProgress) {
            m_log.debug("onDataReceived bDIOCommitConfigInProgress");
            object = this.objWaitDIOCommitConfigResp;
            synchronized (object) {
                this.nResponse = inBuf[0];
                this.bDIOCommitConfigInProgress = false;
                m_log.debug("onDataReceived:" + this.nResponse);
                this.objWaitDIOCommitConfigResp.notify();
                rawBytes2 = FunctionLib.byteArrayToString(inBuf);
                m_log.debug("onDataReceived: # bytes received" + rawBytes2);
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        m_log.debug("onDataReceived about to process status message");
        if (this.bs.size() == 0 && inBuf[0] == 1 || this.nWaitingOnEot > 0) {
            object = this.objWaitSohBuf;
            synchronized (object) {
                ++this.nWaitingOnEot;
                this.parseMessages(inBuf, (byte)4);
                if (this.msgList.size() > 0) {
                    this.nWaitingOnEot = 0;
                    this.sohBuf = (byte[])this.msgList.get(0);
                    this.msgList.clear();
                    this.objWaitSohBuf.notifyAll();
                } else if (this.nWaitingOnEot > 30) {
                    this.nWaitingOnEot = 0;
                    this.bs.reset();
                    this.msgList.clear();
                }
            }
            rawBytes = FunctionLib.byteArrayToString(inBuf);
            m_log.debug("onDataReceived: # bytes received " + rawBytes);
            m_log.trace("onDataReceived (out)");
            return;
        }
        this.parseMessages(inBuf, oInfo.getRxTrailer());
        if (!this.getDeviceEnabled()) {
            this.sohBuf = (byte[])this.msgList.get(0);
            rawBytes = FunctionLib.byteArrayToString(inBuf);
            m_log.debug("onDataReceived: # bytes received " + rawBytes);
            return;
        }
        this.decodeType = oInfo.getDecodingType();
        for (byte[] tmpBuf : this.msgList) {
            byte pre = oInfo.getRxPrefix();
            m_log.debug("onDataReceived: RxPrefix = " + Byte.toString(pre));
            if (tmpBuf.length <= 2) continue;
            if (pre == tmpBuf[0]) {
                m_log.debug("onDataReceived: RxPrefix exists in packet. Setting start position to byte 1.");
                this.CMD_POS = 1;
            }
            byte[] identifier = new byte[]{tmpBuf[this.CMD_POS], tmpBuf[this.CMD_POS + 1], tmpBuf[this.CMD_POS + 2]};
            LabelRow labelRow = this.extractBarcodeType(identifier);
            int type = labelRow.getUPOSID();
            int identifierLength = labelRow.getIdentifierLength();
            byte[] barcode = this.extractBarcodeLabel(tmpBuf, identifierLength);
            type = LabelParser.addOns(barcode, type);
            Branding oBr = Branding.getInstance();
            String sProp = "com." + oBr.getBrandingPrefix() + ".jpos.service.ScannerService.sendCookedData";
            DLSProperties options = DLSProperties.getInstance();
            this.bSendCookedData = options.get(sProp, false);
            if (this.bSendCookedData) {
                tmpBuf = barcode;
            }
            this.fireLabelReceivedEvent(tmpBuf, barcode, type);
        }
        rawBytes2 = FunctionLib.byteArrayToString(inBuf);
        m_log.debug("onDataReceived: # bytes received" + rawBytes2);
        this.msgList.clear();
        m_log.trace("onDataReceived (out)");
    }

    @Override
    public int sendMessage(String sRecord) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

