/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSState;
import com.dls.jpos.interpretation.DLSDevice;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSUSBFlash
extends DLSDevice {
    private boolean bRaiseBusy = true;
    private static final int RESP_COMMAND_COMPLETE = 1;
    private static final int RESP_FLASH_LOADING = 2;
    private static final int RESP_OPERATION_ERROR = 64;
    private static final int RESP_COMMAND_REJECT = 128;
    @Deprecated
    public static final int ACK = 6;
    @Deprecated
    public static final int NAK = 21;
    @Deprecated
    public static final int CAN = 24;
    @Deprecated
    public static final int BEL = 7;
    @Deprecated
    public static final int UNKWN = 239;
    @Deprecated
    public static final int NRESP = 255;
    @Deprecated
    public static final int REPORT_COUNT = 263;
    @Deprecated
    public int nRecordTimeout = 180000;
    private int nResponse = 0;
    private boolean bReattachPending = true;
    private byte nStatus;
    private final Object objStatus = new Object();
    private boolean bWindows = false;
    private byte[] outBuf;
    private static final Logger m_log = LogManager.getLogger(DLSUSBFlash.class);

    public DLSUSBFlash() {
        if (File.separatorChar == '\\') {
            this.bWindows = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startCommand() {
        DLSDeviceInfo flashDeviceInfo = new DLSDeviceInfo();
        int prodID = flashDeviceInfo.getProductId();
        try {
            Object object = this.objStatus;
            synchronized (object) {
                this.nResponse = 255;
                this.nStatus = 0;
                this.outBuf = this.bWindows ? new byte[263] : new byte[4];
                this.outBuf[0] = 0;
                this.outBuf[1] = 0;
                this.outBuf[2] = 1;
                this.outBuf[3] = 0;
                this.port.sendData(this.outBuf, 4);
                if (prodID == 1511) {
                    this.objStatus.wait(10000L);
                } else {
                    this.objStatus.wait(8000L);
                }
                this.nResponse = this.nStatus == 3 ? 6 : ((this.nStatus & 0x40) != 0 ? 7 : ((this.nStatus & 0x80) != 0 ? 21 : 239));
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            m_log.error("startCommand: Error sending record: ", (Throwable)e);
        }
        return this.nResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resetCommand() {
        try {
            Object object = this.objStatus;
            synchronized (object) {
                this.nResponse = 255;
                this.nStatus = 0;
                this.outBuf = this.bWindows ? new byte[263] : new byte[4];
                this.outBuf[0] = 0;
                this.outBuf[1] = 0;
                this.outBuf[2] = 0;
                this.outBuf[3] = 64;
                this.port.sendData(this.outBuf, 4);
                this.objStatus.wait(8000L);
                this.nResponse = this.nStatus == 3 ? 6 : ((this.nStatus & 0x40) != 0 ? 7 : ((this.nStatus & 0x80) != 0 ? 21 : 239));
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            m_log.error("resetCommand: Error sending record: ", (Throwable)e);
        }
        return this.nResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendRecord(String sRecord) {
        try {
            Object object = this.objStatus;
            synchronized (object) {
                this.nResponse = 255;
                this.nStatus = 0;
                this.outBuf = this.bWindows ? new byte[263] : new byte[sRecord.length() + 4];
                this.outBuf[0] = 0;
                this.outBuf[1] = 0;
                this.outBuf[2] = 2;
                this.outBuf[3] = 0;
                byte[] temp = sRecord.getBytes(DLSJposConst.HDL_CHARSET);
                for (int i = 0; i < sRecord.length(); ++i) {
                    this.outBuf[i + 4] = temp[i];
                }
                this.port.sendData(this.outBuf, sRecord.length() + 4);
                this.nRecordTimeout = 60000;
                this.objStatus.wait(this.nRecordTimeout);
                if (this.nStatus == 3) {
                    this.nResponse = 6;
                } else if ((this.nStatus & 0x40) != 0) {
                    this.nResponse = 7;
                } else if ((this.nStatus & 0x80) != 0) {
                    this.nResponse = 21;
                } else {
                    this.nResponse = 239;
                    m_log.warn("UNKNOWN response to sending record with timeout = " + this.nRecordTimeout);
                }
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            m_log.error("sendRecord: Error sending record: ", (Throwable)e);
        }
        return this.nResponse;
    }

    @Override
    public DLSCConfig getConfiguration() {
        return null;
    }

    public int getRecordTimeout() {
        return this.nRecordTimeout;
    }

    @Override
    public void enable() throws DLSException {
    }

    @Override
    public void disable() throws DLSException {
    }

    @Override
    public void doSelfTest() throws DLSException {
    }

    @Override
    public boolean doHealthCheck() throws DLSException {
        return true;
    }

    @Override
    public boolean isAlive() throws DLSException {
        return true;
    }

    @Override
    public int sendJoin() {
        return 0;
    }

    @Override
    @Deprecated
    public int sendReset() {
        return 0;
    }

    public void setRecordTimeout(int timeout) {
        this.nRecordTimeout = timeout;
    }

    @Override
    public void directIO(int command, int[] data, Object object) throws DLSException {
    }

    @Override
    public void reset() throws DLSException {
    }

    @Override
    public void onDeviceAdded() {
    }

    @Override
    public void onDeviceReattached() {
        if (this.bReattachPending) {
            this.bReattachPending = true;
            this.port.openPort();
        }
    }

    @Override
    public void onDeviceRemoved() {
        if (!this.bReattachPending) {
            this.port.closePort();
            this.fireDeviceErrorEvent(-116);
        }
    }

    @Override
    public void open(String strLogicalName) throws DLSException {
        m_log.trace("open (in): " + strLogicalName);
        super.open(strLogicalName);
        this.setState(DLSState.OPENED);
        m_log.trace("open (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataReceived(byte[] inBuf, int inLen) {
        Object object = this.objStatus;
        synchronized (object) {
            if (inLen > 0) {
                this.nStatus = inBuf[0];
            }
            this.objStatus.notifyAll();
        }
    }
}

