/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSScaleConfig;
import com.dls.jpos.common.DLSState;
import com.dls.jpos.common.DevWatcher;
import com.dls.jpos.common.FunctionLib;
import com.dls.jpos.interpretation.DLSScale;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSUSBScale
extends DLSScale {
    private static final byte[] performSelfTestCmd = new byte[]{0, 16, 0, 0, 0};
    private static final byte[] statusRequestCmd = new byte[]{0, 32, 0, 0, 0};
    private static final byte[] resetCmd = new byte[]{0, 64, 0, 0, 0};
    private static final byte[] englishWeightCmd = new byte[]{1, 0, 0, 0, 0};
    private static final byte[] metricWeightCmd = new byte[]{2, 0, 0, 0, 0};
    private static final byte[] zeroScaleCmd = new byte[]{3, 0, 0, 0, 0};
    private static final byte[] enable3ByteStatusCmd = new byte[]{4, 0, 0, 0, 0};
    private static final byte[] disable3ByteStatusCmd = new byte[]{5, 0, 0, 0, 0};
    private static final byte[] clearRemoteDisplayCmd = new byte[]{6, 0, 0, 0, 0};
    private byte[] configureScaleCmd = new byte[]{32, 0, 0, 0, 0};
    private static final byte[] reportScaleConfigCmd = new byte[]{33, 0, 0, 0, 0};
    private static final int RESP_FIRMWARE_FLASH = 1;
    private static final int RESP_CONFIG_DATA = 2;
    private static final int RESP_XTEND_STATUS = 4;
    private static final int RESP_CMD_ERROR = 64;
    private static final int RESP_NOT_READY = 128;
    private static final int RESP_METRIC = 256;
    private static final int RESP_FIVE_DIGIT = 512;
    private static final int RESP_NO_WEIGHT = 1024;
    private static final int RESP_DATA_ERROR = 2048;
    private static final int RESP_READ_ERROR = 4096;
    private static final int RESP_NO_DISPLAY = 8192;
    private static final int RESP_HARDWARE_ERROR = 16384;
    private static final int RESP_CMD_REJECT = 32768;
    private static final int RESP_CONFIG_SUCCESS = 65536;
    private static final int RESP_UNDER_ZERO = 131072;
    private static final int RESP_OVER_CAPACITY = 262144;
    private static final int RESP_CENTER_OF_ZERO = 524288;
    private static final int RESP_REQUIRES_ZEROING = 0x100000;
    private static final int RESP_SCALE_WARMUP = 0x200000;
    private static final int RESP_DUPLICATE_WEIGHT = 0x400000;
    private final Object reportResp = new Object();
    private final Object updateResp = new Object();
    private static final int updateTimeout = 2000;
    private static final int statusTimeout = 2000;
    private final Object statusResp = new Object();
    private static final int liveTimeout = 1000;
    private int nLiveResp = 0;
    private int nDevLiveWeight = 0;
    private byte[] dataBuf = null;
    private boolean bDeviceReady = false;
    private byte nStat1;
    private byte nStat2;
    private byte nStat3;
    private final Object objStatus = new Object();
    private boolean bReattachPending = true;
    private boolean bGetWeight = false;
    private boolean bZeroValid = true;
    private boolean bDioCommand = false;
    public volatile boolean bLiveWeight = false;
    private boolean bSaveLiveWeight = false;
    private boolean bSaveDeviceEnabled = false;
    private int saveStatusNotify = 0;
    private DevWatcher sdw = null;
    private Thread monitor = null;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Logger m_log = LogManager.getLogger(DLSUSBScale.class);

    @Override
    public boolean canZeroScale() {
        return true;
    }

    @Override
    public void clearDisplay() throws DLSException {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        this.port.sendData(clearRemoteDisplayCmd, clearRemoteDisplayCmd.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void directIO(int command, int[] data, Object object) throws DLSException {
        m_log.trace("directIO (in): " + Integer.toString(command));
        if (DLSJposConst.updateInProgress) {
            m_log.warn("directIO: Firmware update in progress.");
            m_log.trace("directIO (out)");
            return;
        }
        byte[] buf = EMPTY_BYTE_ARRAY;
        this.bDioCommand = true;
        switch (command) {
            case 21: {
                m_log.debug("directIO: DIO_SCALE_RESET");
                Object object2 = this.objStatus;
                synchronized (object2) {
                    this.bSaveLiveWeight = this.bLiveWeight;
                    this.bSaveDeviceEnabled = this.getDeviceEnabled();
                    this.saveStatusNotify = this.getStatusNotify();
                    this.setStatusNotify(1);
                    this.bLiveWeight = false;
                    m_log.debug("directIO: resetting.");
                    this.reset();
                    try {
                        this.objStatus.wait(2L * (long)this.nTimeout);
                    }
                    catch (InterruptedException ie) {
                        m_log.error("directIO: Interrupted. ", (Throwable)ie);
                    }
                    buf = "OK".getBytes();
                    break;
                }
            }
            case 22: {
                m_log.debug("directIO: DIO_SCALE_ENABLE3BYTESTATUS");
                Object object2 = this.objStatus;
                synchronized (object2) {
                    this.port.sendData(enable3ByteStatusCmd, enable3ByteStatusCmd.length);
                    try {
                        this.objStatus.wait(2L * (long)this.nTimeout);
                    }
                    catch (InterruptedException ie) {
                        m_log.error("directIO: Interrupted. ", (Throwable)ie);
                    }
                    String sOut = String.format("Enable 3-byte status [0x%02X 0x%02X 0x%02X]", this.nStat1, this.nStat2, this.nStat3);
                    buf = sOut.getBytes();
                    break;
                }
            }
            case 23: {
                m_log.debug("directIO: DIO_SCALE_DISABLE3BYTESTATUS");
                Object object2 = this.objStatus;
                synchronized (object2) {
                    this.port.sendData(disable3ByteStatusCmd, disable3ByteStatusCmd.length);
                    try {
                        this.objStatus.wait(2L * (long)this.nTimeout);
                    }
                    catch (InterruptedException ie) {
                        m_log.error("directIO: Interrupted. ", (Throwable)ie);
                    }
                    String sOut = String.format("Disable 3-byte status[0x%02X 0x%02X]", this.nStat1, this.nStat2);
                    buf = sOut.getBytes();
                    break;
                }
            }
            case 24: {
                m_log.debug("directIO: DIO_SCALE_CONFIGURE");
                Object object2 = this.objStatus;
                synchronized (object2) {
                    if (data.length < 3) throw new DLSException(-2147483637, "Data array, invalid size");
                    this.configureScaleCmd[2] = (byte)data[0];
                    this.configureScaleCmd[3] = (byte)data[1];
                    this.configureScaleCmd[4] = (byte)data[2];
                    this.port.sendData(this.configureScaleCmd, this.configureScaleCmd.length);
                    this.port.sendData(statusRequestCmd, statusRequestCmd.length);
                    try {
                        this.objStatus.wait(2L * (long)this.nTimeout);
                    }
                    catch (InterruptedException ie) {
                        m_log.error("directIO: Interrupted. ", (Throwable)ie);
                    }
                    buf = new byte[]{this.nStat1, this.nStat2, this.nStat3};
                    break;
                }
            }
            case 25: {
                m_log.debug("directIO: DIO_SCALE_REPORT_CONFIG");
                this.reportConfiguration();
                if (this.dataBuf.length != 0) {
                    buf = new byte[]{this.dataBuf[3], this.dataBuf[4], this.dataBuf[5]};
                    break;
                }
                m_log.warn("dataBuf returned as empty");
                break;
            }
            case 41: {
                m_log.debug("directIO: DIO_DEV_PROTOCOL");
                buf = "USB".getBytes();
                break;
            }
            default: {
                throw new DLSException(-2147483637, "Invalid directio command received");
            }
        }
        if (buf.length != 0) {
            try {
                ByteArrayOutputStream oBs = (ByteArrayOutputStream)object;
                oBs.reset();
                oBs.write(buf);
            }
            catch (Exception e) {
                m_log.error("Unable to return data to DIO caller - Are you passing in a ByteArrayOuputStream object? ", (Throwable)e);
                throw new DLSException(-2147483637, "Need a ByteArrayOutStream object to return data");
            }
        }
        m_log.trace("directIO (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable() throws DLSException {
        m_log.trace("disable (in)");
        Object object = this.objStatus;
        synchronized (object) {
            this.port.stopLiveWeight();
            this.bLiveWeight = false;
        }
        this.setState(DLSState.DISABLED);
        m_log.trace("disable (out)");
    }

    @Override
    public boolean doHealthCheck() {
        m_log.trace("doHealthCheck (in)");
        boolean alive = this.isAlive();
        m_log.trace("doHealthCheck (out)");
        return alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSelfTest() {
        m_log.trace("doSelfTest (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.warn("doSelfTest: Firmware update in progress.");
            m_log.trace("doSelfTest (out)");
            return;
        }
        Object object = this.statusResp;
        synchronized (object) {
            this.port.sendData(performSelfTestCmd, performSelfTestCmd.length);
            try {
                this.statusResp.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                m_log.error("isAlive: Interrupted. ", (Throwable)ie);
            }
        }
        m_log.trace("doSelfTest (out)");
    }

    @Override
    public void enable() throws DLSException {
        m_log.trace("enable (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.warn("enable: Firmware update in progress.");
            m_log.trace("enable (out)");
            return;
        }
        this.setState(DLSState.ENABLED);
        if (this.getStatusNotify() == 2) {
            m_log.trace("enable: SCAL_SN_ENABLED ");
            if (this.bLiveWeight) {
                m_log.trace("enable (out): bLiveWeight = true");
                return;
            }
            this.bLiveWeight = this.getMetricMode() ? this.port.startLiveWeight(metricWeightCmd, metricWeightCmd.length, this.getPollRate()) : this.port.startLiveWeight(englishWeightCmd, englishWeightCmd.length, this.getPollRate());
        }
        m_log.trace("enable (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void enable3ByteStatus() {
        m_log.trace("enable3ByteStatus (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.warn("enable3ByteStatus: Firmware update in progress.");
            m_log.trace("enable3ByteStatus (out)");
            return;
        }
        try {
            Object object = this.statusResp;
            synchronized (object) {
                this.port.sendData(enable3ByteStatusCmd, enable3ByteStatusCmd.length);
                this.statusResp.wait(2000L);
            }
        }
        catch (InterruptedException e) {
            m_log.error("enable3ByteStatus: Interrupted. ", (Throwable)e);
        }
        m_log.trace("enable3ByteStatus (out)");
    }

    protected void fireWeightEvent(int nResp, byte[] inBuf) {
        int digits = 4;
        if ((nResp & 0x200) == 512 || (nResp & 0x100) == 256) {
            digits = 5;
        }
        StringBuilder oSb = new StringBuilder();
        for (int i = 0; i < digits; ++i) {
            oSb.append(inBuf[i + 3]);
        }
        int nWeight = Integer.parseInt(oSb.toString());
        if (digits == 4) {
            nWeight *= 10;
        }
        this.fireWeightReceivedEvent(nWeight);
    }

    @Override
    public HashMap<String, Object> getStatistics() throws DLSException {
        m_log.trace("getStatistics (in)");
        HashMap<String, Object> table = new HashMap<String, Object>();
        String put = table.put("DeviceCategory", "Scale");
        put = table.put("GoodWeightReadCount", "NA");
        put = table.put("Interface", "USB");
        this.statistics = table;
        m_log.trace("getStatistics (out)");
        return table;
    }

    @Override
    public boolean hasStatisticsReporting() {
        boolean stats = this.scaleConfig.getCanAcceptStatisticsCmd();
        return stats;
    }

    @Override
    protected void internalClaim() {
        m_log.trace("internalClaim (in)");
        if (File.separatorChar == '\\' && this.sdw == null) {
            m_log.debug("internalClaim: Starting DevWatcher");
            this.sdw = new DevWatcher(this);
            m_log.debug("internalClaim: SDW:" + this.sdw + " Hash Code:" + this.sdw.hashCode());
            this.monitor = new Thread(this.sdw);
            this.monitor.start();
        }
        m_log.trace("internalClaim (out)");
    }

    @Override
    protected void internalRelease() {
        m_log.trace("internalRelease (in)");
        if (this.sdw != null) {
            m_log.debug("Killing DevWatcher");
            this.sdw.CloseWindow();
            try {
                this.monitor.join(1000L);
            }
            catch (InterruptedException ex) {
                m_log.error("internalRelease: Interrupted. ", (Throwable)ex);
            }
            this.monitor = null;
            this.sdw = null;
        }
        m_log.trace("internalRelease (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAlive() {
        m_log.trace("isAlive (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.warn("isAlive: Firmware update in progress.");
            m_log.trace("isAlive (out): false");
            return false;
        }
        boolean bRc = true;
        Object object = this.statusResp;
        synchronized (object) {
            this.bDeviceReady = false;
            this.port.sendData(statusRequestCmd, statusRequestCmd.length);
            try {
                this.statusResp.wait(this.nTimeout);
                bRc = this.bDeviceReady;
            }
            catch (InterruptedException ie) {
                m_log.error("isAlive: Interrupted. ", (Throwable)ie);
            }
        }
        m_log.trace("isAlive (out): " + Boolean.toString(bRc));
        return bRc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataReceived(byte[] inBuf, int len) {
        m_log.trace("onDataReceived (in): " + Integer.toString(len));
        if (inBuf == null || len == 0) {
            m_log.error("onDataReceived called with zero length data packet");
            m_log.trace("onDataReceived (out)");
            return;
        }
        m_log.debug("onDataReceived: inBuf = " + new String(inBuf));
        int nResp = 0;
        String rawBytes = FunctionLib.byteArrayToString(inBuf);
        m_log.debug("# bytes received" + rawBytes);
        Object object = this.objStatus;
        synchronized (object) {
            nResp |= inBuf[0];
            nResp |= inBuf[1] << 8;
            nResp |= inBuf[2] << 16;
            this.nStat1 = inBuf[0];
            this.nStat2 = inBuf[1];
            this.nStat3 = inBuf[2];
            if (inBuf[0] == -1 && inBuf[1] == -1 && inBuf[2] == -1) {
                m_log.debug("onDataReceived: got special message");
                try {
                    this.disable();
                    this.close();
                    this.open(this.getLogicalName());
                    this.enable();
                }
                catch (DLSException ex) {
                    m_log.error("onDataReceived: Exception. ", (Throwable)ex);
                }
                m_log.trace("onDataReceived (out)");
                return;
            }
            if (this.bLiveWeight && !this.bGetWeight) {
                int nCurStatus = 0;
                int nCurWeight = 0;
                if ((nResp & 0x80) == 128) {
                    nCurStatus = 15;
                } else if ((nResp & 0x20000) == 131072) {
                    nCurStatus = 16;
                } else if ((nResp & 0x40000) == 262144) {
                    nCurStatus = 14;
                } else if ((nResp & 0x400) == 1024) {
                    nCurStatus = 12;
                } else if ((nResp & 0x80000) == 524288) {
                    nCurStatus = 13;
                } else {
                    nCurStatus = 11;
                    int digits = 4;
                    if ((nResp & 0x200) == 512 || (nResp & 0x100) == 256) {
                        digits = 5;
                    }
                    StringBuilder oSb = new StringBuilder();
                    for (int i = 0; i < digits; ++i) {
                        oSb.append(inBuf[i + 3]);
                    }
                    nCurWeight = Integer.parseInt(oSb.toString());
                    if (digits == 4) {
                        nCurWeight *= 10;
                    }
                }
                if (nCurStatus != this.getStatusValue() || nCurWeight != this.getLiveWeight() && nCurStatus == 11) {
                    this.setStatusValue(nCurStatus);
                    if (nCurStatus == 11 || nCurStatus == 13) {
                        this.setLiveWeight(nCurWeight);
                    }
                    if (this.bLiveWeight) {
                        this.onStatusUpdate(nCurStatus);
                    }
                }
                m_log.debug("onDataReceived: Live weight = " + String.format("%.3f", Float.valueOf((float)nCurWeight / 1000.0f)));
                m_log.trace("onDataReceived (out)");
                return;
            }
            this.objStatus.notifyAll();
        }
        if ((nResp & 0x80) == 128) {
            object = this.statusResp;
            synchronized (object) {
                this.bDeviceReady = false;
                this.statusResp.notifyAll();
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        object = this.statusResp;
        synchronized (object) {
            this.bDeviceReady = true;
            this.statusResp.notifyAll();
        }
        if ((nResp & 0x10000) == 65536) {
            object = this.updateResp;
            synchronized (object) {
                this.dataBuf = Arrays.copyOf(inBuf, inBuf.length);
                this.updateResp.notifyAll();
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        if ((nResp & 2) == 2) {
            object = this.reportResp;
            synchronized (object) {
                this.dataBuf = Arrays.copyOf(inBuf, inBuf.length);
                this.reportResp.notifyAll();
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        if (this.bDioCommand) {
            this.bDioCommand = false;
            m_log.trace("onDataReceived (out)");
            return;
        }
        if ((nResp & 0x40) == 64) {
            m_log.error("onDataReceived: RESP_CMD_ERROR");
            this.fireDeviceErrorEvent(-100);
        } else if ((nResp & 0x800) == 2048) {
            m_log.error("onDataReceived: RESP_DATA_ERROR");
            this.fireDeviceErrorEvent(-102);
        } else if ((nResp & 0x1000) == 4096) {
            m_log.error("onDataReceived: RESP_READ_ERROR");
            this.fireDeviceErrorEvent(-103);
        } else if ((nResp & 0x2000) == 8192) {
            m_log.error("onDataReceived: RESP_NO_DISPLAY");
            this.fireDeviceErrorEvent(-104);
        } else if ((nResp & 0x4000) == 16384) {
            m_log.error("onDataReceived: RESP_HARDWARE_ERROR");
            this.fireDeviceErrorEvent(-105);
        } else if ((nResp & 0x8000) == 32768) {
            m_log.error("onDataReceived: RESP_CMD_REJECT");
            this.fireDeviceErrorEvent(-106);
        } else if ((nResp & 0x40000) == 262144) {
            m_log.error("onDataReceived: RESP_OVER_CAPACITY");
            this.fireDeviceErrorEvent(-107);
        } else if ((nResp & 0x20000) == 131072) {
            m_log.error("onDataReceived: RESP_UNDER_ZERO");
            this.fireDeviceErrorEvent(-118);
        } else if ((nResp & 0x100000) == 0x100000) {
            m_log.error("onDataReceived: RESP_REQUIRES_ZEROING");
            this.fireDeviceErrorEvent(-108);
        } else if ((nResp & 0x200000) == 0x200000) {
            m_log.error("onDataReceived: RESP_SCALE_WARMUP");
            this.fireDeviceErrorEvent(-109);
        } else if ((nResp & 0x400000) == 0x400000) {
            m_log.error("onDataReceived: RESP_DUPLICATE_WEIGHT");
            this.fireDeviceErrorEvent(-110);
        } else if ((nResp & 0x80000) == 524288) {
            if (this.bZeroValid) {
                this.fireWeightEvent(nResp, inBuf);
            } else {
                m_log.error("onDataReceived: RESP_NO_WEIGHT");
                this.fireDeviceErrorEvent(-117);
            }
        } else if ((nResp & 0x400) == 1024) {
            m_log.error("onDataReceived: RESP_NO_WEIGHT");
            this.fireDeviceErrorEvent(-101);
        } else {
            this.fireWeightEvent(nResp, inBuf);
        }
        this.bGetWeight = false;
        m_log.trace("onDataReceived (out)");
    }

    @Override
    public void onDeviceAdded() {
    }

    @Override
    public void onDeviceArrival() {
        m_log.trace("onDeviceArrival (in)");
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            m_log.error("onDeviceArrival: Interrupted. ", (Throwable)ex);
        }
        this.setStatusNotify(this.saveStatusNotify);
        this.bLiveWeight = this.bSaveLiveWeight;
        if (this.getStatusNotify() == 2) {
            if (DLSJposConst.updateInProgress) {
                m_log.warn("onDeviceArrival: Update in progress.");
                m_log.trace("onDeviceArrival (out)");
                return;
            }
            if (this.bSaveLiveWeight) {
                m_log.debug("onDeviceArrival: Restarting live weight.");
                this.bLiveWeight = this.getMetricMode() ? this.port.startLiveWeight(metricWeightCmd, metricWeightCmd.length, this.getPollRate()) : this.port.startLiveWeight(englishWeightCmd, englishWeightCmd.length, this.getPollRate());
            }
        }
        m_log.trace("onDeviceArrival (out)");
    }

    @Override
    public void onDeviceReattached() {
        m_log.trace("onDeviceReattached (in)");
        if (this.bReattachPending) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                m_log.error("onDeviceReattached: Interrupted. ", (Throwable)ex);
            }
            this.bReattachPending = true;
            this.port.openPort();
            try {
                if (this.bSaveDeviceEnabled) {
                    m_log.trace("onDeviceReattached: Trying to enable.");
                    this.port.sendData(enable3ByteStatusCmd, enable3ByteStatusCmd.length);
                    this.enable();
                }
            }
            catch (DLSException e) {
                m_log.error("onDeviceReattached: Device reattached exception: ", (Throwable)e);
            }
            this.fireDeviceErrorEvent(-120);
        }
        m_log.trace("onDeviceReattached (out)");
    }

    @Override
    public void onDeviceRemoved() {
        boolean closed;
        if (!this.bReattachPending) {
            this.port.closePort();
        }
        if (!(closed = this.port.closePort())) {
            m_log.warn("onDeviceRemoved: Failed to close port.");
        }
        this.fireDeviceErrorEvent(-116);
    }

    @Override
    public void onStatusUpdate(int nStatus) {
        m_log.trace("onStatusUpdate (in)");
        this.fireDeviceStatusEvent(nStatus);
        switch (nStatus) {
            case 2004: {
                m_log.trace("onStatusUpdate: JPOS_SUE_POWER_OFF_OFFLINE.");
                this.onDeviceRemoved();
                break;
            }
            case 2001: {
                m_log.trace("onStatusUpdate: JPOS_SUE_POWER_ONLINE.");
                this.onDeviceReattached();
            }
        }
        m_log.trace("onStatusUpdate (out)");
    }

    @Override
    public void readEnglishWeight() throws DLSException {
        if (DLSJposConst.updateInProgress) {
            m_log.warn("readEnglishWeight: Firmware update in progress.");
            m_log.trace("readEnglishWeight (out)");
            return;
        }
        this.bGetWeight = true;
        this.port.sendData(englishWeightCmd, englishWeightCmd.length);
    }

    @Override
    public void readMetricWeight() throws DLSException {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        this.bGetWeight = true;
        this.port.sendData(metricWeightCmd, metricWeightCmd.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readStatusWeight() throws DLSException {
        m_log.trace("readStatusWeight (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.warn("readStatusWeight: Firmware update in progress.");
            m_log.trace("readStatusWeight (out)");
            return;
        }
        if (!this.isLiveWeight()) {
            m_log.warn("readStatusWeight: isLiveWeight returned false.");
            m_log.trace("readStatusWeight (out)");
            return;
        }
        int nCurStatus = 0;
        int nCurWeight = 0;
        Object object = this.objStatus;
        synchronized (object) {
            this.nDevLiveWeight = -1;
            this.nLiveResp = 0;
            if (this.getMetricMode()) {
                this.port.sendData(metricWeightCmd, metricWeightCmd.length);
            } else {
                this.port.sendData(englishWeightCmd, englishWeightCmd.length);
            }
            try {
                this.objStatus.wait(1000L);
            }
            catch (InterruptedException e) {
                throw new DLSException(-2147483640, "readStatusWeight interrupted.");
            }
            if (!this.isLiveWeight()) {
                m_log.warn("readStatusWeight: isLiveWeight returned false.");
                m_log.trace("readStatusWeight (out)");
                return;
            }
            if (this.nDevLiveWeight < 0) {
                throw new DLSException(-2147483640, "readStatusWeight timeout");
            }
            nCurWeight = this.nDevLiveWeight;
            nCurStatus = (this.nLiveResp & 0x80) == 128 ? 15 : ((this.nLiveResp & 0x400) == 1024 ? 12 : ((this.nLiveResp & 0x20000) == 131072 ? 16 : ((this.nLiveResp & 0x40000) == 262144 ? 14 : ((this.nLiveResp & 0x80000) == 524288 ? 13 : 11))));
        }
        if (nCurStatus != this.getStatusValue() || nCurWeight != this.getLiveWeight() && nCurStatus == 11) {
            this.setStatusValue(nCurStatus);
            if (nCurStatus == 11 || nCurStatus == 13) {
                this.setLiveWeight(nCurWeight);
            }
            if (nCurStatus == 12) {
                this.setLiveWeight(nCurWeight);
            }
            if (this.isLiveWeight()) {
                this.onStatusUpdate(nCurStatus);
            }
        }
        m_log.trace("readStatusWeight (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportConfiguration() throws DLSException {
        m_log.trace("reportConfiguration (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.warn("reportConfiguration: Firmware update in progress.");
            m_log.trace("reportConfiguration (out)");
            return;
        }
        Object object = this.reportResp;
        synchronized (object) {
            this.dataBuf = EMPTY_BYTE_ARRAY;
            this.port.sendData(reportScaleConfigCmd, reportScaleConfigCmd.length);
            try {
                this.reportResp.wait(this.nTimeout);
                if (this.dataBuf.length != 0) {
                    DLSScaleConfig sConfig = new DLSScaleConfig(this.dataBuf);
                    sConfig.setZeroValid(this.scaleConfig.getZeroValid());
                    this.bZeroValid = this.scaleConfig.getZeroValid();
                    m_log.info(sConfig.toString());
                }
            }
            catch (InterruptedException e) {
                m_log.error("reportConfiguration: Interrupted. ", (Throwable)e);
            }
        }
        m_log.trace("reportConfiguration (out)");
    }

    @Override
    public void reset() throws DLSException {
        m_log.trace("reset (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.warn("reset: Firmware update in progress.");
            m_log.trace("reset (out)");
            return;
        }
        this.bReattachPending = true;
        if (this.bLiveWeight) {
            this.port.stopLiveWeight();
        }
        this.port.sendData(resetCmd, resetCmd.length);
        m_log.trace("reset (out)");
    }

    @Override
    public int sendJoin() {
        return 0;
    }

    @Override
    @Deprecated
    public int sendReset() {
        return 0;
    }

    @Override
    public void setMetricMode(boolean bValue) {
        m_log.trace("setMetricMode (in): " + Boolean.toString(bValue));
        this.bMetricMode = bValue;
        this.scaleConfig.setMetricWeightMode(bValue);
        try {
            this.updateConfiguration();
        }
        catch (DLSException e) {
            m_log.error("setMetricMode: Exception. ", (Throwable)e);
        }
        m_log.trace("setMetricMode (out)");
    }

    @Override
    public void setStatusNotify(int nValue) {
        m_log.trace("setStatusNotify (in): " + Integer.toString(nValue));
        if (this.nStatusNotify != nValue) {
            this.port.stopLiveWeight();
            this.bLiveWeight = false;
        }
        this.nStatusNotify = nValue;
        m_log.trace("setStatusNotify (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfiguration() throws DLSException {
        m_log.trace("updateConfiguration (in)");
        m_log.info(" #---# displayRequired: ..... " + this.scaleConfig.getDisplayRequired());
        m_log.info(" #---# enforceZeroReturn: ... " + this.scaleConfig.getEnforceZeroReturn());
        m_log.info(" #---# fiveDigitWeight: ..... " + this.scaleConfig.getFiveDigitWeight());
        m_log.info(" #---# indicateZeroWithLED .. " + this.scaleConfig.getIndicateZeroWithLED());
        m_log.info(" #---# metricWeightMode ..... " + this.scaleConfig.getMetricWeightMode());
        m_log.info(" #---# operationMode ........ " + this.scaleConfig.getOperationMode());
        m_log.info(" #---# vibrationSensitivity . " + this.scaleConfig.getVibrationSensitivity());
        m_log.info(" #---# zeroValid ............ " + this.scaleConfig.getZeroValid());
        byte cfg0 = 0;
        byte cfg1 = 0;
        byte cfg2 = 0;
        if (this.scaleConfig.getOperationMode() != 0) {
            cfg0 = (byte)(cfg0 | 1);
        }
        if (this.scaleConfig.getDisplayRequired()) {
            cfg0 = (byte)(cfg0 | 4);
        }
        if (this.scaleConfig.getIndicateZeroWithLED()) {
            cfg0 = (byte)(cfg0 | 8);
        }
        if (this.scaleConfig.getMetricWeightMode()) {
            cfg0 = (byte)(cfg0 | 0x10);
        }
        if (this.scaleConfig.getEnforceZeroReturn()) {
            cfg0 = (byte)(cfg0 | 0x20);
        }
        if (this.scaleConfig.getVibrationSensitivity() < 4) {
            cfg0 = (byte)(cfg0 | this.scaleConfig.getVibrationSensitivity() << 6);
        }
        if (this.scaleConfig.getFiveDigitWeight()) {
            cfg1 = (byte)(cfg1 | 1);
        }
        this.configureScaleCmd[2] = cfg0;
        this.configureScaleCmd[3] = cfg1;
        this.configureScaleCmd[4] = cfg2;
        this.bZeroValid = this.scaleConfig.getZeroValid();
        if (DLSJposConst.updateInProgress) {
            m_log.warn("updateConfiguration: Firmware update in progress.");
            m_log.trace("updateConfiguration (out)");
            return;
        }
        Object object = this.updateResp;
        synchronized (object) {
            this.dataBuf = EMPTY_BYTE_ARRAY;
            this.port.sendData(this.configureScaleCmd, this.configureScaleCmd.length);
            try {
                this.updateResp.wait(2000L);
                if (this.dataBuf.length != 0) {
                    this.waitForReady();
                }
            }
            catch (InterruptedException e) {
                m_log.error("updateConfiguration: Interrupted. ", (Throwable)e);
            }
        }
        m_log.trace("updateConfiguration (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForReady() {
        int loops = 50;
        long lTimeout = 500L;
        this.bDeviceReady = false;
        if (DLSJposConst.updateInProgress) {
            m_log.warn("waitForReady: Firmware update in progress.");
            m_log.trace("waitForReady (out)");
            return;
        }
        while (loops-- > 0 && !this.bDeviceReady) {
            try {
                Object object = this.statusResp;
                synchronized (object) {
                    this.port.sendData(statusRequestCmd, statusRequestCmd.length);
                    this.statusResp.wait(lTimeout);
                }
            }
            catch (InterruptedException e) {
                m_log.error("waitForReady: Interrupted. ", (Throwable)e);
            }
        }
    }

    @Override
    public void zeroScale() throws DLSException {
        if (DLSJposConst.updateInProgress) {
            m_log.warn("zeroScale: Firmware update in progress.");
            m_log.trace("zeroScale (out)");
            return;
        }
        this.port.sendData(zeroScaleCmd, zeroScaleCmd.length);
    }
}

