/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.interpretation;

import com.dls.jpos.common.Branding;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScannerConfig;
import com.dls.jpos.common.DLSState;
import com.dls.jpos.common.DevWatcher;
import com.dls.jpos.common.FunctionLib;
import com.dls.jpos.common.LabelParser;
import com.dls.jpos.common.LabelRow;
import com.dls.jpos.interpretation.DLSScanner;
import com.dls.jpos.transport.DLSUsbWin32;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSUSBScanner
extends DLSScanner {
    private static final byte[] enableCmd = new byte[]{17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] disableCmd = new byte[]{18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] resetCmd = new byte[]{0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] statusCmd = new byte[]{0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] reportConfigCmd = new byte[]{33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] configCmd = new byte[]{32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] reportConfig2LabelCmd = new byte[]{52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] config2LabelCmd = new byte[]{35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] enableBeepCmd = new byte[]{20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] disableBeepCmd = new byte[]{24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] doSelfTestCmd = new byte[]{0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] directIOCmd = new byte[]{48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int identificationCmd = 1;
    private static final int healthCmd = 2;
    private static final int statisticsCmd = 3;
    private static final byte beepCmd = 4;
    private static final byte nofBeepCmd = 6;
    private static final byte errorBeepCmd = 5;
    private static final byte[] cellPhoneModeECOMMEnter = new byte[]{48, 0, 112, 1, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] cellPhoneModeECOMMExit = new byte[]{48, 0, 112, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] cellPhoneModeScannerEnter = new byte[]{48, 0, 113, 1, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] cellPhoneModeScannerExit = new byte[]{48, 0, 113, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] getNumberStats = new byte[]{48, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] getStat = new byte[]{48, 0, 116, 1, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] getStatN = new byte[]{48, 0, 116, 2, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] getLastEvent = new byte[]{48, 0, 116, 3, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] clearEventLog = new byte[]{48, 0, 116, 4, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] statusRequestCmd = new byte[]{0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] writeConfigInt = new byte[]{48, 0, 116, 5, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] readConfigInt = new byte[]{48, 0, 116, 6, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] writeConfigNonInt = new byte[]{48, 0, 116, 7, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] readConfigNonInt = new byte[]{48, 0, 116, 8, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] queryConfig = new byte[]{48, 0, 116, 9, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] commitConfig = new byte[]{48, 0, 116, 5, 127, -3, 1, 0, 0, 0, 0};
    private static final int ACTION_TAG_DELAY = 4000;
    private static final int RESET_TIMEOUT = 15000;
    private static final byte[] getScaleSentryStatus = new byte[]{48, 0, 114, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] clearScaleSentryStatus = new byte[]{48, 0, 115, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] extVideoStreamOn = new byte[]{48, 0, 120, 1, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] extVideoStreamOff = new byte[]{48, 0, 120, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] extVideoStreamStatus = new byte[]{48, 0, 120, 2, 0, 0, 0, 0, 0, 0, 0};
    private boolean bLocalAlive = false;
    private boolean bRaiseBusy = true;
    private static final int RESP_FIRMWARE_FLASH = 1;
    private static final int RESP_CONFIG_DATA = 2;
    private static final int RESP_EANJANCONFIG_DATA = 4;
    private static final int RESP_HARDWARE_ERROR = 32;
    private static final int RESP_DIO_DATA = 64;
    private static final int RESP_NOT_READY = 128;
    private static final int RESP_ALIVE = 256;
    private static final int RESP_ENABLED = 512;
    private static final int RESP_CHECKDIGIT_ERROR = 1024;
    private static final int RESP_CMD_REJECT = 32768;
    private static final int RESP_CONFIG_SUCCESS = 65536;
    private static final int RESP_CONFIG_COERCED = 131072;
    private static final int RESP_EANJANCONFIG_SUCCESS = 262144;
    private static final int RESP_DIO_SUCCESS = 524288;
    private static final int RESP_DIO_NOT_ALLOWED = 0x100000;
    private static final int RESP_DIO_UNDEFINED = 0x200000;
    private final Object reportResp = new Object();
    private byte[] reportBuf = null;
    private final Object statusResp = new Object();
    private byte[] statusBuf = null;
    private final Object dioResp = new Object();
    private byte[] dioBuf = null;
    private boolean bInternalDIO = false;
    private boolean bInternalDIOSuccess = false;
    private boolean bReattachPending = true;
    private byte nStat1;
    private byte nStat2;
    private byte nStat3;
    private final Object objStatus = new Object();
    private boolean bStatMessageSent = false;
    private boolean notRun = true;
    private int nObjWaitTime;
    private int timeout;
    @Deprecated
    public int numBytes = 0;
    private DLSProperties options;
    private DevWatcher sdw = null;
    private Thread monitor = null;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Logger m_log = LogManager.getLogger(DLSUSBScanner.class);

    public DLSUSBScanner() {
        Branding oBr = Branding.getInstance();
        this.options = DLSProperties.getInstance();
        String sPre = oBr.getBrandingPrefix();
        String sProp = "com." + sPre + ".jpos.service.Scanner.objWaitTime";
        this.nObjWaitTime = this.options.get(sProp, 100);
        sProp = "com." + sPre + ".jpos.service.Scanner.timeout";
        this.timeout = this.options.get(sProp, 1100);
    }

    @Override
    public void enable() throws DLSException {
        m_log.trace("enable (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.warn("enable: Firmware update in progress.");
            m_log.trace("enable (out)");
            return;
        }
        this.locateDevice();
        byte[] buf = this.doInternalSend(enableCmd);
        if (buf.length == 0) {
            m_log.debug("enable: No response from scanner, retry enable");
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                m_log.error("enable: Thread interrupted, " + ex);
            }
            buf = this.doInternalSend(enableCmd);
        }
        if (buf.length != 0 && (buf[2] & 2) == 2) {
            this.setState(DLSState.ENABLED);
            m_log.trace("enable (out)");
            return;
        }
        throw new DLSException(-2147483641, "Failed to enable device.");
    }

    private void locateDevice() {
        String sDevice = "";
        if (File.separator.equals("\\")) {
            DLSUsbWin32 oPort = (DLSUsbWin32)this.port;
            int i = 0;
            while (sDevice.equals("")) {
                try {
                    sDevice = oPort.queryPath(oPort.getDeviceInfo());
                }
                catch (Exception ex) {
                    m_log.error("locateDevice: Exception, ", (Throwable)ex);
                    break;
                }
                if (++i < 100) continue;
                m_log.error("locateDevice: failed to locate device.");
                break;
            }
        }
        if (!sDevice.equals("")) {
            m_log.debug("locateDevice: located " + sDevice);
        }
    }

    @Override
    public void disable() throws DLSException {
        m_log.trace("disable (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.warn("disable: Firmware update in progress.");
            m_log.trace("disable (out)");
            return;
        }
        byte[] buf = this.doInternalSend(disableCmd);
        this.setState(DLSState.DISABLED);
        m_log.trace("enable (out)");
    }

    @Override
    public void reset() throws DLSException {
        m_log.trace("reset (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.warn("reset: Firmware update in progress.");
            m_log.trace("reset (out)");
            return;
        }
        this.bReattachPending = true;
        this.port.sendData(resetCmd, resetCmd.length);
        m_log.trace("reset (out)");
    }

    @Override
    public void setFirmwareBaudRate() {
    }

    @Override
    public void restoreBaudRate() {
    }

    @Override
    public int sendJoin() {
        return 0;
    }

    @Override
    @Deprecated
    public int sendReset() {
        return 0;
    }

    @Override
    public void enableBeep() {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        this.port.sendData(enableBeepCmd, enableBeepCmd.length);
    }

    @Override
    public void disableBeep() {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        this.port.sendData(disableBeepCmd, disableBeepCmd.length);
    }

    @Override
    public void doSelfTest() {
        if (DLSJposConst.updateInProgress) {
            return;
        }
        this.port.sendData(doSelfTestCmd, doSelfTestCmd.length);
    }

    @Override
    public int sendRecord(String sRecord) {
        return 255;
    }

    protected byte[] doInternalDirectIO(byte cmd) {
        return this.doInternalDirectIO(cmd, this.nObjWaitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doInternalDirectIO(byte cmd, int timeOut) {
        byte[] buf = EMPTY_BYTE_ARRAY;
        if (DLSJposConst.updateInProgress) {
            return buf;
        }
        try {
            ByteArrayOutputStream bStream = new ByteArrayOutputStream();
            Object object = this.dioResp;
            synchronized (object) {
                this.bInternalDIO = true;
                this.directIOCmd[1] = 0;
                this.directIOCmd[2] = cmd;
                this.dioBuf = EMPTY_BYTE_ARRAY;
                this.port.sendData(this.directIOCmd, this.directIOCmd.length);
                try {
                    do {
                        this.bInternalDIO = true;
                        this.dioBuf = EMPTY_BYTE_ARRAY;
                        this.dioResp.wait(timeOut);
                        if (this.dioBuf.length == 0) continue;
                        bStream.write(this.dioBuf, 5, this.dioBuf.length - 6);
                    } while (this.dioBuf.length != 0);
                }
                catch (InterruptedException ie) {
                    m_log.error("doInternalDirectIO: Interrupted. ", (Throwable)ie);
                }
            }
            buf = bStream.toByteArray();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            m_log.error("doInternalDirectIO: Exception. ", (Throwable)e);
        }
        this.bInternalDIO = false;
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doInternalSend(byte[] cmd) {
        byte[] buf = EMPTY_BYTE_ARRAY;
        if (DLSJposConst.updateInProgress) {
            return buf;
        }
        try {
            ByteArrayOutputStream bStream = new ByteArrayOutputStream();
            Object object = this.statusResp;
            synchronized (object) {
                this.statusBuf = EMPTY_BYTE_ARRAY;
                this.port.sendData(cmd, cmd.length);
                try {
                    do {
                        this.statusBuf = EMPTY_BYTE_ARRAY;
                        this.statusResp.wait(this.nObjWaitTime);
                        if (this.statusBuf.length == 0) continue;
                        bStream.write(this.statusBuf, 0, this.statusBuf.length);
                    } while (this.statusBuf.length != 0);
                }
                catch (InterruptedException ie) {
                    m_log.error("doInternalSend: Interrupted. ", (Throwable)ie);
                }
            }
            buf = bStream.toByteArray();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            m_log.error("doInternalSend: Exception: ", (Throwable)e);
        }
        this.bInternalDIO = false;
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doInternalMultiByteDirectIO(byte[] cmd) {
        long start = System.currentTimeMillis();
        long end = 0L;
        m_log.trace("doInternalMultiByteDirectIO (in): " + new String(cmd));
        byte[] buf = EMPTY_BYTE_ARRAY;
        if (DLSJposConst.updateInProgress) {
            end = System.currentTimeMillis();
            m_log.debug("FWBusy() doInternalMultiByteDirectIO for: " + (end - start) + " milliseconds");
            m_log.trace("doInternalMultiByteDirectIO (out)");
            return buf;
        }
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        Object object = this.dioResp;
        synchronized (object) {
            this.bInternalDIO = true;
            this.dioBuf = EMPTY_BYTE_ARRAY;
            this.port.sendData(cmd, cmd.length);
            try {
                do {
                    this.bInternalDIO = true;
                    this.dioBuf = EMPTY_BYTE_ARRAY;
                    this.dioResp.wait(this.nObjWaitTime);
                    if (this.dioBuf.length <= 0) continue;
                    bStream.write(this.dioBuf, 0, this.dioBuf.length);
                } while (this.dioBuf.length > 0);
            }
            catch (InterruptedException ie) {
                m_log.error("doInternalMultiByteDirectIO: Interrupted. ", (Throwable)ie);
            }
        }
        buf = bStream.toByteArray();
        this.bInternalDIO = false;
        end = System.currentTimeMillis();
        m_log.debug("doInternalMultiByteDirectIO for: " + (end - start) + " milliseconds");
        m_log.trace("doInternalMultiByteDirectIO (out)");
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doInternalMultiByteDirectIODelayed(byte[] cmd) {
        byte[] buf = EMPTY_BYTE_ARRAY;
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        if (DLSJposConst.updateInProgress) {
            return buf;
        }
        try {
            Object object = this.dioResp;
            synchronized (object) {
                this.bInternalDIO = true;
                this.dioBuf = EMPTY_BYTE_ARRAY;
                this.port.sendData(cmd, cmd.length);
                Thread.sleep(1000L);
                try {
                    do {
                        this.bInternalDIO = true;
                        this.dioBuf = EMPTY_BYTE_ARRAY;
                        this.dioResp.wait(this.nObjWaitTime);
                        if (this.dioBuf.length == 0) continue;
                        bStream.write(this.dioBuf, 0, this.dioBuf.length);
                        buf = buf.length == 0 ? this.dioBuf : this.concat(buf, this.dioBuf);
                    } while (this.dioBuf.length != 0);
                }
                catch (InterruptedException ie) {
                    m_log.error("doInternalMultiByteDirectIODelayed: Interrupted. ", (Throwable)ie);
                }
            }
            if (buf.length == 0) {
                buf = bStream.toByteArray();
            }
        }
        catch (InterruptedException e) {
            m_log.error("doInternalMultiByteDirectIODelayed: Interrupted. ", (Throwable)e);
        }
        this.bInternalDIO = false;
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doInternalMultiByteDirectIOWithDelay(byte[] cmd) {
        byte[] buf = EMPTY_BYTE_ARRAY;
        if (DLSJposConst.updateInProgress) {
            return buf;
        }
        try {
            ByteArrayOutputStream bStream = new ByteArrayOutputStream();
            Object object = this.dioResp;
            synchronized (object) {
                this.bInternalDIO = true;
                this.dioBuf = EMPTY_BYTE_ARRAY;
                this.port.sendData(cmd, cmd.length);
                Thread.sleep(4000L);
                try {
                    do {
                        this.bInternalDIO = true;
                        this.dioBuf = EMPTY_BYTE_ARRAY;
                        this.dioResp.wait(this.nObjWaitTime);
                        if (this.dioBuf.length == 0) continue;
                        bStream.write(this.dioBuf, 0, this.dioBuf.length);
                    } while (this.dioBuf.length != 0);
                }
                catch (InterruptedException ie) {
                    m_log.error("doInternalMultiByteDirectIOWithDelay: Interrupted, ", (Throwable)ie);
                }
            }
            buf = bStream.toByteArray();
        }
        catch (InterruptedException e) {
            m_log.error("doInternalMultiByteDirectIOWithDelay: Interrupted. ", (Throwable)e);
        }
        this.bInternalDIO = false;
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doInternalMultiByteDirectIOSinglePacket(byte[] cmd) {
        byte[] buf = EMPTY_BYTE_ARRAY;
        if (DLSJposConst.updateInProgress) {
            return buf;
        }
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        Object object = this.dioResp;
        synchronized (object) {
            this.bInternalDIO = true;
            this.dioBuf = EMPTY_BYTE_ARRAY;
            this.port.sendData(cmd, cmd.length);
            try {
                this.dioResp.wait(this.timeout);
                if (this.dioBuf.length != 0) {
                    bStream.write(this.dioBuf, 0, this.dioBuf.length);
                }
            }
            catch (InterruptedException ie) {
                m_log.error("doInternalMultiByteDirectIOSinglePacket: Interrupted. ", (Throwable)ie);
            }
        }
        buf = bStream.toByteArray();
        this.bInternalDIO = false;
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doHealthCheck() throws DLSException {
        m_log.trace("doHealthCheck (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.warn("doHealthCheck: Firmware update in progress.");
            m_log.trace("doHealthCheck (out): true");
            return true;
        }
        boolean bRc = true;
        Object object = this.dioResp;
        synchronized (object) {
            this.dioBuf = this.doInternalDirectIO((byte)2);
            if (this.dioBuf.length > 0) {
                this.logHealthCheck(this.dioBuf);
            } else {
                m_log.error("Timeout on directio HealthCheck");
                bRc = false;
            }
        }
        m_log.trace("doHealthCheck (out): " + Boolean.toString(bRc));
        return bRc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAlive() {
        m_log.trace("isAlive (in)");
        boolean alive = false;
        Object object = this.objStatus;
        synchronized (object) {
            this.nStat1 = 0;
            this.nStat2 = 0;
            this.nStat3 = 0;
            this.port.sendData(statusCmd, statusCmd.length);
            try {
                this.objStatus.wait(this.nTimeout);
            }
            catch (InterruptedException ie) {
                m_log.error("isAlive wait interrupted: ", (Throwable)ie);
            }
            alive = this.nStat1 + this.nStat2 + this.nStat3 != 0;
        }
        m_log.trace("isAlive (out): " + Boolean.toString(alive));
        return alive;
    }

    public String dumpConfig(DLSScannerConfig sConfig, String sPrefix) {
        String sOut = "";
        sOut = sOut + sPrefix + " EnableUPCEAN: ................ " + sConfig.getEnableUPCEAN() + "\n";
        sOut = sOut + sPrefix + " EnableUPCD1toD5: ............. " + sConfig.getEnableUPCD1D5() + "\n";
        sOut = sOut + sPrefix + " EnableCode39: ................ " + sConfig.getEnableCode39() + "\n";
        sOut = sOut + sPrefix + " EnableInterleaved: ........... " + sConfig.getEnableInterleaved() + "\n";
        sOut = sOut + sPrefix + " EnableCodabar: ............... " + sConfig.getEnableCodabar() + "\n";
        sOut = sOut + sPrefix + " EnableCode93: ................ " + sConfig.getEnableCode93() + "\n";
        sOut = sOut + sPrefix + " EnableCode128: ............... " + sConfig.getEnableCode128() + "\n";
        sOut = sOut + sPrefix + " EnableUCCEAN128: ............. " + sConfig.getEnableUCCEAN128() + "\n";
        sOut = sOut + sPrefix + " Enable2DigitSups: ............ " + sConfig.getEnable2DigitSups() + "\n";
        sOut = sOut + sPrefix + " Enable5DigitSups: ............ " + sConfig.getEnable5DigitSups() + "\n";
        sOut = sOut + sPrefix + " EnableCode128Sups: ........... " + sConfig.getEnableCode128Sups() + "\n";
        sOut = sOut + sPrefix + " EnableUPCACheckDigit: ........ " + sConfig.getEnableUPCACheckDigit() + "\n";
        sOut = sOut + sPrefix + " EnableUPCECheckDigit: ........ " + sConfig.getEnableUPCECheckDigit() + "\n";
        sOut = sOut + sPrefix + " EnableCode39CheckDigit: ...... " + sConfig.getEnableCode39CheckDigit() + "\n";
        sOut = sOut + sPrefix + " EnableItfCheckDigit: ......... " + sConfig.getEnableITFCheckDigit() + "\n";
        sOut = sOut + sPrefix + " EnableEANJAN2LabelDecode: .... " + sConfig.getEnableEANJAN2LabelDecode() + "\n";
        sOut = sOut + sPrefix + " EnableUPCAtoEAN13Expansion: .. " + sConfig.getEnableUPCAtoEAN13Expansion() + "\n";
        sOut = sOut + sPrefix + " EnableUPCEtoUPCAExpansion: ... " + sConfig.getEnableUPCEtoUPCAExpansion() + "\n";
        sOut = sOut + sPrefix + " Enable4DigitPriceCheckDigit: . " + sConfig.getEnable4DigitPriceCheckDigit() + "\n";
        sOut = sOut + sPrefix + " Enable5DigitPriceCheckDigit: . " + sConfig.getEnable5DigitPriceCheckDigit() + "\n";
        sOut = sOut + sPrefix + " EnableGoodReadBeep: .......... " + sConfig.getEnableGoodReadBeep() + "\n";
        sOut = sOut + sPrefix + " BeepVolume: .................. " + sConfig.getBeepVolume() + "\n";
        sOut = sOut + sPrefix + " BeepFrequency: ............... " + sConfig.getBeepFrequency() + "\n";
        sOut = sOut + sPrefix + " BeepDuration: ................ " + sConfig.getBeepDuration() + "\n";
        sOut = sOut + sPrefix + " MotorTimeout: ................ " + sConfig.getMotorTimeout() + "\n";
        sOut = sOut + sPrefix + " LaserTimeout: ................ " + sConfig.getLaserTimeout() + "\n";
        sOut = sOut + sPrefix + " DoubleReadTimeout: ........... " + sConfig.getDoubleReadTimeout() + "\n";
        sOut = sOut + sPrefix + " StoreLabelSecurityLevel: ..... " + sConfig.getStoreLabelSecurityLevel() + "\n";
        sOut = sOut + sPrefix + " ITFLength1: .................. " + sConfig.getItfLength1() + "\n";
        sOut = sOut + sPrefix + " ITFLength2: .................. " + sConfig.getItfLength2() + "\n";
        sOut = sOut + sPrefix + " Two Itfs specified: .......... " + sConfig.getTwoItfs() + "\n";
        sOut = sOut + sPrefix + " ITFisRange: .................. " + sConfig.getItfRange() + "\n";
        return sOut;
    }

    protected void logConfig(DLSScannerConfig sConfig, String strPrefix) {
        m_log.info(strPrefix + " EnableUPCEAN: ................ " + sConfig.getEnableUPCEAN());
        m_log.info(strPrefix + " EnableUPCD1toD5: ............. " + sConfig.getEnableUPCD1D5());
        m_log.info(strPrefix + " EnableCode39: ................ " + sConfig.getEnableCode39());
        m_log.info(strPrefix + " EnableInterleaved: ........... " + sConfig.getEnableInterleaved());
        m_log.info(strPrefix + " EnableCodabar: ............... " + sConfig.getEnableCodabar());
        m_log.info(strPrefix + " EnableCode93: ................ " + sConfig.getEnableCode93());
        m_log.info(strPrefix + " EnableCode128: ............... " + sConfig.getEnableCode128());
        m_log.info(strPrefix + " EnableUCCEAN128: ............. " + sConfig.getEnableUCCEAN128());
        m_log.info(strPrefix + " Enable2DigitSups: ............ " + sConfig.getEnable2DigitSups());
        m_log.info(strPrefix + " Enable5DigitSups: ............ " + sConfig.getEnable5DigitSups());
        m_log.info(strPrefix + " EnableCode128Sups: ........... " + sConfig.getEnableCode128Sups());
        m_log.info(strPrefix + " EnableUPCACheckDigit: ........ " + sConfig.getEnableUPCACheckDigit());
        m_log.info(strPrefix + " EnableUPCECheckDigit: ........ " + sConfig.getEnableUPCECheckDigit());
        m_log.info(strPrefix + " EnableCode39CheckDigit: ...... " + sConfig.getEnableCode39CheckDigit());
        m_log.info(strPrefix + " EnableItfCheckDigit: ......... " + sConfig.getEnableITFCheckDigit());
        m_log.info(strPrefix + " EnableEANJAN2LabelDecode: .... " + sConfig.getEnableEANJAN2LabelDecode());
        m_log.info(strPrefix + " EnableUPCAtoEAN13Expansion: .. " + sConfig.getEnableUPCAtoEAN13Expansion());
        m_log.info(strPrefix + " EnableUPCEtoEAN13Expansion: .. " + sConfig.getEnableUPCEtoEAN13Expansion());
        m_log.info(strPrefix + " EnableUPCEtoUPCAExpansion: ... " + sConfig.getEnableUPCEtoUPCAExpansion());
        m_log.info(strPrefix + " Enable4DigitPriceCheckDigit: . " + sConfig.getEnable4DigitPriceCheckDigit());
        m_log.info(strPrefix + " Enable5DigitPriceCheckDigit: . " + sConfig.getEnable5DigitPriceCheckDigit());
        m_log.info(strPrefix + " EnableGoodReadBeep: .......... " + sConfig.getEnableGoodReadBeep());
        m_log.info(strPrefix + " BeepVolume: .................. " + sConfig.getBeepVolume());
        m_log.info(strPrefix + " BeepFrequency: ............... " + sConfig.getBeepFrequency());
        m_log.info(strPrefix + " BeepDuration: ................ " + sConfig.getBeepDuration());
        m_log.info(strPrefix + " MotorTimeout: ................ " + sConfig.getMotorTimeout());
        m_log.info(strPrefix + " LaserTimeout: ................ " + sConfig.getLaserTimeout());
        m_log.info(strPrefix + " DoubleReadTimeout: ........... " + sConfig.getDoubleReadTimeout());
        m_log.info(strPrefix + " StoreLabelSecurityLevel: ..... " + sConfig.getStoreLabelSecurityLevel());
        m_log.info(strPrefix + " ITFLength1: .................. " + sConfig.getItfLength1());
        m_log.info(strPrefix + " ITFLength2: .................. " + sConfig.getItfLength2());
        m_log.info(strPrefix + " Two Itfs specified: .......... " + sConfig.getTwoItfs());
        m_log.info(strPrefix + " ITFisRange: .................. " + sConfig.getItfRange());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfiguration() throws DLSException {
        m_log.trace("updateConfiguration (in)");
        if (DLSJposConst.updateInProgress) {
            m_log.warn("updateConfiguration: Firmware update in progress.");
            m_log.trace("updateConfiguration (out)");
            return;
        }
        this.logConfig(this.scannerConfig, " #---#");
        byte cfg0 = 0;
        byte cfg1 = 0;
        byte cfg2 = 0;
        byte cfg3 = 0;
        int cfg4 = 0;
        int cfg5 = 0;
        int cfg6 = 0;
        int cfg7 = 0;
        int cfg8 = 0;
        if (this.scannerConfig.getEnableUPCEAN()) {
            cfg0 = (byte)(cfg0 | 1);
        }
        if (this.scannerConfig.getEnableUPCD1D5()) {
            cfg0 = (byte)(cfg0 | 2);
        }
        if (this.scannerConfig.getEnableCode39()) {
            cfg0 = (byte)(cfg0 | 4);
        }
        if (this.scannerConfig.getEnableInterleaved()) {
            cfg0 = (byte)(cfg0 | 8);
        }
        if (this.scannerConfig.getEnableCodabar()) {
            cfg0 = (byte)(cfg0 | 0x10);
        }
        if (this.scannerConfig.getEnableCode93()) {
            cfg0 = (byte)(cfg0 | 0x20);
        }
        if (this.scannerConfig.getEnableCode128()) {
            cfg0 = (byte)(cfg0 | 0x40);
        }
        if (this.scannerConfig.getEnableUCCEAN128()) {
            cfg0 = (byte)(cfg0 | 0x80);
        }
        if (this.scannerConfig.getEnable2DigitSups()) {
            cfg1 = (byte)(cfg1 | 1);
        }
        if (this.scannerConfig.getEnable5DigitSups()) {
            cfg1 = (byte)(cfg1 | 2);
        }
        if (this.scannerConfig.getEnableCode128Sups()) {
            cfg1 = (byte)(cfg1 | 4);
        }
        if (this.scannerConfig.getEnableUPCACheckDigit()) {
            cfg1 = (byte)(cfg1 | 8);
        }
        if (this.scannerConfig.getEnableUPCECheckDigit()) {
            cfg1 = (byte)(cfg1 | 0x10);
        }
        if (this.scannerConfig.getEnableCode39CheckDigit()) {
            cfg1 = (byte)(cfg1 | 0x20);
        }
        if (this.scannerConfig.getEnableITFCheckDigit()) {
            cfg1 = (byte)(cfg1 | 0x40);
        }
        if (this.scannerConfig.getEnableEANJAN2LabelDecode()) {
            cfg2 = (byte)(cfg2 | 1);
        }
        if (this.scannerConfig.getEnableUPCAtoEAN13Expansion()) {
            cfg2 = (byte)(cfg2 | 2);
        }
        if (this.scannerConfig.getEnableUPCEtoEAN13Expansion()) {
            cfg2 = (byte)(cfg2 | 4);
        }
        if (this.scannerConfig.getEnableUPCEtoUPCAExpansion()) {
            cfg2 = (byte)(cfg2 | 8);
        }
        if (this.scannerConfig.getEnable4DigitPriceCheckDigit()) {
            cfg2 = (byte)(cfg2 | 0x10);
        }
        if (this.scannerConfig.getEnable5DigitPriceCheckDigit()) {
            cfg2 = (byte)(cfg2 | 0x20);
        }
        if (this.scannerConfig.getEnableGoodReadBeep()) {
            cfg3 = (byte)(cfg3 | 1);
        }
        cfg3 = (byte)(cfg3 | this.scannerConfig.getBeepVolume() << 1);
        cfg3 = (byte)(cfg3 | this.scannerConfig.getBeepFrequency() << 3);
        cfg3 = (byte)(cfg3 | this.scannerConfig.getBeepDuration() << 5);
        cfg4 = (byte)(cfg4 | this.scannerConfig.getMotorTimeout());
        cfg4 = (byte)(cfg4 | this.scannerConfig.getLaserTimeout() << 3);
        cfg4 = (byte)(cfg4 | this.scannerConfig.getDoubleReadTimeout() << 5);
        cfg5 = (byte)(cfg5 | this.scannerConfig.getStoreLabelSecurityLevel());
        cfg6 = (byte)(cfg6 | this.scannerConfig.getItfLength1());
        if (this.scannerConfig.getTwoItfs()) {
            cfg6 = (byte)(cfg6 | 0x40);
        }
        if (this.scannerConfig.getItfRange()) {
            cfg6 = (byte)(cfg6 | 0x80);
        }
        cfg7 = (byte)(cfg7 | this.scannerConfig.getItfLength2());
        cfg8 = (byte)(cfg8 | this.scannerConfig.getLEDGoodReadDuration());
        if (this.scannerConfig.getEnableBarCodeProgramming()) {
            cfg8 = (byte)(cfg8 | 4);
        }
        if (this.scannerConfig.getEnableLaserOnOffSwitch()) {
            cfg8 = (byte)(cfg8 | 8);
        }
        if (this.scannerConfig.getEnableVolumeSwitch()) {
            cfg8 = (byte)(cfg8 | 0x10);
        }
        this.configCmd[2] = cfg0;
        this.configCmd[3] = cfg1;
        this.configCmd[4] = cfg2;
        this.configCmd[5] = cfg3;
        this.configCmd[6] = cfg4;
        this.configCmd[7] = cfg5;
        this.configCmd[8] = cfg6;
        this.configCmd[9] = cfg7;
        this.configCmd[10] = cfg8;
        Object object = this.statusResp;
        synchronized (object) {
            this.statusBuf = EMPTY_BYTE_ARRAY;
            this.port.sendData(this.configCmd, this.configCmd.length);
            try {
                this.statusResp.wait(2000L);
                if (this.statusBuf.length != 0) {
                    if ((this.statusBuf[3] & 1) == 1) {
                        m_log.info("Configuration Successful");
                    } else {
                        m_log.info("Configuration Failed.");
                    }
                }
            }
            catch (InterruptedException e) {
                m_log.error("updateConfiguration: Interrupted. ", (Throwable)e);
            }
        }
        m_log.trace("updateConfiguration (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DLSScannerConfig reportConfiguration() throws DLSException {
        m_log.trace("reportConfiguration (in)");
        DLSScannerConfig sConfig = new DLSScannerConfig();
        if (DLSJposConst.updateInProgress) {
            m_log.warn("reportConfiguration: Firmware update in progress.");
            m_log.trace("reportConfiguration (out)");
            return sConfig;
        }
        Object object = this.reportResp;
        synchronized (object) {
            this.reportBuf = EMPTY_BYTE_ARRAY;
            this.port.sendData(reportConfigCmd, reportConfigCmd.length);
            try {
                this.reportResp.wait(this.nTimeout);
                if (this.reportBuf.length != 0) {
                    byte cfg0 = 0;
                    byte cfg1 = 0;
                    byte cfg2 = 0;
                    byte cfg3 = 0;
                    byte cfg4 = 0;
                    byte cfg5 = 0;
                    byte cfg6 = 0;
                    byte cfg7 = 0;
                    byte cfg8 = 0;
                    cfg0 = this.reportBuf[4];
                    cfg1 = this.reportBuf[5];
                    cfg2 = this.reportBuf[6];
                    cfg3 = this.reportBuf[7];
                    cfg4 = this.reportBuf[8];
                    cfg5 = this.reportBuf[9];
                    cfg6 = this.reportBuf[10];
                    cfg7 = this.reportBuf[11];
                    cfg8 = this.reportBuf[12];
                    sConfig.setEnableUPCEAN((cfg0 & 1) == 1);
                    sConfig.setEnableUPCD1D5((cfg0 & 2) == 2);
                    sConfig.setEnableCode39((cfg0 & 4) == 4);
                    sConfig.setEnableInterleaved((cfg0 & 8) == 8);
                    sConfig.setEnableCodabar((cfg0 & 0x10) == 16);
                    sConfig.setEnableCode93((cfg0 & 0x20) == 32);
                    sConfig.setEnableCode128((cfg0 & 0x40) == 64);
                    sConfig.setEnableUCCEAN128((cfg0 & 0x80) == 128);
                    sConfig.setEnable2DigitSups((cfg1 & 1) == 1);
                    sConfig.setEnable5DigitSups((cfg1 & 2) == 2);
                    sConfig.setEnableCode128Sups((cfg1 & 4) == 4);
                    sConfig.setEnableUPCACheckDigit((cfg1 & 8) == 8);
                    sConfig.setEnableUPCECheckDigit((cfg1 & 0x10) == 16);
                    sConfig.setEnableCode39CheckDigit((cfg1 & 0x20) == 32);
                    sConfig.setEnableITFCheckDigit((cfg1 & 0x40) == 64);
                    sConfig.setEnableEANJAN2LabelDecode((cfg2 & 1) == 1);
                    sConfig.setEnableUPCAtoEAN13Expansion((cfg2 & 2) == 2);
                    sConfig.setEnableUPCEtoEAN13Expansion((cfg2 & 4) == 4);
                    sConfig.setEnableUPCEtoUPCAExpansion((cfg2 & 8) == 8);
                    sConfig.setEnable4DigitPriceCheckDigit((cfg2 & 0x10) == 16);
                    sConfig.setEnable5DigitPriceCheckDigit((cfg2 & 0x20) == 32);
                    sConfig.setEnableGoodReadBeep((cfg3 & 1) == 1);
                    sConfig.setBeepVolume((cfg3 & 6) >> 1);
                    sConfig.setBeepFrequency((cfg3 & 0x18) >> 3);
                    sConfig.setBeepDuration((cfg3 & 0x60) >> 5);
                    sConfig.setMotorTimeout(cfg4 & 7);
                    sConfig.setLaserTimeout((cfg4 & 0x18) >> 3);
                    sConfig.setDoubleReadTimeout((cfg4 & 0x60) >> 5);
                    sConfig.setStoreLabelSecurityLevel(cfg5 & 3);
                    sConfig.setItfLength1(cfg6 & 0x3F);
                    sConfig.setTwoItfs((cfg6 & 0x40) == 64);
                    sConfig.setItfRange((cfg6 & 0x80) == 128);
                    sConfig.setItfLength2(cfg7 & 0x3F);
                    sConfig.setLEDGoodReadDuration(cfg8 & 3);
                    sConfig.setEnableBarCodeProgramming((cfg8 & 4) == 4);
                    sConfig.setEnableLaserOnOffSwitch((cfg8 & 8) == 8);
                    sConfig.setEnableVolumeSwitch((cfg8 & 0x10) == 16);
                    this.logConfig(sConfig, " #+++#");
                }
            }
            catch (InterruptedException e) {
                m_log.error("reportConfiguration: Interrupted. ", (Throwable)e);
            }
        }
        m_log.trace("reportConfiguration (out)");
        return sConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void directIO(int command, int[] data, Object object) throws DLSException {
        long start;
        block126: {
            m_log.trace("directIO (in): " + Integer.toString(command));
            if (DLSJposConst.updateInProgress) {
                m_log.warn("directIO: Firmware update in progress.");
                return;
            }
            start = System.currentTimeMillis();
            byte[] buf = EMPTY_BYTE_ARRAY;
            String resultString = null;
            String fileName = null;
            boolean bCopyObjectToBuf = false;
            BufferedWriter output = null;
            try {
                switch (command) {
                    case 1: {
                        m_log.debug("DIO_SCANNER_RESET");
                        Object object2 = this.objStatus;
                        synchronized (object2) {
                            this.reset();
                            try {
                                this.objStatus.wait(2L * (long)this.nTimeout);
                            }
                            catch (InterruptedException ie) {
                                m_log.error("DIO_SCANNER_RESET wait interrupted: ", (Throwable)ie);
                            }
                            buf = new byte[]{this.nStat1, this.nStat2, this.nStat3};
                            break;
                        }
                    }
                    case 2: {
                        m_log.debug("DIO_SCANNER_ENABLE_BEEP");
                        Object object2 = this.objStatus;
                        synchronized (object2) {
                            this.enableBeep();
                            this.port.sendData(statusCmd, statusCmd.length);
                            try {
                                this.objStatus.wait(2L * (long)this.nTimeout);
                            }
                            catch (InterruptedException ie) {
                                m_log.error("DIO_SCANNER_ENABLE_BEEP wait interrupted: ", (Throwable)ie);
                            }
                            buf = new byte[]{this.nStat1, this.nStat2, this.nStat3};
                            int beeperEnabled = 16;
                            data[0] = (beeperEnabled & buf[0]) == beeperEnabled ? 0 : -1;
                            break;
                        }
                    }
                    case 3: {
                        m_log.debug("DIO_SCANNER_DISABLE_BEEP");
                        Object object2 = this.objStatus;
                        synchronized (object2) {
                            this.disableBeep();
                            this.port.sendData(statusCmd, statusCmd.length);
                            try {
                                this.objStatus.wait(2L * (long)this.nTimeout);
                            }
                            catch (InterruptedException ie) {
                                m_log.error("DIO_SCANNER_DISABLE_BEEP wait interrupted: ", (Throwable)ie);
                            }
                            buf = new byte[]{this.nStat1, this.nStat2, this.nStat3};
                        }
                        this.dioResults("DIO_SCANNER_DISABLE_BEEP", "sendData()", data, buf);
                        break;
                    }
                    case 377: {
                        m_log.debug("DIO_SCANNER_DISABLE");
                        buf = this.doInternalSend(disableCmd);
                        this.dioResults("DIO_SCANNER_DISABLE", "doInternalSend()", data, buf);
                        break;
                    }
                    case 378: {
                        m_log.debug("DIO_SCANNER_ENABLE");
                        buf = this.doInternalSend(enableCmd);
                        this.dioResults("DIO_SCANNER_ENABLE", "doInternalSend()", data, buf);
                        break;
                    }
                    case 4: {
                        m_log.debug("DIO_SCANNER_CONFIGURE");
                        if (data.length >= 9) {
                            this.configCmd[2] = (byte)data[0];
                            this.configCmd[3] = (byte)data[1];
                            this.configCmd[4] = (byte)data[2];
                            this.configCmd[5] = (byte)data[3];
                            this.configCmd[6] = (byte)data[4];
                            this.configCmd[7] = (byte)data[5];
                            this.configCmd[8] = (byte)data[6];
                            this.configCmd[9] = (byte)data[7];
                            this.configCmd[10] = (byte)data[8];
                            this.port.sendData(this.configCmd, this.configCmd.length);
                            this.nStat1 = 0;
                            this.bRaiseBusy = false;
                            do {
                                try {
                                    Thread.sleep(200L);
                                }
                                catch (InterruptedException e) {
                                    m_log.error("directIO: Interrupted. ", (Throwable)e);
                                }
                                this.reportConfiguration();
                            } while ((this.nStat1 & 0x80) != 0);
                        } else {
                            throw new DLSException(-2147483637, "Must provide 9 bytes of configuration data");
                        }
                        this.bRaiseBusy = true;
                        buf = new byte[]{this.nStat1, this.nStat2, this.nStat3};
                        this.dioResults("DIO_SCANNER_CONFIGURE", "reportConfiguration()", data, buf);
                        break;
                    }
                    case 5: {
                        m_log.debug("DIO_SCANNER_REPORT_CONFIG");
                        DLSScannerConfig oCfg = this.reportConfiguration();
                        if (this.reportBuf.length != 0) {
                            buf = new byte[]{this.reportBuf[4], this.reportBuf[5], this.reportBuf[6], this.reportBuf[7], this.reportBuf[8], this.reportBuf[9], this.reportBuf[10], this.reportBuf[11], this.reportBuf[12]};
                        } else {
                            m_log.warn("reportBuf returned as empty");
                        }
                        this.dioResults("DIO_SCANNER_REPORT_CONFIG", "reportConfiguration()", data, buf);
                        String sRpt = this.dumpConfig(oCfg, "");
                        buf = sRpt.getBytes();
                        break;
                    }
                    case 6: {
                        m_log.debug("DIO_SCANNER_CONFIG_2LABEL");
                        if (data.length >= 8) {
                            this.config2LabelCmd[2] = (byte)data[0];
                            this.config2LabelCmd[3] = (byte)data[1];
                            this.config2LabelCmd[4] = (byte)data[2];
                            this.config2LabelCmd[5] = (byte)data[3];
                            this.config2LabelCmd[6] = (byte)data[4];
                            this.config2LabelCmd[7] = (byte)data[5];
                            this.config2LabelCmd[8] = (byte)data[6];
                            this.config2LabelCmd[9] = (byte)data[7];
                            Object object3 = this.objStatus;
                            synchronized (object3) {
                                this.port.sendData(this.config2LabelCmd, this.config2LabelCmd.length);
                                try {
                                    this.objStatus.wait(2L * (long)this.nTimeout);
                                }
                                catch (InterruptedException ie) {
                                    m_log.error("DIO_SCANNER_CONFIG_2LABEL wait interrupted. ", (Throwable)ie);
                                }
                            }
                        }
                        throw new DLSException(-2147483637, "Data array, invalid size");
                        buf = new byte[]{this.nStat1, this.nStat2, this.nStat3};
                        if (buf[2] == 4) {
                            data[0] = 0;
                            break;
                        }
                        data[0] = -1;
                        break;
                    }
                    case 7: {
                        m_log.debug("DIO_SCANNER_REPORT_2LABEL");
                        Object object4 = this.reportResp;
                        synchronized (object4) {
                            this.reportBuf = EMPTY_BYTE_ARRAY;
                            this.port.sendData(reportConfig2LabelCmd, reportConfig2LabelCmd.length);
                            try {
                                this.reportResp.wait(this.nTimeout);
                                if (this.reportBuf.length == 0) {
                                    throw new DLSException(-2147483640, "Unable to retrieve 2Label Config Data");
                                }
                                buf = new byte[]{this.reportBuf[4], this.reportBuf[5], this.reportBuf[6], this.reportBuf[7], this.reportBuf[8], this.reportBuf[9], this.reportBuf[10], this.reportBuf[11]};
                            }
                            catch (InterruptedException ie) {
                                m_log.error("DIO_SCANNER_REPORT_2LABEL wait interrupted. ", (Throwable)ie);
                            }
                        }
                        this.dioResults("DIO_SCANNER_REPORT_2LABEL", "sendData", data, buf);
                        break;
                    }
                    case 8: {
                        m_log.debug("DIO_SCANNER_DIO_INFORMATION");
                        buf = this.doInternalDirectIO((byte)1);
                        break;
                    }
                    case 9: {
                        m_log.debug("DIO_SCANNER_DIO_HEALTH");
                        buf = this.doInternalDirectIO((byte)2);
                        if (buf.length == 0) {
                            buf[0] = 0;
                            break;
                        }
                        if (buf[0] != 0) {
                            data[0] = 0;
                            break;
                        }
                        buf[0] = 0;
                        data[0] = -1;
                        break;
                    }
                    case 10: {
                        m_log.debug("DIO_SCANNER_DIO_STATS");
                        buf = this.doInternalDirectIO((byte)3);
                        if (buf.length == 0) {
                            buf[0] = 0;
                            break;
                        }
                        if (buf[0] != 0) {
                            data[0] = 0;
                            break;
                        }
                        buf[0] = 0;
                        data[0] = -1;
                        break;
                    }
                    case 345: {
                        buf = this.executeDIO(getNumberStats, "DIO_READ_STAT_LOG_COUNT", data, buf);
                        break;
                    }
                    case 346: {
                        m_log.debug("DIO_READ_STAT_LOG_ITEMS");
                        resultString = "";
                        StringBuilder oSb = new StringBuilder();
                        String intString = "";
                        buf = this.doInternalMultiByteDirectIO(getNumberStats);
                        int iLength = buf[6];
                        for (int i = 0; i < iLength; ++i) {
                            DLSUSBScanner.getStat[4] = (byte)i;
                            buf = this.doInternalMultiByteDirectIO(getStat);
                            intString = this.printToStatString(buf);
                            oSb.append(intString);
                        }
                        resultString = oSb.toString();
                        if (object instanceof ByteArrayOutputStream) {
                            ((ByteArrayOutputStream)object).reset();
                            try {
                                ((ByteArrayOutputStream)object).write(resultString.getBytes());
                            }
                            catch (IOException ex) {
                                m_log.error("ByteArrayOutputStream object write exception: ", (Throwable)ex);
                            }
                        }
                        this.dioResults("DIO_READ_STAT_LOG_ITEMS", "doInternalMultiByteDirectIO()", data, buf);
                        bCopyObjectToBuf = true;
                        break;
                    }
                    case 347: {
                        m_log.debug("DIO_READ_EVENT_LOG_ITEMS");
                        StringBuilder oSb = new StringBuilder();
                        resultString = "";
                        String intString = "";
                        for (int i = 0; i < 254; ++i) {
                            DLSUSBScanner.getStatN[4] = (byte)i;
                            buf = this.doInternalMultiByteDirectIO(getStatN);
                            intString = this.printToEventString(buf);
                            if (intString.contains("EOF")) break;
                            oSb.append(intString);
                        }
                        resultString = oSb.toString();
                        if (object instanceof ByteArrayOutputStream) {
                            ((ByteArrayOutputStream)object).reset();
                            try {
                                ((ByteArrayOutputStream)object).write(resultString.getBytes());
                            }
                            catch (IOException ex) {
                                m_log.error("ByteArrayOutputStream object wtite exception: ", (Throwable)ex);
                            }
                        }
                        this.dioResults("DIO_READ_EVENT_LOG_ITEMS", "doInternalMultiByteDirectIO()", data, buf);
                        bCopyObjectToBuf = true;
                        break;
                    }
                    case 348: {
                        m_log.debug("DIO_READ_EVENT_LOG_LAST_EVENT");
                        buf = this.doInternalMultiByteDirectIO(getLastEvent);
                        String intString = this.printLastEventString(buf);
                        if (intString.contains("EOF")) {
                            intString = "Empty";
                        }
                        if (object instanceof ByteArrayOutputStream) {
                            ((ByteArrayOutputStream)object).reset();
                            try {
                                ((ByteArrayOutputStream)object).write(intString.getBytes());
                            }
                            catch (IOException ex) {
                                m_log.error("ByteArrayOutputStream object wtite exception: ", (Throwable)ex);
                            }
                        }
                        this.dioResults("DIO_READ_EVENT_LOG_LAST_EVENT", "doInternalMultiByteDirectIO()", data, buf);
                        bCopyObjectToBuf = true;
                        break;
                    }
                    case 349: {
                        buf = this.executeDIO(clearEventLog, "DIO_CLEAR_EVENT_LOG", data, buf);
                        break;
                    }
                    case 350: {
                        fileName = object.toString().isEmpty() ? this.scannerConfig.getLogicalName() + "_event.log" : object.toString();
                        m_log.debug("DIO_SAVE_EVENT_LOG: " + fileName);
                        resultString = "";
                        String intString = "";
                        resultString = resultString + fileName + "\n";
                        StringBuilder oSb = new StringBuilder();
                        for (int i = 0; i < 254; ++i) {
                            DLSUSBScanner.getStatN[4] = (byte)i;
                            buf = this.doInternalMultiByteDirectIO(getStatN);
                            intString = this.printToEventString(buf);
                            if (intString.contains("EOF")) break;
                            oSb.append(intString);
                        }
                        resultString = resultString + oSb.toString();
                        try {
                            File eventFile = new File(fileName);
                            output = new BufferedWriter(new FileWriter(eventFile));
                            output.write(resultString);
                            FunctionLib.cleanup(output);
                        }
                        catch (IOException e) {
                            m_log.error("directIO exception: ", (Throwable)e);
                        }
                        finally {
                            FunctionLib.cleanup(output);
                        }
                        if (object instanceof ByteArrayOutputStream) {
                            ((ByteArrayOutputStream)object).reset();
                            try {
                                ((ByteArrayOutputStream)object).write(resultString.getBytes());
                            }
                            catch (IOException ex) {
                                m_log.error("ByteArrayOutputStream object wtite exception: ", (Throwable)ex);
                            }
                        }
                        this.dioResults("DIO_SAVE_EVENT_LOG", "doInternalDirectIO", data, buf);
                        bCopyObjectToBuf = true;
                        break;
                    }
                    case 351: {
                        fileName = object.toString().isEmpty() ? this.scannerConfig.getLogicalName() + "_stats.log" : object.toString();
                        m_log.debug("DIO_SAVE_STATS_LOG: " + fileName);
                        resultString = "";
                        String intString = "";
                        resultString = resultString + fileName + "\n";
                        buf = this.doInternalMultiByteDirectIO(getNumberStats);
                        int iLength = buf[6];
                        StringBuilder oSb = new StringBuilder();
                        for (int i = 0; i < iLength; ++i) {
                            DLSUSBScanner.getStat[4] = (byte)i;
                            buf = this.doInternalMultiByteDirectIO(getStat);
                            intString = this.printToStatString(buf);
                            oSb.append(intString);
                        }
                        resultString = resultString + oSb.toString();
                        try {
                            File statFile = new File(fileName);
                            output = new BufferedWriter(new FileWriter(statFile));
                            output.write(resultString);
                        }
                        catch (IOException e) {
                            try {
                                m_log.error("doInternalDirectIO exception: ", (Throwable)e);
                            }
                            catch (Throwable throwable) {
                                FunctionLib.cleanup(output);
                                throw throwable;
                            }
                            FunctionLib.cleanup(output);
                        }
                        FunctionLib.cleanup(output);
                        if (object instanceof ByteArrayOutputStream) {
                            ((ByteArrayOutputStream)object).reset();
                            try {
                                ((ByteArrayOutputStream)object).write(resultString.getBytes());
                            }
                            catch (IOException ex) {
                                m_log.error("ByteArrayOutputStream object wtite exception: ", (Throwable)ex);
                            }
                        }
                        this.dioResults("DIO_SAVE_STATS_LOG", "doInternalDirectIO", data, buf);
                        bCopyObjectToBuf = true;
                        break;
                    }
                    case 352: {
                        buf = this.executeDIO(getScaleSentryStatus, "DIO_GET_SCALE_SENTRY_STATUS", data, buf);
                        break;
                    }
                    case 353: {
                        buf = this.executeDIO(clearScaleSentryStatus, "DIO_CLEAR_SCALE_SENTRY", data, buf);
                        break;
                    }
                    case 342: {
                        m_log.debug("DIO_READ_CONFIG_ITEM");
                        int sizeOfPayload = -1;
                        if (object.toString().isEmpty() || object.toString().length() > 4) {
                            data[0] = -1;
                            break;
                        }
                        String inString = object.toString();
                        byte[] tagID = FunctionLib.hexStringToByteArray(inString);
                        try {
                            sizeOfPayload = this.queryConfig(tagID);
                        }
                        catch (Exception e) {
                            data[0] = 21;
                            m_log.error("DIO_READ_CONFIG_ITEM exception: ", (Throwable)e);
                            return;
                        }
                        if (sizeOfPayload < 0) break;
                        buf = this.readConfigItem(tagID, sizeOfPayload, data);
                        break;
                    }
                    case 343: {
                        byte[] tempBuf;
                        m_log.debug("DIO_WRITE_CONFIG_ITEM");
                        if (object.toString().isEmpty()) {
                            m_log.error("directIO: Input string is empty.");
                            data[0] = -1;
                            return;
                        }
                        String input = object.toString();
                        if (input.length() < 6) {
                            m_log.error("directIO: Invalid input - This command requires a four digit hexadecimal tag ID followed by a minimum of one hexadecimal byte (two digits) for the value of the tag item.");
                            data[0] = 21;
                            return;
                        }
                        String tagID = input.substring(0, 4);
                        byte[] byteArrayTagID = FunctionLib.hexStringToByteArray(tagID);
                        Pattern pattern = Pattern.compile("[0-9a-fA-F]{4}");
                        Matcher matcher = pattern.matcher(tagID);
                        if (!matcher.find()) {
                            m_log.error("directIO: Invalid input - The tag ID provided is not a hexadecimal value or it is not four four digits.");
                            data[0] = 21;
                            return;
                        }
                        String value = input.substring(4, input.length());
                        int sizeOfInputValue = value.length() / 2;
                        byte[] configItem = FunctionLib.hexStringToByteArray(input);
                        int sizeOfPayload = this.queryConfig(byteArrayTagID);
                        if (sizeOfPayload == 0) {
                            String hexStringInput;
                            m_log.debug("Writing integer tag item " + tagID + ".");
                            pattern = Pattern.compile("[0-9a-fA-F]+");
                            matcher = pattern.matcher(value);
                            if (!matcher.find() || value.length() > 8) {
                                m_log.error("directIO: Invalid input - The value provided (" + value + ") to update tag ID " + tagID + " is not hexadecimal or is greater than eight digits.");
                                data[0] = 21;
                                m_log.trace("directIO (out)");
                                return;
                            }
                            tempBuf = this.readConfigItem(byteArrayTagID, sizeOfPayload, data);
                            int intCurrent = new BigInteger(tempBuf).intValue();
                            int inputValue = new BigInteger(FunctionLib.hexStringToByteArray(value)).intValue();
                            String hexStringCurrent = String.format("%08x", intCurrent).replaceAll(" ", "0");
                            if (hexStringCurrent.equals(hexStringInput = String.format("%08x", inputValue).replaceAll(" ", "0"))) {
                                m_log.debug(tagID + " int values are equal (input value: " + hexStringInput + " current value from scanner config: " + hexStringCurrent + ").");
                                data[0] = 6;
                                m_log.trace("directIO (out)");
                                return;
                            }
                            System.arraycopy(configItem, 0, writeConfigInt, 4, 2);
                            System.arraycopy(FunctionLib.hexStringToByteArray(hexStringInput), 0, writeConfigInt, 6, 4);
                            tempBuf = this.doInternalMultiByteDirectIODelayed(writeConfigInt);
                            if (tempBuf.length == 0) {
                                data[0] = 21;
                                m_log.error("directIO: doInternalMultiByteDirectIODelayed did not return data.");
                                m_log.trace("directIO (out)");
                                return;
                            }
                        } else {
                            if (sizeOfPayload != sizeOfInputValue) {
                                data[0] = 21;
                                m_log.error("directIO: The tag item " + tagID + " has a fixed length of " + sizeOfPayload + ".");
                                break;
                            }
                            m_log.debug("Writing non-integer tag item " + tagID + ".");
                            tempBuf = this.readConfigItem(byteArrayTagID, sizeOfPayload, data);
                            if (Arrays.equals(tempBuf, FunctionLib.hexStringToByteArray(value))) {
                                m_log.debug(tagID + " non-int values are equal (inputted value: " + value + " current value from scanner config: " + FunctionLib.byteArrayToString(tempBuf) + ").");
                                data[0] = 6;
                                m_log.trace("directIO (out)");
                                return;
                            }
                            byte[] outBuf = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                            System.arraycopy(writeConfigNonInt, 0, outBuf, 0, 4);
                            System.arraycopy(configItem, 0, outBuf, 4, 2);
                            for (int i = 0; i < configItem.length - 2; ++i) {
                                outBuf[6] = (byte)i;
                                outBuf[7] = 1;
                                outBuf[8] = configItem[i + 2];
                                tempBuf = this.doInternalMultiByteDirectIODelayed(outBuf);
                            }
                        }
                        data[0] = tempBuf.length == 0 ? -1 : tempBuf[5];
                        buf = EMPTY_BYTE_ARRAY;
                        break;
                    }
                    case 344: {
                        data[0] = 0;
                        m_log.debug("DIO_COMMIT_CONFIG_ITEMS - stubbed for the 9800i because the write auto copies - there is no need to execute this command");
                        break;
                    }
                    case 373: {
                        buf = this.executeDIO(cellPhoneModeECOMMEnter, "DIO_CELL_PHONE_ECOMM_ENTER", data, buf);
                        break;
                    }
                    case 374: {
                        buf = this.executeDIO(cellPhoneModeECOMMExit, "DIO_CELL_PHONE_ECOMM_EXIT", data, buf);
                        break;
                    }
                    case 375: {
                        buf = this.executeDIO(cellPhoneModeScannerEnter, "DIO_CELL_PHONE_SCAN_ENTER", data, buf);
                        Thread.sleep(1500L);
                        break;
                    }
                    case 376: {
                        m_log.debug("DIO_CELL_PHONE_SCAN_EXIT");
                        buf = this.doInternalMultiByteDirectIODelayed(cellPhoneModeScannerExit);
                        m_log.debug("DIO_CELL_PHONE_SCAN_EXIT buf length:" + buf.length);
                        this.dioResults("DIO_CELL_PHONE_SCAN_EXIT", "doInternalMultiByteDirectIODelayed()", data, buf);
                        Thread.sleep(1500L);
                        break;
                    }
                    case 379: {
                        buf = this.executeDIO(extVideoStreamOn, "DIO_EXT_VIDEO_STREAM_ON", data, buf);
                        break;
                    }
                    case 380: {
                        buf = this.executeDIO(extVideoStreamOff, "DIO_EXT_VIDEO_STREAM_OFF", data, buf);
                        break;
                    }
                    case 11: {
                        m_log.debug("DIO_SCANNER_DIO_BEEP");
                        buf = this.doInternalDirectIO((byte)4);
                        this.dioResults("DIO_SCANNER_DIO_BEEP", "doInternalDirectIO()", data, buf);
                        break;
                    }
                    case 12: {
                        m_log.debug("DIO_SCANNER_DIO_NOF_BEEP");
                        buf = this.doInternalDirectIO((byte)6);
                        this.dioResults("DIO_SCANNER_DIO_NOF_BEEP", "doInternalDirectIO()", data, buf);
                        break;
                    }
                    case 13: {
                        m_log.debug("DIO_SCANNER_DIO_ERROR_BEEP");
                        buf = this.doInternalDirectIO((byte)5);
                        this.dioResults("DIO_SCANNER_DIO_ERROR_BEEP", "doInternalDirectIO()", data, buf);
                        break;
                    }
                    case 41: {
                        m_log.debug("DIO_DEV_PROTOCOL");
                        buf = "USB".getBytes();
                        if (buf[0] != 0) {
                            data[0] = 0;
                            break;
                        }
                        buf[0] = 0;
                        data[0] = -1;
                        break;
                    }
                    default: {
                        throw new DLSException(-2147483637, "Invalid directio command received");
                    }
                }
                if (buf.length == 0) break block126;
                if (bCopyObjectToBuf) {
                    buf = ((ByteArrayOutputStream)object).toByteArray();
                }
                try {
                    ByteArrayOutputStream oBs = (ByteArrayOutputStream)object;
                    oBs.reset();
                    oBs.write(buf);
                }
                catch (Exception e) {
                    m_log.error("Unable to return data to DIO caller - Are you passing in a ByteArrayOuputStream object? ", (Throwable)e);
                    throw new DLSException(-2147483637, "Need a ByteArrayOutStream object to return data");
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                m_log.error("Caught exception in DLSUSBScanner::directIO: ", (Throwable)e);
                data[0] = -1;
            }
        }
        long end = System.currentTimeMillis();
        m_log.debug("directIO for: " + (end - start) + " milliseconds");
        m_log.trace("directIO (out)");
    }

    private int queryConfig(byte[] input) throws Exception {
        System.arraycopy(input, 0, queryConfig, 4, 2);
        byte[] tempBuf = this.doInternalMultiByteDirectIO(queryConfig);
        int sizeOfPayload = 0;
        byte statusByte = 0;
        if (tempBuf.length > 1) {
            int lengthOffset = tempBuf[0] - 1;
            statusByte = tempBuf[5];
            sizeOfPayload = tempBuf[lengthOffset];
            if (statusByte != 6) {
                throw new Exception("The status byte of the query config command was not acknowledged.");
            }
        }
        return sizeOfPayload;
    }

    private byte[] readConfigItem(byte[] tagID, int sizeOfPayload, int[] data) {
        byte[] buf = EMPTY_BYTE_ARRAY;
        byte[] tempBuf = EMPTY_BYTE_ARRAY;
        this.bInternalDIO = true;
        if (sizeOfPayload == 0) {
            System.arraycopy(tagID, 0, readConfigInt, 4, 2);
            tempBuf = this.doInternalMultiByteDirectIO(readConfigInt);
            if (tempBuf.length > 6) {
                data[0] = tempBuf[5];
                byte len = tempBuf[0];
                buf = new byte[len - 6];
                System.arraycopy(tempBuf, 6, buf, 0, len - 6);
            }
        } else {
            System.arraycopy(tagID, 0, readConfigNonInt, 4, 2);
            buf = new byte[sizeOfPayload];
            for (int i = 0; i < sizeOfPayload; ++i) {
                DLSUSBScanner.readConfigNonInt[6] = (byte)i;
                DLSUSBScanner.readConfigNonInt[7] = 1;
                tempBuf = this.doInternalMultiByteDirectIO(readConfigNonInt);
                if (tempBuf.length <= 7 || tempBuf[5] != 6) continue;
                buf[i] = tempBuf[8];
            }
            if (tempBuf.length > 4) {
                data[0] = tempBuf[5];
            }
        }
        return buf;
    }

    private byte[] executeDIO(byte[] cmd, String cmdConstant, int[] data, byte[] buf) {
        m_log.trace("executeDIO (in): " + new String(cmd) + ", " + cmdConstant);
        buf = this.doInternalMultiByteDirectIOSinglePacket(cmd);
        this.dioResults(cmdConstant, "doInternalMultiByteDirectIOSinglePacket()", data, buf);
        m_log.trace("executeDIO (out)");
        return buf;
    }

    public void dioResults(String cmd, String functionName, int[] data, byte[] buf) {
        if (buf == null) {
            m_log.error(cmd + " NULL buffer returned from " + functionName + ".");
            return;
        }
        m_log.debug(cmd + " " + functionName + " returned " + buf.length + " bytes.");
        if (buf.length == 0) {
            data[0] = -1;
        } else if (buf.length > 5) {
            data[0] = buf[5] == 21 || !this.bInternalDIOSuccess ? 1 : (buf[5] == 6 || buf[5] == 0 ? 0 : -1);
        }
        this.bInternalDIOSuccess = false;
    }

    @Override
    public boolean hasStatisticsReporting() {
        boolean stats = this.scannerConfig.getCanAcceptStatisticsCmd();
        return stats;
    }

    @Override
    protected void internalRelease() {
        m_log.trace("internalRelease (in)");
        if (null != this.sdw) {
            m_log.debug("Killing DevWatcher");
            this.sdw.CloseWindow();
            try {
                this.monitor.join(1000L);
            }
            catch (InterruptedException ex) {
                m_log.error("internalRelease: Interrupted. ", (Throwable)ex);
            }
            this.monitor = null;
            this.sdw = null;
        }
        m_log.trace("internalRelease (out)");
    }

    @Override
    protected void internalClaim() {
        m_log.trace("internalClaim (in)");
        if (File.separatorChar == '\\' && null == this.sdw) {
            m_log.debug("internalClaim: Starting DevWatcher");
            this.sdw = new DevWatcher(this);
            m_log.debug("internalClaim: SDW:" + this.sdw + " Hash Code:" + this.sdw.hashCode());
            this.monitor = new Thread(this.sdw);
            this.monitor.start();
        }
        m_log.trace("internalClaim (out)");
    }

    @Override
    public HashMap<String, Object> getStatistics() throws DLSException {
        m_log.trace("getStatistics (in)");
        HashMap<String, Object> table = new HashMap<String, Object>();
        if (DLSJposConst.updateInProgress) {
            m_log.warn("Firmware update in progress. Cannot pull i-h-s data during firmware update.");
            m_log.trace("getStatistics (out)");
            return table;
        }
        if (!this.scannerConfig.getCanAcceptStatisticsCmd()) {
            m_log.warn("Scanner does not support i-h-s data.");
            m_log.trace("getStatistics (out)");
            return table;
        }
        String[] strInfo = null;
        String[] strStat = null;
        byte[] buf = EMPTY_BYTE_ARRAY;
        String str = "";
        String truncated = null;
        String truncated2 = null;
        String subTruncated = null;
        int i = 0;
        Object put = table.put("GoodScanCount", "NA");
        put = table.put("DeviceCategory", "Scanner");
        put = table.put("Interface", "USB-OEM");
        m_log.debug("getStatistics: Getting identificationCmd");
        DLSScannerConfig oConfig = this.getScannerConfig();
        int timeOut = oConfig.getExtendedHostTimeout();
        if (timeOut != 0) {
            m_log.info("getStatistics: Using extended host timeout of " + Integer.toString(timeOut) + " milliseconds.");
            buf = this.doInternalDirectIO((byte)1, timeOut);
        } else {
            buf = this.doInternalDirectIO((byte)1);
        }
        if (buf.length == 0 && this.hasStatisticsReporting()) {
            m_log.debug("getStatistics: No response from scanner, retry sending the 'i' command.");
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                m_log.error("getStatistics: Thread interrupted, " + ex);
            }
            buf = timeOut != 0 ? this.doInternalDirectIO((byte)1, timeOut) : this.doInternalDirectIO((byte)1);
        }
        String rawBytes = "";
        if (buf.length == 0) {
            m_log.debug("getStatistics: # bytes received[0]Empty");
            if (this.hasStatisticsReporting()) {
                throw new DLSException(-2147483640, "Unable to get statistical data.");
            }
            m_log.warn("Scanner does not support statistical data.");
            m_log.trace("getStatistics (out)");
            return table;
        }
        rawBytes = FunctionLib.byteArrayToString(buf);
        m_log.debug("getStatistics: # bytes received" + rawBytes);
        put = table.put("RawInfo", "# bytes received" + rawBytes);
        String strInfoString = new String(buf);
        strInfo = strInfoString.split("\u0003");
        block73: for (i = 0; i < strInfo.length; ++i) {
            str = strInfo[i];
            truncated = str.replaceAll("\\p{Cntrl}", "");
            truncated2 = truncated.replaceAll("Sp<", "");
            if (truncated2.length() <= 1) continue;
            subTruncated = truncated2.substring(1);
            switch (truncated2.charAt(0)) {
                case 'M': {
                    put = table.put("ModelNumber", subTruncated);
                    continue block73;
                }
                case 'S': {
                    put = table.put("SerialNumber", subTruncated);
                    put = table.put("DeviceID", subTruncated);
                    continue block73;
                }
                case 'm': {
                    put = table.put("ScannerBoardSerialNumber", subTruncated);
                    continue block73;
                }
                case 'A': {
                    put = table.put("FirmwareVersionNumber", subTruncated);
                    continue block73;
                }
                case 'R': {
                    put = table.put("ScannerRevisionNumber", subTruncated);
                    continue block73;
                }
                case 'C': {
                    put = table.put("ConfigFileVersionNumber", subTruncated);
                    continue block73;
                }
                case 'B': {
                    put = table.put("ScannerBootROMID", subTruncated);
                    continue block73;
                }
                case 'H': {
                    put = table.put("RadiolHardwareVersion", subTruncated);
                    continue block73;
                }
                case 'U': {
                    put = table.put("CometROMID", subTruncated);
                    continue block73;
                }
                case 'u': {
                    put = table.put("CometBootROMID", subTruncated);
                    continue block73;
                }
                case 'W': {
                    put = table.put("ScaleInformation", subTruncated);
                    continue block73;
                }
                case 'D': {
                    put = table.put("DisplayVersion", subTruncated);
                    continue block73;
                }
                case 'E': {
                    put = table.put("EASVersion", subTruncated);
                    continue block73;
                }
                case 'I': {
                    if (subTruncated.contains("45")) {
                        put = table.put("ScannerInterface", "USB-OEM");
                        continue block73;
                    }
                    if (subTruncated.contains("05")) {
                        put = table.put("ScannerInterface", "RS232-STD");
                        continue block73;
                    }
                    if (subTruncated.toUpperCase().contains("0D")) {
                        put = table.put("ScannerInterface", "USB-TEC");
                        continue block73;
                    }
                    if (subTruncated.contains("12")) {
                        put = table.put("ScannerInterface", "RS232-WN");
                        continue block73;
                    }
                    if (subTruncated.contains("20")) {
                        put = table.put("ScannerInterface", "RS232-Single Cable");
                        continue block73;
                    }
                    if (subTruncated.contains("35")) {
                        put = table.put("ScannerInterface", "USB-Keyboard");
                        continue block73;
                    }
                    if (!subTruncated.contains("47")) continue block73;
                    put = table.put("ScannerInterface", "USB-COM");
                    continue block73;
                }
                case 'r': {
                    put = table.put("RadioSoftwareVersion", subTruncated);
                    continue block73;
                }
                case 'b': {
                    put = table.put("RadioBootloaderVersion", subTruncated);
                    continue block73;
                }
                case 'X': {
                    put = table.put("BaseModelNumber", subTruncated);
                    continue block73;
                }
                case 'F': {
                    put = table.put("FPGAVersion", subTruncated);
                    continue block73;
                }
                case 'f': {
                    put = table.put("TDR_FPGAVersion", subTruncated);
                    continue block73;
                }
                case 'P': {
                    put = table.put("IPEAppVersion", subTruncated);
                    continue block73;
                }
                case 'l': {
                    put = table.put("USBLoaderVersion", subTruncated);
                    continue block73;
                }
                case 'Q': {
                    put = table.put("SDRAMCfgVersion", subTruncated);
                    continue block73;
                }
                case 'V': {
                    put = table.put("VisionLibraryVersion", subTruncated);
                    continue block73;
                }
                case 'v': {
                    put = table.put("VirtualScanLineLibraryVersion", subTruncated);
                }
            }
        }
        m_log.debug("getStatistics: Getting healthRequestCmd");
        this.bStatMessageSent = true;
        buf = this.doInternalDirectIO((byte)2);
        if (buf.length == 0) {
            throw new DLSException(-2147483640, "Error retrieving Health via DirectIO");
        }
        rawBytes = FunctionLib.byteArrayToString(buf);
        m_log.debug("getStatistics: # bytes received" + rawBytes);
        put = table.put("RawHealth", "# bytes received" + rawBytes);
        strInfoString = new String(buf);
        strStat = strInfoString.split("\u0003");
        block74: for (i = 0; i < strStat.length; ++i) {
            str = strStat[i];
            truncated = str.replaceAll("\\p{Cntrl}", "");
            truncated2 = truncated.replaceAll("Sp=", "");
            if (truncated2.length() <= 1) continue;
            subTruncated = truncated2.substring(1);
            switch (truncated2.charAt(0)) {
                case 'm': {
                    put = table.put("MotorHealth", subTruncated);
                    continue block74;
                }
                case 'h': {
                    put = table.put("VerticalLaserHealth", subTruncated);
                    continue block74;
                }
                case 'v': {
                    put = table.put("HorizontalLaserHealth", subTruncated);
                    continue block74;
                }
                case 's': {
                    put = table.put("ScaleHealth", subTruncated);
                    continue block74;
                }
                case 'd': {
                    put = table.put("RemoteDisplayHealth", subTruncated);
                    continue block74;
                }
                case 'e': {
                    put = table.put("EASHealth", subTruncated);
                    continue block74;
                }
                case 'c': {
                    put = table.put("CameraHealth", subTruncated);
                    continue block74;
                }
                case 'r': {
                    put = table.put("RadiolHealth", subTruncated);
                    continue block74;
                }
                case 'H': {
                    put = table.put("USBHandheldConnected", subTruncated);
                    continue block74;
                }
                case 'D': {
                    put = table.put("USBSerialDongleConnected", subTruncated);
                    continue block74;
                }
                case '0': {
                    put = table.put("IPE0Health", subTruncated);
                    continue block74;
                }
                case '1': {
                    put = table.put("IPE1Health", subTruncated);
                    continue block74;
                }
                case '2': {
                    put = table.put("IPE2Health", subTruncated);
                    continue block74;
                }
                case '3': {
                    put = table.put("IPE3Health", subTruncated);
                    continue block74;
                }
                case 'S': {
                    put = table.put("ScaleSentryHealth", subTruncated);
                }
            }
        }
        m_log.debug("getStatistics: Getting statisticsCmd");
        this.bStatMessageSent = true;
        buf = this.doInternalDirectIO((byte)3);
        if (buf.length == 0) {
            throw new DLSException(-2147483640, "Error retrieving Statistical data via DirectIO.");
        }
        rawBytes = FunctionLib.byteArrayToString(buf);
        m_log.debug("getStatistics: # bytes received" + rawBytes);
        put = table.put("RawStats", "# bytes received" + rawBytes);
        strInfoString = new String(buf);
        strStat = strInfoString.split("\u0003");
        block75: for (i = 0; i < strStat.length; ++i) {
            str = strStat[i];
            truncated = str.replaceAll("\\p{Cntrl}", "");
            truncated2 = truncated.replaceAll("Sp>", "");
            if (truncated2.length() <= 1) continue;
            subTruncated = truncated2.substring(1);
            switch (truncated2.charAt(0)) {
                case 'P': {
                    put = table.put("HoursPoweredCount", subTruncated);
                    continue block75;
                }
                case 'm': {
                    put = table.put("MotorTime", subTruncated);
                    continue block75;
                }
                case 'l': {
                    put = table.put("LaserTime", subTruncated);
                    continue block75;
                }
                case 'L': {
                    put = table.put("GoodScanCount", subTruncated);
                    continue block75;
                }
                case 'z': {
                    put = table.put("ScaleZeroed", subTruncated);
                    continue block75;
                }
                case 'c': {
                    put = table.put("ScaleCalibrations", subTruncated);
                    continue block75;
                }
                case 'C': {
                    put = table.put("CustomData", subTruncated);
                    continue block75;
                }
                case 'E': {
                    put = table.put("EASDeactivations", subTruncated);
                    continue block75;
                }
                case 'e': {
                    put = table.put("EASManualPresses", subTruncated);
                    continue block75;
                }
                case 'B': {
                    put = table.put("BatteryChargeCycles", subTruncated);
                    continue block75;
                }
                case 'T': {
                    put = table.put("TriggerPulls", subTruncated);
                    continue block75;
                }
                case 'K': {
                    put = table.put("KeyPresses", subTruncated);
                    continue block75;
                }
                case 'R': {
                    put = table.put("TotalResets", subTruncated);
                    continue block75;
                }
                case 'r': {
                    put = table.put("ErrorResets", subTruncated);
                    continue block75;
                }
                case 'V': {
                    put = table.put("VerticalIPEForcedResets", subTruncated);
                    continue block75;
                }
                case 'H': {
                    put = table.put("HorizontalIPEForcedResets", subTruncated);
                    continue block75;
                }
                case 'D': {
                    put = table.put("Forced2DResets", subTruncated);
                    continue block75;
                }
                case 'Q': {
                    put = table.put("TDRForcedResets", subTruncated);
                    continue block75;
                }
                case 'v': {
                    put = table.put("VertExcessiveResets", subTruncated);
                    continue block75;
                }
                case 'h': {
                    put = table.put("HorzExcessiveResets", subTruncated);
                    continue block75;
                }
                case 'd': {
                    put = table.put("2DExcessiveResets", subTruncated);
                    continue block75;
                }
                case 'q': {
                    put = table.put("TRDExcessiveResets", subTruncated);
                    continue block75;
                }
                case 'Z': {
                    put = table.put("POSZeroRequests", subTruncated);
                    continue block75;
                }
                case 'X': {
                    put = table.put("EnforcedZeroEvents", subTruncated);
                    continue block75;
                }
                case 'S': {
                    put = table.put("ScaleSentryEvents", subTruncated);
                    continue block75;
                }
                case 'Y': {
                    put = table.put("EASRuntimeFaults", subTruncated);
                }
            }
        }
        if (!table.containsKey("Interface")) {
            put = table.put("Interface", "USB");
        }
        Branding oBr = Branding.getInstance();
        String sName = oBr.getManufacturerShortName();
        put = table.put("ManufacturerName", sName);
        put = table.put("DeviceCategory", "Scanner");
        this.bStatMessageSent = false;
        this.statistics = table;
        m_log.trace("getStatistics (out)");
        return table;
    }

    @Override
    public void onDeviceAdded() {
    }

    @Override
    public void onDeviceArrival() {
    }

    @Override
    public void onDeviceReattached() {
        m_log.trace("onDeviceReattached (in)");
        this.numBytes = 0;
        if (this.bReattachPending) {
            this.bReattachPending = true;
            this.port.openPort();
            try {
                if (this.getDeviceEnabled()) {
                    this.setState(DLSState.DISABLED);
                    m_log.trace("onDeviceReattached: Trying to enable.");
                    this.enable();
                    if (this.numBytes == 0) {
                        this.enable();
                    }
                }
            }
            catch (DLSException e) {
                m_log.error("onDeviceReattached: Device reattached exception: ", (Throwable)e);
            }
            this.fireDeviceErrorEvent(-120);
        }
        m_log.trace("onDeviceReattached (out)");
    }

    @Override
    public void onDeviceRemoved() {
        this.fireDeviceErrorEvent(-116);
        boolean close_succesful = this.port.closePort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataReceived(byte[] inBuf, int inLen) {
        m_log.trace("onDataReceived (in): " + Integer.toString(inLen));
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        super.onDataReceived(inBuf, inLen);
        int nResp = 0;
        boolean b2DLabel = false;
        if (inBuf == null || inLen == 0) {
            m_log.error("onDataReceived called with zero length data packet");
            m_log.trace("onDataReceived (out)");
            return;
        }
        m_log.debug("onDataReceived: inBuf = " + new String(inBuf));
        Object object = this.objStatus;
        synchronized (object) {
            nResp |= inBuf[1];
            nResp |= inBuf[2] << 8;
            nResp |= inBuf[3] << 16;
            this.nStat1 = inBuf[1];
            this.nStat2 = inBuf[2];
            this.nStat3 = inBuf[3];
            this.objStatus.notifyAll();
        }
        boolean bIsEnabled = (this.nStat2 & 2) == 2;
        m_log.debug("onDataReceived: Enabled = " + Boolean.toString(bIsEnabled));
        String rawBytes = FunctionLib.byteArrayToString(inBuf);
        m_log.debug("onDataReceived: # bytes received" + rawBytes);
        int nType = 0;
        if ((nResp & 0x100) == 256) {
            if (!this.bLocalAlive) {
                m_log.debug("onDataReceived: STATUS_ALIVE");
                this.fireDeviceStatusEvent(-200);
                this.bLocalAlive = true;
            }
        } else if (this.bLocalAlive) {
            m_log.debug("onDataReceived: STATUS_NOT_ALIVE");
            this.fireDeviceStatusEvent(-201);
            this.bLocalAlive = false;
        }
        if ((nResp & 1) == 1) {
            m_log.debug("onDataReceived: ERR_FLASHING");
            this.fireDeviceErrorEvent(-111);
        } else if ((nResp & 0x20) == 32) {
            m_log.debug("onDataReceived: RESP_HARDWARE_ERROR");
            this.fireDeviceErrorEvent(-105);
        } else if ((nResp & 0x80) == 128) {
            if (this.bRaiseBusy) {
                m_log.debug("onDataReceived: RESP_NOT_READY");
                this.fireDeviceErrorEvent(-112);
            }
        } else if ((nResp & 0x400) == 1024) {
            m_log.debug("onDataReceived: RESP_CHECKDIGIT_ERROR");
            this.fireDeviceErrorEvent(-113);
        } else if ((nResp & 0x8000) == 32768) {
            m_log.debug("onDataReceived: RESP_CMD_REJECT");
            this.fireDeviceErrorEvent(-100);
        } else if ((nResp & 0x100000) == 0x100000) {
            m_log.debug("onDataReceived: RESP_DIO_NOT_ALLOWED");
            this.fireDeviceErrorEvent(-114);
        } else if ((nResp & 0x200000) == 0x200000) {
            m_log.debug("onDataReceived: RESP_DIO_UNDEFINED");
            this.fireDeviceErrorEvent(-115);
        } else if ((nResp & 2) == 2) {
            m_log.debug("onDataReceived: RESP_CONFIG_DATA");
            Object object2 = this.reportResp;
            synchronized (object2) {
                this.reportBuf = Arrays.copyOf(inBuf, inBuf.length);
                this.reportResp.notifyAll();
            }
        } else if ((nResp & 4) == 4) {
            m_log.debug("onDataReceived: RESP_EANJANCONFIG_DATA");
            Object object3 = this.reportResp;
            synchronized (object3) {
                this.reportBuf = Arrays.copyOf(inBuf, inBuf.length);
                this.reportResp.notifyAll();
            }
        } else if ((nResp & 0x40) == 64) {
            m_log.debug("onDataReceived: RESP_DIO_DATA");
            Object object4 = this.dioResp;
            synchronized (object4) {
                if (this.bInternalDIO) {
                    this.bInternalDIO = false;
                    if ((nResp & 0x80000) == 524288) {
                        this.bInternalDIOSuccess = true;
                    }
                    this.dioBuf = Arrays.copyOf(inBuf, inBuf.length);
                    this.dioResp.notifyAll();
                }
            }
        } else if ((nResp & 0x80000) == 524288) {
            m_log.debug("onDataReceived: RESP_DIO_SUCCESS");
            Object object5 = this.dioResp;
            synchronized (object5) {
                if (this.bInternalDIO) {
                    this.bInternalDIO = false;
                    this.bInternalDIOSuccess = true;
                    this.dioBuf = Arrays.copyOf(inBuf, inBuf.length);
                    this.dioResp.notifyAll();
                }
            }
        } else if ((nResp & 0x10000) == 65536) {
            m_log.debug("onDataReceived: RESP_CONFIG_SUCCESS");
        } else if ((nResp & 0x40000) == 262144) {
            m_log.debug("onDataReceived: RESP_EANJANCONFIG_SUCCESS");
        } else if ((nResp & 0x20000) == 131072) {
            m_log.debug("onDataReceived: RESP_CONFIG_COERCED");
        } else if (inBuf[0] == 4) {
            Object object6 = this.statusResp;
            synchronized (object6) {
                this.statusBuf = Arrays.copyOf(inBuf, inBuf.length);
                this.statusResp.notifyAll();
            }
        } else {
            m_log.debug("onDataReceived: Parsing data as barcode.");
            byte bufLen = inBuf[0];
            byte[] identifier = null;
            int identifierLength = 0;
            if (inBuf[bufLen - 1] == 0) {
                m_log.debug("onDataReceived: Hit special label identifier. (0x00)");
                identifierLength = 4;
                identifier = new byte[]{inBuf[bufLen - 4], inBuf[bufLen - 3], inBuf[bufLen - 2], inBuf[bufLen - 1]};
                nType = 501;
            } else {
                if (inBuf[bufLen - 1] == 11) {
                    m_log.debug("onDataReceived: Using 3 byte identifier.");
                    identifier = new byte[]{0, inBuf[bufLen - 2], inBuf[bufLen - 1]};
                } else {
                    m_log.debug("onDataReceived: Using 1 byte identifier.");
                    identifier = new byte[]{inBuf[bufLen - 1]};
                }
                LabelParser labelParser = LabelParser.getInstance();
                labelParser.setDecodeType("oem");
                LabelRow labelRow = labelParser.extractBarcodeType(identifier);
                identifierLength = labelRow.getIdentifierLength();
                nType = labelRow.getUPOSID();
            }
            byte moreDataByte = inBuf[bufLen - 3];
            if (identifierLength == 4) {
                moreDataByte = inBuf[bufLen - 4];
            }
            m_log.debug("onDataReceived: moreDataByte = " + String.format("0x%02X", moreDataByte));
            byte[] labelData = null;
            labelData = new byte[bufLen - 4 - identifierLength];
            for (int i = 4; i < bufLen - identifierLength; ++i) {
                labelData[i - 4] = inBuf[i];
            }
            if (oInfo.getUsage() == 18944) {
                switch (nType) {
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 111: 
                    case 112: 
                    case 118: 
                    case 119: {
                        Branding oBr = Branding.getInstance();
                        String sProp = "com." + oBr.getBrandingPrefix() + ".jpos.service.ScannerService.convertBCDtoASCII";
                        DLSProperties oOpt = DLSProperties.getInstance();
                        this.bConvertBCDtoASCII = oOpt.get(sProp, true);
                        if (!this.bConvertBCDtoASCII) break;
                        for (int i = 0; i < labelData.length; ++i) {
                            if (labelData[i] < 0 || labelData[i] > 9) continue;
                            labelData[i] = (byte)(labelData[i] + 48);
                        }
                        break;
                    }
                }
            }
            boolean bHasMore = false;
            if (identifierLength == 4) {
                if ((moreDataByte & 0x10) == 16) {
                    bHasMore = true;
                }
            } else if (moreDataByte == 16) {
                bHasMore = true;
            }
            if (bHasMore) {
                m_log.debug("onDataReceived: Concatenating data into label, additional data follows.");
                this.concatUSBMessages(labelData, false);
            } else {
                m_log.debug("onDataReceived: No additional label data follows.");
                this.concatUSBMessages(labelData, true);
                Iterator it = this.msgList.iterator();
                while (it.hasNext()) {
                    m_log.debug("onDataReceived: Examining next label.");
                    byte[] tmpBuf = (byte[])it.next();
                    if (tmpBuf.length <= 0) continue;
                    byte[] rawLabel = new byte[tmpBuf.length + identifierLength];
                    System.arraycopy(tmpBuf, 0, rawLabel, 0, tmpBuf.length);
                    m_log.debug("onDataReceived: parsed rawLabel of \"" + new String(rawLabel) + "\"");
                    System.arraycopy(identifier, 0, rawLabel, tmpBuf.length, identifierLength);
                    m_log.debug("onDataReceived: parsed identifier of \"" + new String(identifier) + "\"");
                    byte[] barcode = this.extractBarcodeLabel(rawLabel, identifierLength);
                    m_log.debug("onDataReceived: parsed barcode of \"" + new String(barcode) + "\"");
                    Branding oBr = Branding.getInstance();
                    String sProp = "com." + oBr.getBrandingPrefix() + ".jpos.service.ScannerService.sendCookedData";
                    DLSProperties oOpt = DLSProperties.getInstance();
                    this.bSendCookedData = oOpt.get(sProp, false);
                    if (this.bSendCookedData) {
                        tmpBuf = barcode;
                    }
                    this.fireLabelReceivedEvent(rawLabel, barcode, nType);
                }
                this.msgList.clear();
                m_log.trace("onDataReceived (out)");
                return;
            }
        }
        m_log.trace("onDataReceived (out)");
    }

    @Override
    protected byte[] extractBarcodeLabel(byte[] inBuf, int identifierLength) {
        byte[] buf = new byte[inBuf.length - identifierLength];
        System.arraycopy(inBuf, 0, buf, 0, inBuf.length - identifierLength);
        return buf;
    }

    byte[] concat(byte[] ... arrays) {
        int totalLength = 0;
        for (int i = 0; i < arrays.length; ++i) {
            totalLength += arrays[i].length;
        }
        byte[] result = new byte[totalLength];
        int currentIndex = 0;
        for (int i = 0; i < arrays.length; ++i) {
            System.arraycopy(arrays[i], 0, result, currentIndex, arrays[i].length);
            currentIndex += arrays[i].length;
        }
        return result;
    }

    private String printToStatString(byte[] buf) {
        String resultString = "";
        int i = 5;
        byte StatID = buf[i++];
        byte InterID = buf[i++];
        int StatValue = buf[i + 0] << 24 | buf[i + 1] << 16 | buf[i + 2] << 8 | buf[i + 3];
        int index = 0;
        for (index = i += 4; index < buf.length - i && buf[index] != 0; ++index) {
        }
        byte[] bBuf = new byte[index - i];
        System.arraycopy(buf, i, bBuf, 0, index - i);
        String strBuf = new String(bBuf);
        resultString = String.format("StatID: %d, InterID: %X, Value: %d, String: %s%n", StatID, (int)InterID, StatValue, strBuf);
        return resultString;
    }

    private String printToEventString(byte[] buf) {
        String resultString = "";
        if (buf.length < 19 || buf[0] < 19) {
            return "EOF";
        }
        int i = 5;
        byte EventType2 = buf[i++];
        byte EventModule = buf[i++];
        byte EventCode = buf[i++];
        int EventData2 = buf[i + 0] << 24 | buf[i + 1] << 16 | buf[i + 2] << 8 | buf[i + 3];
        int EventAdditionalData = buf[(i += 4) + 0] << 24 | buf[i + 1] << 16 | buf[i + 2] << 8 | buf[i + 3];
        int EventHours = buf[(i += 4) + 0] << 8 | buf[i + 1] & 0xFF;
        i += 2;
        byte EventCount = buf[i++];
        resultString = String.format("EvType: %02X, EvMod: %02X, EvCod: %02X, EvDat: %08X, AddEvDat: %08X, Hours: %04d, EvCount %02X%n", EventType2, (int)EventModule, (int)EventCode, EventData2, EventAdditionalData, EventHours, (int)EventCount);
        return resultString;
    }

    private String printLastEventString(byte[] buf) {
        String resultString = "";
        int i = 5;
        byte EventType2 = buf[i++];
        byte EventModule = buf[i++];
        byte EventCode = buf[i++];
        int EventData2 = buf[i + 0] << 24 | buf[i + 1] << 16 | buf[i + 2] << 8 | buf[i + 3];
        int EventAdditionalData = buf[(i += 4) + 0] << 24 | buf[i + 1] << 16 | buf[i + 2] << 8 | buf[i + 3];
        int EventHours = buf[(i += 4) + 0] << 8 | buf[i + 1] & 0xFF;
        i += 2;
        byte EventCount = buf[i++];
        resultString = String.format("EvType: %02X, EvMod: %02X, EvCod: %02X, EvDat: %08X, AddEvDat: %08X, Hours: %04d, EvCount %02X%n", EventType2, (int)EventModule, (int)EventCode, EventData2, EventAdditionalData, EventHours, (int)EventCount);
        return resultString;
    }

    @Override
    public int sendMessage(String sRecord) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

