/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.service;

import com.dls.jpos.common.Branding;
import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSRegistry;
import com.dls.jpos.common.DLSScaleConfig;
import com.dls.jpos.common.DLSState;
import com.dls.jpos.common.DLSStatistics;
import com.dls.jpos.common.FunctionLib;
import com.dls.jpos.interpretation.DLSDevice;
import com.dls.jpos.interpretation.DLSSerialScanner;
import com.dls.jpos.interpretation.DeviceErrorStatusListener;
import com.dls.jpos.interpretation.DirectIODataListener;
import com.dls.jpos.service.ScannerScaleAgent;
import com.dls.jpos.service.WMIService;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import jpos.JposConst;
import jpos.JposException;
import jpos.events.DirectIOEvent;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSBaseService
implements BaseService,
JposConst,
DeviceErrorStatusListener,
DirectIODataListener {
    protected DLSDevice device = null;
    protected EventCallbacks evtCallback = null;
    protected String strLogicalName = "None";
    public String busType = "RS232";
    public static final String RELEASE = "@RELEASE@";
    @Deprecated
    public static String APP_NAME = "DLSJavaPOS";
    public static final String VERSION = "1.14.026";
    public static final String UPOS_VERSION = "1.14.0";
    public static final int deviceServiceVersion = 1014026;
    protected String manufacturerName;
    public boolean beenClaimed = false;
    protected boolean bFreezeEvents = false;
    protected int deviceState = 1;
    protected String strCheckHealthText = "";
    protected int nMaxWeight = 30000;
    protected int nWeightUnit = 0;
    protected int nPwrNotify = 0;
    protected int nPwrState = 2000;
    protected boolean bMetricMode = false;
    protected String sDecodeType = null;
    private String serviceVersion = null;
    public ArrayList<String> scannerInfo = new ArrayList();
    public HashMap<String, Object> statistics = new HashMap();
    public HashMap<String, Object> wmiStatistics = new HashMap();
    protected WMIService lWMI = new WMIService();
    public int deviceNumber = 0;
    boolean bEnablePole = false;
    String category = "Scanner";
    protected DLSProperties options = null;
    protected DLSCConfig config = null;
    protected boolean notRun = true;
    public int numBytes = 0;
    protected SimpleTask st;
    protected Timer t;
    boolean busyFlag = false;
    boolean bUpdateStatsOnRetrieve = false;
    protected boolean bWMIEnabled = false;
    protected boolean bMBeansEnabled = false;
    protected ScannerScaleAgent agent = null;
    private static final Logger m_log = LogManager.getLogger(DLSBaseService.class);

    public DLSBaseService() {
        Branding oBr = Branding.getInstance();
        APP_NAME = oBr.getBrandedProduct();
        String ver = Integer.toString(1014026);
        this.serviceVersion = Integer.valueOf(ver.substring(0, 1)) + "." + Integer.valueOf(ver.substring(1, 4)) + "." + Integer.valueOf(ver.substring(4, 7));
        this.initialize();
        this.options = DLSProperties.getInstance();
    }

    @Override
    public void checkHealth(int level) throws JposException {
        m_log.trace("checkHealth (in): " + level);
        if (!this.getClaimed()) {
            m_log.error("checkHealth: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        switch (level) {
            case 1: {
                try {
                    if (this.device.isAlive()) {
                        this.strCheckHealthText = "Internal HCheck: Successful";
                        break;
                    }
                    this.strCheckHealthText = "Internal HCheck: Not Successful";
                }
                catch (DLSException e) {
                    this.strCheckHealthText = "Internal HCheck: Not Successful: " + e.getMessage();
                }
                break;
            }
            case 2: {
                try {
                    if (this.device.doHealthCheck()) {
                        this.strCheckHealthText = "External HCheck: Successful";
                        break;
                    }
                    this.strCheckHealthText = "External HCheck: Not Successful";
                }
                catch (DLSException e) {
                    this.strCheckHealthText = "External HCheck: Not Successful: " + e.getMessage();
                }
                break;
            }
            case 3: {
                this.strCheckHealthText = "Interactive HCheck: Not Supported";
            }
        }
        m_log.trace("checkHealth (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void claim(int timeout) throws JposException {
        boolean useClaimLockFile;
        String sProp1;
        String sPre;
        String tempDir;
        DLSDeviceInfo oInfo;
        block35: {
            int i;
            BufferedWriter output;
            BufferedReader in;
            File clf;
            String claimLockName;
            String[] pidList;
            String procID;
            block37: {
                String clfPID;
                block38: {
                    block36: {
                        m_log.trace("claim (in): " + Integer.toString(timeout));
                        oInfo = this.device.getDeviceInfo();
                        if (this.getClaimed()) {
                            m_log.trace("claim (out)");
                            return;
                        }
                        this.logOptions();
                        Branding oBr = Branding.getInstance();
                        tempDir = this.options.getTempDir();
                        sPre = oBr.getBrandingPrefix();
                        sProp1 = "com." + sPre + ".jpos.common.ScannerService.updateStatsEveryRetrieveStatistics";
                        this.bUpdateStatsOnRetrieve = this.options.get(sProp1, true);
                        sProp1 = "com." + sPre + ".jpos.service.ScannerService.enableDisablePole";
                        String sProp2 = "com." + sPre + ".jpos.service.ScannerService.enablePole";
                        this.bEnablePole = this.options.get(sProp1, this.options.get(sProp2, false));
                        this.category = oInfo.getDeviceCategory();
                        this.busType = oInfo.getDeviceBus();
                        m_log.info("claim: jpos.xml entries");
                        this.config = this.device.getConfiguration();
                        HashMap<String, String> configHT = this.config.mapConfig;
                        for (Map.Entry<String, String> e : configHT.entrySet()) {
                            m_log.info(e.getKey() + ": " + e.getValue());
                        }
                        sProp1 = "com." + sPre + ".jpos.service.ScannerService.useClaimLockFile";
                        useClaimLockFile = this.options.get(sProp1, false);
                        if (!useClaimLockFile) break block35;
                        procID = this.getProcessId();
                        pidList = DLSBaseService.getJPOSPIDs();
                        String bus = oInfo.getDeviceBus();
                        int vid = oInfo.getVendorId();
                        int pid = oInfo.getProductId();
                        String lName = oInfo.getLogicalName();
                        claimLockName = bus + vid + pid + lName + ".lock";
                        clf = new File(claimLockName);
                        in = null;
                        output = null;
                        clfPID = "";
                        if (!clf.exists()) break block36;
                        try {
                            in = new BufferedReader(new FileReader(claimLockName));
                            clfPID = in.readLine();
                        }
                        catch (FileNotFoundException ex) {
                            m_log.error("claim: error reading" + claimLockName, (Throwable)ex);
                        }
                        catch (IOException ex) {
                            m_log.error("claim: error reading " + claimLockName, (Throwable)ex);
                        }
                        i = 0;
                        if (clfPID == null) break block37;
                        if (clfPID.contains(procID)) {
                            m_log.error("claim: 102 Device in use");
                            FunctionLib.cleanup(in);
                            throw new JposException(102, "Device in use");
                        }
                        break block38;
                    }
                    try {
                        if (clf.createNewFile()) {
                            m_log.debug("claim: Creating new " + claimLockName + " file");
                        }
                    }
                    catch (IOException ex) {
                        m_log.error("claim: error creating " + claimLockName + ", ", (Throwable)ex);
                    }
                    try {
                        output = new BufferedWriter(new FileWriter(clf));
                        output.write(procID);
                    }
                    catch (IOException ex) {
                        try {
                            m_log.error("claim: error writing " + claimLockName + ", ", (Throwable)ex);
                        }
                        catch (Throwable throwable) {
                            FunctionLib.cleanup(output);
                            throw throwable;
                        }
                        FunctionLib.cleanup(output);
                        break block35;
                    }
                    FunctionLib.cleanup(output);
                    break block35;
                }
                for (i = 0; i < pidList.length && pidList[i] != null; ++i) {
                    if (!clfPID.contains(pidList[i])) continue;
                    m_log.error("claim: 102 Device in use");
                    FunctionLib.cleanup(in);
                    throw new JposException(102, "Device in use");
                }
            }
            if (i == pidList.length || pidList[i] == null) {
                if (!clf.delete()) {
                    m_log.error("claim: Could not delete " + claimLockName + " file");
                }
                try {
                    if (clf.createNewFile()) {
                        m_log.debug("claim: Creating new " + claimLockName + " file");
                    }
                }
                catch (IOException ex) {
                    m_log.error("claim: error creating " + claimLockName + ", ", (Throwable)ex);
                    FunctionLib.cleanup(in);
                }
                try {
                    output = new BufferedWriter(new FileWriter(clf));
                    output.write(procID);
                }
                catch (IOException ex) {
                    m_log.error("claim: error writing " + claimLockName + ", ", (Throwable)ex);
                }
                finally {
                    FunctionLib.cleanup(output);
                    FunctionLib.cleanup(in);
                }
            }
        }
        if (this.isClosed()) {
            m_log.error("claim: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        try {
            this.device.claim(timeout);
            this.device.addDeviceErrorListener(this);
            this.device.addDeviceStatusListener(this);
            this.device.addDirectIODataListener(this);
            oInfo.setServiceVersion(this.serviceVersion);
        }
        catch (DLSException e) {
            m_log.error("claim: 111, ", (Throwable)e);
            sProp1 = "com." + sPre + ".jpos.service.ScannerService.useClaimLockFile";
            useClaimLockFile = this.options.get(sProp1, false);
            if (useClaimLockFile) {
                String bus = oInfo.getDeviceBus();
                int vid = oInfo.getVendorId();
                int pid = oInfo.getProductId();
                String lName = oInfo.getLogicalName();
                String claimLockName = bus + vid + pid + lName + ".lock";
                File clf = new File(claimLockName);
                boolean delete = clf.delete();
                if (!delete) {
                    m_log.warn("claim: Failed to delete Claim Lock File.");
                }
            }
            throw new JposException(111, e.getMessage());
        }
        sProp1 = "com." + sPre + ".jpos.common.ScannerService.ScannerInfoFilename";
        String scannerInfoFilename = oInfo.getDeviceClass() + "_" + this.options.get(sProp1, "info") + ".txt";
        scannerInfoFilename = tempDir + scannerInfoFilename;
        String scannerInfoAvalancheFilename = FunctionLib.getFilename(scannerInfoFilename) + ".prf";
        sProp1 = "com." + sPre + ".jpos.common.ScannerService.AvalancheEnabled";
        boolean avalancheEnabled = this.options.get(sProp1, false);
        if (avalancheEnabled && File.separatorChar == '\\') {
            boolean success;
            boolean fileExists;
            boolean exists;
            String propsPath = "";
            try {
                propsPath = DLSRegistry.readString(-2147483646, "Software\\Wavelink\\Avalanche", "PROPS");
            }
            catch (IllegalArgumentException ex) {
                m_log.error("claim: ", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                m_log.error("claim: ", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                m_log.error("claim: ", (Throwable)ex);
            }
            if (propsPath != null && (exists = new File(propsPath).exists()) && (fileExists = new File(propsPath + System.getProperty("file.separator") + scannerInfoAvalancheFilename).exists()) && !(success = new File(propsPath + System.getProperty("file.separator") + scannerInfoAvalancheFilename).delete())) {
                m_log.error("Failed to delete Avalanche file: " + propsPath + System.getProperty("file.separator") + scannerInfoAvalancheFilename);
            }
        }
        m_log.trace("claim (out)");
    }

    @Override
    public void close() throws JposException {
        m_log.trace("close (in)");
        try {
            if (this.getClaimed()) {
                this.release();
            }
        }
        catch (JposException e) {
            m_log.error("close: Error releasing, ", (Throwable)e);
        }
        try {
            this.device.close();
            this.deviceState = 1;
        }
        catch (DLSException ex) {
            m_log.error("close: Error closing device, ", (Throwable)ex);
        }
        m_log.trace("close (out)");
    }

    private String[] commaSeparatedStringToStringArray(String aString) {
        String[] splitArray = new String[]{};
        if (aString == null) {
            m_log.error("commaSeparatedStringToStringArray: parameter string is null.");
            return splitArray;
        }
        String laString = aString.replaceAll(" ", "");
        if (!laString.isEmpty()) {
            splitArray = laString.split(",");
        }
        return splitArray;
    }

    public void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
        m_log.trace("compareFirmwareVersion (in): " + firmwareFileName);
        if (!this.getClaimed()) {
            m_log.error("compareFirmwareVersion: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            m_log.error("compareFirmwareVersion: 105 Device not enabled");
            throw new JposException(105, "Device not enabled");
        }
        m_log.trace("compareFirmwareVersion (out)");
    }

    public void completeStatistics() {
        try {
            String ver = Integer.toString(1014026);
            String controlVersion = Integer.valueOf(ver.substring(0, 1)) + "." + Integer.valueOf(ver.substring(2, 4));
            this.statistics.put("ServiceVersion", DLSBaseService.getVersionString());
            float fcv = Float.valueOf(controlVersion.trim()).floatValue();
            int cv = (int)(fcv * 100000.0f);
            this.statistics.put("UnifiedPOSVersion", controlVersion);
            this.statistics.put("ControlVersion", cv);
            if (this.statistics.containsKey("ScannerRevisionNumber")) {
                this.statistics.put("ApplicationRevisionLevel", this.statistics.get("ScannerRevisionNumber"));
            }
            if (this.statistics.containsKey("BaseSoftwareVersion")) {
                this.statistics.put("ApplicationRevisionLevel", this.statistics.get("BaseSoftwareVersion"));
                this.statistics.put("ScannerRevisionNumber", this.statistics.get("BaseSoftwareVersion"));
            }
            if (this.statistics.containsKey("RadiolHardwareVersion")) {
                this.statistics.put("ApplicationRevisionLevel", this.statistics.get("RadiolHardwareVersion"));
            }
            if (this.statistics.containsKey("RadioSoftwareVersion")) {
                this.statistics.put("RadioSoftwareVersion", this.statistics.get("RadioSoftwareVersion"));
            }
            this.statistics.put("PowerNotify", this.getPowerNotify());
            this.statistics.put("PowerState", this.getPowerState());
            String tempResponse = this.getCapPowerReporting() == 2 ? "Advanced" : (this.getCapPowerReporting() == 1 ? "Standard" : "None");
            this.statistics.put("CapPowerReporting", tempResponse);
            this.statistics.put("CapStatisticsReporting", this.getCapStatisticsReporting());
            this.statistics.put("CapUpdateStatistics", this.getCapUpdateStatistics());
            this.statistics.put("CapCompareFirmwareVersion", this.getCapCompareFirmwareVersion());
            this.statistics.put("CapUpdateFirmware", this.getCapUpdateFirmware());
            this.statistics.put("Caption", this.device.getDeviceInfo().getVendorName());
            this.statistics.put("Description", this.device.getDeviceInfo().getDeviceDescription());
            this.statistics.put("PhysicalDeviceDescription", this.device.getDeviceInfo().getProductDescription());
            this.statistics.put("PhysicalDeviceName", this.device.getDeviceInfo().getProductName());
            this.statistics.put("AsyncMode", "0");
            this.manufacturerName = this.device.getDeviceInfo().getVendorName();
            this.statistics.put("ManufacturerName", this.manufacturerName);
        }
        catch (JposException e) {
            m_log.error("Exception caught attempting to complete stats. ", (Throwable)e);
        }
    }

    @Override
    public void directIO(int command, int[] data, Object object) throws JposException {
        m_log.trace("directIO (in): " + command);
        if (!this.getClaimed()) {
            m_log.error("directIO: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        try {
            this.device.directIO(command, data, object);
        }
        catch (DLSException e) {
            m_log.error("directIO: ", (Throwable)e);
            throw new JposException(111, e.getMessage());
        }
        m_log.trace("directIO (out)");
    }

    public String getBusType() {
        return this.busType;
    }

    public boolean getCapCompareFirmwareVersion() throws JposException {
        m_log.trace("getCapCompareFirmwareVersion (in)");
        if (this.isClosed()) {
            m_log.error("getCapCompareFirmwareVersion: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getCapCompareFirmwareVersion (out)");
        return false;
    }

    public int getCapPowerReporting() throws JposException {
        m_log.trace("getCapPowerReporting (in)");
        if (this.isClosed()) {
            m_log.error("getCapPowerReporting: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getCapPowerReporting (out)");
        return 1;
    }

    public boolean getCapStatisticsReporting() throws JposException {
        boolean bRes = false;
        m_log.trace("getCapStatisticsReporting (in)");
        if (this.isClosed()) {
            m_log.error("DLSBaseService.getCapStatisticsReporting: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        bRes = this.device.hasStatisticsReporting();
        m_log.trace("getCapStatisticsReporting (out): " + Boolean.toString(bRes));
        return bRes;
    }

    public boolean getCapStatusUpdate() throws JposException {
        m_log.trace("getCapStatusUpdate (in)");
        if (this.isClosed()) {
            m_log.error("getCapStatusUpdate: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getCapStatusUpdate (out)");
        return false;
    }

    public boolean getCapUpdateFirmware() throws JposException {
        m_log.trace("getCapUpdateFirmware (in)");
        if (this.isClosed()) {
            m_log.error("getCapUpdateFirmware: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getCapUpdateFirmware (out)");
        return false;
    }

    public boolean getCapUpdateStatistics() throws JposException {
        m_log.trace("getCapUpdateStatistics (in)");
        if (this.isClosed()) {
            m_log.error("getCapUpdateStatistics: 101 Device not open");
            m_log.trace("getCapUpdateStatistics(out)");
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getCapUpdateStatistics(out)");
        return false;
    }

    @Override
    public String getCheckHealthText() throws JposException {
        m_log.trace("getCheckHealthText (in)");
        if (this.isClosed()) {
            m_log.error("getCheckHealthText: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getCheckHealthText (out): " + this.strCheckHealthText);
        return this.strCheckHealthText;
    }

    @Override
    public boolean getClaimed() throws JposException {
        m_log.trace("getClaimed (in)");
        boolean claimed = false;
        DLSState state = this.device.getState();
        if (this.isClosed()) {
            m_log.error("getClaimed: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        if (state == DLSState.CLAIMED || state == DLSState.ENABLED || state == DLSState.DISABLED) {
            claimed = true;
        }
        m_log.trace("getClaimed (out): " + Boolean.toString(claimed));
        return claimed;
    }

    @Override
    public boolean getDeviceEnabled() throws JposException {
        if (this.isClosed()) {
            m_log.error("getDeviceEnabled: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        return this.device.getState() == DLSState.ENABLED;
    }

    public int getDeviceNumber() throws JposException {
        m_log.trace("getDeviceNumber (in)");
        DLSDeviceInfo oInfo = this.device.getDeviceInfo();
        if (!this.getClaimed()) {
            m_log.error("getDeviceNumber: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        m_log.trace("getDeviceNumber (out): " + Integer.toString(oInfo.deviceNumber));
        return oInfo.deviceNumber;
    }

    @Override
    public String getDeviceServiceDescription() throws JposException {
        m_log.trace("getDeviceServiceDescription (in)");
        if (this.isClosed()) {
            m_log.error("getDeviceServiceDescription: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        String str = "Scanner";
        if (this.device != null) {
            m_log.debug("device != null");
            str = this.device.getDeviceInfo().getProductDescription();
            if (this.getCapStatisticsReporting()) {
                m_log.debug("getCapStatisticsReporting()");
                String sstr = "";
                sstr = this.device.getClass().getCanonicalName();
                if (sstr.contains("Scale")) {
                    sstr = Arrays.toString(this.device.getClass().getMethods());
                    DLSScaleConfig oConfig = (DLSScaleConfig)this.device.getConfiguration();
                    if (oConfig != null) {
                        if (oConfig.getMetricWeightMode()) {
                            this.nMaxWeight = oConfig.getFiveDigitWeight() ? 15000 : 1500;
                            this.nWeightUnit = 2;
                            this.bMetricMode = true;
                        } else {
                            this.nMaxWeight = oConfig.getFiveDigitWeight() ? 30000 : 3000;
                            this.nWeightUnit = 4;
                            this.bMetricMode = false;
                        }
                    }
                }
            }
        }
        m_log.trace("getDeviceServiceDescription (out): " + str);
        return str;
    }

    @Override
    public int getDeviceServiceVersion() throws JposException {
        m_log.trace("getDeviceServiceVersion (in)");
        if (this.isClosed()) {
            m_log.error("getDeviceServiceVersion: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getDeviceServiceVersion (out): " + Integer.toString(1014026));
        return 1014026;
    }

    public boolean getEnabled() {
        m_log.trace("getEnabled (in)");
        boolean enabled = false;
        if (this.device.getState() == DLSState.ENABLED) {
            enabled = true;
        }
        m_log.trace("getEnabled (out): " + Boolean.toString(enabled));
        return enabled;
    }

    @Override
    public boolean getFreezeEvents() throws JposException {
        if (this.isClosed()) {
            m_log.error("getFreezeEvents: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        return this.bFreezeEvents;
    }

    public static String[] getJPOSPIDs() {
        String[] returnStringArray = new String[10];
        try {
            Process process = Runtime.getRuntime().exec("jps -l");
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String output = reader.getResult();
            String[] parsed = output.split("\\s");
            boolean bStartFlag = false;
            int j = 0;
            for (int i = 0; i < parsed.length; ++i) {
                if (parsed[i].contains("jpos")) {
                    bStartFlag = true;
                }
                if (!bStartFlag || !parsed[i].contains("jpos")) continue;
                returnStringArray[j++] = parsed[i - 1];
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            m_log.error("getJPOSPIDs: Failed to get PIDs, " + e.getMessage());
            return new String[0];
        }
        return returnStringArray;
    }

    @Override
    public String getPhysicalDeviceDescription() throws JposException {
        m_log.trace("getPhysicalDeviceDescription (in)");
        if (this.isClosed()) {
            m_log.error("getPhysicalDeviceDescription: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        String str = "";
        if (this.device != null) {
            str = this.device.getDeviceInfo().getDeviceDescription();
        }
        m_log.trace("getPhysicalDeviceDescription (out): " + str);
        return str;
    }

    @Override
    public String getPhysicalDeviceName() throws JposException {
        m_log.trace("getPhysicalDeviceName (in)");
        if (this.isClosed()) {
            m_log.error("getPhysicalDeviceName: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        String str = "";
        if (this.device != null) {
            str = this.device.getDeviceInfo().getDeviceName();
        }
        m_log.trace("getPhysicalDeviceName (out): " + str);
        return str;
    }

    public String getPortName() {
        m_log.trace("getPortName (in)");
        String str = "";
        if (this.device != null) {
            str = this.device.getDeviceInfo().portName;
        }
        m_log.trace("getPortName (out): " + str);
        return str;
    }

    public int getPowerNotify() throws JposException {
        m_log.trace("getPowerNotify (in)");
        if (this.isClosed()) {
            m_log.error("getPowerNotify: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        String sPN = "";
        sPN = this.nPwrNotify == 1 ? "JPOS_PN_ENABLED" : "JPOS_PN_DISABLED";
        m_log.debug("getPowerNotify returns: " + sPN);
        m_log.trace("getPowerNotify (out): " + Integer.toString(this.nPwrNotify));
        return this.nPwrNotify;
    }

    public int getPowerState() throws JposException {
        return 2000;
    }

    private String getProcessId() {
        String sPID = "";
        int iPID = File.separatorChar == '\\' ? Kernel32.INSTANCE.GetCurrentProcessId() : CLibrary.INSTANCE.getpid();
        sPID = Integer.toString(iPID);
        if (sPID.isEmpty()) {
            sPID = "10000";
        }
        return sPID;
    }

    @Override
    public int getState() throws JposException {
        return this.deviceState;
    }

    public void getUsableStatistics(String[] statisticsBuffer) throws JposException {
        m_log.trace("getUsableStatistics (in)");
        if (!this.getCapStatisticsReporting()) {
            m_log.debug("no getUsableStatistics");
            m_log.trace("getUsableStatistics (out)");
            return;
        }
        ArrayList<String> items = new ArrayList<String>();
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed.");
        }
        try {
            HashMap<String, Object> table = this.device.getStatistics();
            if ((String)this.statistics.get("DeviceCategory") == null) {
                m_log.error("Error getting device category from statistical data of the device.");
                throw new JposException(111, "Device category unknown");
            }
            String pad = " ...........................";
            Set<String> keySet = table.keySet();
            ArrayList<String> keyArrayList = new ArrayList<String>(keySet);
            Collections.sort(keyArrayList);
            Enumeration<String> e = Collections.enumeration(keyArrayList);
            boolean bTest = false;
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                for (int i = 0; i < DLSJposConst.namesUPOS.size() && !(bTest = key.contains(DLSJposConst.namesUPOS.get(i))); ++i) {
                }
                if (!bTest) continue;
                String value = (String)table.get(key);
                items.add(key + "\t" + value);
                key = key + pad;
                m_log.debug("** Stats ** " + key.substring(0, 32) + " " + value);
                bTest = false;
            }
        }
        catch (DLSException ex) {
            m_log.error("Enumeration error: " + ex);
        }
        catch (NullPointerException npe) {
            m_log.error("NullPointerException: " + npe);
        }
        if (statisticsBuffer.length >= items.size()) {
            for (int i = 0; i < items.size(); ++i) {
                statisticsBuffer[i] = (String)items.get(i);
            }
        }
        m_log.trace("getUsableStatistics(out)");
    }

    public int getVersion() {
        return 1014026;
    }

    public static String getVersionString() {
        return APP_NAME + " " + VERSION + " (" + System.getProperty("os.arch") + "; " + System.getProperty("os.name") + (RELEASE.equals(RELEASE) ? "" : "; @RELEASE@") + ")";
    }

    private void initialize() {
        m_log.info("Device Service Version: " + DLSBaseService.getVersionString());
        for (Map.Entry<Object, Object> s : System.getProperties().entrySet()) {
            m_log.info(s.getKey() + ": " + s.getValue());
        }
    }

    public boolean isClosed() {
        return this.device.getState() == DLSState.CLOSED;
    }

    private void loadWMI() throws JposException {
        boolean bStats;
        m_log.trace("loadWMI (in)");
        DLSDeviceInfo oInfo = this.device.getDeviceInfo();
        if (File.separatorChar == '\\') {
            this.bWMIEnabled = this.config.getOptionAsBoolean("WMIEnabled");
            m_log.debug("loadWMI: WMI enabled - " + Boolean.toString(this.bWMIEnabled));
        }
        if (!(bStats = this.config.getOptionAsBoolean("canAcceptStatisticsCmd"))) {
            m_log.debug("loadWMI: Device does not accept Statistics command.");
        }
        if (this.bWMIEnabled && bStats) {
            DLSStatistics stats = DLSStatistics.getInstance();
            stats.loadWMI(this.statistics, this.wmiStatistics, this.lWMI);
        }
        this.bMBeansEnabled = this.config.getOptionAsBoolean("MBeansEnabled");
        m_log.debug("loadWMI: MBeans Enabled - " + Boolean.toString(this.bMBeansEnabled));
        if (this.bMBeansEnabled && bStats) {
            m_log.debug("loadWMI: MBeans and Statistics enabled.");
            String deviceDescription = oInfo.getDeviceDescription();
            if (!(null == deviceDescription || deviceDescription.equals("Scanner") && deviceDescription.equals("Scale"))) {
                m_log.debug("loadWMI: Populating MBeans table with " + deviceDescription);
                this.agent = new ScannerScaleAgent(this.wmiStatistics, deviceDescription);
                m_log.debug("loadWMI: Created agent instance.");
            } else {
                m_log.error("WMI and MBeans reporting is unavailable because device description must be \"Scanner\" or \"Scale\".");
                throw new JposException(111, "WMI and MBeans reporting is unavailable because device description must be \"Scanner\" or \"Scale\".");
            }
        }
        m_log.trace("loadWMI (out)");
    }

    protected void logOptions() {
        m_log.trace("logOptions (in)");
        DLSProperties oOpt = DLSProperties.getInstance();
        DLSProperties.SortedProperties props = oOpt.getProps();
        Enumeration e = oOpt.getPropsEnum();
        Branding oBr = Branding.getInstance();
        m_log.info(oBr.getBrandingPrefix() + ".properties entries: ");
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            m_log.info(key + ": " + props.getProperty(key));
        }
        m_log.trace("logOptions (out)");
    }

    @Override
    public void onDeviceError(int nErrorCode) {
        m_log.debug("In onDeviceError: " + nErrorCode);
    }

    @Override
    public void onDeviceStatus(int nStatusCode) {
        m_log.debug("In onDeviceStatus" + nStatusCode);
    }

    @Override
    public void onDirectIOData(int cmd, byte[] buf) {
        m_log.trace("onDirectIOData (in): " + cmd);
        try {
            if (buf != null && buf.length != 0) {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                bs.write(buf);
                this.evtCallback.fireDirectIOEvent(new DirectIOEvent(this, cmd, 0, bs));
            } else {
                m_log.error("onDirectIOData: buf size is zero/null");
            }
        }
        catch (IOException ioe) {
            m_log.error("Error writing to byte array output stream. ", (Throwable)ioe);
        }
        m_log.trace("onDirectIOData (out)");
    }

    @Override
    public void open(String logicalName, EventCallbacks cb) throws JposException {
        m_log.trace("open (in): " + logicalName);
        this.strLogicalName = logicalName;
        this.evtCallback = cb;
        this.deviceState = 2;
        m_log.trace("open (out)");
    }

    @Override
    public void release() throws JposException {
        m_log.trace("release (in)");
        DLSDeviceInfo oInfo = this.device.getDeviceInfo();
        String tempDir = this.options.getTempDir();
        if (!this.getClaimed()) {
            m_log.error("release: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        try {
            this.device.removeDirectIODataListener(this);
            this.device.removeDeviceStatusListener(this);
            this.device.removeDeviceErrorListener(this);
            this.device.release();
        }
        catch (DLSException e) {
            m_log.error("release: ", (Throwable)e);
            throw new JposException(111, e.getMessage());
        }
        this.notRun = true;
        Branding oBr = Branding.getInstance();
        String sProp = "com." + oBr.getBrandingPrefix() + ".jpos.service.ScannerService.useClaimLockFile";
        boolean useClaimLockFile = this.options.get(sProp, false);
        if (useClaimLockFile) {
            String bus = oInfo.getDeviceBus();
            int vid = oInfo.getVendorId();
            int pid = oInfo.getProductId();
            String lName = oInfo.getLogicalName();
            String claimLockFile = bus + vid + pid + lName + ".lock";
            File file = new File(tempDir + claimLockFile);
            if (!file.delete()) {
                m_log.error("release: Could not delete " + claimLockFile + " file");
            }
        }
        if (this.bWMIEnabled && this.agent != null) {
            this.agent.UnregisterAgent();
        }
        m_log.trace("release (out)");
    }

    public void resetStatistics(String statisticsBuffer) throws JposException {
        m_log.trace("resetStatistics (in)");
        if (!this.getCapStatisticsReporting()) {
            m_log.debug("CapStatisticsReporting is set to false. Resetting statistical data for this device is not permitted.");
            m_log.trace("resetStatistics (out)");
            return;
        }
        if (!this.getCapUpdateStatistics()) {
            m_log.debug("CapUpdateStatistics is set to false. Resetting statistical data for this device is not permitted.");
            m_log.trace("resetStatistics (out)");
            return;
        }
        if (!this.getClaimed()) {
            m_log.error("resetStatistics: 103 Device not claimed");
            m_log.trace("resetStatistics (out)");
            throw new JposException(103, "Device not claimed");
        }
        m_log.trace("resetStatistics (out)");
        throw new JposException(106, "resetStatistics Not supported");
    }

    public void retrieveScaleStatistics(String[] statisticsBuffer) throws JposException {
        m_log.trace("retrieveScaleStatistics (in)");
        if (!this.getCapStatisticsReporting()) {
            m_log.debug("no retrieveScaleStatistics");
            m_log.trace("retrieveScaleStatistics (out)");
            return;
        }
        if (!this.getClaimed()) {
            m_log.error("retrieveScaleStatistics: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        try {
            this.statistics = this.device.getStatistics();
            this.statistics.put("UnifiedPOSVersion", UPOS_VERSION);
            this.statistics.put("CapPowerReporting", this.getCapPowerReporting() == 2 ? "Advanced" : (this.getCapPowerReporting() == 1 ? "Standard" : "None"));
            this.statistics.put("CapStatisticsReporting", this.getCapStatisticsReporting());
            this.statistics.put("CapUpdateStatistics", this.getCapUpdateStatistics());
            this.statistics.put("CapCompareFirmwareVersion", this.getCapCompareFirmwareVersion());
            this.statistics.put("CapUpdateFirmware", this.getCapUpdateFirmware());
            String model = (String)this.statistics.get("ModelNumber");
            String serial = (String)this.statistics.get("SerialNumber");
            String firmware = (String)this.statistics.get("FirmwareVersionNumber");
            if (model == null) {
                model = "";
                this.statistics.put("SerialNumber", model);
            }
            if (serial == null) {
                serial = "";
                this.statistics.put("SerialNumber", serial);
            }
            if (firmware == null) {
                firmware = "";
                this.statistics.put("FirmwareVersionNumber", firmware);
            }
            String ver = Integer.toString(this.getDeviceServiceVersion());
            String controlVersion = Integer.valueOf(ver.substring(0, 1)) + "." + Integer.valueOf(ver.substring(1, 4));
            String sServiceVersion = Integer.valueOf(ver.substring(0, 1)) + "." + Integer.valueOf(ver.substring(1, 4)) + "." + Integer.valueOf(ver.substring(5, 7));
            this.statistics.put("ServiceVersion", sServiceVersion);
            float fcv = Float.valueOf(controlVersion.trim()).floatValue();
            int cv = (int)(fcv * 100000.0f);
            this.statistics.put("ControlVersion", cv);
            m_log.trace("retrieveScaleStatistics (out)");
        }
        catch (DLSException dlse) {
            m_log.error("retrieveStatistics: ", (Throwable)dlse);
            throw new JposException(106, dlse.getMessage());
        }
        m_log.trace("retrieveScaleStatistics (out)");
    }

    public void retrieveStatistics(String[] statisticsBuffer) throws JposException {
        String str;
        m_log.trace("retrieveStatistics (in)");
        DLSDeviceInfo oInfo = this.device.getDeviceInfo();
        if (!this.getCapStatisticsReporting()) {
            m_log.debug("CapStatisticsReporting is set to false.");
            m_log.trace("retrieveStatistics (out)");
            return;
        }
        if (!this.getClaimed()) {
            m_log.error("retrieveStatistics: 101 Device not claimed.");
            m_log.trace("retrieveStatistics (out)");
            throw new JposException(103, "Device not claimed");
        }
        String[] myLocalStatisticsBuffer = new String[100];
        if (statisticsBuffer[0].contains(",")) {
            myLocalStatisticsBuffer = this.commaSeparatedStringToStringArray(statisticsBuffer[0]);
        }
        if ((str = this.device.getDeviceInfo().getProductDescription()).contains("Scanner") && !this.getCapStatisticsReporting()) {
            this.getUsableStatistics(myLocalStatisticsBuffer);
            m_log.trace("retrieveStatistics (out)");
            return;
        }
        if (statisticsBuffer[0].equals("R_")) {
            this.getUsableStatistics(myLocalStatisticsBuffer);
            m_log.trace("retrieveStatistics (out)");
            return;
        }
        if (statisticsBuffer[0].equals("W_")) {
            this.getUsableStatistics(myLocalStatisticsBuffer);
            m_log.trace("retrieveStatistics (out)");
            return;
        }
        try {
            this.statistics = this.device.getStatistics(this.getDeviceEnabled());
        }
        catch (DLSException e) {
            try {
                this.statistics = this.device.getStatistics();
            }
            catch (DLSException dlse) {
                m_log.error("retrieveStatistics: 106 ", (Throwable)dlse);
                m_log.trace("retrieveStatistics (out)");
                throw new JposException(106, dlse.getMessage());
            }
        }
        if (this.statistics.containsKey("DeviceCategory") && null == (String)this.statistics.get("DeviceCategory")) {
            m_log.error("retrieveStatistics: 111Error getting device category from device statistical data.");
            throw new JposException(111, "Device category unknown");
        }
        this.completeStatistics();
        DLSStatistics stats = DLSStatistics.getInstance();
        stats.logStatistics(this.statistics);
        stats.buildXMLString(this.statistics, this.scannerInfo, statisticsBuffer, myLocalStatisticsBuffer);
        this.loadWMI();
        Branding oBr = Branding.getInstance();
        String sPre = oBr.getBrandingPrefix();
        String sProp = "com." + sPre + ".jpos.common.ScannerService.ScannerInfoFilename";
        String scannerInfoFilename = oInfo.getDeviceClass() + "_" + this.options.get(sProp, "info") + ".txt";
        sProp = "com." + sPre + ".jpos.common.ScannerService.AvalancheEnabled";
        boolean avalancheEnabled = this.options.get(sProp, false);
        stats.scannerInfoFile(this.statistics, scannerInfoFilename, avalancheEnabled);
        this.scannerInfo.clear();
        m_log.trace("retrieveStatistics (out)");
    }

    protected void sendDataEvent() {
        m_log.debug("In sendDataEvent - should not be here");
    }

    @Override
    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        m_log.trace("setDeviceEnabled (in): " + deviceEnabled);
        DLSDeviceInfo oInfo = this.device.getDeviceInfo();
        if (!this.getClaimed()) {
            m_log.error("setDeviceEnabled: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        try {
            DLSSerialScanner serialScanner;
            this.deviceState = 3;
            if (deviceEnabled) {
                this.device.enable();
                if (this.bEnablePole) {
                    Branding oBr = Branding.getInstance();
                    String sPre = oBr.getBrandingPrefix();
                    String sProp1 = "com." + sPre + ".jpos.service.ScannerService.enableDisablePoleRate";
                    String sProp2 = "com." + sPre + ".jpos.service.ScannerService.enablePoleRate";
                    int usage = oInfo.getUsage();
                    int iRate = this.options.get(sProp1, this.options.get(sProp2, 1));
                    if (iRate != 0 && usage == 19200 && this.notRun) {
                        m_log.debug("Initializing scannerControl object for enable disable polling.");
                        scannerControl sc = new scannerControl();
                        sc.scannerEnableDisable();
                        this.notRun = false;
                    }
                }
            } else {
                this.device.disable();
            }
            this.deviceState = 2;
            boolean bCanNotifyPower = this.device.getConfiguration().getOptionAsBoolean("canNotifyPowerChange");
            if (this.getEnabled()) {
                this.sendDataEvent();
                if (bCanNotifyPower && this.category.contains("Scanner") && this.getPowerNotify() == 1) {
                    if (this.device instanceof DLSSerialScanner) {
                        serialScanner = (DLSSerialScanner)this.device;
                        if (serialScanner.findPort()) {
                            this.nPwrState = 2001;
                            this.onDeviceStatus(this.nPwrState);
                        }
                    } else if (this.device.doHealthCheck()) {
                        this.nPwrState = 2001;
                        this.onDeviceStatus(this.nPwrState);
                    }
                }
            } else {
                this.sendDataEvent();
                if (bCanNotifyPower && this.category.contains("Scanner") && this.getPowerNotify() == 1) {
                    if (this.device instanceof DLSSerialScanner) {
                        serialScanner = (DLSSerialScanner)this.device;
                        if (serialScanner.findPort()) {
                            this.nPwrState = 2000;
                            this.onDeviceStatus(this.nPwrState);
                        }
                    } else if (this.device.doHealthCheck()) {
                        this.nPwrState = 2000;
                        this.onDeviceStatus(this.nPwrState);
                    }
                }
            }
        }
        catch (DLSException e) {
            m_log.error("Error enabling/disabling device: ", (Throwable)e);
            throw new JposException(111, e.getMessage());
        }
        m_log.trace("setDeviceEnabled (out)");
    }

    public void setDeviceNumber(int deviceNum) throws JposException {
        m_log.trace("setDeviceNumber (in): " + deviceNum);
        DLSDeviceInfo oInfo = this.device.getDeviceInfo();
        if (!this.getClaimed()) {
            m_log.error("setDeviceNumber: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        this.deviceNumber = deviceNum;
        oInfo.deviceNumber = deviceNum;
        m_log.trace("setDeviceNumber (out)");
    }

    @Override
    public void setFreezeEvents(boolean freezeEvents) throws JposException {
        m_log.trace("setFreezeEvents (in): " + freezeEvents);
        if (this.isClosed()) {
            m_log.error("setFreezeEvents: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        this.bFreezeEvents = freezeEvents;
        if (!this.bFreezeEvents) {
            this.sendDataEvent();
        }
        m_log.trace("setFreezeEvents (out)");
    }

    public void setPowerNotify(int powerNotify) throws JposException {
        m_log.trace("setPowerNotify (in): " + powerNotify);
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        if (this.getEnabled()) {
            throw new JposException(106, "Device enabled");
        }
        this.nPwrNotify = powerNotify;
        String sPN = "";
        sPN = this.nPwrNotify == 1 ? "JPOS_PN_ENABLED" : "JPOS_PN_DISABLED";
        m_log.debug("setPowerNotify to: " + sPN);
        m_log.trace("setPowerNotify (out)");
    }

    public void updateFirmware(String firmwareFileName) throws JposException {
        m_log.trace("updateFirmware (in): " + firmwareFileName);
        if (!this.getClaimed()) {
            m_log.error("updateFirmware: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            m_log.error("updateFirmware: 105 Device not enabled");
            throw new JposException(105, "Device not enabled");
        }
        m_log.trace("updateFirmware (out)");
    }

    public void updateStatistics(String statisticsBuffer) throws JposException {
        m_log.trace("updateStatistics (in)");
        if (!this.getCapStatisticsReporting()) {
            m_log.debug("no updateStatistics");
            m_log.trace("updateStatistics (out)");
            return;
        }
        if (!this.getClaimed()) {
            m_log.error("updateStatistics: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        m_log.trace("updateStatistics (out)");
        throw new JposException(106, "updateStatistics Not supported");
    }

    class scannerControl {
        private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

        scannerControl() {
        }

        public void scannerEnableDisable() {
            Runnable doIt = new Runnable(){

                @Override
                public void run() {
                    DLSState state = DLSBaseService.this.device.getState();
                    boolean claimed = state == DLSState.CLAIMED || state == DLSState.ENABLED || state == DLSState.DISABLED;
                    if (!DLSBaseService.this.busyFlag && claimed) {
                        if (state == DLSState.ENABLED) {
                            try {
                                m_log.debug("scannerControl.run: Poll enable");
                                DLSBaseService.this.device.enable();
                            }
                            catch (DLSException ex) {
                                m_log.error("scannerControl.run: Exception enabling device. ", (Throwable)ex);
                            }
                        } else {
                            try {
                                m_log.debug("scannerControl.run: Poll disable");
                                DLSBaseService.this.device.disable();
                            }
                            catch (DLSException ex) {
                                m_log.error("scannerControl.run: Exception disabling device. ", (Throwable)ex);
                            }
                        }
                    }
                }
            };
            Branding oBr = Branding.getInstance();
            String sPre = oBr.getBrandingPrefix();
            String sProp1 = "com." + sPre + ".jpos.service.ScannerService.enableDisablePoleRate";
            String sProp2 = "com." + sPre + ".jpos.service.ScannerService.enablePoleRate";
            int iRate = DLSBaseService.this.options.get(sProp1, DLSBaseService.this.options.get(sProp2, 1));
            ScheduledFuture<?> doItHandle = this.scheduler.scheduleAtFixedRate(doIt, iRate, iRate, TimeUnit.SECONDS);
        }
    }

    public class SimpleTask
    extends TimerTask {
        @Override
        public void run() {
            if (!DLSBaseService.this.busyFlag) {
                if (DLSBaseService.this.getEnabled()) {
                    try {
                        DLSBaseService.this.device.enable();
                    }
                    catch (DLSException ex) {
                        m_log.error("SimpleTask.run: Exception enabling device. ", (Throwable)ex);
                    }
                } else {
                    try {
                        DLSBaseService.this.device.disable();
                    }
                    catch (DLSException ex) {
                        m_log.error("SimpleTask.run: Exception disabling device. ", (Throwable)ex);
                    }
                }
            }
        }
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw = new StringWriter();

        public StreamReader(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException e) {
                m_log.error("StreamReader.run: I/O Exception - ", (Throwable)e);
            }
        }

        public String getResult() {
            return this.sw.toString();
        }
    }

    private static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);

        public int getpid();
    }
}

