/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.service;

import com.dls.jpos.common.Branding;
import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSObjectFactory;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.FunctionLib;
import com.dls.jpos.interpretation.DLSPortalScanner;
import com.dls.jpos.interpretation.DLSScanner;
import com.dls.jpos.interpretation.DLSUSBFlash;
import com.dls.jpos.interpretation.ItemReceivedListener;
import com.dls.jpos.interpretation.LabelReceivedListener;
import com.dls.jpos.interpretation.SystemDataReceivedListener;
import com.dls.jpos.service.DLSBaseService;
import com.dls.jpos.service.ScannerScaleAgent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import jpos.JposException;
import jpos.ScannerConst;
import jpos.events.DataEvent;
import jpos.events.ErrorEvent;
import jpos.events.StatusUpdateEvent;
import jpos.services.EventCallbacks;
import jpos.services.PortalScannerService114;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSPortalScannerService
extends DLSBaseService
implements PortalScannerService114,
ItemReceivedListener,
LabelReceivedListener,
SystemDataReceivedListener,
ScannerConst {
    protected static final int nDelayTimeout = 30000;
    protected boolean bAutoDisable = false;
    protected boolean bDataEventEnabled = true;
    protected boolean bDecodeData = true;
    protected DLSScanner scanner = null;
    protected DLSUSBFlash flash = null;
    protected DLSDeviceInfo flashdi = new DLSDeviceInfo();
    protected boolean bUSB = false;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Logger m_log = LogManager.getLogger(DLSPortalScannerService.class);
    LabelData currentLabelData = null;
    ItemData currentItemData = null;
    SystemData currentSystemData = null;
    LinkedList<EventData> listData = null;

    @Override
    public int getDeviceNumber() throws JposException {
        return this.deviceNumber;
    }

    @Override
    public void setDeviceNumber(int i) throws JposException {
        this.deviceNumber = i;
    }

    @Override
    public int getPowerState() throws JposException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void open(String logicalName, EventCallbacks cb) throws JposException {
        m_log.trace("open (in): " + logicalName);
        super.open(logicalName, cb);
        this.bDecodeData = true;
        this.bFreezeEvents = false;
        this.listData = new LinkedList();
        try {
            this.device = DLSObjectFactory.createScanner(logicalName);
            this.scanner = (DLSPortalScanner)this.device;
            this.device.open(logicalName);
        }
        catch (Exception e) {
            m_log.error("Error creating scanner object ", (Throwable)e);
            throw new JposException(104, "Service creation error");
        }
        m_log.trace("open (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void claim(int lTimeout) throws JposException {
        m_log.trace("claim (in): " + Integer.toString(lTimeout));
        super.claim(lTimeout);
        String[] temp = new String[]{""};
        String tempDir = this.options.getTempDir();
        this.scanner.addLabelReceivedListener(this);
        this.scanner.addItemReceivedListener(this);
        this.scanner.addSystemDataReceivedListener(this);
        this.listData.clear();
        DLSCConfig dConfig = this.scanner.getConfiguration();
        DLSDeviceInfo info = this.scanner.getDeviceInfo();
        this.sDecodeType = info.getOption("decodeType");
        boolean bCanAcceptStats = dConfig.getOptionAsBoolean("canAcceptStatisticsCmd");
        DLSProperties oOpt = DLSProperties.getInstance();
        boolean bGetStatsOnClaim = false;
        Branding oBr = Branding.getInstance();
        String sProp = "com." + oBr.getBrandingPrefix() + ".jpos.common.ScannerService.generateStatsOnEveryClaim";
        bGetStatsOnClaim = oOpt.get(sProp, true);
        if (bCanAcceptStats && bGetStatsOnClaim) {
            super.retrieveStatistics(temp);
        }
        if (this.bWMIEnabled && bCanAcceptStats) {
            boolean success;
            String scannerTempFilename = "scanner_temp.txt";
            String scaleTempFilename = "scale_temp.txt";
            BufferedWriter output = null;
            BufferedReader in = null;
            StringBuilder oSb = new StringBuilder();
            if (tempDir.length() > 0) {
                scannerTempFilename = tempDir + scannerTempFilename;
                scaleTempFilename = tempDir + scaleTempFilename;
            }
            File scannerTempfile = new File(scannerTempFilename);
            File scaleTempfile = new File(scaleTempFilename);
            try {
                Enumeration e = Collections.enumeration(this.wmiStatistics.keySet());
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    Object value = this.wmiStatistics.get(key);
                    if (value == null) continue;
                    oSb.append(key);
                    oSb.append("=");
                    oSb.append(value.toString());
                    oSb.append("\n");
                }
                output = new BufferedWriter(new FileWriter(scannerTempfile));
                output.write(oSb.toString());
                FunctionLib.cleanup(output);
            }
            catch (IOException ex) {
                m_log.error("IOException: ", (Throwable)ex);
            }
            finally {
                FunctionLib.cleanup(output);
            }
            this.lWMI.CreateWMIScannerFile(this.wmiStatistics);
            if (scaleTempfile.exists()) {
                try {
                    String str;
                    in = new BufferedReader(new FileReader(scaleTempFilename));
                    while ((str = in.readLine()) != null) {
                        String[] result = str.split("=");
                        if (result.length == 1) {
                            this.wmiStatistics.put(result[0], "0");
                            continue;
                        }
                        this.wmiStatistics.put(result[0], result[1]);
                    }
                }
                catch (IOException ex) {
                    try {
                        m_log.error("IOException: ", (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        FunctionLib.cleanup(in);
                        throw throwable;
                    }
                    FunctionLib.cleanup(in);
                }
                FunctionLib.cleanup(in);
            }
            if (scannerTempfile.exists() && scaleTempfile.exists()) {
                this.lWMI.CreateWMIScaleFile(this.wmiStatistics);
            }
            if (!(success = new File(scannerTempFilename).delete())) {
                m_log.warn("Could not delete scanner temp file: " + scannerTempFilename);
            }
            if (!(success = new File(scaleTempFilename).delete())) {
                m_log.warn("Could not delete scale temp file: " + scaleTempFilename);
            }
        }
        if (this.bMBeansEnabled & bCanAcceptStats) {
            this.agent = new ScannerScaleAgent(this.wmiStatistics, "Scanner");
        }
        m_log.trace("claim (out)");
    }

    @Override
    public void release() throws JposException {
        m_log.trace("release (in)");
        this.scanner.removeItemReceivedListener(this);
        this.scanner.removeLabelReceivedListener(this);
        if (this.bWMIEnabled && this.agent != null) {
            this.agent.UnregisterAgent();
        }
        super.release();
        m_log.trace("release (out)");
    }

    protected void releaseFlash() {
    }

    @Override
    public boolean getCapCompareFirmwareVersion() throws JposException {
        boolean bRes = false;
        m_log.trace("getCapCompareFirmwareVersion (in)");
        if (this.isClosed()) {
            m_log.error("getCapCompareFirmwareVersion: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        bRes = this.scanner.getCanCompareFirmwareVersion();
        m_log.trace("getCapCompareFirmwareVersion (out): " + Boolean.toString(bRes));
        return bRes;
    }

    @Override
    public boolean getCapUpdateFirmware() throws JposException {
        boolean bRes = false;
        m_log.trace("getCapUpdateFirmware (in)");
        if (this.isClosed()) {
            m_log.error("getCapUpdateFirmware: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        bRes = this.scanner.getCanUpdateFirmware();
        m_log.trace("getCapUpdateFirmware (out): " + Boolean.toString(bRes));
        return bRes;
    }

    @Override
    public boolean getAutoDisable() throws JposException {
        m_log.trace("getAutoDisable (in)");
        if (this.isClosed()) {
            m_log.error("getAutoDisable: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getAutoDisable (out): " + Boolean.toString(this.bAutoDisable));
        return this.bAutoDisable;
    }

    @Override
    public void setAutoDisable(boolean autoDisable) throws JposException {
        m_log.trace("setAutoDisable (in): " + Boolean.toString(autoDisable));
        if (this.isClosed()) {
            m_log.error("setAutoDisable: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        this.bAutoDisable = autoDisable;
        m_log.trace("setAutoDisable (out)");
    }

    @Override
    public int getDataCount() throws JposException {
        int iCt = 0;
        m_log.trace("getDataCount (in)");
        if (this.isClosed()) {
            m_log.error("getDataCount: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        iCt = this.listData.size();
        m_log.trace("getDataCount (out): " + Integer.toString(iCt));
        return iCt;
    }

    @Override
    public boolean getDataEventEnabled() throws JposException {
        m_log.trace("getDataEventEnabled (in)");
        if (this.isClosed()) {
            m_log.error("getDataEventEnabled: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getDataEventEnabled (out): " + Boolean.toString(this.bDataEventEnabled));
        return this.bDataEventEnabled;
    }

    @Override
    public void setDataEventEnabled(boolean dataEventEnabled) throws JposException {
        m_log.trace("setDataEventEnabled (in): " + Boolean.toString(dataEventEnabled));
        if (this.isClosed()) {
            m_log.error("setDataEventEnabled: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        this.bDataEventEnabled = dataEventEnabled;
        if (dataEventEnabled && this.getClaimed() && !this.getFreezeEvents()) {
            this.sendDataEvent();
        }
        m_log.trace("setDataEventEnabled (out)");
    }

    @Override
    public boolean getDecodeData() throws JposException {
        if (this.isClosed()) {
            m_log.error("getDecodeData: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        return this.bDecodeData;
    }

    @Override
    public void setDecodeData(boolean decodeData) throws JposException {
        m_log.trace("setDecodeData (in): " + Boolean.toString(decodeData));
        if (this.isClosed()) {
            m_log.error("setDecodeData: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        this.bDecodeData = decodeData;
        m_log.trace("setDecodeData (out)");
    }

    @Override
    public byte[] getScanData() throws JposException {
        m_log.trace("getScanData (in)");
        if (this.isClosed()) {
            m_log.error("getScanData: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        if (this.currentLabelData != null) {
            m_log.debug("getScanData: " + new String(this.currentLabelData.rawLabel));
            m_log.trace("getScanData (out): " + new String(this.currentLabelData.rawLabel));
            return this.currentLabelData.rawLabel;
        }
        m_log.trace("getScanData (out): null");
        return EMPTY_BYTE_ARRAY;
    }

    @Override
    public byte[] getScanDataLabel() throws JposException {
        m_log.trace("getScanDataLabel (in)");
        if (this.isClosed()) {
            m_log.error("getScanDataLabel: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        if (this.getDecodeData()) {
            m_log.debug("getScanDataLabel: " + new String(this.currentLabelData.decodedLabel));
            m_log.trace("getScanDataLabel (out)");
            return this.currentLabelData.decodedLabel;
        }
        m_log.debug("getScanDataLabel: getDecodedData returned false");
        m_log.trace("getScanDataLabel (out)");
        byte[] b = new byte[]{};
        return b;
    }

    @Override
    public int getScanDataType() throws JposException {
        m_log.trace("getScanDataType (in)");
        if (this.isClosed()) {
            m_log.error("getScanDataType: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        if (this.getDecodeData()) {
            m_log.debug("getScanDataType: " + this.currentLabelData.nType);
            m_log.trace("getScanDataType (out): " + Integer.toString(this.currentLabelData.nType));
            return this.currentLabelData.nType;
        }
        m_log.debug("getScanDataType: getDecodeData returned false");
        m_log.trace("getScanDataType (out): " + Integer.toString(0));
        return 0;
    }

    @Override
    public byte[] getItemData() throws JposException {
        m_log.trace("getItemData (in)");
        if (this.isClosed()) {
            m_log.error("getItemData: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        if (this.currentItemData != null) {
            m_log.debug("getItemData: nType: " + this.currentItemData.nType + "  Data: " + new String(this.currentItemData.rawItemData));
        } else if (this.currentLabelData != null) {
            m_log.debug("getItemLabelData: nType: " + this.currentLabelData.nType + "  LabelData: " + new String(this.currentLabelData.rawLabel) + "  LabelDataMsg: " + new String(this.currentLabelData.rawLabelMsg));
        }
        if (this.currentItemData != null) {
            m_log.debug("getItemData: returning: " + new String(this.currentItemData.rawItemData));
            m_log.trace("getItemData (out)");
            return this.currentItemData.rawItemData;
        }
        if (this.currentLabelData != null) {
            m_log.debug("getItemLabelData: returning: " + new String(this.currentLabelData.rawLabel));
            m_log.trace("getItemData (out)");
            return this.currentLabelData.rawLabelMsg;
        }
        m_log.trace("getItemData (out)");
        return EMPTY_BYTE_ARRAY;
    }

    public byte[] getSystemData() throws JposException {
        m_log.trace("getSystemData (in)");
        if (this.isClosed()) {
            m_log.error("getSystemData: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        if (this.currentItemData != null) {
            m_log.debug("getSystemData: " + new String(this.currentSystemData.rawSystemData));
        }
        if (this.currentSystemData != null) {
            m_log.trace("getSystemData (out)");
            return this.currentSystemData.rawSystemData;
        }
        m_log.trace("getSystemData (out)");
        return EMPTY_BYTE_ARRAY;
    }

    @Override
    public void clearInput() throws JposException {
        m_log.trace("clearInput (in)");
        if (!this.getClaimed()) {
            m_log.error("clearInput: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        this.listData.clear();
        this.deviceState = 2;
        m_log.trace("clearInput (out)");
    }

    @Override
    public void clearInputProperties() throws JposException {
        m_log.trace("clearInputProperties (in)");
        if (!this.getClaimed()) {
            m_log.error("clearInputProperties: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        this.listData.clear();
        this.deviceState = 2;
        m_log.trace("clearInputProperties (out)");
    }

    @Override
    public void deleteInstance() throws JposException {
    }

    public byte[] expandUPCE(byte[] labelData) {
        byte[] newLabel = new byte[11];
        switch (labelData[6]) {
            case 48: 
            case 49: 
            case 50: {
                newLabel[0] = 48;
                newLabel[1] = labelData[1];
                newLabel[2] = labelData[2];
                newLabel[3] = labelData[6];
                newLabel[4] = 48;
                newLabel[5] = 48;
                newLabel[6] = 48;
                newLabel[7] = 48;
                newLabel[8] = labelData[3];
                newLabel[9] = labelData[4];
                newLabel[10] = labelData[5];
                break;
            }
            case 51: {
                newLabel[0] = 48;
                newLabel[1] = labelData[1];
                newLabel[2] = labelData[2];
                newLabel[3] = labelData[3];
                newLabel[4] = 48;
                newLabel[5] = 48;
                newLabel[6] = 48;
                newLabel[7] = 48;
                newLabel[8] = 48;
                newLabel[9] = labelData[4];
                newLabel[10] = labelData[5];
                break;
            }
            case 52: {
                newLabel[0] = 48;
                newLabel[1] = labelData[1];
                newLabel[2] = labelData[2];
                newLabel[3] = labelData[3];
                newLabel[4] = labelData[4];
                newLabel[5] = 48;
                newLabel[6] = 48;
                newLabel[7] = 48;
                newLabel[8] = 48;
                newLabel[9] = 48;
                newLabel[10] = labelData[5];
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                newLabel[0] = 48;
                newLabel[1] = labelData[1];
                newLabel[2] = labelData[2];
                newLabel[3] = labelData[3];
                newLabel[4] = labelData[4];
                newLabel[5] = labelData[5];
                newLabel[6] = 48;
                newLabel[7] = 48;
                newLabel[8] = 48;
                newLabel[9] = 48;
                newLabel[10] = labelData[6];
            }
        }
        return newLabel;
    }

    protected byte[] addCheckDigit(byte[] labelData) {
        int mult = 0;
        int sum = 0;
        for (int i = labelData.length - 1; i >= 0; --i) {
            mult = i % 2 != labelData.length % 2 ? 3 : 1;
            sum += (labelData[i] - 48) * mult;
        }
        if ((sum %= 10) != 0) {
            sum = 10 - sum;
        }
        byte[] newData = new byte[labelData.length + 1];
        System.arraycopy(labelData, 0, newData, 0, labelData.length);
        newData[labelData.length] = (byte)(sum + 48);
        return newData;
    }

    @Override
    public void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
    }

    int ProcessCall(String[] args) {
        int ret = 0;
        return ret;
    }

    @Override
    public void updateFirmware(String firmwareFileName) throws JposException {
    }

    protected void doUpdate(String sFilename) {
    }

    @Override
    public void onLabelReceived(byte[] inLabelMsg, byte[] decodedLabelData, int nType) {
        m_log.trace("onLabelReceived (in)");
        try {
            if (this.getAutoDisable()) {
                this.setDeviceEnabled(false);
            }
        }
        catch (JposException e) {
            m_log.error("onLabelReceived: JposException. ", (Throwable)e);
        }
        switch (nType) {
            case 102: {
                if (decodedLabelData.length >= 8) break;
                if (decodedLabelData.length < 7) {
                    m_log.error("Invalid UPCE Label length.");
                    break;
                }
                byte[] newLabel = this.expandUPCE(decodedLabelData);
                newLabel = this.addCheckDigit(newLabel);
                byte[] upceLabel = new byte[8];
                System.arraycopy(decodedLabelData, 0, upceLabel, 0, 7);
                upceLabel[7] = newLabel[11];
                decodedLabelData = upceLabel;
                break;
            }
            case 101: {
                if (decodedLabelData.length >= 12) break;
                decodedLabelData = this.addCheckDigit(decodedLabelData);
                break;
            }
            case 103: {
                if (decodedLabelData.length >= 8) break;
                decodedLabelData = this.addCheckDigit(decodedLabelData);
                break;
            }
            case 104: {
                if (decodedLabelData.length >= 13) break;
                decodedLabelData = this.addCheckDigit(decodedLabelData);
            }
        }
        byte[] rawLabelData = new byte[inLabelMsg.length - 16];
        System.arraycopy(inLabelMsg, 16, rawLabelData, 0, inLabelMsg.length - 16);
        this.listData.addLast(new LabelData(rawLabelData, decodedLabelData, nType, inLabelMsg));
        m_log.debug("Label: " + new String(decodedLabelData) + "  List size: " + this.listData.size());
        this.sendDataEvent();
        m_log.trace("onLabelReceived (out)");
    }

    @Override
    public void onItemReceived(byte[] rawItemData) {
        m_log.trace("onItemReceived (in): " + new String(rawItemData));
        try {
            if (this.getAutoDisable()) {
                this.setDeviceEnabled(false);
            }
        }
        catch (JposException e) {
            m_log.error("onItemReceived: JposException. ", (Throwable)e);
        }
        this.listData.addLast(new ItemData(rawItemData, rawItemData.length));
        m_log.debug("Item: [" + rawItemData.length + "]");
        this.sendDataEvent();
        m_log.trace("onItemReceived (out)");
    }

    @Override
    public void onSystemDataReceived(byte[] rawSystemData) {
        m_log.trace("onSystemDataReceived (in): " + new String(rawSystemData));
        this.listData.addLast(new SystemData(rawSystemData, rawSystemData.length));
        m_log.debug("System: [" + rawSystemData.length + "]");
        this.sendDataEvent();
        m_log.trace("onSystemDataReceived (out)");
    }

    public void onErrorDataReceived(byte[] rawSystemData) {
        m_log.trace("onErrorDataReceived (in): " + new String(rawSystemData));
        this.listData.addLast(new SystemData(rawSystemData, rawSystemData.length));
        m_log.debug("Item: [" + rawSystemData.length + "]");
        this.sendDataEvent();
        m_log.trace("onErrorDataReceived (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendDataEvent() {
        m_log.trace("sendDataEvent (in)");
        try {
            LinkedList<EventData> linkedList = this.listData;
            synchronized (linkedList) {
                if (this.listData.size() != 0) {
                    this.bDataEventEnabled = true;
                    if (this.bDataEventEnabled && !this.bFreezeEvents) {
                        this.bDataEventEnabled = false;
                        EventData ed = this.listData.getFirst();
                        if (ed.nEventType == 2) {
                            this.currentLabelData = (LabelData)ed;
                            this.currentItemData = null;
                            this.listData.removeFirst();
                            m_log.debug("sendDataEvent for LabelData msg.  listData size: " + this.listData.size() + "  ed data: " + this.currentLabelData.rawLabel[0] + "," + this.currentLabelData.rawLabel[1] + "," + this.currentLabelData.rawLabel[2] + "," + this.currentLabelData.rawLabel[3] + "");
                            DataEvent de = new DataEvent(this.evtCallback.getEventSource(), 0);
                            this.evtCallback.fireDataEvent(de);
                        } else if (ed.nEventType == 3) {
                            this.currentItemData = (ItemData)ed;
                            this.listData.removeFirst();
                            m_log.debug("sendDataEvent for ItemEvent msg.  listData size: " + this.listData.size() + "  ed nType: " + this.currentItemData.nType + "  ed data: " + this.currentItemData.rawItemData[0]);
                            DataEvent de = new DataEvent(this.evtCallback.getEventSource(), 0);
                            this.evtCallback.fireDataEvent(de);
                        } else if (ed.nEventType == 4) {
                            this.currentSystemData = (SystemData)ed;
                            this.listData.removeFirst();
                            DataEvent de = new DataEvent(this.evtCallback.getEventSource(), 0);
                            this.evtCallback.fireDataEvent(de);
                        } else if (ed.nEventType == 1) {
                            this.listData.removeFirst();
                            ErrorData err = (ErrorData)ed;
                            m_log.debug("firingErrorEvent: " + err.nCode);
                            ErrorEvent errorEvent = new ErrorEvent(this, err.nCode, err.nExCode, err.nLocus, err.nResponse);
                            this.evtCallback.fireErrorEvent(errorEvent);
                            if (!this.isClosed()) {
                                this.deviceState = 2;
                            }
                            switch (errorEvent.getErrorResponse()) {
                                case 12: {
                                    m_log.error("Application error response: JPOS_ER_CLEAR");
                                    this.listData.clear();
                                    break;
                                }
                                case 13: {
                                    m_log.error("Application error response: JPOS_ER_CONTINUEINPUT");
                                    break;
                                }
                                case 11: {
                                    m_log.error("Application error response: JPOS_ER_RETRY");
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            m_log.warn("sendDataEvent Exception: " + e.getLocalizedMessage() + " but for PortalScanner this is OK");
        }
        m_log.trace("sendDataEvent (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueError(int nCode, int nExCode, int nLocus, int nResponse) {
        m_log.trace("enqueueError (in): " + Integer.toString(nCode) + ", " + Integer.toString(nExCode) + ", " + Integer.toString(nLocus) + ", " + Integer.toString(nResponse));
        LinkedList<EventData> linkedList = this.listData;
        synchronized (linkedList) {
            ErrorData err;
            if (this.listData.size() > 0 && nLocus != 1) {
                boolean bData = false;
                for (EventData ed : this.listData) {
                    if (ed.nEventType != 2) continue;
                    bData = true;
                    break;
                }
                if (bData) {
                    err = new ErrorData(nCode, nExCode, 3, 13);
                    this.listData.addFirst(err);
                }
            }
            err = new ErrorData(nCode, nExCode, nLocus, nResponse);
            this.listData.add(err);
        }
        this.sendDataEvent();
        m_log.trace("enqueueError (out)");
    }

    @Override
    public void onDeviceError(int nErrorCode) {
        m_log.trace("onDeviceError (in): " + Integer.toString(nErrorCode));
        this.deviceState = 4;
        switch (nErrorCode) {
            case -116: {
                this.enqueueError(107, -116, 2, 12);
                break;
            }
            case -113: {
                this.enqueueError(111, -113, 2, 12);
                break;
            }
            case -105: {
                this.enqueueError(111, -105, 2, 12);
                break;
            }
            case -111: {
                this.enqueueError(113, -111, 2, 13);
                break;
            }
            case -112: {
                this.enqueueError(113, -112, 2, 13);
                break;
            }
            case -115: {
                this.enqueueError(106, -115, 1, 13);
                break;
            }
            case -114: {
                this.enqueueError(106, -114, 1, 13);
                break;
            }
            case -100: {
                this.enqueueError(106, -100, 1, 13);
                break;
            }
            case -106: {
                this.enqueueError(106, -106, 1, 13);
                break;
            }
            case -121: {
                this.enqueueError(106, -121, 1, 13);
                break;
            }
            default: {
                this.deviceState = 2;
            }
        }
        m_log.trace("onDeviceError (out)");
    }

    @Override
    public void onDeviceStatus(int nStatusCode) {
        m_log.trace("onDeviceStatus (in): " + Integer.toString(nStatusCode));
        if (!this.bFreezeEvents) {
            try {
                this.evtCallback.fireStatusUpdateEvent(new StatusUpdateEvent(this, nStatusCode));
            }
            catch (Exception e) {
                m_log.error("onDeviceStatus: Exception. ", (Throwable)e);
            }
        }
        m_log.trace("onDeviceStatus (out)");
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw = new StringWriter();

        public StreamReader(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getResult() {
            return this.sw.toString();
        }
    }

    class SystemData
    extends EventData {
        protected byte[] rawSystemData;
        protected int nType;

        public SystemData(byte[] rawSystemData, int nType) {
            this.rawSystemData = rawSystemData;
            this.nType = nType;
            this.nEventType = 4;
        }
    }

    class ItemData
    extends EventData {
        protected byte[] rawItemData;
        protected int nType;

        public ItemData(byte[] rawItemData, int nType) {
            this.rawItemData = rawItemData;
            this.nType = nType;
            this.nEventType = 3;
        }
    }

    class LabelData
    extends EventData {
        protected byte[] rawLabel;
        protected byte[] decodedLabel;
        protected byte[] rawLabelMsg;
        protected int nType;

        public LabelData(byte[] rawLabel, byte[] decodedLabel, int nType, byte[] rawLabelMsg) {
            this.rawLabelMsg = rawLabelMsg;
            this.rawLabel = rawLabel;
            this.decodedLabel = decodedLabel;
            this.nType = nType;
            this.nEventType = 2;
        }
    }

    class ErrorData
    extends EventData {
        protected int nCode;
        protected int nExCode;
        protected int nLocus;
        protected int nResponse;

        public ErrorData(int nCode, int nExCode, int nLocus, int nResponse) {
            this.nCode = nCode;
            this.nExCode = nExCode;
            this.nEventType = 1;
            this.nLocus = nLocus;
            this.nResponse = nResponse;
        }
    }

    class EventData {
        protected int nEventType;
        protected static final int ERROR_EVENT = 1;
        protected static final int LABEL_EVENT = 2;
        protected static final int ITEM_EVENT = 3;
        protected static final int SYSTEM_DATA_EVENT = 4;

        EventData() {
        }
    }
}

