/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.service;

import java.lang.reflect.Constructor;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.loader.JposServiceInstance;
import jpos.loader.JposServiceInstanceFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSScaleInstanceFactory
implements JposServiceInstanceFactory {
    private static final Logger m_log = LogManager.getLogger(DLSScaleInstanceFactory.class);

    @Override
    public JposServiceInstance createInstance(String logicalName, JposEntry entry) throws JposException {
        m_log.trace("createInstance (in): " + logicalName);
        if (!entry.hasPropertyWithName("serviceClass")) {
            m_log.error("The JposEntry does not contain the 'serviceClass' property");
            throw new JposException(104, "The JposEntry does not contain the 'serviceClass' property");
        }
        JposServiceInstance serviceInstance = null;
        try {
            String serviceClassName = (String)entry.getPropertyValue("serviceClass");
            Class<?> serviceClass = Class.forName(serviceClassName);
            Class[] params = new Class[]{};
            Constructor<?> ctor = serviceClass.getConstructor(params);
            serviceInstance = (JposServiceInstance)ctor.newInstance(params);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            m_log.error("createInstance: Exception. ", (Throwable)e);
            throw new JposException(104, "Unable to instantiate the service instance");
        }
        m_log.trace("createInstance (out)");
        return serviceInstance;
    }
}

