/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.service;

import com.dls.jpos.common.Branding;
import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSObjectFactory;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSScaleConfig;
import com.dls.jpos.interpretation.DLSScale;
import com.dls.jpos.interpretation.WeightReceivedListener;
import com.dls.jpos.service.DLSBaseService;
import jpos.JposException;
import jpos.ScaleConst;
import jpos.events.DataEvent;
import jpos.events.ErrorEvent;
import jpos.events.StatusUpdateEvent;
import jpos.services.EventCallbacks;
import jpos.services.ScaleService114;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSScaleService
extends DLSBaseService
implements ScaleService114,
ScaleConst,
WeightReceivedListener {
    private static final int CMD_PENDING = -1;
    private static final int CMD_ABORT = -2;
    private static final int CMD_COMPLETE = -3;
    private static final int CMD_MOTION = -4;
    private static final int CMD_OVERWEIGHT = -5;
    private static final int CMD_ZERO = -6;
    private static final int CMD_AT_ZERO = -7;
    private static final int CMD_TIMEOUT = -8;
    private static final int CMD_UNDERZERO = -9;
    private static final int SCALE_IN_MOTION = 112;
    private static final int SCALE_NEEDS_ZEROING = 113;
    private static final int SCALE_AT_ZERO = 114;
    private static final int SCALE_OVERWEIGHT = 201;
    private static final int SCALE_UNDERZERO = 202;
    private static final int SCALE_READ_ERROR = 1;
    private static final int MAXIMUM_READ_TIMEOUT = 5000;
    private static final int DEFAULT_READ_TIMEOUT = 1000;
    private WeightData currentWeightData = new WeightData();
    private DLSScale scale = null;
    private boolean bAsyncMode = false;
    private boolean bAutoDisable = false;
    private int nTareWeight = 0;
    private long lUnitPrice = 0L;
    private boolean bDataEventEnabled = false;
    private final Object scaleResp = new Object();
    private boolean bExceptionOnMotion = false;
    private boolean bIsZeroValid = false;
    private boolean bCanAcceptStats = false;
    private static final Logger m_log = LogManager.getLogger(DLSScaleService.class);

    public DLSScaleService() {
        this.nMaxWeight = 30000;
        this.nWeightUnit = 4;
        this.bMetricMode = false;
    }

    @Override
    public void claim(int lTimeout) throws JposException {
        m_log.trace("claim (in): " + Integer.toString(lTimeout));
        super.claim(lTimeout);
        String[] temp = new String[]{""};
        this.scale.addWeightReceivedListener(this);
        DLSCConfig dConfig = this.scale.getConfiguration();
        this.bCanAcceptStats = dConfig.getOptionAsBoolean("canAcceptStatisticsCmd");
        if (this.bWMIEnabled && this.bCanAcceptStats) {
            super.retrieveScaleStatistics(temp);
            this.statistics.put("CapDisplayText", this.getCapDisplayText() ? "True" : "False");
            this.statistics.put("CapPriceCalculating", this.getCapPriceCalculating() ? "True" : "False");
            this.statistics.put("CapTareWeight", this.getCapTareWeight() ? "True" : "False");
            this.statistics.put("CapZeroScale", this.getCapZeroScale() ? "True" : "False");
            this.statistics.put("CapStatusUpdate", this.getCapStatusUpdate() ? "True" : "False");
        }
        try {
            if (!this.scale.isAlive()) {
                m_log.error("claim: No device communication");
                throw new JposException(106, "Error - no response from scale");
            }
        }
        catch (DLSException ex) {
            throw new JposException(106, ex.getMessage());
        }
        m_log.trace("claim (out)");
    }

    @Override
    public boolean getCapDisplay() throws JposException {
        m_log.trace("getCapDisplay (in)");
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getCapDisplay (out): false");
        return false;
    }

    @Override
    public boolean getCapStatusUpdate() throws JposException {
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        return this.scale.canStatusUpdate();
    }

    @Override
    public int getMaximumWeight() throws JposException {
        m_log.trace("getMaximumWeight (in)");
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getMaximumWeight (out): " + Integer.toString(this.nMaxWeight));
        return this.nMaxWeight;
    }

    @Override
    public int getPowerState() throws JposException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getScaleLiveWeight() throws JposException {
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        return this.scale.getLiveWeight();
    }

    @Override
    public int getStatusNotify() throws JposException {
        int iRes = 0;
        m_log.trace("getStatusNotify (in)");
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        iRes = this.scale.getStatusNotify();
        m_log.trace("getStatusNotify (out): " + Integer.toString(iRes));
        return iRes;
    }

    @Override
    public int getWeightUnit() throws JposException {
        m_log.trace("getWeightUnit (in)");
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getWeightUnit (out): " + Integer.toString(this.nWeightUnit));
        return this.nWeightUnit;
    }

    @Override
    public void open(String logicalName, EventCallbacks cb) throws JposException {
        m_log.trace("open (in): " + logicalName);
        super.open(logicalName, cb);
        Branding oBr = Branding.getInstance();
        try {
            DLSProperties oOpt = DLSProperties.getInstance();
            String sProp = "com." + oBr.getBrandingPrefix() + ".jpos.service.ScaleService.ThrowExceptionOnScaleMotion";
            this.bExceptionOnMotion = oOpt.get(sProp, false);
            this.device = DLSObjectFactory.createScale(logicalName);
            this.scale = (DLSScale)this.device;
            this.device.open(logicalName);
            this.bAsyncMode = false;
            this.bDataEventEnabled = false;
            DLSScaleConfig oConfig = (DLSScaleConfig)this.device.getConfiguration();
            if (oConfig != null) {
                if (oConfig.getMetricWeightMode()) {
                    this.nMaxWeight = oConfig.getFiveDigitWeight() ? 15000 : 1500;
                    this.nWeightUnit = 2;
                    this.bMetricMode = true;
                } else {
                    this.nMaxWeight = oConfig.getFiveDigitWeight() ? 30000 : 3000;
                    this.nWeightUnit = 4;
                    this.bMetricMode = false;
                }
            }
        }
        catch (DLSException e) {
            m_log.error("open: DLSException. ", (Throwable)e);
            throw new JposException(111, e.getMessage());
        }
        m_log.trace("open (out)");
    }

    @Override
    public void release() throws JposException {
        m_log.trace("release (in)");
        this.scale.removeWeightReceivedListener(this);
        if (this.bMBeansEnabled & this.bCanAcceptStats) {
            this.agent.UnregisterAgent();
        }
        super.release();
        m_log.trace("release (out)");
    }

    @Override
    public void setStatusNotify(int nValue) throws JposException {
        m_log.trace("setStatusNotify (in): " + Integer.toString(nValue));
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        if (!this.getCapStatusUpdate()) {
            throw new JposException(106, "Capability not available");
        }
        if (this.getDeviceEnabled()) {
            throw new JposException(106, "Device is enabled");
        }
        this.scale.setStatusNotify(nValue);
        m_log.trace("setStatusNotify (out)");
    }

    protected void getWeight() throws JposException {
        m_log.trace("getWeight (in)");
        try {
            if (this.bMetricMode) {
                this.scale.readMetricWeight();
            } else {
                this.scale.readEnglishWeight();
            }
        }
        catch (DLSException e) {
            m_log.error("getWeight: DLSException. ", (Throwable)e);
            throw new JposException(111, e.getMessage());
        }
        m_log.trace("getWeight (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getWeightAsync(int nTimeout) throws JposException {
        m_log.trace("getWeightAsync (in): " + Integer.toString(nTimeout));
        WeightData weightData = this.currentWeightData;
        synchronized (weightData) {
            long currTime = System.currentTimeMillis();
            if (this.currentWeightData.nEndTime > currTime && this.currentWeightData.nState == -1) {
                throw new JposException(113, "Read command pending");
            }
            this.currentWeightData.nEndTime = nTimeout > 0 ? currTime + (long)nTimeout : 0L;
            this.currentWeightData.nState = -1;
        }
        this.getWeight();
        m_log.trace("getWeightAsync (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getWeightSync(int[] weightData, int nTimeout) throws JposException {
        m_log.trace("getWeightSync (in): " + Integer.toString(nTimeout));
        WeightData weightData2 = this.currentWeightData;
        synchronized (weightData2) {
            int nWait = 5000;
            if (nTimeout == 0) {
                this.currentWeightData.bRetry = false;
                nWait = 1000;
            } else {
                this.currentWeightData.bRetry = true;
                if (nTimeout > 0 && nTimeout < 5000) {
                    nWait = nTimeout;
                }
            }
            this.currentWeightData.nState = -1;
            this.getWeight();
            try {
                this.currentWeightData.wait(nWait);
            }
            catch (InterruptedException e) {
                m_log.error("getWeightSync: Interrupted. ", (Throwable)e);
            }
            this.currentWeightData.bSendPending = false;
            weightData[0] = this.currentWeightData.nWeight;
            if (this.currentWeightData.nState != -3) {
                weightData[0] = 0;
                switch (this.currentWeightData.nState) {
                    case -1: {
                        this.currentWeightData.nState = -3;
                        throw new JposException(112, "Timeout on scale read");
                    }
                    case -3: {
                        break;
                    }
                    case -2: {
                        break;
                    }
                    case -6: {
                        m_log.warn("Scale Needs Zeroing - throwing exception: 113");
                        throw new JposException(113, "Scale needs zeroing");
                    }
                    case -7: {
                        m_log.warn("Scale at zero - throwing exception: 114");
                        throw new JposException(114, "Scale at zero");
                    }
                    case -4: {
                        m_log.warn("Scale in motion - throwing exception: 112");
                        throw new JposException(112, "Scale in motion");
                    }
                    case -5: {
                        m_log.warn("Scale over capacity - throwing exception: 201");
                        throw new JposException(201, "Scale over capacity");
                    }
                    case -9: {
                        m_log.warn("Scale under zero - throwing exception: 202");
                        throw new JposException(202, "Scale under zero");
                    }
                    default: {
                        throw new JposException(this.currentWeightData.nState, "Scale read error");
                    }
                }
            }
        }
        m_log.trace("getWeightSync (out)");
    }

    @Override
    public void readWeight(int[] weightData, int nTimeout) throws JposException {
        m_log.trace("readWeight (in): " + Integer.toString(nTimeout));
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        if (this.bAsyncMode) {
            this.getWeightAsync(nTimeout);
        } else {
            this.getWeightSync(weightData, nTimeout);
        }
        m_log.trace("readWeight (out)");
    }

    @Override
    public boolean getCapDisplayText() throws JposException {
        m_log.trace("getCapDisplayText (in)");
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getCapDisplayText (out): false");
        return false;
    }

    @Override
    public boolean getCapPriceCalculating() throws JposException {
        m_log.trace("getCapPriceCalculating (in)");
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getCapPriceCalculating (out): false");
        return false;
    }

    @Override
    public boolean getCapTareWeight() throws JposException {
        m_log.trace("getCapTareWeight (in)");
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        m_log.trace("getCapTareWeight (out): false");
        return false;
    }

    @Override
    public boolean getCapZeroScale() throws JposException {
        boolean bRes = false;
        m_log.trace("getCapZeroScale (in)");
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        bRes = this.scale.canZeroScale();
        m_log.trace("getCapZeroScale (out): " + Boolean.toString(bRes));
        return bRes;
    }

    @Override
    public boolean getAsyncMode() throws JposException {
        m_log.trace("getAsyncMode (in)");
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getAsyncMode (out): " + Boolean.toString(this.bAsyncMode));
        return this.bAsyncMode;
    }

    @Override
    public void setAsyncMode(boolean asyncMode) throws JposException {
        m_log.trace("setAsyncMode (in): " + Boolean.toString(asyncMode));
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        this.bAsyncMode = asyncMode;
        m_log.trace("setAsyncMode (out)");
    }

    @Override
    public boolean getAutoDisable() throws JposException {
        m_log.trace("getAutoDisable (in)");
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getAutoDisable (out): " + Boolean.toString(this.bAutoDisable));
        return this.bAutoDisable;
    }

    @Override
    public void setAutoDisable(boolean autoDisable) throws JposException {
        m_log.trace("setAutoDisable (in): " + Boolean.toString(autoDisable));
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        this.bAutoDisable = autoDisable;
        m_log.trace("setAutoDisable (out)");
    }

    @Override
    public int getDataCount() throws JposException {
        int iRes = 0;
        m_log.trace("getDataCount (in)");
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        iRes = this.currentWeightData.bSendPending ? 1 : 0;
        m_log.trace("getDataCount (out): " + Integer.toString(iRes));
        return iRes;
    }

    @Override
    public boolean getDataEventEnabled() throws JposException {
        m_log.trace("getDataEventEnabled (in)");
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getDataEventEnabled (out): " + Boolean.toString(this.bDataEventEnabled));
        return this.bDataEventEnabled;
    }

    @Override
    public void setDataEventEnabled(boolean dataEventEnabled) throws JposException {
        m_log.trace("setDataEventEnabled (in): " + Boolean.toString(dataEventEnabled));
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        this.bDataEventEnabled = dataEventEnabled;
        if (dataEventEnabled && this.getClaimed() && !this.getFreezeEvents()) {
            this.sendDataEvent();
        }
        m_log.trace("setDataEventEnabled (out)");
    }

    @Override
    public int getMaxDisplayTextChars() throws JposException {
        m_log.trace("getMaxDisplayTextChars (in)");
        if (this.isClosed()) {
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getMaxDisplayTextChars (out): 0");
        return 0;
    }

    @Override
    public long getSalesPrice() throws JposException {
        m_log.trace("getSalesPrice (in)");
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        m_log.trace("getSalesPrice (out): 0");
        return 0L;
    }

    @Override
    public int getTareWeight() throws JposException {
        m_log.trace("getTareWeight (in)");
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        m_log.trace("getTareWeight (out): " + Integer.toString(this.nTareWeight));
        return this.nTareWeight;
    }

    @Override
    public void setTareWeight(int tareWeight) throws JposException {
        m_log.trace("setTareWeight (in): " + Integer.toString(tareWeight));
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        this.nTareWeight = tareWeight;
        m_log.trace("setTareWeight (out)");
    }

    @Override
    public long getUnitPrice() throws JposException {
        m_log.trace("getUnitPrice (in)");
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        m_log.trace("getUnitPrice (out): " + Long.toString(this.lUnitPrice));
        return this.lUnitPrice;
    }

    @Override
    public void setUnitPrice(long unitPrice) throws JposException {
        m_log.trace("setUnitPrice (in): " + Long.toString(unitPrice));
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        this.lUnitPrice = unitPrice;
        m_log.trace("setUnitPrice (out)");
    }

    @Override
    public boolean getZeroValid() throws JposException {
        return this.scale.getZeroValid();
    }

    @Override
    public void setZeroValid(boolean zeroValid) throws JposException {
        this.scale.setZeroValid(zeroValid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearInput() throws JposException {
        m_log.trace("clearInput (in)");
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        WeightData weightData = this.currentWeightData;
        synchronized (weightData) {
            this.currentWeightData.nState = -2;
            this.currentWeightData.bSendPending = false;
            this.currentWeightData.nEndTime = 0L;
            this.currentWeightData.notifyAll();
        }
        m_log.trace("clearInput (out)");
    }

    @Override
    public void displayText(String data) throws JposException {
        m_log.trace("displayText (in): " + data);
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        m_log.trace("displayText (out)");
    }

    @Override
    public void zeroScale() throws JposException {
        m_log.trace("zeroScale (in)");
        if (!this.getClaimed()) {
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            throw new JposException(105, "Device not enabled");
        }
        if (this.scale.canZeroScale()) {
            try {
                this.scale.zeroScale();
            }
            catch (DLSException e) {
                m_log.error("zeroScale: DLSException. ", (Throwable)e);
                throw new JposException(111, e.getMessage());
            }
        } else {
            throw new JposException(106, "Zero scale not supported");
        }
        m_log.trace("zeroScale (out)");
    }

    @Override
    public void deleteInstance() throws JposException {
    }

    @Override
    public void onDeviceStatus(int nStatusCode) {
        if (this.scale.getStatusNotify() == 2) {
            this.evtCallback.fireStatusUpdateEvent(new StatusUpdateEvent(this.evtCallback.getEventSource(), nStatusCode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeviceError(int nErrorCode) {
        m_log.trace("onDeviceError (in): " + Integer.toString(nErrorCode));
        WeightData weightData = this.currentWeightData;
        synchronized (weightData) {
            if (nErrorCode == -101 || nErrorCode == -117) {
                if (this.bExceptionOnMotion) {
                    this.currentWeightData.nWeight = 0;
                    this.currentWeightData.nState = nErrorCode == -101 ? -4 : -7;
                    this.currentWeightData.bSendPending = false;
                    this.currentWeightData.bRetry = false;
                    this.currentWeightData.nEndTime = 0L;
                    this.currentWeightData.notifyAll();
                } else if (this.currentWeightData.nState == -1) {
                    if (this.bAsyncMode) {
                        long currTime = System.currentTimeMillis();
                        if (this.currentWeightData.nEndTime < currTime) {
                            this.currentWeightData.nState = -8;
                            this.currentWeightData.nEndTime = 0L;
                            return;
                        }
                    } else if (!this.currentWeightData.bRetry) {
                        this.currentWeightData.nWeight = 0;
                        this.currentWeightData.bSendPending = false;
                        this.currentWeightData.nEndTime = 0L;
                        this.currentWeightData.notifyAll();
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        m_log.error("onDeviceError: Interrupted. ", (Throwable)ie);
                    }
                    try {
                        this.getWeight();
                    }
                    catch (JposException jpe) {
                        this.currentWeightData.nState = 111;
                        this.currentWeightData.notifyAll();
                    }
                }
            } else {
                this.currentWeightData.nState = 111;
                switch (nErrorCode) {
                    case -100: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -100, 1, 12));
                        break;
                    }
                    case -102: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -102, 1, 12));
                        break;
                    }
                    case -103: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -103, 2, 12));
                        break;
                    }
                    case -104: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 107, -104, 2, 12));
                        break;
                    }
                    case -105: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -105, 2, 12));
                        break;
                    }
                    case -106: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -106, 1, 12));
                        break;
                    }
                    case -107: {
                        this.currentWeightData.nWeight = 0;
                        this.currentWeightData.nState = -5;
                        this.currentWeightData.bSendPending = false;
                        this.currentWeightData.nEndTime = 0L;
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 201, -107, 2, 12));
                        break;
                    }
                    case -118: {
                        this.currentWeightData.nWeight = 0;
                        this.currentWeightData.nState = -9;
                        this.currentWeightData.bSendPending = false;
                        this.currentWeightData.nEndTime = 0L;
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 202, -118, 2, 12));
                        break;
                    }
                    case -108: {
                        this.currentWeightData.nWeight = 0;
                        this.currentWeightData.nState = -6;
                        this.currentWeightData.bSendPending = false;
                        this.currentWeightData.nEndTime = 0L;
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -108, 2, 12));
                        break;
                    }
                    case -109: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -109, 2, 12));
                        break;
                    }
                    case -110: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 111, -110, 2, 12));
                        break;
                    }
                    case -116: {
                        this.evtCallback.fireErrorEvent(new ErrorEvent(this, 107, -116, 2, 12));
                    }
                }
                this.currentWeightData.notifyAll();
            }
        }
        m_log.trace("onDeviceError (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWeightReceived(int nWeight) {
        m_log.trace("onWeightReceived (in): " + Integer.toString(nWeight));
        try {
            if (this.getAutoDisable()) {
                this.setDeviceEnabled(false);
            }
        }
        catch (JposException e) {
            m_log.error("onWeightReceived: JposException. ", (Throwable)e);
        }
        WeightData weightData = this.currentWeightData;
        synchronized (weightData) {
            long currTime;
            this.currentWeightData.nWeight = nWeight;
            this.currentWeightData.nState = -3;
            this.currentWeightData.bSendPending = true;
            this.currentWeightData.bRetry = false;
            if (this.bAsyncMode && this.currentWeightData.nEndTime > 0L && this.currentWeightData.nEndTime < (currTime = System.currentTimeMillis())) {
                this.currentWeightData.nState = -8;
            }
            this.currentWeightData.nEndTime = 0L;
            this.currentWeightData.notifyAll();
        }
        if (this.bAsyncMode && this.currentWeightData.nState == -3) {
            this.sendDataEvent();
        }
        m_log.trace("onWeightReceived (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendDataEvent() {
        block5: {
            m_log.trace("sendDataEvent (in)");
            try {
                if (this.getDataCount() == 0 || !this.bDataEventEnabled || this.getFreezeEvents()) break block5;
                this.bDataEventEnabled = false;
                m_log.trace("Firing dataEvent");
                WeightData weightData = this.currentWeightData;
                synchronized (weightData) {
                    this.evtCallback.fireDataEvent(new DataEvent(this.evtCallback.getEventSource(), this.currentWeightData.nWeight));
                    this.currentWeightData.bSendPending = false;
                }
            }
            catch (JposException e) {
                m_log.error("sendDataEvent: JposException. ", (Throwable)e);
            }
        }
        m_log.trace("sendDataEvent (out)");
    }

    @Override
    public boolean getCapFreezeValue() throws JposException {
        m_log.trace("getCapFreezeValue (in)");
        if (this.isClosed()) {
            throw new JposException(101, "getCapFreezeValue() - Device not open");
        }
        m_log.trace("getCapFreezeValue (out): false");
        return false;
    }

    @Override
    public boolean getCapReadLiveWeightWithTare() throws JposException {
        m_log.trace("getCapReadLiveWeightWithTare (in)");
        if (this.isClosed()) {
            throw new JposException(101, "getCapReadLiveWeightWithTare() - Device not open");
        }
        m_log.trace("getCapReadLiveWeightWithTare (out): false");
        return false;
    }

    @Override
    public boolean getCapSetPriceCalculationMode() throws JposException {
        m_log.trace("getCapSetPriceCalculationMode (in)");
        if (this.isClosed()) {
            throw new JposException(101, "getCapSetPriceCalculationMode() - Device not open");
        }
        m_log.trace("getCapSetPriceCalculationMode (out): false");
        return false;
    }

    @Override
    public boolean getCapSetUnitPriceWithWeightUnit() throws JposException {
        m_log.trace("getCapSetUnitPriceWithWeightUnit (in)");
        if (this.isClosed()) {
            throw new JposException(101, "getCapSetUnitPriceWithWeightUnit() - Device not open");
        }
        m_log.trace("getCapSetUnitPriceWithWeightUnit (out): false");
        return false;
    }

    @Override
    public boolean getCapSpecialTare() throws JposException {
        m_log.trace("getCapSpecialTare (in)");
        if (this.isClosed()) {
            throw new JposException(101, "getCapSpecialTare() - Device not open");
        }
        m_log.trace("getCapSpecialTare (out): false");
        return false;
    }

    @Override
    public boolean getCapTarePriority() throws JposException {
        m_log.trace("getCapTarePriority (in)");
        if (this.isClosed()) {
            throw new JposException(101, "getCapTarePriority() - Device not open");
        }
        m_log.trace("getCapTarePriority (out): false");
        return false;
    }

    @Override
    public int getMinimumWeight() throws JposException {
        m_log.trace("getMinimumWeight (in)");
        if (this.isClosed()) {
            throw new JposException(101, "getMinimumWeight() - Device not open");
        }
        m_log.trace("getMinimumWeight (out): 0");
        return 0;
    }

    @Override
    public void doPriceCalculating(int[] ints, int[] ints1, long[] longs, long[] longs1, int[] ints2, int[] ints3, int[] ints4, long[] longs2, int i) throws JposException {
        throw new JposException(106, "doPriceCalculating() Not Supported");
    }

    @Override
    public void freezeValue(int i, boolean bln) throws JposException {
        throw new JposException(106, "freezeValue() - Device not open");
    }

    @Override
    public void readLiveWeightWithTare(int[] ints, int[] ints1, int i) throws JposException {
        throw new JposException(106, "readLiveWeightWithTare() Not Supported");
    }

    @Override
    public void setPriceCalculationMode(int i) throws JposException {
        throw new JposException(106, "setPriceCalculationMode() Not Supported");
    }

    @Override
    public void setSpecialTare(int i, int i1) throws JposException {
        throw new JposException(106, "setSpecialTare() Not Supported");
    }

    @Override
    public void setTarePrioity(int i) throws JposException {
        throw new JposException(106, "setTarePrioity() Not Supported");
    }

    @Override
    public void setUnitPriceWithWeightUnit(long l, int i, int i1, int i2) throws JposException {
        throw new JposException(106, "setUnitPriceWithWeightUnit() Not Supported");
    }

    private class WeightData {
        public int nWeight = 0;
        public int nState = -3;
        public boolean bSendPending = false;
        public long nEndTime = 0L;
        public boolean bRetry = false;

        private WeightData() {
        }
    }
}

