/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.service;

import com.dls.jpos.common.Branding;
import com.dls.jpos.common.DLSCConfig;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.common.DLSObjectFactory;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.FunctionLib;
import com.dls.jpos.common.LabelParser;
import com.dls.jpos.interpretation.DLSSCSerialScanner;
import com.dls.jpos.interpretation.DLSScanner;
import com.dls.jpos.interpretation.DLSUSBFlash;
import com.dls.jpos.interpretation.LabelReceivedListener;
import com.dls.jpos.service.DLSBaseService;
import com.dls.jpos.service.ScannerScaleAgent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import jpos.JposException;
import jpos.ScannerConst;
import jpos.events.DataEvent;
import jpos.events.ErrorEvent;
import jpos.events.StatusUpdateEvent;
import jpos.services.EventCallbacks;
import jpos.services.ScannerService114;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSScannerService
extends DLSBaseService
implements ScannerService114,
LabelReceivedListener,
ScannerConst {
    protected static final int nDelayTimeout = 30000;
    private boolean bAutoDisable = false;
    private boolean bDataEventEnabled = true;
    private boolean bDecodeData = true;
    private DLSScanner scanner = null;
    private DLSUSBFlash flash = null;
    private DLSDeviceInfo flashDeviceInfo = new DLSDeviceInfo();
    private boolean bUSB = false;
    private boolean bWaitOnScanner = true;
    private boolean bUpdateFirmwareStatus = false;
    private static String DLS_USB_FLASH = "DLS-USB-Flash";
    private static String fileNameFor8300 = "";
    private String localLogicalName = "";
    @Deprecated
    public int nPowerState = 2000;
    private static final int THIRTY = 30000;
    private static final int SIXTY = 60000;
    private static final int SIX = 6000;
    private static final int ONE_TWENTY = 120000;
    private static final int ONE_EIGHTY = 180000;
    private static final Logger m_log = LogManager.getLogger(DLSScannerService.class);
    LabelData currentLabelData = null;
    ItemData currentItemData = null;
    SystemData currentSystemData = null;
    ErrorData currentErrorData = null;
    LinkedList<EventData> listData = null;

    public DLSScannerService() {
        String sFlash;
        Branding oBr = Branding.getInstance();
        DLS_USB_FLASH = sFlash = oBr.getBrandingPrefix().toUpperCase() + "-USB-Flash";
    }

    @Override
    public void open(String logicalName, EventCallbacks cb) throws JposException {
        m_log.trace("open (in): " + logicalName);
        super.open(logicalName, cb);
        this.localLogicalName = logicalName;
        this.bDecodeData = true;
        this.bFreezeEvents = false;
        this.listData = new LinkedList();
        try {
            this.device = DLSObjectFactory.createScanner(logicalName);
            this.scanner = (DLSScanner)this.device;
            m_log.debug("open: <-- Created in ScannerService.");
            this.device.open(logicalName);
        }
        catch (Exception e) {
            m_log.error("open: Error creating scanner object " + e.getMessage());
            throw new JposException(104, "Service creation error");
        }
        if (this.scanner.getCanUpdateFirmware()) {
            try {
                DLSDeviceInfo oInfo = this.device.getDeviceInfo();
                String bus = oInfo.getDeviceBus();
                if (bus.equals("USB") || bus.equals("HID")) {
                    this.bUSB = true;
                    this.flash = new DLSUSBFlash();
                    this.flash.open(DLS_USB_FLASH);
                    this.flashDeviceInfo = this.flash.getDeviceInfo();
                    this.flashDeviceInfo.setDeviceCategory(oInfo.getDeviceCategory());
                    this.flashDeviceInfo.setDeviceName(oInfo.getDeviceName());
                    this.flashDeviceInfo.setProductId(oInfo.getProductId());
                    this.flashDeviceInfo.setVendorId(oInfo.getVendorId());
                }
            }
            catch (Exception e) {
                m_log.error("open: The USB-Flash JposEntry must be included in your jpos.xml file for USB OEM devices.");
                throw new JposException(104, "Service creation error. " + e.getMessage());
            }
        }
        m_log.trace("open (out)");
    }

    @Override
    public void claim(int lTimeout) throws JposException {
        m_log.trace("claim (in): " + Integer.toString(lTimeout));
        super.claim(lTimeout);
        String[] temp = new String[]{""};
        this.scanner.addLabelReceivedListener(this);
        this.listData.clear();
        DLSDeviceInfo oInfo = this.device.getDeviceInfo();
        this.sDecodeType = oInfo.getOption("decodeType");
        boolean bCanAcceptStats = this.config.getOptionAsBoolean("canAcceptStatisticsCmd");
        this.options = DLSProperties.getInstance();
        boolean bGetStatsOnClaim = false;
        Branding oBr = Branding.getInstance();
        String sProp = "com." + oBr.getBrandingPrefix() + ".jpos.common.ScannerService.generateStatsOnEveryClaim";
        bGetStatsOnClaim = this.options.get(sProp, true);
        boolean bIHSOnClaim = this.config.getOptionAsBoolean("sendIHSOnClaim");
        if (bIHSOnClaim && bCanAcceptStats && bGetStatsOnClaim) {
            super.retrieveStatistics(temp);
        }
        if (System.getProperty("com.sun.management.jmxremote") != null) {
            m_log.debug("claim: jmxremote support is turned on.");
            this.bMBeansEnabled = this.config.getOptionAsBoolean("MBeansEnabled");
            m_log.debug("claim: MBeans enabled - " + Boolean.toString(this.bMBeansEnabled));
        } else {
            m_log.debug("claim: jmxremote support is turned off.");
        }
        if (bIHSOnClaim && this.bMBeansEnabled && bCanAcceptStats) {
            this.agent = new ScannerScaleAgent(this.wmiStatistics, "Scanner");
        }
        boolean bCanNotifyPower = this.config.getOptionAsBoolean("canNotifyPowerChange");
        int myPowerNotify = this.getMyPowerNotify();
        int nCapPowerReporting = this.getCapPowerReporting();
        if (bCanNotifyPower && nCapPowerReporting == 1 && myPowerNotify != 0) {
            this.setPowerState(2001);
        }
        HashMap<String, Object> configItems = this.config.mapConfigItems;
        if (this.category.toUpperCase().contains("SCANNER")) {
            boolean bCanAcceptConfigItems = this.config.getOptionAsBoolean("canAcceptConfigItems");
            boolean bCanProgramConfigOnClaim = this.config.getOptionAsBoolean("canProgramConfigOnClaim");
            boolean bHasConfigItems = configItems.isEmpty();
            if (!bHasConfigItems && bCanAcceptConfigItems && bCanProgramConfigOnClaim) {
                try {
                    boolean bSuccess = this.loadConfigItems(configItems);
                    if (!bSuccess) {
                        m_log.error("claim: ERROR: could not load config items");
                    }
                }
                catch (Exception e) {
                    m_log.error("claim: ERROR: could not load config items", (Throwable)e);
                }
            }
        }
        m_log.trace("claim (out)");
    }

    @Override
    public void release() throws JposException {
        m_log.trace("release (in)");
        boolean bCanNotifyPower = this.config.getOptionAsBoolean("canNotifyPowerChange");
        int myPowerNotify = this.getMyPowerNotify();
        int nCapPowerReporting = this.getCapPowerReporting();
        if (bCanNotifyPower && nCapPowerReporting == 1 && myPowerNotify != 0) {
            this.setPowerState(2004);
        }
        this.scanner.removeLabelReceivedListener(this);
        super.release();
        m_log.trace("release (out)");
    }

    protected void releaseFlash() {
        m_log.trace("releaseFlash (in)");
        try {
            if (this.flash != null) {
                this.flash.release();
            }
        }
        catch (DLSException e) {
            m_log.error("releaseFlash: Exception releasing flash device: ", (Throwable)e);
        }
        m_log.trace("releaseFlash (out)");
    }

    @Override
    public boolean getCapCompareFirmwareVersion() throws JposException {
        m_log.trace("getCapCompareFirmwareVersion (in)");
        boolean bRet = false;
        if (this.isClosed()) {
            m_log.error("getCapCompareFirmwareVersion: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        bRet = this.scanner.getCanCompareFirmwareVersion();
        m_log.trace("getCapCompareFirmwareVersion (out): " + Boolean.toString(bRet));
        return bRet;
    }

    public int getMyPowerNotify() {
        m_log.trace("getMyPowerNotify (in)");
        int retValue = 0;
        try {
            retValue = this.getPowerNotify();
        }
        catch (JposException ex) {
            m_log.error("getPowerNotify: ", (Throwable)ex);
        }
        m_log.trace("getMyPowerNotify (out): " + Integer.toString(retValue));
        return retValue;
    }

    @Override
    public int getPowerState() throws JposException {
        m_log.trace("getPowerState (in)");
        if (!this.getClaimed()) {
            m_log.error("getPowerState: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        String sPNState = "";
        switch (this.nPowerState) {
            case 2000: {
                sPNState = "JPOS_PS_UNKNOWN";
                break;
            }
            case 2003: {
                m_log.error("getPowerState() ERROR: JAVAPOS_SWCR_293 - JPOS_PS_OFFLINE Not Supported - returned JPOS_PS_OFF_OFFLINE instead.");
                sPNState = "JPOS_PS_OFF_OFFLINE";
                break;
            }
            case 2001: {
                sPNState = "JPOS_PS_ONLINE";
                break;
            }
            case 2004: {
                sPNState = "JPOS_PS_OFF_OFFLINE";
                break;
            }
            case 2002: {
                m_log.error("getPowerState() ERROR: JAVAPOS_SWCR_293 - JPOS_PS_OFF Not Supported - returned JPOS_PS_OFF_OFFLINE instead.");
                sPNState = "JPOS_PS_OFF_OFFLINE";
                break;
            }
            default: {
                sPNState = "JPOS_PS_UNKNOWN";
            }
        }
        m_log.debug("getPowerState reports: " + sPNState);
        m_log.trace("getPowerState (out): " + Integer.toString(this.nPowerState));
        return this.nPowerState;
    }

    public void setPowerState(int nPwrState) throws JposException {
        m_log.trace("setPowerState (in): " + Integer.toString(nPwrState));
        this.nPowerState = nPwrState;
        if (!this.getClaimed()) {
            m_log.error("setPowerState: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        String sPNState = "";
        switch (this.nPowerState) {
            case 2000: {
                sPNState = "JPOS_PS_UNKNOWN";
                break;
            }
            case 2003: {
                m_log.error("setPowerState() ERROR: JAVAPOS_SWCR_293 - JPOS_PS_OFFLINE Not Supported - set to JPOS_PS_OFF_OFFLINE instead.");
                sPNState = "JPOS_PS_OFF_OFFLINE";
                break;
            }
            case 2001: {
                sPNState = "JPOS_PS_ONLINE";
                break;
            }
            case 2004: {
                sPNState = "JPOS_PS_OFF_OFFLINE";
                break;
            }
            case 2002: {
                m_log.error("setPowerState() ERROR: JAVAPOS_SWCR_293 - JPOS_PS_OFF Not Supported - returned JPOS_PS_OFF_OFFLINE instead.");
                sPNState = "JPOS_PS_OFF_OFFLINE";
                break;
            }
            default: {
                sPNState = "JPOS_PS_UNKNOWN";
            }
        }
        this.nPwrState = this.nPowerState;
        m_log.debug("setPowerState reports: " + sPNState);
        m_log.trace("setPowerState (out)");
    }

    @Override
    public boolean getCapUpdateFirmware() throws JposException {
        boolean bRet = false;
        m_log.trace("getCapUpdateFirmware (in)");
        if (this.isClosed()) {
            m_log.error("getCapUpdateFirmware: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        bRet = this.scanner.getCanUpdateFirmware();
        m_log.trace("getCapUpdateFirmware (out): " + Boolean.toString(bRet));
        return bRet;
    }

    @Override
    public boolean getAutoDisable() throws JposException {
        m_log.trace("getAutoDisable (in)");
        if (this.isClosed()) {
            m_log.error("getAutoDisable: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getAutoDisable (out): " + Boolean.toString(this.bAutoDisable));
        return this.bAutoDisable;
    }

    @Override
    public void setAutoDisable(boolean autoDisable) throws JposException {
        m_log.trace("setAutoDisable (in): " + Boolean.toString(autoDisable));
        if (this.isClosed()) {
            m_log.error("setAutoDisable: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        this.bAutoDisable = autoDisable;
        m_log.trace("setAutoDisable (out)");
    }

    @Override
    public int getDataCount() throws JposException {
        int iRet = 0;
        m_log.trace("getDataCount (in)");
        if (this.isClosed()) {
            m_log.error("getDataCount: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        iRet = this.listData.size();
        m_log.trace("getDataCount (out): " + Integer.toString(iRet));
        return iRet;
    }

    @Override
    public boolean getDataEventEnabled() throws JposException {
        m_log.trace("getDataEventEnabled (in)");
        if (this.isClosed()) {
            m_log.error("getDataEventEnabled: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getDataEventEnabled (out): " + Boolean.toString(this.bDataEventEnabled));
        return this.bDataEventEnabled;
    }

    @Override
    public void setDataEventEnabled(boolean dataEventEnabled) throws JposException {
        m_log.trace("setDataEventEnabled (in): " + Boolean.toString(dataEventEnabled));
        this.bDataEventEnabled = dataEventEnabled;
        if (this.isClosed()) {
            m_log.error("setDataEventEnabled: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        if (dataEventEnabled && this.getClaimed() && !this.getFreezeEvents()) {
            this.sendDataEvent();
        }
        m_log.trace("setDataEventEnabled (out)");
    }

    @Override
    public boolean getDecodeData() throws JposException {
        m_log.trace("getDecodeData (in)");
        if (this.isClosed()) {
            m_log.error("getDecodeData: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        m_log.trace("getDecodeData (out): " + Boolean.toString(this.bDecodeData));
        return this.bDecodeData;
    }

    @Override
    public void setDecodeData(boolean decodeData) throws JposException {
        m_log.trace("setDecodeData (in): " + Boolean.toString(decodeData));
        if (this.isClosed()) {
            m_log.error("setDecodeData: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        this.bDecodeData = decodeData;
        m_log.trace("setDecodeData (out)");
    }

    @Override
    public byte[] getScanData() throws JposException {
        m_log.trace("getScanData (in)");
        if (this.isClosed()) {
            m_log.error("getScanData: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        if (this.currentLabelData != null) {
            String strRaw = new String(this.currentLabelData.rawLabel);
            m_log.debug("getScanData: " + strRaw);
            m_log.trace("getScanData (out): " + new String(this.currentLabelData.rawLabel));
            return this.currentLabelData.rawLabel;
        }
        m_log.trace("getScanData (out): empty");
        return new byte[0];
    }

    @Override
    public byte[] getScanDataLabel() throws JposException {
        m_log.trace("getScanDataLabel (in)");
        if (this.isClosed()) {
            m_log.error("getScanDataLabel: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        if (this.getDecodeData() && this.currentLabelData != null) {
            m_log.debug("getScanDataLabel: " + new String(this.currentLabelData.decodedLabel));
            m_log.trace("getScanDataLabel (out): " + new String(this.currentLabelData.decodedLabel));
            return this.currentLabelData.decodedLabel;
        }
        m_log.debug("getScanDataLabel: getDecodedData returned false");
        m_log.trace("getScanDataLabel (out): empty");
        return new byte[0];
    }

    @Override
    public int getScanDataType() throws JposException {
        m_log.trace("getScanDataType (in)");
        if (this.isClosed()) {
            m_log.error("getScanDataType: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        if (this.getDecodeData()) {
            if (this.currentLabelData != null) {
                m_log.debug("getScanDataType: " + this.currentLabelData.nType);
                LabelParser labelParser = LabelParser.getInstance();
                String sReadable = labelParser.convertToReadable(this.currentLabelData.nType);
                m_log.debug("getScanDataType: bar code type = " + sReadable);
                m_log.trace("getScanDataType (out): " + Integer.toString(this.currentLabelData.nType));
                return this.currentLabelData.nType;
            }
        } else {
            m_log.debug("getScanDataType: getDecodeData returned false");
        }
        m_log.trace("getScanDataType (out): " + Integer.toString(0));
        return 0;
    }

    public byte[] getItemData() throws JposException {
        m_log.trace("getItemData (in)");
        if (this.isClosed()) {
            m_log.error("getItemData: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        m_log.debug("getItemData: " + new String(this.currentItemData.rawItemData));
        m_log.trace("getItemData (out): " + new String(this.currentItemData.rawItemData));
        return this.currentItemData.rawItemData;
    }

    public byte[] getSystemData() throws JposException {
        m_log.trace("getSystemData (in)");
        if (this.isClosed()) {
            m_log.error("getSystemData: 101 Device not open");
            throw new JposException(101, "Device not open");
        }
        m_log.debug("getSystemData: " + new String(this.currentSystemData.rawSystemData));
        m_log.trace("getSystemData (out): " + new String(this.currentSystemData.rawSystemData));
        return this.currentSystemData.rawSystemData;
    }

    @Override
    public void clearInput() throws JposException {
        m_log.trace("clearInput (in)");
        if (!this.getClaimed()) {
            m_log.error("clearInput: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        this.deviceState = 2;
        this.listData.clear();
        m_log.trace("clearInput (out)");
    }

    @Override
    public void clearInputProperties() throws JposException {
        m_log.trace("clearInputProperties (in)");
        if (!this.getClaimed()) {
            m_log.error("clearInputProperties: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        this.listData.clear();
        this.deviceState = 2;
        m_log.trace("clearInputProperties (out)");
    }

    @Override
    public void deleteInstance() throws JposException {
    }

    protected byte[] expandUPCE(byte[] labelData) {
        byte[] newLabel = new byte[11];
        switch (labelData[6]) {
            case 48: 
            case 49: 
            case 50: {
                newLabel[0] = 48;
                newLabel[1] = labelData[1];
                newLabel[2] = labelData[2];
                newLabel[3] = labelData[6];
                newLabel[4] = 48;
                newLabel[5] = 48;
                newLabel[6] = 48;
                newLabel[7] = 48;
                newLabel[8] = labelData[3];
                newLabel[9] = labelData[4];
                newLabel[10] = labelData[5];
                break;
            }
            case 51: {
                newLabel[0] = 48;
                newLabel[1] = labelData[1];
                newLabel[2] = labelData[2];
                newLabel[3] = labelData[3];
                newLabel[4] = 48;
                newLabel[5] = 48;
                newLabel[6] = 48;
                newLabel[7] = 48;
                newLabel[8] = 48;
                newLabel[9] = labelData[4];
                newLabel[10] = labelData[5];
                break;
            }
            case 52: {
                newLabel[0] = 48;
                newLabel[1] = labelData[1];
                newLabel[2] = labelData[2];
                newLabel[3] = labelData[3];
                newLabel[4] = labelData[4];
                newLabel[5] = 48;
                newLabel[6] = 48;
                newLabel[7] = 48;
                newLabel[8] = 48;
                newLabel[9] = 48;
                newLabel[10] = labelData[5];
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                newLabel[0] = 48;
                newLabel[1] = labelData[1];
                newLabel[2] = labelData[2];
                newLabel[3] = labelData[3];
                newLabel[4] = labelData[4];
                newLabel[5] = labelData[5];
                newLabel[6] = 48;
                newLabel[7] = 48;
                newLabel[8] = 48;
                newLabel[9] = 48;
                newLabel[10] = labelData[6];
            }
        }
        return newLabel;
    }

    protected byte[] addCheckDigit(byte[] labelData) {
        int mult = 0;
        int sum = 0;
        for (int i = labelData.length - 1; i >= 0; --i) {
            mult = i % 2 != labelData.length % 2 ? 3 : 1;
            sum += (labelData[i] - 48) * mult;
        }
        if ((sum %= 10) != 0) {
            sum = 10 - sum;
        }
        byte[] newData = new byte[labelData.length + 1];
        System.arraycopy(labelData, 0, newData, 0, labelData.length);
        newData[labelData.length] = (byte)(sum + 48);
        return newData;
    }

    @Override
    public void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
        block59: {
            m_log.trace("compareFirmwareVersion (in): " + firmwareFileName);
            String scanVersion = "";
            String scanECVersion = "";
            String fileVersion = "";
            String FileECVersion = "";
            String VID = "";
            String PID = "";
            boolean bConfigOnly = false;
            int nScanVer = 0;
            int nScanECVer = 0;
            DLSDeviceInfo oInfo = this.device.getDeviceInfo();
            int fvid = this.SearchInFile("VID", firmwareFileName);
            int fpid = this.SearchInFile("PID", firmwareFileName);
            if (!this.getClaimed()) {
                m_log.error("compareFirmwareVersion: Device not claimed");
                throw new JposException(103, "Device not claimed");
            }
            if (!this.getDeviceEnabled()) {
                m_log.error("compareFirmwareVersion: Device not enabled");
                throw new JposException(105, "Device not enabled");
            }
            if (!this.scanner.getCanCompareFirmwareVersion()) {
                m_log.error("compareFirmwareVersion: Capability not available");
                throw new JposException(106, "getCanCompareFirmwareVersion not available for this device");
            }
            if (!this.scanner.hasStatisticsReporting()) {
                m_log.error("Exception: Statistical Reporting not available for this device.");
                throw new JposException(106, "Statistical Reporting Capability not available for this device.");
            }
            try {
                String[] temp = new String[]{""};
                this.retrieveStatistics(temp);
                if (null == this.statistics || 0 == this.statistics.size()) {
                    result[0] = 5;
                    throw new JposException(111, "Failed to compare (No statistical data returned). Does the device support i-h-s data?");
                }
            }
            catch (Exception e) {
                m_log.error("compareFirmwareVersion: ", (Throwable)e);
                throw new JposException(111, "Failed to read scanner version: " + e.getMessage());
            }
            if (!this.scanner.getDeviceInfo().get8xxx()) {
                try {
                    String sExt = firmwareFileName.substring(firmwareFileName.length() - 4, firmwareFileName.length());
                    String bus = oInfo.getDeviceBus();
                    if (bus.equals("USB") || bus.equals("HID")) {
                        if (sExt.compareToIgnoreCase(".DAT") != 0) {
                            m_log.error("compareFirmwareVersion: Bad file extension");
                            throw new JposException(114, 281, "Bad file extension");
                        }
                    } else if (sExt.compareToIgnoreCase(".S37") != 0) {
                        m_log.error("compareFirmwareVersion: Bad file extension");
                        throw new JposException(114, 281, "Bad file extension");
                    }
                }
                catch (StringIndexOutOfBoundsException e) {
                    m_log.error("compareFirmwareVersion: Bad file name");
                    throw new JposException(114, 281, "Bad firmware file name");
                }
                File fileFirm = new File(firmwareFileName);
                if (!fileFirm.exists() || !fileFirm.canRead() || fileFirm.isDirectory()) {
                    m_log.error("Exception: File does not exist");
                    throw new JposException(109, "File does not exist");
                }
                try {
                    String sLine;
                    FileReader fr = new FileReader(fileFirm);
                    BufferedReader in = new BufferedReader(fr);
                    int appNdx = 0;
                    int cfgNdx = 0;
                    int ecNdx = 0;
                    int lines = 0;
                    while ((sLine = in.readLine()) != null) {
                        int ndx;
                        if (!(lines != 0 || sLine.contains("HDFgen") || sLine.contains("Generator") || sLine.toUpperCase().contains("DATALOGIC") || sLine.contains("Copyright") || sLine.contains("PSC"))) {
                            m_log.error("Exception: Bad file name");
                            FunctionLib.cleanup(in);
                            throw new JposException(114, 281, "Bad firmware file");
                        }
                        if (sLine.contains("App")) {
                            appNdx = sLine.indexOf(" App=");
                            fileVersion = sLine.substring(appNdx += 5, appNdx + 8);
                        }
                        if (sLine.contains("Cfg")) {
                            cfgNdx = sLine.indexOf(" Cfg=");
                        }
                        if (sLine.contains("EC")) {
                            ecNdx = sLine.indexOf(" EC=");
                            FileECVersion = sLine.substring(ecNdx += 4, ecNdx + 4);
                        }
                        if (sLine.contains("VID")) {
                            ndx = sLine.indexOf(" VID=");
                            VID = sLine.substring(ndx += 5, ndx + 4);
                        }
                        if (sLine.contains("PID")) {
                            ndx = sLine.indexOf(" PID=");
                            PID = sLine.substring(ndx += 5, ndx + 4);
                        }
                        if (++lines < 4) continue;
                        FunctionLib.cleanup(in);
                        FunctionLib.cleanup(fr);
                        break;
                    }
                    FunctionLib.cleanup(in);
                    if (ecNdx == 0) {
                        FileECVersion = "0000";
                    }
                    if (cfgNdx > 0 && appNdx <= 0) {
                        bConfigOnly = true;
                    }
                    if (appNdx <= 0) {
                        appNdx = cfgNdx;
                    }
                    if (ecNdx < 0) {
                        ecNdx = 0;
                    }
                    if (appNdx < 10 || appNdx > 24) {
                        m_log.error("Exception: Bad file type");
                        FunctionLib.cleanup(in);
                        throw new JposException(114, 281, "Bad firmware file type");
                    }
                }
                catch (IOException e) {
                    m_log.error("Exception: File does not exist");
                    throw new JposException(109, "File does not exist");
                }
                if (DLSJposConst.updateInProgress || this.getState() == 3) {
                    m_log.error("Exception: Device is busy");
                    throw new JposException(113, "Device is busy");
                }
                try {
                    if (bConfigOnly) {
                        scanVersion = (String)this.statistics.get("ConfigFileVersionNumber");
                        if (scanVersion == null) {
                            result[0] = 5;
                        } else {
                            scanVersion = scanVersion.toUpperCase();
                            fileVersion = fileVersion.trim();
                            result[0] = scanVersion.equals(fileVersion = fileVersion.toUpperCase()) ? 2 : 4;
                        }
                        break block59;
                    }
                    int nFileVer = 0;
                    if (!fileVersion.contains("XXXX")) {
                        try {
                            nFileVer = Integer.parseInt(fileVersion.substring(4, 8));
                        }
                        catch (NumberFormatException nFE) {
                            m_log.error("File version is not a number");
                        }
                    }
                    int nFileECVer = 0;
                    if (!FileECVersion.contains("XXXX")) {
                        try {
                            nFileECVer = Integer.parseInt(FileECVersion.substring(0, 4));
                        }
                        catch (NumberFormatException nFE) {
                            m_log.error("File EC level is not a number");
                        }
                    }
                    scanVersion = (String)this.statistics.get("FirmwareVersionNumber");
                    scanECVersion = (String)this.statistics.get("ScannerRevisionNumber");
                    if (scanVersion == null || scanVersion.length() == 0 || scanECVersion == null || scanECVersion.length() == 0) {
                        result[0] = 5;
                        break block59;
                    }
                    try {
                        nScanVer = Integer.parseInt(scanVersion.substring(4, 8));
                    }
                    catch (NumberFormatException nFE) {
                        m_log.error("Scanner version is not a number");
                    }
                    try {
                        nScanECVer = Integer.parseInt(scanECVersion.substring(0, 4));
                    }
                    catch (NumberFormatException nFE) {
                        m_log.error("Scanner EC version is not a number, attempting to parse as hexadecimal");
                        try {
                            nScanECVer = Integer.parseInt(scanECVersion.substring(0, 4), 16);
                        }
                        catch (NumberFormatException exc) {
                            m_log.error("Scanner EC version could not be parsed as hexadecimal: " + exc.toString());
                        }
                    }
                    if (nFileECVer == nScanECVer) {
                        result[0] = 2;
                    } else if (nFileECVer > nScanECVer) {
                        result[0] = 3;
                    } else if (nFileECVer < nScanECVer) {
                        result[0] = 1;
                    } else if (nFileECVer == 0 || nScanECVer == 0) {
                        result[0] = 4;
                    }
                    if (this.bUSB) {
                        int vid = this.flashDeviceInfo.getVendorId();
                        int pid = this.flashDeviceInfo.getProductId();
                        if (vid != fvid) {
                            m_log.warn("Wrong Vendor ID for firmware compare. " + String.format("%04X", vid) + " != " + String.format("%04X", fvid));
                            result[0] = 6;
                            result[1] = vid;
                            result[2] = fvid;
                        }
                        if (pid != fpid) {
                            m_log.warn("Wrong Product ID for firmware compare. " + String.format("%04X", pid) + " != " + String.format("%04X", fpid));
                            result[0] = 7;
                            result[1] = pid;
                            result[2] = fpid;
                        }
                    }
                    m_log.debug("FileVersion = " + nFileECVer);
                    m_log.debug("ScannerVersion = " + nScanECVer);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    m_log.error("Exception in compareFirmwareVersion: ", (Throwable)e);
                    result[0] = 5;
                    throw new JposException(111, "Failed to compare: " + e);
                }
            }
        }
        m_log.trace("compareFirmwareVersion (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ReadDFWFile(String fileName, String model_name) {
        boolean returnValue = false;
        File file = new File(fileName);
        BufferedReader reader = null;
        m_log.trace("ReadDFWFile (in): " + fileName + ", " + model_name);
        try {
            reader = new BufferedReader(new FileReader(file));
            String text = null;
            while ((text = reader.readLine()) != null) {
                if (text.contains(model_name)) {
                    returnValue = true;
                    break;
                }
                returnValue = false;
            }
        }
        catch (FileNotFoundException e) {
            m_log.error("File not found: " + fileName);
        }
        catch (IOException e) {
            m_log.error("I/O Exception reading " + fileName);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                m_log.error("I/O Exception closing " + fileName);
            }
        }
        m_log.trace("ReadDFWFile (out): " + Boolean.toString(returnValue));
        return returnValue;
    }

    int ProcessCall(String[] args) {
        int ret = 0;
        Process process = null;
        m_log.trace("ProcessCall (in)");
        try {
            process = Runtime.getRuntime().exec(args);
        }
        catch (IOException ex) {
            m_log.error("Exception on Runtime.getRuntime().exec ", (Throwable)ex);
            return ret;
        }
        StreamReader reader = new StreamReader(process.getInputStream());
        reader.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException ex) {
            m_log.error("Exception on process.waitFor ", (Throwable)ex);
        }
        try {
            reader.join();
        }
        catch (InterruptedException ex) {
            m_log.error("Exception on reader.join ", (Throwable)ex);
        }
        String output = reader.getResult();
        if (output.contains("JPOS_EFIRMWARE_BAD_FILE")) {
            ret = 281;
        }
        if (output.contains("CFV_FIRMWARE_NEWER")) {
            ret = 3;
        } else if (output.contains("CFV_FIRMWARE_SAME")) {
            ret = 2;
        } else if (output.contains("CFV_FIRMWARE_OLDER")) {
            ret = 1;
        } else if (output.contains("CFV_FIRMWARE_DIFFERENT")) {
            ret = 4;
        } else if (output.contains("CFV_FIRMWARE_UNKNOWN")) {
            ret = 5;
        } else if (output.contains("JPOS_ALADDIN_LIGHT_OK")) {
            ret = 2200;
        }
        m_log.trace("ProcessCall (out): " + Integer.toString(ret));
        return ret;
    }

    @Override
    public void updateFirmware(String firmwareFileName) throws JposException {
        m_log.trace("updateFirmware (in): " + firmwareFileName);
        if (!this.getClaimed()) {
            m_log.error("updateFirmware: 103 Device not claimed");
            throw new JposException(103, "Device not claimed");
        }
        if (!this.getDeviceEnabled()) {
            m_log.error("updateFirmware: 105 Device not enabled");
            throw new JposException(105, "Device not enabled");
        }
        if (!this.scanner.getCanUpdateFirmware()) {
            m_log.error("updateFirmware: 106 Capability not available");
            throw new JposException(106, "Capability not available");
        }
        if (DLSJposConst.updateInProgress || this.getState() == 3) {
            m_log.error("updateFirmware: 113 Device is busy");
            throw new JposException(113, "Device is busy");
        }
        if (!this.scanner.getDeviceInfo().get8xxx() && !this.scanner.getDeviceInfo().get9xxx()) {
            if (this.bUSB && this.flash != null) {
                try {
                    this.flash.claim(1000L);
                }
                catch (DLSException e) {
                    m_log.error("Error creating flash object ", (Throwable)e);
                    throw new JposException(104, "Flash device creation error");
                }
            }
            String sExt = firmwareFileName.substring(firmwareFileName.length() - 4, firmwareFileName.length());
            if (this.bUSB) {
                if (sExt.compareToIgnoreCase(".DAT") != 0) {
                    m_log.error("Exception: Bad file extension");
                    this.releaseFlash();
                    throw new JposException(114, 281, "Bad file extension");
                }
            } else if (sExt.compareToIgnoreCase(".S37") != 0) {
                m_log.error("Exception: Bad file extension");
                throw new JposException(114, 281, "Bad file extension");
            }
            if (this.bUSB) {
                int vid = this.flashDeviceInfo.getVendorId();
                int pid = this.flashDeviceInfo.getProductId();
                int fvid = this.SearchInFile("VID", firmwareFileName);
                int fpid = this.SearchInFile("PID", firmwareFileName);
                if (vid != fvid) {
                    m_log.warn("Wrong Vendor ID for firmware compare. " + String.format("%X", vid) + " != " + String.format("%X", fvid));
                    this.releaseFlash();
                    throw new JposException(5, "Wrong vid " + String.format("%X", vid) + " != " + String.format("%X", fvid));
                }
                if (pid != fpid) {
                    m_log.warn("Wrong Vendor ID for firmware compare. " + String.format("%X", pid) + " != " + String.format("%X", fpid));
                    this.releaseFlash();
                    throw new JposException(5, "Wrong pid " + String.format("%X", pid) + " != " + String.format("%X", fpid));
                }
            }
            this.deviceState = 3;
            this.scanner.setFirmwareBaudRate();
            DLSJposConst.updateInProgress = true;
            this.bUpdateFirmwareStatus = true;
            this.doUpdate(firmwareFileName);
            this.bUpdateFirmwareStatus = false;
        } else if (this.scanner.getDeviceInfo().get9xxx()) {
            try {
                String sExt = firmwareFileName.substring(firmwareFileName.length() - 4, firmwareFileName.length());
                if (sExt.compareToIgnoreCase(".S37") != 0) {
                    m_log.error("Exception: Bad file extension");
                    throw new JposException(114, 281, "Bad file extension");
                }
                this.scanner.sendMessage("acceptHostCmd");
                this.deviceState = 3;
                DLSJposConst.updateInProgress = true;
                this.bUpdateFirmwareStatus = true;
                this.doUpdate(firmwareFileName);
                this.bUpdateFirmwareStatus = false;
                this.scanner.sendMessage("rejectHostCmd");
            }
            catch (Exception e) {
                m_log.error("Firmware Update Exception: ", (Throwable)e);
            }
        } else {
            String sExt = firmwareFileName.substring(firmwareFileName.length() - 4, firmwareFileName.length());
            m_log.debug("firmwareFileName.substring: " + sExt);
            if (sExt.compareToIgnoreCase(".DFW") != 0) {
                m_log.error("Exception: Bad file extension");
                this.releaseFlash();
                throw new JposException(114, 281, "Bad file extension");
            }
            this.deviceState = 3;
            DLSJposConst.updateInProgress = true;
            this.bUpdateFirmwareStatus = true;
            fileNameFor8300 = firmwareFileName;
            m_log.debug("do8xxxUpdate(fileNameFor8300)" + firmwareFileName);
            this.do8xxxUpdate(fileNameFor8300);
            this.bUpdateFirmwareStatus = false;
        }
        m_log.trace("updateFirmware (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int SearchInFile(String myStr, String myPath) {
        m_log.trace("SearchInFile (in): " + myStr + ", " + myPath);
        int myint = 0;
        BufferedReader bf = null;
        try {
            String line;
            String stringSearch = myStr;
            bf = new BufferedReader(new FileReader(myPath));
            int linecount = 0;
            while ((line = bf.readLine()) != null) {
                ++linecount;
                int indexfound = line.indexOf(stringSearch);
                if (indexfound > -1) {
                    String mystr = line.substring(indexfound + 4, indexfound + 4 + 4);
                    m_log.debug("Found in file " + stringSearch + ": " + mystr);
                    myint = Integer.decode("0x" + mystr);
                }
                if (linecount < 4) continue;
                break;
            }
            FunctionLib.cleanup(bf);
        }
        catch (IOException e) {
            m_log.error("SearchInFile: ", (Throwable)e);
        }
        finally {
            FunctionLib.cleanup(bf);
        }
        m_log.trace("SearchInFile (out): " + Integer.toString(myint));
        return myint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpdate(String sFilename) {
        int resetHDLTime;
        String sLine;
        m_log.trace("doUpdate (in): " + sFilename);
        long start = System.currentTimeMillis();
        long end = 0L;
        int nSent = 0;
        boolean bDAT = false;
        String filename = sFilename;
        BufferedReader in = null;
        double fPerc = 0.0;
        int maxRetries = this.options.getRecordRetry();
        int nRetry = 0;
        int nRestart = 0;
        int nType = 0;
        int ndxS = 1;
        int fileRecords = 0;
        int nResp = 21;
        int xPerc = 0;
        try {
            String sExt = filename.substring(filename.length() - 4, filename.length());
            if (sExt.compareToIgnoreCase(".DAT") == 0) {
                ndxS += 4;
                bDAT = true;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            m_log.error("doUpdate: ", (Throwable)e);
        }
        fileRecords = 0;
        try {
            FileReader fr = new FileReader(filename);
            in = new BufferedReader(fr);
            while ((sLine = in.readLine()) != null && sLine.length() >= 10) {
                ++fileRecords;
            }
            FunctionLib.cleanup(in);
        }
        catch (IOException e) {
            m_log.error("doUpdate: ", (Throwable)e);
        }
        finally {
            FunctionLib.cleanup(in);
        }
        m_log.debug("File record count: " + fileRecords);
        this.scanner.setRecordTimeout(30000);
        if (this.bUSB) {
            this.flash.setRecordTimeout(30000);
        }
        this.onDeviceStatus(2100);
        if (this.bUSB && (nResp = this.flash.startCommand()) != 6) {
            DLSJposConst.updateInProgress = false;
            this.releaseFlash();
            this.deviceState = 2;
            this.onDeviceStatus(2201);
            m_log.trace("doUpdate (out)");
            return;
        }
        try {
            InputStreamReader iStream = new InputStreamReader((InputStream)new FileInputStream(filename), DLSJposConst.HDL_CHARSET);
            in = new BufferedReader(iStream);
            sLine = in.readLine();
            if (bDAT) {
                sLine = sLine.substring(8);
            }
            while (sLine != null) {
                if (sLine.length() < 10) {
                    break;
                }
                sLine = sLine + '\r';
                if (bDAT) {
                    sLine = sLine + '\n';
                }
                nResp = 21;
                nType = Integer.parseInt(sLine.substring(ndxS, ndxS + 1));
                for (nRetry = 0; nRetry <= maxRetries && ((nResp = this.bUSB ? this.flash.sendRecord(sLine) : this.scanner.sendRecord(sLine)) == 21 || nResp == 255); ++nRetry) {
                }
                if (nRetry > 0) {
                    m_log.debug("Retries: " + nRetry + " on record " + (nSent + 1));
                }
                if (nResp == 24 || nResp == 7) {
                    m_log.debug("Response " + nResp + " on record " + (nSent + 1));
                    in.close();
                    in = new BufferedReader(iStream);
                    nSent = 0;
                    xPerc = 0;
                    if (nRestart++ <= 2) continue;
                    break;
                }
                if (nResp != 6) {
                    m_log.debug("No ACK response " + nResp + " on record " + (nSent + 1));
                    break;
                }
                fPerc = 100.0 * (double)(++nSent) / (double)fileRecords;
                m_log.debug("Records sent: " + nSent);
                if ((int)fPerc > xPerc) {
                    this.onDeviceStatus(2100 + xPerc);
                    xPerc = (int)fPerc;
                }
                sLine = in.readLine();
            }
        }
        catch (IOException e) {
            m_log.error("doUpdate: ", (Throwable)e);
        }
        finally {
            FunctionLib.cleanup(in);
        }
        DLSJposConst.updateInProgress = false;
        if (nSent == fileRecords) {
            try {
                if (this.bUSB) {
                    Branding oBr = Branding.getInstance();
                    String sPre = oBr.getBrandingPrefix();
                    String sProp = "com." + sPre + ".jpos.service.ScannerService.FirmwareSendNulls";
                    if (this.options.get(sProp, true)) {
                        String sOut = "\u0000\u0000\u0000\u0000";
                        int n = this.flash.sendRecord(sOut);
                    }
                    if (this.options.get(sProp = "com." + sPre + ".jpos.service.ScannerService.FirmwareSendReset", true)) {
                        int n = this.flash.resetCommand();
                    }
                } else {
                    this.scanner.reset();
                }
            }
            catch (DLSException e) {
                m_log.error("Exception resetting scanner: ", (Throwable)e);
            }
        }
        this.scanner.restoreBaudRate();
        m_log.debug("Records sent: " + nSent);
        if (this.bUSB) {
            this.releaseFlash();
        }
        if ((resetHDLTime = this.options.getHDLResetTime()) < 25) {
            m_log.warn("doUpdate: Invalid wait time for reset found in properties file. Changing wait time to the minimum 25 seconds that is required.");
            resetHDLTime = 25;
        }
        if (!this.bFreezeEvents) {
            try {
                this.evtCallback.fireStatusUpdateEvent(new StatusUpdateEvent(this, 3001));
            }
            catch (Exception e) {
                m_log.error("Error firing status update: ", (Throwable)e);
            }
        }
        m_log.debug("Sleeping " + Integer.toString(resetHDLTime) + " seconds, waiting for scanner to reset");
        try {
            Thread.sleep(resetHDLTime * 1000);
        }
        catch (InterruptedException ex) {
            m_log.error("Thread.sleep exception: ", (Throwable)ex);
        }
        boolean scannerAlive = false;
        if (File.separatorChar != '\\' && this.bUSB) {
            m_log.debug("doUpdate: USB Linux device detected. Attempting to reclaim and enable...");
            try {
                this.scanner.disable();
                this.scanner.release();
                this.scanner.claim(1000L);
                this.scanner.enable();
            }
            catch (DLSException e) {
                m_log.error("doUpdate: DLSException thrown while attempting to reclaim and enable device: ", (Throwable)e);
            }
        }
        try {
            scannerAlive = this.scanner.isAlive();
            m_log.debug("doUpdate: isAlive returned " + Boolean.toString(scannerAlive));
        }
        catch (DLSException e) {
            m_log.error("doUpdate: Exception thrown while checking if the scanner is alive: ", (Throwable)e);
        }
        if (nSent == fileRecords) {
            if (scannerAlive) {
                this.onDeviceStatus(2200);
            } else {
                this.onDeviceStatus(2205);
            }
        } else if (nType == 0 && nRestart == 0 || nType == 7) {
            this.onDeviceStatus(2201);
        } else if (nRetry > maxRetries) {
            this.onDeviceStatus(2202);
        } else if (nRestart > 2) {
            this.onDeviceStatus(2203);
        } else {
            this.onDeviceStatus(2204);
        }
        this.deviceState = 2;
        end = System.currentTimeMillis();
        long duration = end - start;
        long second = duration / 1000L % 60L;
        long minute = duration / 60000L % 60L;
        long hour = duration / 3600000L % 24L;
        long mills = duration % 1000L;
        String time = String.format("%02d:%02d:%02d:%03d", hour, minute, second, mills);
        m_log.debug("Done updating firmware. Elapsed time =" + time);
        m_log.trace("doUpdate (out)");
    }

    protected void do8xxxUpdate(String sFilename) {
        m_log.trace("do8xxxUpdate (in): " + sFilename);
        int retCode = 0;
        int sentBytes = 0;
        String portName = "COM20";
        this.getPortName();
        String fakeFilename = "C:/Temp/Base_std.dfw";
        this.onDeviceStatus(2101);
        String[] argUpdate = new String[]{"java.exe", "-jar", "AladdinLight.jar", "-port", portName, "-firmwareupgrade", "-dfw", sFilename, "-waittime", "8000"};
        try {
            this.scanner.release();
            this.scanner.close();
        }
        catch (DLSException ex) {
            m_log.error("Exception on scanner.release() or scanner.close() ", (Throwable)ex);
        }
        retCode = this.ProcessCall(argUpdate);
        try {
            Thread.sleep(120000L);
        }
        catch (InterruptedException ex) {
            m_log.error("Thread.sleep exception: ", (Throwable)ex);
        }
        DLSJposConst.updateInProgress = false;
        try {
            this.scanner.open(this.strLogicalName);
            this.scanner.claim(30000L);
        }
        catch (DLSException ex) {
            m_log.error("Exception on scanner.open() or scanner.claim() ", (Throwable)ex);
        }
        sentBytes = this.scanner.sendJoin();
        try {
            Thread.sleep(2500L);
        }
        catch (InterruptedException ex) {
            m_log.error("Thread.sleep exception: ", (Throwable)ex);
        }
        if (retCode == -1) {
            this.onDeviceStatus(2200);
        } else if (retCode == 0) {
            this.onDeviceStatus(2201);
        } else if (retCode == 2200) {
            this.onDeviceStatus(2200);
        }
        this.deviceState = 2;
        m_log.trace("do8xxxUpdate (out)");
    }

    protected void do9xxxUpdate(String sFilename) {
    }

    @Override
    public void onLabelReceived(byte[] rawLabelData, byte[] decodedLabelData, int nType) {
        m_log.trace("onLabelReceived (in): " + new String(rawLabelData) + ", " + new String(decodedLabelData) + ", " + Integer.toString(nType));
        try {
            if (this.getAutoDisable()) {
                this.setDeviceEnabled(false);
            }
        }
        catch (JposException e) {
            m_log.error("onLabelReceived: JposException: ", (Throwable)e);
        }
        switch (nType) {
            case 102: {
                if (decodedLabelData.length >= 8) break;
                if (decodedLabelData.length < 7) {
                    m_log.error("onLabelReceived: Invalid UPCE Label length.");
                    break;
                }
                byte[] newLabel = this.expandUPCE(decodedLabelData);
                newLabel = this.addCheckDigit(newLabel);
                byte[] upceLabel = new byte[8];
                System.arraycopy(decodedLabelData, 0, upceLabel, 0, 7);
                upceLabel[7] = newLabel[11];
                decodedLabelData = upceLabel;
                break;
            }
            case 101: {
                if (decodedLabelData.length >= 12) break;
                decodedLabelData = this.addCheckDigit(decodedLabelData);
                break;
            }
            case 103: {
                if (decodedLabelData.length >= 8) break;
                decodedLabelData = this.addCheckDigit(decodedLabelData);
                break;
            }
            case 104: {
                if (decodedLabelData.length >= 13) break;
                if (this.scanner instanceof DLSSCSerialScanner) {
                    if (rawLabelData[3] == 73) break;
                    decodedLabelData = this.addCheckDigit(decodedLabelData);
                    break;
                }
                if (rawLabelData[0] == 110 || rawLabelData[0] == 64 || rawLabelData[0] == 73) break;
                decodedLabelData = this.addCheckDigit(decodedLabelData);
            }
        }
        this.listData.addLast(new LabelData(rawLabelData, decodedLabelData, nType));
        m_log.debug("onLabelReceived: Label: " + new String(decodedLabelData));
        this.sendDataEvent();
        m_log.trace("onLabelReceived (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendDataEvent() {
        m_log.trace("sendDataEvent (in)");
        LinkedList<EventData> linkedList = this.listData;
        synchronized (linkedList) {
            if (this.listData.size() != 0) {
                m_log.debug("sendDataEvent: Queue size = " + Integer.toString(this.listData.size()));
                if (this.bDataEventEnabled && !this.bFreezeEvents) {
                    this.bDataEventEnabled = false;
                    EventData ed = this.listData.getFirst();
                    if (ed.nEventType == 2) {
                        m_log.debug("sendDataEvent: Event Type = LABEL_EVENT.");
                        this.currentLabelData = (LabelData)ed;
                        this.listData.removeFirst();
                        DataEvent de = new DataEvent(this.evtCallback.getEventSource(), 0);
                        this.evtCallback.fireDataEvent(de);
                    } else if (ed.nEventType == 3) {
                        m_log.debug("sendDataEvent: Event Type = ITEM_EVENT.");
                        this.currentItemData = (ItemData)ed;
                        this.listData.removeFirst();
                        DataEvent de = new DataEvent(this.evtCallback.getEventSource(), 0);
                        this.evtCallback.fireDataEvent(de);
                    } else if (ed.nEventType == 1) {
                        m_log.debug("sendDataEvent: Event Type = ERROR_EVENT.");
                        this.listData.removeFirst();
                        ErrorData err = (ErrorData)ed;
                        m_log.debug("sendDataEvent: firingErrorEvent: " + err.nCode);
                        ErrorEvent errorEvent = new ErrorEvent(this, err.nCode, err.nExCode, err.nLocus, err.nResponse);
                        this.evtCallback.fireErrorEvent(errorEvent);
                        if (!this.isClosed()) {
                            this.deviceState = 2;
                        }
                        switch (errorEvent.getErrorResponse()) {
                            case 12: {
                                m_log.info("sendDataEvent: Application error response: JPOS_ER_CLEAR");
                                this.listData.clear();
                                break;
                            }
                            case 13: {
                                m_log.info("sendDataEvent: Application error response: JPOS_ER_CONTINUEINPUT");
                                break;
                            }
                            case 11: {
                                m_log.info("sendDataEvent: Application error response: JPOS_ER_RETRY");
                            }
                        }
                    }
                }
            }
        }
        m_log.trace("sendDataEvent (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueError(int nCode, int nExCode, int nLocus, int nResponse) {
        m_log.trace("enqueueError (in): " + Integer.toString(nCode) + ", " + Integer.toString(nExCode) + ", " + Integer.toString(nLocus) + ", " + Integer.toString(nResponse));
        LinkedList<EventData> linkedList = this.listData;
        synchronized (linkedList) {
            ErrorData err;
            if (this.listData.size() > 0 && nLocus != 1) {
                boolean bData = false;
                for (EventData ed : this.listData) {
                    if (ed.nEventType != 2) continue;
                    bData = true;
                    break;
                }
                if (bData) {
                    err = new ErrorData(nCode, nExCode, 3, 13);
                    this.listData.addFirst(err);
                }
            }
            err = new ErrorData(nCode, nExCode, nLocus, nResponse);
            this.listData.add(err);
        }
        this.sendDataEvent();
        m_log.trace("enqueueError (out)");
    }

    @Override
    public void onDeviceError(int nErrorCode) {
        m_log.trace("onDeviceError (in): " + Integer.toString(nErrorCode));
        DLSProperties oOptions = DLSProperties.getInstance();
        DLSCConfig oConfig = this.scanner.getConfiguration();
        DLSDeviceInfo oInfo = this.device.getDeviceInfo();
        boolean bCanNotifyPower = oConfig.getOptionAsBoolean("canNotifyPowerChange");
        int myPowerNotify = this.getMyPowerNotify();
        boolean nCapPowerReporting = false;
        Branding oBr = Branding.getInstance();
        String sPre = oBr.getBrandingPrefix();
        String sProp = "com." + sPre + ".jpos.service.ScannerService.suppressErrors";
        boolean supressErrors = oOptions.get(sProp, false);
        if (supressErrors) {
            m_log.warn("onDeviceError: Errors are being suppressed");
        }
        if (!supressErrors) {
            this.deviceState = 4;
            switch (nErrorCode) {
                case -116: {
                    this.bWaitOnScanner = true;
                    sProp = "com." + sPre + ".jpos.service.ScannerService.PostRemovalErrorEvents";
                    if (oOptions.get(sProp, false)) {
                        this.enqueueError(107, -116, 2, 12);
                        break;
                    }
                    this.deviceState = 2;
                    break;
                }
                case -120: {
                    this.bWaitOnScanner = false;
                    sProp = "com." + sPre + ".jpos.service.ScannerService.PostRemovalErrorEvents";
                    if (oOptions.get(sProp, false)) {
                        String bus = oInfo.getDeviceBus();
                        boolean bUseSun = oInfo.getOptionAsBoolean("useSunJavaxComm");
                        try {
                            if (bus.equals("RS232") && bUseSun) {
                                m_log.info("onDeviceError: Release-Close-Open-Claim-Restore_State");
                                this.release();
                                this.close();
                                this.open(this.localLogicalName, this.evtCallback);
                                this.claim(30000);
                            }
                        }
                        catch (Exception e) {
                            m_log.error("onDeviceError: Error release-close-open-claim-enable ", (Throwable)e);
                        }
                        this.enqueueError(107, -120, 2, 12);
                    } else {
                        this.deviceState = 2;
                    }
                    if (!this.getEnabled()) break;
                    try {
                        m_log.debug("onDeviceError: Sending Enable to scanner.");
                        this.setDeviceEnabled(true);
                    }
                    catch (JposException ex) {
                        m_log.error("onDeviceError: setDeviceEnabled ", (Throwable)ex);
                    }
                    break;
                }
                case -113: {
                    this.enqueueError(111, -113, 2, 12);
                    break;
                }
                case -105: {
                    this.enqueueError(111, -105, 2, 12);
                    break;
                }
                case -111: {
                    this.enqueueError(113, -111, 2, 13);
                    break;
                }
                case -112: {
                    this.enqueueError(113, -112, 2, 13);
                    break;
                }
                case -115: {
                    this.enqueueError(106, -115, 1, 13);
                    break;
                }
                case -114: {
                    this.enqueueError(106, -114, 1, 13);
                    break;
                }
                case -100: {
                    this.enqueueError(106, -100, 1, 13);
                    break;
                }
                default: {
                    this.deviceState = 2;
                }
            }
        }
        m_log.trace("onDeviceError (out)");
    }

    @Override
    public void onDeviceStatus(int nStatusCode) {
        m_log.trace("onDeviceStatus (in): " + Integer.toString(nStatusCode));
        if (this.bUpdateFirmwareStatus) {
            if (nStatusCode >= 2100 && nStatusCode < 2200) {
                int value = nStatusCode - 2100;
                m_log.info(String.format("The update firmware process is continuing... %d%%", value));
            }
            switch (nStatusCode) {
                case 2200: {
                    m_log.info("The update firmware process has completed successfully.");
                    break;
                }
                case 2205: {
                    m_log.info("The update firmware process succeeded, however the Service and/or the physical device cannot be returned to the state they were in before the update firmware process started. The Service has restored all properties to their default initialization values. To ensure consistent Service and physical device states, the application needs to close the Service, then open, claim, and enable again, and also restore all custom application settings.");
                    break;
                }
                case 2201: {
                    m_log.info("The update firmware process failed but the device is still operational.");
                    break;
                }
                case 2202: {
                    m_log.info("The update firmware process failed and the device is neither usable nor recoverable through software. The device requires service to be returned to an operational state.");
                    break;
                }
                case 2203: {
                    m_log.info("The update firmware process failed and the device will not be operational until another attempt to update the firmware is successful.");
                    break;
                }
                case 2204: {
                    m_log.info("The update firmware process failed and the device is in an indeterminate state.");
                }
            }
        }
        try {
            if (this.getPowerNotify() == 1) {
                if (nStatusCode == 2001) {
                    this.setPowerState(2001);
                }
                if (nStatusCode == 2004) {
                    this.setPowerState(2004);
                }
            } else if (nStatusCode == 2004 || nStatusCode == 2001) {
                return;
            }
        }
        catch (JposException ex) {
            m_log.error("Exception in onDeviceStatus() Power Notify:", (Throwable)ex);
        }
        if (!this.bFreezeEvents) {
            try {
                this.evtCallback.fireStatusUpdateEvent(new StatusUpdateEvent(this, nStatusCode));
            }
            catch (Exception e) {
                m_log.error("Error firing status update: ", (Throwable)e);
            }
        }
        m_log.trace("onDeviceStatus (out)");
    }

    private boolean loadConfigItems(HashMap<String, Object> configItems) {
        m_log.trace("loadConfigItems (in)");
        m_log.debug("loadConfigItems: " + configItems.size() + " attempting to compare and write");
        int[] data = null;
        boolean bSuccess = true;
        boolean bSuccessWrite = false;
        boolean bItemsWritten = false;
        Enumeration<String> enumItems = Collections.enumeration(configItems.keySet());
        while (enumItems.hasMoreElements()) {
            data = new int[4];
            String key = enumItems.nextElement();
            String val = (String)configItems.get(key);
            bSuccessWrite = false;
            m_log.info("**********************BEGIN Config Number: " + key + "**********************");
            try {
                m_log.info("Attempting to update Config Number: " + key + " to 0x" + val + ".");
                this.directIO(343, data, key + val);
                if (data[0] == 6) {
                    bSuccessWrite = true;
                }
            }
            catch (JposException ex) {
                m_log.error("Exception writing Tag Item: " + key + " could not be updated to 0x" + val + " Reason: ", (Throwable)ex);
                bSuccessWrite = false;
                bSuccess = false;
            }
            if (bSuccessWrite) {
                bItemsWritten = true;
                m_log.info("Config Number: " + key + " = 0x" + val + " updated.");
            } else {
                m_log.error("Config Number: " + key + " = " + val + " could not be updated: " + data[0] + " returned at data[0].");
            }
            m_log.info("**********************END Config Number: " + key + "**********************");
        }
        if (bItemsWritten) {
            try {
                try {
                    Object obj = new Object();
                    this.directIO(1, data, obj);
                }
                catch (JposException ex) {
                    m_log.error("Reset Error: ", (Throwable)ex);
                    bSuccess = false;
                }
                Thread.sleep(60000L);
            }
            catch (InterruptedException ex) {
                m_log.error("Sleep got interrupted", (Throwable)ex);
            }
        }
        m_log.trace("loadConfigItems (out): " + Boolean.toString(bSuccess));
        return bSuccess;
    }

    public static String convertStatusToReadable(int nStatusCode) {
        String sStatusCode = "NONE";
        if (nStatusCode >= 2100 && nStatusCode < 2200) {
            sStatusCode = "JPOS_SUE_UF_PROGRESS";
        }
        switch (nStatusCode) {
            case -100: {
                sStatusCode = "ERR_CMD";
                break;
            }
            case -101: {
                sStatusCode = "ERR_NO_WEIGHT";
                break;
            }
            case -102: {
                sStatusCode = "ERR_DATA";
                break;
            }
            case -103: {
                sStatusCode = "ERR_READ";
                break;
            }
            case -104: {
                sStatusCode = "ERR_NO_DISPLAY";
                break;
            }
            case -105: {
                sStatusCode = "ERR_HARDWARE";
                break;
            }
            case -106: {
                sStatusCode = "ERR_CMD_REJECT";
                break;
            }
            case -107: {
                sStatusCode = "ERR_CAPACITY";
                break;
            }
            case -108: {
                sStatusCode = "ERR_REQUIRES_ZEROING";
                break;
            }
            case -109: {
                sStatusCode = "ERR_WARMUP";
                break;
            }
            case -110: {
                sStatusCode = "ERR_DUPLICATE";
                break;
            }
            case -111: {
                sStatusCode = "ERR_FLASHING";
                break;
            }
            case -112: {
                sStatusCode = "ERR_BUSY";
                break;
            }
            case -113: {
                sStatusCode = "ERR_CHECKDIGIT";
                break;
            }
            case -114: {
                sStatusCode = "ERR_DIO_NOT_ALLOWED";
                break;
            }
            case -115: {
                sStatusCode = "ERR_DIO_UNDEFINED";
                break;
            }
            case -116: {
                sStatusCode = "ERR_DEVICE_REMOVED";
                break;
            }
            case -117: {
                sStatusCode = "ERR_SCALE_AT_ZERO";
                break;
            }
            case -118: {
                sStatusCode = "ERR_SCALE_UNDER_ZERO";
                break;
            }
            case -120: {
                sStatusCode = "ERR_DEVICE_REATTACHED";
                break;
            }
            case -121: {
                sStatusCode = "ERR_CFG_CMD_REJECTED";
                break;
            }
            case -200: {
                sStatusCode = "STATUS_ALIVE";
                break;
            }
            case -201: {
                sStatusCode = "STATUS_NOT_ALIVE";
                break;
            }
            case -202: {
                sStatusCode = "STATUS_ENABLED";
                break;
            }
            case -203: {
                sStatusCode = "STATUS_NOT_ENABLED";
                break;
            }
            case 2200: {
                sStatusCode = "JPOS_SUE_UF_COMPLETE";
                break;
            }
            case 2205: {
                sStatusCode = "JPOS_SUE_UF_COMPLETE_DEV_NOT_RESTORED";
                break;
            }
            case 2201: {
                sStatusCode = "JPOS_SUE_UF_FAILED_DEV_OK";
                break;
            }
            case 2202: {
                sStatusCode = "JPOS_SUE_UF_FAILED_DEV_UNRECOVERABLE";
                break;
            }
            case 2203: {
                sStatusCode = "JPOS_SUE_UF_FAILED_DEV_NEEDS_FIRMWARE";
                break;
            }
            case 2204: {
                sStatusCode = "JPOS_SUE_UF_FAILED_DEV_UNKNOWN";
                break;
            }
        }
        return sStatusCode;
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw = new StringWriter();

        public StreamReader(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getResult() {
            return this.sw.toString();
        }
    }

    class SystemData
    extends EventData {
        protected byte[] rawSystemData;
        protected int nType;

        public SystemData(byte[] rawSystemData, int nType) {
            this.rawSystemData = rawSystemData;
            this.nType = nType;
            this.nEventType = 4;
        }
    }

    class ItemData
    extends EventData {
        protected byte[] rawItemData;
        protected int nType;

        public ItemData(byte[] rawItemData, int nType) {
            this.rawItemData = rawItemData;
            this.nType = nType;
            this.nEventType = 3;
        }
    }

    class LabelData
    extends EventData {
        protected byte[] rawLabel;
        protected byte[] decodedLabel;
        protected int nType;

        public LabelData(byte[] rawLabel, byte[] decodedLabel, int nType) {
            this.rawLabel = rawLabel;
            this.decodedLabel = decodedLabel;
            this.nType = nType;
            this.nEventType = 2;
        }
    }

    class ErrorData
    extends EventData {
        protected int nCode;
        protected int nExCode;
        protected int nLocus;
        protected int nResponse;

        public ErrorData(int nCode, int nExCode, int nLocus, int nResponse) {
            this.nCode = nCode;
            this.nExCode = nExCode;
            this.nEventType = 1;
            this.nLocus = nLocus;
            this.nResponse = nResponse;
        }
    }

    class EventData {
        protected int nEventType;
        protected static final int ERROR_EVENT = 1;
        protected static final int LABEL_EVENT = 2;
        protected static final int ITEM_EVENT = 3;
        protected static final int SYSTEM_DATA_EVENT = 4;

        EventData() {
        }
    }
}

