/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.service;

import com.dls.jpos.service.ScannerScale;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScannerScaleAgent {
    private MBeanServer mbs = null;
    private ObjectName objName;
    private static final Logger m_log = LogManager.getLogger(ScannerScaleAgent.class);

    public void UnregisterAgent() {
        try {
            this.mbs.unregisterMBean(this.objName);
        }
        catch (InstanceNotFoundException ex) {
            m_log.error("UnregisterAgent: Instance Not Found. ", (Throwable)ex);
        }
        catch (MBeanRegistrationException ex) {
            m_log.error("UnregisterAgent: MBean Registration Exception. ", (Throwable)ex);
        }
    }

    public ScannerScaleAgent(HashMap<String, Object> statistics, String DeviceType) {
        m_log.trace("ScannerScaleAgent (in): " + DeviceType);
        m_log.debug("ScannerScaleAgent: getting Platform MBean Server.");
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        m_log.debug("ScannerScaleAgent: creating ScannerScale instance.");
        ScannerScale scannerScaleBean = new ScannerScale();
        scannerScaleBean.populate(statistics);
        try {
            this.objName = DeviceType.contains("Scanner") ? new ObjectName("CIMV2:name=Scanner") : new ObjectName("CIMV2:name=Scale");
            if (!this.mbs.isRegistered(this.objName)) {
                m_log.debug("ScannerScaleAgent: Registering new MBean - " + this.objName.toString());
                this.mbs.registerMBean(scannerScaleBean, this.objName);
            }
        }
        catch (MalformedObjectNameException e) {
            m_log.error("ScannerScaleAgent: Exception registering agent. ", (Throwable)e);
        }
        catch (NullPointerException e) {
            m_log.error("ScannerScaleAgent: Exception registering agent. ", (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            m_log.error("ScannerScaleAgent: Exception registering agent. ", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            m_log.error("ScannerScaleAgent: Exception registering agent. ", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            m_log.error("ScannerScaleAgent: Exception registering agent. ", (Throwable)e);
        }
    }
}

