/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.service;

import com.dls.jpos.common.FunctionLib;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;

public class SimpleFTPClient {
    private URLConnection m_client;
    private String host;
    private String user;
    private String password;
    private String remoteFile;
    private String erMesg;
    private String succMesg;

    public synchronized void setHost(String host) {
        this.host = host;
    }

    public synchronized void setUser(String user) {
        this.user = user;
    }

    public synchronized void setPassword(String p) {
        this.password = p;
    }

    public synchronized void setRemoteFile(String d) {
        this.remoteFile = d;
    }

    public synchronized String getLastSuccessMessage() {
        if (this.succMesg == null) {
            return "";
        }
        return this.succMesg;
    }

    public synchronized String getLastErrorMessage() {
        if (this.erMesg == null) {
            return "";
        }
        return this.erMesg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean uploadFile(String localfilename) {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        boolean result = false;
        try {
            int readCount;
            FileInputStream is = new FileInputStream(localfilename);
            bis = new BufferedInputStream(is);
            OutputStream os = this.m_client.getOutputStream();
            bos = new BufferedOutputStream(os);
            byte[] buffer = new byte[1024];
            while ((readCount = bis.read(buffer)) > 0) {
                bos.write(buffer, 0, readCount);
            }
            this.succMesg = "Uploaded!";
            result = true;
        }
        catch (IOException ex) {
            try {
                StringWriter sw0 = new StringWriter();
                PrintWriter p0 = new PrintWriter((Writer)sw0, true);
                ex.printStackTrace(p0);
                this.erMesg = sw0.getBuffer().toString();
                result = false;
            }
            catch (Throwable throwable) {
                FunctionLib.cleanup(bis);
                FunctionLib.cleanup(bos);
                throw throwable;
            }
            FunctionLib.cleanup(bis);
            FunctionLib.cleanup(bos);
        }
        FunctionLib.cleanup(bis);
        FunctionLib.cleanup(bos);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean downloadFile(String localfilename) {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        boolean result = false;
        try {
            int readCount;
            InputStream is = this.m_client.getInputStream();
            bis = new BufferedInputStream(is);
            FileOutputStream os = new FileOutputStream(localfilename);
            bos = new BufferedOutputStream(os);
            byte[] buffer = new byte[1024];
            while ((readCount = bis.read(buffer)) > 0) {
                bos.write(buffer, 0, readCount);
            }
            is.close();
            this.succMesg = "Downloaded!";
            result = true;
        }
        catch (IOException ex) {
            try {
                StringWriter sw0 = new StringWriter();
                PrintWriter p0 = new PrintWriter((Writer)sw0, true);
                ex.printStackTrace(p0);
                this.erMesg = sw0.getBuffer().toString();
                result = false;
            }
            catch (Throwable throwable) {
                FunctionLib.cleanup(bis);
                FunctionLib.cleanup(bos);
                throw throwable;
            }
            FunctionLib.cleanup(bis);
            FunctionLib.cleanup(bos);
        }
        FunctionLib.cleanup(bis);
        FunctionLib.cleanup(bos);
        return result;
    }

    public synchronized boolean connect() {
        try {
            URL url = new URL("ftp://" + this.user + ":" + this.password + "@" + this.host + "/" + this.remoteFile + ";type=i");
            this.m_client = url.openConnection();
            return true;
        }
        catch (IOException ex) {
            StringWriter sw0 = new StringWriter();
            PrintWriter p0 = new PrintWriter((Writer)sw0, true);
            ex.printStackTrace(p0);
            this.erMesg = sw0.getBuffer().toString();
            return false;
        }
    }
}

