/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.service;

import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.FunctionLib;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WMIService {
    private DLSProperties options = DLSProperties.getInstance();
    private static final Logger m_log = LogManager.getLogger(WMIService.class);

    public Map CreateWMIFile(Hashtable hTable) {
        m_log.trace("CreateWMIFile (in)");
        HashMap map = new HashMap();
        Set set = hTable.entrySet();
        for (Map.Entry entry : set) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (key == null) {
                key = "" + null;
            }
            if (val == null) {
                val = "" + null;
            }
            map.put(key, val);
        }
        m_log.trace("CreateWMIFile (out)");
        return map;
    }

    public Map convertHashTableToHashMap(Hashtable hTable) {
        HashMap map = new HashMap();
        Set set = hTable.entrySet();
        for (Map.Entry entry : set) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (key == null) {
                key = "" + null;
            }
            if (val == null) {
                val = "" + null;
            }
            map.put(key, val);
        }
        return map;
    }

    public void CreateWMIFile(String[] lString) {
    }

    public void CreateWMIScannerFile(HashMap<String, Object> wmiHashMap) {
        m_log.trace("CreateWMIScannerFile (in)");
        StringBuilder oSc = new StringBuilder("#PRAGMA AUTORECOVER#pragma classflags(\"forceupdate\")\n#pragma namespace (\"\\\\\\\\.\\\\Root\\\\CIMV2\")\n[\n\tDescription (\"The JPOS Scanner Class describes characteristics of Scanner devices.\"):\n\tToSubClass\n]\nclass UPOS_Scanner\n{\n\t[\nread, key,\n\t\tDescription(\"The Device ID Must be unique for each storage instance\"):\n\t\tDisableOverride ToSubClass\n\t]\n");
        StringBuilder oSi = new StringBuilder("\ninstance of UPOS_Scanner\n{\n");
        String sId = wmiHashMap.get("DeviceID").toString();
        oSc.append("string DeviceID;\n");
        oSc.append("[write (true): ToSubClass]\n");
        oSi.append(" DeviceID = \"");
        oSi.append(sId);
        oSi.append("\";\n");
        Enumeration<String> e = Collections.enumeration(wmiHashMap.keySet());
        if (e.hasMoreElements()) {
            String key = e.nextElement();
            oSc.append("string ");
            oSc.append(key);
            oSc.append(";\n");
            while (e.hasMoreElements()) {
                key = e.nextElement();
                if (key.equals("DeviceID")) continue;
                oSc.append("[write (true): ToSubClass]\n");
                Object ob = wmiHashMap.get(key);
                oSi.append(" ");
                oSi.append(key);
                oSi.append(" = ");
                if (ob instanceof Boolean) {
                    oSc.append("boolean ");
                    oSc.append(key);
                    oSc.append(";\n");
                    oSi.append(ob);
                    oSi.append(";\n");
                    continue;
                }
                if (ob instanceof String) {
                    oSc.append("string ");
                    oSc.append(key);
                    oSc.append(";\n");
                    oSi.append("\"");
                    oSi.append(ob);
                    oSi.append("\";\n");
                    continue;
                }
                if (!(ob instanceof Integer)) continue;
                oSc.append("uint32 ");
                oSc.append(key);
                oSc.append(";\n");
                oSi.append(ob);
                oSi.append(";\n");
            }
        }
        oSc.append("};\n");
        oSi.append("};\n");
        String sWriteFile = this.WriteMOFfile(oSc.toString(), oSi.toString());
        boolean bCallWMI = this.CallWMI(sWriteFile);
        m_log.trace("CreateWMIScannerFile (out)");
    }

    public void CreateWMIScaleFile(HashMap<String, Object> wmiHTable) {
        m_log.trace("CreateWMIScaleFile (in)");
        String classString = "#PRAGMA AUTORECOVER#pragma classflags(\"forceupdate\")\n#pragma namespace (\"\\\\\\\\.\\\\Root\\\\CIMV2\")\n[\n\tDescription (\"The JPOS Scale Class describes characteristics of Scale devices.\"):\n\tToSubClass\n]\nclass UPOS_Scale\n{\n\t[\nread, key,\n\t\tDescription(\"The Device ID Must be unique for each storage instance\"):\n\t\tDisableOverride ToSubClass\n\t]\n";
        String instanceString = "\ninstance of UPOS_Scale\n{\n";
        StringBuilder oSc = new StringBuilder("#PRAGMA AUTORECOVER#pragma classflags(\"forceupdate\")\n#pragma namespace (\"\\\\\\\\.\\\\Root\\\\CIMV2\")\n[\n\tDescription (\"The JPOS Scale Class describes characteristics of Scale devices.\"):\n\tToSubClass\n]\nclass UPOS_Scale\n{\n\t[\nread, key,\n\t\tDescription(\"The Device ID Must be unique for each storage instance\"):\n\t\tDisableOverride ToSubClass\n\t]\n");
        StringBuilder oSi = new StringBuilder("\ninstance of UPOS_Scale\n{\n");
        String sId = wmiHTable.get("DeviceID").toString();
        oSc.append("string DeviceID;\n");
        oSc.append("[write (true): ToSubClass]\n");
        oSi.append(" DeviceID = \"");
        oSi.append(sId);
        oSi.append("\";\n");
        Enumeration<String> e = Collections.enumeration(wmiHTable.keySet());
        String key = e.nextElement();
        oSc.append("string ");
        oSc.append(key);
        oSc.append(";\n");
        while (e.hasMoreElements()) {
            key = e.nextElement();
            if (key.equals("DeviceID")) continue;
            oSc.append("[write (true): ToSubClass]\n");
            Object ob = wmiHTable.get(key);
            oSi.append(" ");
            oSi.append(key);
            oSi.append(" = ");
            if (ob instanceof Boolean) {
                oSc.append("boolean ");
                oSc.append(key);
                oSc.append(";\n");
                oSi.append(ob);
                oSi.append(";\n");
                continue;
            }
            if (ob instanceof String) {
                oSc.append("string ");
                oSc.append(key);
                oSc.append(";\n");
                oSi.append("\"");
                oSi.append(ob);
                oSi.append("\";\n");
                continue;
            }
            if (!(ob instanceof Integer)) continue;
            oSc.append("uint32 ");
            oSc.append(key);
            oSc.append(";\n");
            oSi.append(ob);
            oSi.append(";\n");
        }
        oSc.append("};\n");
        oSi.append("};\n");
        String sWriteFile = this.WriteMOFfile(oSc.toString(), oSi.toString());
        boolean bCallWMI = this.CallWMI(sWriteFile);
        m_log.trace("CreateWMIScaleFile (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String WriteMOFfile(String sClass, String sInstance) {
        m_log.trace("WriteMOFfile (in): " + sClass + ", " + sInstance);
        String tempDir = this.options.getTempDir();
        BufferedWriter output = null;
        String sWMIfilename = "DatalogicScanner.MOF";
        sWMIfilename = tempDir + sWMIfilename;
        File file = new File(sWMIfilename);
        try {
            output = new BufferedWriter(new FileWriter(file));
            output.write(sClass + sInstance);
        }
        catch (IOException ex) {
            try {
                m_log.error("Error creating " + file.getName(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                FunctionLib.cleanup(output);
                throw throwable;
            }
            FunctionLib.cleanup(output);
        }
        FunctionLib.cleanup(output);
        m_log.trace("WriteMOFfile (out): " + sWMIfilename);
        return sWMIfilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean CallWMI(String filename) {
        m_log.trace("CallWMI (in): " + filename);
        boolean retValue = true;
        BufferedReader br = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add(System.getenv("windir") + "\\system32\\Wbem\\" + "mofcomp.exe");
        command.add(filename);
        ProcessBuilder builder = new ProcessBuilder(command);
        try {
            String line;
            Process process = builder.start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                m_log.debug(line);
            }
            FunctionLib.cleanup(br);
        }
        catch (IOException ex) {
            m_log.error("Error starting process: ", (Throwable)ex);
            retValue = false;
        }
        finally {
            FunctionLib.cleanup(br);
        }
        m_log.trace("CallWMI (out): " + Boolean.toString(retValue));
        return retValue;
    }
}

