/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.transport;

import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.FunctionLib;
import com.dls.jpos.transport.DataReceivedListener;
import com.dls.jpos.transport.DeviceAddedListener;
import com.dls.jpos.transport.DeviceReattachedListener;
import com.dls.jpos.transport.DeviceRemovedListener;
import com.dls.jpos.transport.PortResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DLSPort {
    protected ArrayList<Object> dataReceivedListeners;
    protected ArrayList<Object> deviceReattachedListeners;
    protected ArrayList<Object> deviceRemovedListeners;
    protected ArrayList<Object> deviceAddedListeners;
    protected DLSDeviceInfo m_info;
    protected boolean bOpen = false;
    boolean SendingMessage = false;
    protected final Object CommandResponseObject = new Object();
    protected byte[] ResponseBuffer = null;
    private static final int DefaultTimeout = 1000;
    private static final Logger m_log = LogManager.getLogger(DLSPort.class);

    public DLSPort(DLSDeviceInfo info) {
        this.dataReceivedListeners = new ArrayList();
        this.deviceReattachedListeners = new ArrayList();
        this.deviceRemovedListeners = new ArrayList();
        this.deviceAddedListeners = new ArrayList();
        this.m_info = info;
    }

    public void addDataReceivedListener(DataReceivedListener drl) {
        m_log.trace("addDataReceivedListener (in)");
        this.dataReceivedListeners.add(drl);
        m_log.trace("addDataReceivedListener (out)");
    }

    public void addDeviceAddedListener(DeviceReattachedListener drl) {
        m_log.trace("addDeviceAddedListener (in)");
        this.deviceAddedListeners.add(drl);
        m_log.trace("addDeviceAddedListener (out)");
    }

    public void addDeviceReattachedListener(DeviceReattachedListener drl) {
        m_log.trace("addDeviceReattachedListener (in)");
        this.deviceReattachedListeners.add(drl);
        m_log.trace("addDeviceReattachedListener (out)");
    }

    public void addDeviceRemovedListener(DeviceRemovedListener drl) {
        m_log.trace("addDeviceRemovedListener (in)");
        this.deviceRemovedListeners.add(drl);
        m_log.trace("addDeviceRemovedListener (out)");
    }

    public abstract void changeBaudRate(int var1);

    public abstract boolean closePort();

    protected void finalize() {
        this.closePort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataReceivedEvent(byte[] buf, int len) {
        m_log.trace("fireDataReceivedEvent (in)");
        if (buf == null || buf.length == 0) {
            m_log.error("fireDataReceivedEvent called with null or empty buffer **onDataReceived not called**");
            m_log.trace("fireDataReceivedEvent (out)");
            return;
        }
        if (this.SendingMessage) {
            Object object = this.CommandResponseObject;
            synchronized (object) {
                this.SendingMessage = false;
                this.ResponseBuffer = (byte[])buf.clone();
                this.CommandResponseObject.notifyAll();
            }
            return;
        }
        Enumeration<Object> e = Collections.enumeration(this.dataReceivedListeners);
        while (e.hasMoreElements()) {
            DataReceivedListener listener = (DataReceivedListener)e.nextElement();
            m_log.debug("fireDataRecievedEvent: Formatting rawBytes from FunctionLib");
            String rawBytes = FunctionLib.byteArrayToString(buf);
            m_log.debug("fireDataReceivedEvent: " + rawBytes);
            listener.onDataReceived(buf, len);
        }
        m_log.trace("fireDataReceivedEvent (out)");
    }

    protected void fireDeviceAddedEvent() {
        m_log.trace("fireDeviceAddedEvent (in)");
        Enumeration<Object> e = Collections.enumeration(this.deviceAddedListeners);
        while (e.hasMoreElements()) {
            DeviceAddedListener listener = (DeviceAddedListener)e.nextElement();
            listener.onDeviceAdded();
        }
        m_log.trace("fireDeviceAddedEvent (out)");
    }

    protected void fireDeviceReattachedEvent() {
        m_log.trace("fireDeviceReattachedEvent (in)");
        Enumeration<Object> e = Collections.enumeration(this.deviceReattachedListeners);
        while (e.hasMoreElements()) {
            DeviceReattachedListener listener = (DeviceReattachedListener)e.nextElement();
            listener.onDeviceReattached();
        }
        m_log.trace("fireDeviceReattachedEvent (out)");
    }

    protected void fireDeviceRemovedEvent() {
        m_log.trace("fireDeviceRemovedEvent (in)");
        Enumeration<Object> e = Collections.enumeration(this.deviceRemovedListeners);
        while (e.hasMoreElements()) {
            DeviceRemovedListener listener = (DeviceRemovedListener)e.nextElement();
            listener.onDeviceRemoved();
        }
        m_log.trace("fireDeviceRemovedEvent (out)");
    }

    public DLSDeviceInfo getDeviceInfo() {
        return this.m_info;
    }

    public boolean isDSR() {
        return false;
    }

    public boolean isOpen() {
        return this.bOpen;
    }

    public abstract boolean openPort();

    public void removeDataReceivedListener(DataReceivedListener drl) {
        m_log.trace("removeDataReceivedListener (in)");
        this.dataReceivedListeners.remove(drl);
        m_log.trace("removeDataReceivedListener (out)");
    }

    public void removeDeviceAddedListener(DeviceReattachedListener drl) {
        m_log.trace("removeDeviceAddedListener (in)");
        this.deviceAddedListeners.remove(drl);
        m_log.trace("removeDeviceAddedListener (out)");
    }

    public void removeDeviceReattachedListener(DeviceReattachedListener drl) {
        m_log.trace("removeDeviceReattachedListener (in)");
        this.deviceReattachedListeners.remove(drl);
        m_log.trace("removeDeviceReattachedListener (out)");
    }

    public void removeDeviceRemovedListener(DeviceRemovedListener drl) {
        m_log.trace("removeDeviceRemovedListener (in)");
        this.deviceRemovedListeners.remove(drl);
        m_log.trace("removeDeviceRemovedListener (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SendCommandResponse(byte[] send, PortResponse responseValue, int Timeout) {
        boolean returnValue = false;
        responseValue.SetBuffer(null);
        Object object = this.CommandResponseObject;
        synchronized (object) {
            this.SendingMessage = true;
            this.ResponseBuffer = null;
            if (this.sendData(send, send.length) > 0) {
                try {
                    this.CommandResponseObject.wait(Timeout);
                    if (!this.SendingMessage) {
                        responseValue.SetBuffer(this.ResponseBuffer);
                        returnValue = true;
                    }
                }
                catch (InterruptedException ie) {
                    m_log.error("Interrupt exception ", (Throwable)ie);
                }
            }
            this.SendingMessage = false;
            this.ResponseBuffer = null;
        }
        return returnValue;
    }

    public boolean SendCommandResponse(String send, PortResponse responseValue) {
        return this.SendCommandResponse(send, responseValue, 1000);
    }

    public boolean SendCommandResponse(String send, PortResponse responseValue, int Timeout) {
        return this.SendCommandResponse(send.getBytes(), responseValue, Timeout);
    }

    public boolean SendCommandResponse(byte[] send, PortResponse responseValue) {
        return this.SendCommandResponse(send, responseValue, 1000);
    }

    public abstract int sendData(byte[] var1, int var2);

    public int sendData(byte[] buf) {
        return this.sendData(buf, buf.length);
    }

    public int sendData(String strBuf) {
        return this.sendData(strBuf.getBytes(), strBuf.length());
    }

    public void setDeviceInfo(DLSDeviceInfo oInfo) {
        this.m_info = oInfo;
    }

    public void setRTS(boolean bValue) {
    }

    public abstract boolean startLiveWeight(byte[] var1, int var2, int var3);

    public abstract void stopLiveWeight();
}

