/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.transport;

import com.dls.jpos.common.Branding;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.common.DLSRegistryAccess;
import com.dls.jpos.common.DirWatcher;
import com.dls.jpos.transport.DLSPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TooManyListenersException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSSerialPort
extends DLSPort
implements SerialPortEventListener {
    protected InputStream inputStream = null;
    protected OutputStream outputStream = null;
    protected SerialPort serialPort = null;
    protected CommPortIdentifier portId = null;
    protected static final int RECEIVE_THRESHOLD = 1;
    protected static final int RECEIVE_TIMEOUT = 50;
    protected byte[] readBuffer = new byte[2048];
    protected byte[] localBuf = new byte[1];
    protected boolean bAliveMessageSent = false;
    protected String logData = "";
    protected String myPortName = "";
    protected int nOpens = 0;
    public String strPort;
    protected DLSProperties options;
    private static final Logger m_log = LogManager.getLogger(DLSSerialPort.class);

    public DLSSerialPort(DLSDeviceInfo info) {
        super(info);
    }

    @Override
    public boolean openPort() {
        String portName = "";
        m_log.trace("openPort (in)");
        this.strPort = this.m_info.getPortAsString();
        int inPort = 0;
        boolean bFound = false;
        Enumeration portList = null;
        Branding oBr = Branding.getInstance();
        String sPre = oBr.getBrandingPrefix();
        String sProp = "com." + sPre + ".jpos.service.Scanner.btWaitTime";
        this.options = DLSProperties.getInstance();
        int iSleep = this.options.get(sProp, 1000);
        if (this.strPort != null && !this.strPort.contains("COM")) {
            inPort = this.m_info.getPort();
        }
        m_log.info("Port: " + this.strPort + ", reported from jpos.xml");
        if (this.nOpens == 0) {
            if (File.separatorChar == '\\') {
                if (this.m_info.getUseVirtualPort()) {
                    this.strPort = DLSRegistryAccess.readRegistry("HKLM\\HARDWARE\\DEVICEMAP\\SERIALCOMM", "Virtual");
                    if (this.strPort != null) {
                        this.m_info.setPortAsString(this.strPort);
                        Pattern p = Pattern.compile("[0-9]+");
                        Matcher m = p.matcher(this.strPort);
                        while (m.find()) {
                            int n;
                            inPort = n = Integer.parseInt(m.group());
                            this.m_info.setPort(n);
                        }
                    }
                } else {
                    this.strPort = this.m_info.getPortAsString();
                }
            } else if (this.m_info.getUseCOMxOnLinux()) {
                this.strPort = this.m_info.getPortAsString();
            }
            try {
                if (File.separatorChar != '\\') {
                    try {
                        this.portId = CommPortIdentifier.getPortIdentifier((String)this.strPort);
                        portName = this.portId.getName();
                        bFound = true;
                    }
                    catch (NoSuchPortException nspe) {
                        m_log.error(this.strPort + " was not found: Make sure you have the correct value for portName in your jpos.xml file.", (Throwable)nspe);
                    }
                }
                if (!bFound) {
                    portList = CommPortIdentifier.getPortIdentifiers();
                    while (portList.hasMoreElements()) {
                        this.portId = (CommPortIdentifier)portList.nextElement();
                        if (this.m_info.getUseBluetoothDongle()) {
                            try {
                                m_log.debug("Sleeping: " + iSleep + " milliseconds");
                                Thread.sleep(iSleep);
                            }
                            catch (InterruptedException ex) {
                                m_log.error("Sleep had an exception: ", (Throwable)ex);
                            }
                        }
                        if (this.portId.getPortType() != 1) continue;
                        portName = this.portId.getName();
                        m_log.info("portName: " + portName);
                        if (portName.contains("ttyS") && portName.endsWith(String.valueOf(inPort - 1))) {
                            bFound = true;
                            break;
                        }
                        if (this.m_info.getUseCOMxOnLinux() && portName.contains("COM") && File.separatorChar == '\\') {
                            bFound = true;
                            break;
                        }
                        if (portName.contains("COM") && portName.endsWith(String.valueOf(inPort))) {
                            bFound = true;
                            break;
                        }
                        if (!portName.contains("ACM") || this.m_info.getUseCOMxOnLinux()) continue;
                        String[] portStrings = portName.split("ACM");
                        if (portStrings.length > 1) {
                            this.myPortName = portStrings[1];
                        }
                        bFound = true;
                        break;
                    }
                }
                if (bFound) {
                    try {
                        m_log.info("Port: " + portName + ", as identified by ComPortIdentifier");
                        String sPort = sPre.toUpperCase() + "SerialPort";
                        try {
                            this.serialPort = this.portId.open(sPort, 5000);
                        }
                        catch (NoSuchMethodError noSuchMethodErr) {
                            try {
                                Method method = CommPortIdentifier.class.getMethod("open", String.class, Integer.TYPE);
                                this.serialPort = (SerialPort)method.invoke((Object)this.portId, portName, 5000);
                            }
                            catch (RuntimeException re) {
                                throw re;
                            }
                            catch (Exception ex) {
                                m_log.error("openPort() NoSuchMethodError: ", (Throwable)noSuchMethodErr);
                                m_log.error("openPort() Exception: ", (Throwable)ex);
                            }
                        }
                        if (this.m_info.getUseBluetoothDongle()) {
                            try {
                                m_log.debug("Sleeping: " + iSleep + " milliseconds");
                                Thread.sleep(iSleep);
                            }
                            catch (InterruptedException ex) {
                                m_log.error("Sleep had an exception: ", (Throwable)ex);
                            }
                        }
                        this.setSerialParms();
                        this.inputStream = this.serialPort.getInputStream();
                        this.outputStream = this.serialPort.getOutputStream();
                        this.serialPort.addEventListener((SerialPortEventListener)this);
                        this.serialPort.notifyOnDataAvailable(true);
                        this.bOpen = true;
                        ++this.nOpens;
                    }
                    catch (UnsupportedCommOperationException ucoe) {
                        m_log.error("UnsupportedCommOperationException: ", (Throwable)ucoe);
                    }
                    catch (PortInUseException e) {
                        m_log.error("PortInUseException: ", (Throwable)e);
                    }
                    catch (IOException e) {
                        m_log.error("IOException: ", (Throwable)e);
                    }
                    catch (TooManyListenersException e) {
                        m_log.error("TooManyListenersException: ", (Throwable)e);
                    }
                }
                m_log.error("Port: " + this.strPort + ", not found");
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                m_log.error("openPort: Exception - ", (Throwable)e);
            }
        } else {
            this.bOpen = true;
        }
        if (File.separatorChar != '\\' && this.m_info.getDeviceCategory().contains("Scanner")) {
            sProp = "com." + sPre + ".jpos.service.ScannerService.poleRateForPortChange";
            int iRate = this.options.get(sProp, 2000);
            this.watchPort(iRate);
        }
        m_log.trace("openPort (out): " + Boolean.toString(this.bOpen));
        return this.bOpen;
    }

    public boolean findPort() {
        boolean bFound;
        block25: {
            m_log.trace("findPort (in)");
            String portName = "";
            this.strPort = this.m_info.getPortAsString();
            int inPort = 0;
            bFound = false;
            Enumeration portList = null;
            Branding oBr = Branding.getInstance();
            String sPre = oBr.getBrandingPrefix();
            String sProp = "com." + sPre + ".jpos.service.Scanner.btWaitTime";
            this.options = DLSProperties.getInstance();
            int iSleep = this.options.get(sProp, 1000);
            if (this.strPort != null && !this.strPort.contains("COM")) {
                inPort = this.m_info.getPort();
            }
            m_log.info("Port: " + this.strPort + ", reported from jpos.xml");
            if (File.separatorChar == '\\') {
                if (this.m_info.getUseVirtualPort()) {
                    this.strPort = DLSRegistryAccess.readRegistry("HKLM\\HARDWARE\\DEVICEMAP\\SERIALCOMM", "Virtual");
                    if (this.strPort != null) {
                        this.m_info.setPortAsString(this.strPort);
                        Pattern p = Pattern.compile("[0-9]+");
                        Matcher m = p.matcher(this.strPort);
                        while (m.find()) {
                            int n;
                            inPort = n = Integer.parseInt(m.group());
                            this.m_info.setPort(n);
                        }
                    }
                } else {
                    this.strPort = this.m_info.getPortAsString();
                }
            } else if (this.m_info.getUseCOMxOnLinux()) {
                this.strPort = this.m_info.getPortAsString();
            }
            try {
                if (File.separatorChar != '\\') {
                    try {
                        this.portId = CommPortIdentifier.getPortIdentifier((String)this.strPort);
                        portName = this.portId.getName();
                        bFound = true;
                    }
                    catch (NoSuchPortException nspe) {
                        m_log.error(this.strPort + " was not found: Make sure you have the correct value for portName in your jpos.xml file.", (Throwable)nspe);
                    }
                }
                if (bFound) break block25;
                portList = CommPortIdentifier.getPortIdentifiers();
                while (portList.hasMoreElements()) {
                    this.portId = (CommPortIdentifier)portList.nextElement();
                    if (this.m_info.getUseBluetoothDongle()) {
                        try {
                            m_log.debug("Sleeping: " + iSleep + " milliseconds");
                            Thread.sleep(iSleep);
                        }
                        catch (InterruptedException ex) {
                            m_log.error("Sleep had an exception: ", (Throwable)ex);
                        }
                    }
                    if (this.portId.getPortType() != 1) continue;
                    portName = this.portId.getName();
                    m_log.info("portName: " + portName);
                    if (portName.contains("ttyS") && portName.endsWith(String.valueOf(inPort - 1))) {
                        bFound = true;
                    } else if (this.m_info.getUseCOMxOnLinux() && portName.contains("COM") && File.separatorChar != '\\') {
                        bFound = true;
                    } else if (portName.contains("COM") && portName.endsWith(String.valueOf(inPort))) {
                        bFound = true;
                    } else {
                        if (!portName.contains("ACM") || this.m_info.getUseCOMxOnLinux()) continue;
                        String[] portStrings = portName.split("ACM");
                        if (portStrings.length > 1) {
                            this.myPortName = portStrings[1];
                        }
                        bFound = true;
                    }
                    break;
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                m_log.error("findPort: ", (Throwable)e);
            }
        }
        return bFound;
    }

    public boolean openPort(int next) {
        m_log.trace("openPort (in): " + Integer.toString(next));
        this.strPort = this.m_info.getPortAsString();
        int inPort = 0;
        boolean bFound = false;
        Enumeration portList = null;
        if (this.strPort != null && !this.strPort.contains("COM")) {
            inPort = this.m_info.getPort();
            ++inPort;
        }
        m_log.info("new port: " + inPort + ", reported from jpos.xml");
        if (this.nOpens == 0) {
            if (File.separatorChar == '\\') {
                if (this.m_info.getUseVirtualPort()) {
                    this.strPort = DLSRegistryAccess.readRegistry("HKLM\\HARDWARE\\DEVICEMAP\\SERIALCOMM", "Virtual");
                    if (this.strPort != null) {
                        this.m_info.setPortAsString(this.strPort);
                        Pattern p = Pattern.compile("[0-9]+");
                        Matcher m = p.matcher(this.strPort);
                        while (m.find()) {
                            int n;
                            inPort = n = Integer.parseInt(m.group());
                            this.m_info.setPort(n);
                        }
                    }
                } else {
                    this.strPort = this.m_info.getPortAsString();
                }
            } else if (this.m_info.getUseCOMxOnLinux()) {
                this.strPort = this.m_info.getPortAsString();
            }
            try {
                portList = CommPortIdentifier.getPortIdentifiers();
                while (portList.hasMoreElements()) {
                    this.portId = (CommPortIdentifier)portList.nextElement();
                    if (this.portId.getPortType() != 1) continue;
                    String portName = this.portId.getName();
                    if (portName.contains("ttyS") && portName.endsWith(String.valueOf(inPort - 1))) {
                        bFound = true;
                        break;
                    }
                    if (this.m_info.getUseCOMxOnLinux() && portName.contains("COM") && File.separatorChar != '\\') {
                        bFound = true;
                        break;
                    }
                    if (portName.contains("COM") && portName.endsWith(String.valueOf(inPort))) {
                        bFound = true;
                        break;
                    }
                    if (!portName.contains("ACM") || this.m_info.getUseCOMxOnLinux()) continue;
                    bFound = true;
                    break;
                }
                if (bFound) {
                    Branding oBr = Branding.getInstance();
                    String sPort = oBr.getBrandingPrefix().toUpperCase() + "SerialPort";
                    try {
                        try {
                            this.serialPort = this.portId.open(sPort, 5000);
                        }
                        catch (NoSuchMethodError noSuchMethodErr) {
                            try {
                                Method method = CommPortIdentifier.class.getMethod("open", String.class, Integer.TYPE);
                                this.serialPort = (SerialPort)method.invoke((Object)this.portId, sPort, 5000);
                            }
                            catch (RuntimeException re) {
                                throw re;
                            }
                            catch (Exception ex) {
                                m_log.error("openPort() NoSuchMethodError: ", (Throwable)noSuchMethodErr);
                                m_log.error("openPort() Exception: ", (Throwable)ex);
                            }
                        }
                        this.setSerialParms();
                        this.inputStream = this.serialPort.getInputStream();
                        this.outputStream = this.serialPort.getOutputStream();
                        this.serialPort.addEventListener((SerialPortEventListener)this);
                        this.serialPort.notifyOnDataAvailable(true);
                        this.bOpen = true;
                        ++this.nOpens;
                    }
                    catch (UnsupportedCommOperationException ucoe) {
                        m_log.error("UnsupportedCommOperationException: ", (Throwable)ucoe);
                    }
                    catch (PortInUseException e) {
                        m_log.error("PortInUseException: ", (Throwable)e);
                    }
                    catch (IOException e) {
                        m_log.error("IOException: ", (Throwable)e);
                    }
                    catch (TooManyListenersException e) {
                        m_log.error("TooManyListenersException: ", (Throwable)e);
                    }
                }
                m_log.error("Port: " + this.strPort + ", not found");
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                m_log.error("openPort: ", (Throwable)e);
            }
        } else {
            ++this.nOpens;
            this.bOpen = true;
        }
        m_log.trace("openPort (out): " + Boolean.toString(this.bOpen));
        return this.bOpen;
    }

    public boolean openPort(String newPort) {
        m_log.trace("openPort (in): " + newPort);
        boolean bFound = false;
        Enumeration portList = null;
        if (this.nOpens == 0) {
            try {
                portList = CommPortIdentifier.getPortIdentifiers();
                while (portList.hasMoreElements()) {
                    this.portId = (CommPortIdentifier)portList.nextElement();
                    if (this.portId.getPortType() != 1) continue;
                    String portName = this.portId.getName();
                    if (portName.contains("COM") && portName.endsWith(newPort)) {
                        bFound = true;
                        break;
                    }
                    if (!portName.contains("ACM") || this.m_info.getUseCOMxOnLinux() || !portName.endsWith(newPort)) continue;
                    String[] portStrings = portName.split("ACM");
                    if (portStrings.length > 1) {
                        this.myPortName = portStrings[1];
                    }
                    bFound = true;
                    break;
                }
                if (bFound) {
                    Branding oBr = Branding.getInstance();
                    String sPort = oBr.getBrandingPrefix().toUpperCase() + "SerialPort";
                    try {
                        try {
                            this.serialPort = this.portId.open(sPort, 5000);
                        }
                        catch (NoSuchMethodError noSuchMethodErr) {
                            try {
                                Method method = CommPortIdentifier.class.getMethod("open", String.class, Integer.TYPE);
                                this.serialPort = (SerialPort)method.invoke((Object)this.portId, sPort, 5000);
                            }
                            catch (RuntimeException re) {
                                throw re;
                            }
                            catch (Exception ex) {
                                m_log.error("openPort() NoSuchMethodError: ", (Throwable)noSuchMethodErr);
                                m_log.error("openPort() Exception: ", (Throwable)ex);
                            }
                        }
                        this.setSerialParms();
                        this.inputStream = this.serialPort.getInputStream();
                        this.outputStream = this.serialPort.getOutputStream();
                        this.serialPort.addEventListener((SerialPortEventListener)this);
                        this.serialPort.notifyOnDataAvailable(true);
                        this.bOpen = true;
                        ++this.nOpens;
                    }
                    catch (UnsupportedCommOperationException ucoe) {
                        m_log.error("UnsupportedCommOperationException: ", (Throwable)ucoe);
                    }
                    catch (PortInUseException e) {
                        m_log.error("PortInUseException: ", (Throwable)e);
                    }
                    catch (IOException e) {
                        m_log.error("IOException: ", (Throwable)e);
                    }
                    catch (TooManyListenersException e) {
                        m_log.error("TooManyListenersException: ", (Throwable)e);
                    }
                }
                m_log.error("Port: " + this.strPort + ", not found");
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                m_log.error("openPort: ", (Throwable)e);
            }
        } else {
            ++this.nOpens;
            this.bOpen = true;
        }
        m_log.trace("openPort (out): " + Boolean.toString(this.bOpen));
        return this.bOpen;
    }

    @Override
    public boolean startLiveWeight(byte[] buf, int len, int rate) {
        return false;
    }

    @Override
    public void stopLiveWeight() {
    }

    public String getPortName() {
        return this.strPort;
    }

    protected void setSerialParms() throws UnsupportedCommOperationException {
        try {
            int nBaud = this.m_info.getBaud();
            int nData = this.m_info.getDatabits();
            int nStop = this.m_info.getStopbits();
            String strParity = this.m_info.getParity();
            int nParity = 0;
            int flowControl = this.m_info.getFlowControl().equals("Xon/Xoff") ? 4 : (this.m_info.getFlowControl().equals("Hardware") ? 1 : 0);
            char bParity = strParity.charAt(0);
            switch (bParity) {
                case 'N': {
                    nParity = 0;
                    break;
                }
                case 'E': {
                    nParity = 2;
                    break;
                }
                case 'O': {
                    nParity = 1;
                    break;
                }
                case 'S': {
                    nParity = 4;
                    break;
                }
                case 'M': {
                    nParity = 3;
                }
            }
            switch (nData) {
                case 5: {
                    nData = 5;
                    break;
                }
                case 6: {
                    nData = 6;
                    break;
                }
                case 7: {
                    nData = 7;
                    break;
                }
                case 8: {
                    nData = 8;
                }
            }
            switch (nStop) {
                case 1: {
                    nStop = 1;
                    break;
                }
                case 2: {
                    nStop = 2;
                }
            }
            this.serialPort.setSerialPortParams(nBaud, nData, nStop, nParity);
            this.serialPort.enableReceiveThreshold(1);
            this.serialPort.enableReceiveTimeout(50);
            this.serialPort.setRTS(true);
        }
        catch (UnsupportedCommOperationException e) {
            m_log.error("UnsupportedCommOperationException: ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            m_log.error("Exception thrown in setSerialParms: ", (Throwable)e);
        }
    }

    @Override
    public void changeBaudRate(int nBaud) {
        try {
            int nData = this.m_info.getDatabits();
            int nStop = this.m_info.getStopbits();
            String strParity = this.m_info.getParity();
            int nParity = 0;
            int flowControl = this.m_info.getFlowControl().equals("Xon/Xoff") ? 4 : (this.m_info.getFlowControl().equals("Hardware") ? 1 : 0);
            char bParity = strParity.charAt(0);
            switch (bParity) {
                case 'N': {
                    nParity = 0;
                    break;
                }
                case 'E': {
                    nParity = 2;
                    break;
                }
                case 'O': {
                    nParity = 1;
                    break;
                }
                case 'S': {
                    nParity = 4;
                    break;
                }
                case 'M': {
                    nParity = 3;
                }
            }
            switch (nData) {
                case 5: {
                    nData = 5;
                    break;
                }
                case 6: {
                    nData = 6;
                    break;
                }
                case 7: {
                    nData = 7;
                    break;
                }
                case 8: {
                    nData = 8;
                }
            }
            switch (nStop) {
                case 1: {
                    nStop = 1;
                    break;
                }
                case 2: {
                    nStop = 2;
                }
            }
            this.serialPort.setSerialPortParams(nBaud, nData, nStop, nParity);
            this.serialPort.enableReceiveThreshold(1);
            this.serialPort.enableReceiveTimeout(50);
            this.serialPort.setRTS(true);
        }
        catch (UnsupportedCommOperationException e) {
            m_log.error("UnsupportedCommOperationException: ", (Throwable)e);
        }
        catch (Exception e) {
            m_log.trace("Exception thrown in changeBaudRate: ", (Throwable)e);
        }
    }

    @Override
    public boolean closePort() {
        boolean result = true;
        m_log.trace("closePort (in)");
        try {
            m_log.debug("closePort: nOpens = " + this.nOpens);
            --this.nOpens;
            if (this.nOpens >= 0) {
                m_log.debug("closePort: nOpens <= 0 = " + this.nOpens);
                if (this.serialPort != null) {
                    m_log.debug("closePort: serialPort != null");
                    this.serialPort.notifyOnDataAvailable(false);
                    this.inputStream.close();
                    this.outputStream.close();
                    if (File.separatorChar == '\\') {
                        this.serialPort.removeEventListener();
                    }
                    this.serialPort.close();
                    this.serialPort = null;
                    this.inputStream = null;
                    this.outputStream = null;
                    this.portId = null;
                }
                if (this.nOpens == 0) {
                    this.bOpen = false;
                }
            }
        }
        catch (Exception e) {
            m_log.error("Error closing port: ", (Throwable)e);
            result = false;
        }
        m_log.trace("closePort (out): " + Boolean.toString(result));
        return result;
    }

    @Override
    public int sendData(byte[] buf, int len) {
        m_log.trace("sendData (in): " + Integer.toString(len));
        int i = 0;
        if (buf == null || len == 0 || buf.length == 0) {
            m_log.debug("sendData: Empty or null buffer or zero length supplied.");
            m_log.trace("sendData (out): " + Integer.toString(i));
            return i;
        }
        if (this.outputStream == null) {
            m_log.error("sendData: Output Stream is null.  Cannot write.");
            return 0;
        }
        m_log.debug("sendData: Possibly assigning 0x45 and 0x46 to local buffer");
        if (buf[0] == 69) {
            this.localBuf[0] = 69;
        }
        if (buf[0] == 68) {
            this.localBuf[0] = 68;
        }
        m_log.debug("sendData: Trying to write buffer to output stream.");
        try {
            if (len == 1) {
                this.outputStream.write(buf[0]);
            } else {
                this.outputStream.write(buf);
            }
            this.logData = "";
            for (i = 0; i < len; ++i) {
                String result = String.format(" 0x%02X", buf[i]);
                this.logData = this.logData + result;
            }
            m_log.debug("sendData: bytes sent[" + i + "]" + this.logData);
        }
        catch (IOException e) {
            m_log.error("sendData: IOException: ", (Throwable)e);
        }
        m_log.trace("sendData (out): " + Integer.toString(i));
        return i;
    }

    public void onDeviceRemoved() {
        m_log.trace("onDeviceRemoved (in)");
        this.fireDeviceRemovedEvent();
        m_log.trace("onDeviceRemoved (out)");
    }

    public void onDeviceReattached() {
        m_log.trace("onDeviceReattached (in)");
        this.fireDeviceReattachedEvent();
        m_log.trace("onDeviceReattached (out)");
    }

    private void watchPort(final int portPollRate) {
        DirWatcher task1 = new DirWatcher("/dev", "ACM"){

            @Override
            protected void onChange(File file, String action) {
                m_log.debug("DirWatcher.onChange: File " + file.getName() + " action: " + action);
                try {
                    Thread.sleep(portPollRate);
                }
                catch (InterruptedException ex) {
                    m_log.error("DirWatcher.onChange: Thread.sleep: ", (Throwable)ex);
                }
                if (!DLSSerialPort.this.bAliveMessageSent && action.contains("add")) {
                    DLSSerialPort.this.bAliveMessageSent = true;
                    byte[] bBuf = new byte[]{104};
                    int nBytesSent = DLSSerialPort.this.sendData(bBuf, 1);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        m_log.error("DirWatcher.onChange: error in sleep", (Throwable)ex);
                    }
                    if (nBytesSent == 0) {
                        DLSSerialPort.this.closePort();
                        DLSSerialPort.this.openPort(file.getName());
                        DLSSerialPort.this.sendData(DLSSerialPort.this.localBuf, 1);
                    }
                    DLSSerialPort.this.bAliveMessageSent = false;
                }
            }
        };
        Timer timer = new Timer();
        timer.schedule((TimerTask)task1, new Date(), (long)portPollRate);
    }

    @Override
    public boolean isDSR() {
        return this.serialPort.isDSR();
    }

    @Override
    public void setRTS(boolean bValue) {
        this.serialPort.setRTS(bValue);
    }

    public void serialEvent(SerialPortEvent event) {
        m_log.trace("serialEvent (in)");
        switch (event.getEventType()) {
            case 10: {
                m_log.debug("event.getEventType: BI");
                break;
            }
            case 7: {
                m_log.debug("event.getEventType: OE");
                break;
            }
            case 9: {
                m_log.debug("event.getEventType: FE");
                break;
            }
            case 8: {
                m_log.debug("event.getEventType: PE");
                break;
            }
            case 6: {
                m_log.debug("event.getEventType: CD");
                break;
            }
            case 3: {
                m_log.debug("event.getEventType: CTS");
                break;
            }
            case 4: {
                m_log.debug("event.getEventType: DSR");
                break;
            }
            case 5: {
                m_log.debug("event.getEventType: RI");
                break;
            }
            case 2: {
                m_log.debug("event.getEventType: OUTPUT_BUFFER_EMPTY");
                break;
            }
            case 1: {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                try {
                    int numBytes = 0;
                    while (this.inputStream.available() > 0) {
                        numBytes = this.inputStream.read(this.readBuffer);
                        bs.write(this.readBuffer, 0, numBytes);
                    }
                    byte[] bytesRead = bs.toByteArray();
                    if (this.bAliveMessageSent) {
                        this.bAliveMessageSent = false;
                        this.readBuffer = bytesRead;
                        break;
                    }
                    this.fireDataReceivedEvent(bytesRead, bytesRead.length);
                    break;
                }
                catch (IOException e) {
                    m_log.error("IOException: ", (Throwable)e);
                }
            }
        }
        m_log.trace("serialEvent (out)");
    }
}

