/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.transport;

import com.dls.jpos.common.Branding;
import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSProperties;
import com.dls.jpos.transport.DLSPort;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSTCPIPPort
extends DLSPort {
    protected InputStream inputStream = null;
    protected OutputStream outputStream = null;
    protected static final int RECEIVE_THRESHOLD = 1;
    protected static final int RECEIVE_TIMEOUT = 40;
    protected byte[] readBuffer = new byte[2048];
    protected String logData = "";
    protected int nOpens = 0;
    public String strPort;
    public String strHealth;
    public Socket kkSocket;
    public BufferedWriter outw = null;
    public BufferedReader inr = null;
    stEnum inState = stEnum.ST_IDLE;
    private char[] fBuff = new char[65536];
    private byte[] tBuff = new byte[65536];
    char[] inCharArray;
    ByteBuffer bB;
    byte[] bytesRead = new byte[2048000];
    public FileOutputStream fOutStream;
    public String ipAddr;
    private boolean hostThreadRunning = false;
    private boolean hostConnected = false;
    public static final byte htpEnable = 101;
    public static final byte htpDisable = 100;
    public static final byte htpConnected = 97;
    public static final byte htpTest = 84;
    public int hostPortNum;
    public boolean isOpen = false;
    protected boolean bShutDownThread = false;
    private char[] inInt = new char[4];
    private char[] inInt2 = new char[4];
    private Thread tcpIPThread = new tcpipThread();
    protected static final String heartbeatResponseCmd = "y";
    private static final Logger m_log = LogManager.getLogger(DLSTCPIPPort.class);
    static tcpipThread tcpipT;

    public DLSTCPIPPort(DLSDeviceInfo info) {
        super(info);
        this.initialize();
    }

    private void initialize() {
        this.tcpIPThread.start();
    }

    public boolean isHostConnected() {
        return this.hostConnected;
    }

    public boolean isHostThreadRunning() {
        return this.hostThreadRunning;
    }

    public void setHostConnected(boolean bConnected) {
        this.hostConnected = bConnected;
    }

    public void setHostThreadRunning(boolean bRunning) {
        this.hostThreadRunning = bRunning;
    }

    @Override
    public boolean openPort() {
        m_log.trace("openPort (in)");
        String ipPortNum = this.m_info.getIPPort();
        this.hostPortNum = Integer.parseInt(ipPortNum);
        this.ipAddr = this.m_info.getIPAddress();
        m_log.debug("IP Address: " + this.ipAddr);
        m_log.debug("Port: " + this.hostPortNum + ", reported from jpos.xml");
        this.bOpen = false;
        if (this.nOpens == 0) {
            ++this.nOpens;
        } else {
            m_log.error("Port: " + this.strPort + ", not found");
            m_log.trace("openPort (out): " + Boolean.toString(this.bOpen));
            return this.bOpen;
        }
        this.bOpen = true;
        if (!this.isHostConnected()) {
            this.bOpen = this.hostConnect();
        }
        m_log.trace("openPort (out): " + Boolean.toString(this.bOpen));
        return this.bOpen;
    }

    public boolean hostConnect() {
        m_log.trace("hostConnect (in)");
        boolean bConnect = true;
        try {
            this.kkSocket = new Socket(this.ipAddr, this.hostPortNum);
            this.inr = new BufferedReader(new InputStreamReader(this.kkSocket.getInputStream(), "ISO-8859-1"));
            this.outw = new BufferedWriter(new OutputStreamWriter(this.kkSocket.getOutputStream(), "ISO-8859-1"));
            this.setHostConnected(true);
            this.kkSocket.setTcpNoDelay(true);
            this.isOpen = true;
            this.bShutDownThread = false;
            this.setHostThreadRunning(true);
        }
        catch (UnknownHostException e) {
            m_log.error("hostConnect: Unknown Host. ", (Throwable)e);
            bConnect = false;
        }
        catch (IOException e) {
            m_log.error("hostConnect: IO Exception. ", (Throwable)e);
            bConnect = false;
        }
        m_log.trace("hostConnect (out): " + Boolean.toString(bConnect));
        return bConnect;
    }

    public String getPortName() {
        return this.strPort;
    }

    @Override
    public boolean closePort() {
        boolean result = true;
        m_log.trace("closePort (in)");
        try {
            m_log.debug("closePort: nOpens = " + this.nOpens);
            --this.nOpens;
            if (this.nOpens >= 0) {
                m_log.debug("closePort: TCPPort");
                result = this.hostDisconnect();
                this.bOpen = false;
                this.isOpen = false;
            }
        }
        catch (Exception e) {
            m_log.error("closePort: Exception. ", (Throwable)e);
            result = false;
        }
        this.bShutDownThread = true;
        m_log.trace("closePort (out): " + Boolean.toString(result));
        return result;
    }

    public boolean hostDisconnect() {
        boolean result = true;
        m_log.trace("hostDisconnect (in)");
        try {
            m_log.debug("Bypass Host monitor thread...");
            this.setHostThreadRunning(false);
            m_log.debug("Closing Socket...");
            this.setHostConnected(false);
            if (this.outw != null) {
                m_log.debug("Closing out...");
                this.outw.flush();
                this.outw.close();
            }
            if (this.inr != null) {
                m_log.debug("Closing in...");
                this.inr.close();
            }
            if (this.kkSocket != null) {
                m_log.debug("Closing kksocket...");
                this.kkSocket.close();
            }
        }
        catch (UnknownHostException e) {
            m_log.error("hostDisconnect: Unknown Host. ", (Throwable)e);
            result = false;
        }
        catch (IOException e) {
            m_log.error("hostDisconnect: IO Exception. ", (Throwable)e);
            result = false;
        }
        m_log.trace("hostDisconnect (out): " + Boolean.toString(result));
        return result;
    }

    @Override
    public int sendData(byte[] buf, int len) {
        if (this.nOpens == 0) {
            return 0;
        }
        int nBytes = buf.length;
        this.logData = "";
        for (int i = 0; i < nBytes; ++i) {
            String result = String.format(" 0x%02X", buf[i]);
            this.logData = this.logData + result;
        }
        m_log.debug("bytes sent[" + nBytes + "] " + this.logData);
        String sendBuff = new String(buf).substring(1);
        this.hostSendIt(buf[0], sendBuff);
        return nBytes;
    }

    public int sendData(byte cmd, String inStr) {
        if (this.nOpens == 0) {
            return 0;
        }
        int nBytes = inStr.length();
        this.logData = inStr;
        m_log.debug("bytes sent[" + nBytes + "]" + this.logData);
        this.hostSendIt(cmd, inStr);
        return nBytes;
    }

    @Override
    public int sendData(String buf) {
        if (this.nOpens == 0) {
            return 0;
        }
        int nBytes = buf.length();
        this.logData = "";
        m_log.debug("bytes sent[" + nBytes + "]" + buf);
        byte[] byteBuf = buf.getBytes();
        this.hostSendIt(byteBuf[0], buf.substring(1));
        return nBytes;
    }

    public void hostSendIt(byte mtype, String mbody) {
        StringBuilder oSb = new StringBuilder();
        m_log.trace("hostSendIt (in): " + Byte.toString(mtype) + ", " + mbody);
        if (this.nOpens == 0) {
            m_log.debug("port closed");
            m_log.trace("hostSendIt (out)");
            return;
        }
        if (this.isOpen) {
            try {
                this.outw.write(mtype);
                oSb.append(String.format("0x%02X ", mtype));
                int strLen = mbody.length();
                byte len = (byte)(0xFF & strLen / 0x1000000);
                this.outw.write(len);
                oSb.append(String.format("0x%02X", len));
                len = (byte)(0xFF & strLen / 65536);
                this.outw.write(len);
                oSb.append(String.format("%02X", len));
                len = (byte)(0xFF & strLen / 256);
                this.outw.write(len);
                oSb.append(String.format("%02X", len));
                len = (byte)(strLen % 256);
                this.outw.write(len);
                oSb.append(String.format("%02X ", len));
                for (int i = 0; i < mbody.length(); ++i) {
                    this.outw.write(mbody.charAt(i));
                    oSb.append(String.format("0x%02X ", (byte)mbody.charAt(i)));
                }
                this.outw.flush();
            }
            catch (IOException ex) {
                m_log.error("hostSendIt: IO Exception. ", (Throwable)ex);
            }
            catch (NullPointerException e) {
                m_log.error("hostSendIt: Null Pointer. ", (Throwable)e);
            }
        }
        m_log.debug("bytes sent to port: " + oSb.toString());
        m_log.trace("hostSendIt (out)");
    }

    public void hostSendIt2(byte mtype, String mbody) {
        m_log.trace("hostSendIt2 (in): " + Byte.toString(mtype) + ", " + mbody);
        if (this.nOpens == 0) {
            m_log.debug("port closed");
            m_log.trace("hostSendIt2 (out)");
            return;
        }
        try {
            this.outw.write(mtype);
            int strLen = mbody.length();
            byte len = (byte)(0xFF & strLen / 0x1000000);
            this.outw.write(len);
            len = (byte)(0xFF & strLen / 65536);
            this.outw.write(len);
            len = (byte)(0xFF & strLen / 256);
            this.outw.write(len);
            len = (byte)(0xFF & strLen);
            this.outw.write(len);
            for (int i = 0; i < mbody.length(); ++i) {
                this.outw.write(mbody.charAt(i));
            }
            this.outw.flush();
        }
        catch (IOException ex) {
            m_log.error("hostSendIt2: IO Exception. ", (Throwable)ex);
        }
        m_log.trace("hostSendIt2 (out)");
    }

    public void hostGetAll() {
        int rawMsgLen = 0;
        boolean bNotFound = false;
        m_log.trace("hostGetAll (in)");
        block12: do {
            try {
                while (this.isHostThreadRunning()) {
                    char inChar = (char)this.inr.read();
                    switch (inChar) {
                        case 'F': 
                        case 'G': 
                        case 'H': 
                        case 'K': 
                        case 'N': {
                            break;
                        }
                        case 'W': {
                            m_log.debug("Configuration Item Value Message");
                            break;
                        }
                        case 'Y': {
                            m_log.debug("Configuration Item Params Message");
                            break;
                        }
                        case 'C': {
                            m_log.debug("Got Connected Message");
                            break;
                        }
                        case 'A': 
                        case 'B': 
                        case 'I': 
                        case 'L': 
                        case 'O': 
                        case 'P': 
                        case 'T': 
                        case 'U': 
                        case 'V': {
                            break;
                        }
                        case 'X': {
                            m_log.debug("Got Check Connection Message");
                            int x = this.sendData("y1");
                            break;
                        }
                    }
                    if (inChar == 'P') {
                        if (!this.hostGetImageData(inChar)) {
                            continue;
                        }
                    } else {
                        String result;
                        int i;
                        m_log.debug("hostGetAll: inChar =  " + inChar);
                        int byteRead = this.inr.read(this.inInt, 0, 4);
                        m_log.debug("hostGetAll: bytesRead  =  " + byteRead);
                        if (byteRead == -1) {
                            m_log.debug("hostGetAll: EOF on read.");
                            break block12;
                        }
                        int msgLen = this.inInt[0];
                        msgLen = msgLen * 256 + this.inInt[1];
                        msgLen = msgLen * 256 + this.inInt[2];
                        if ((msgLen = msgLen * 256 + this.inInt[3]) > 1312788 || msgLen < 0) {
                            m_log.debug("hostGetAll: msgLen: out of bounds");
                            continue;
                        }
                        m_log.debug("hostGetAll: msgLen: " + msgLen);
                        this.inCharArray = new char[msgLen];
                        byteRead = this.inr.read(this.inCharArray, 0, msgLen);
                        m_log.debug("hostGetAll: bytesRead  =  " + byteRead);
                        if (byteRead == -1) {
                            m_log.debug("hostGetAll: EOF on read.");
                        }
                        rawMsgLen = msgLen + 5;
                        this.bytesRead = new byte[rawMsgLen];
                        this.bytesRead[0] = (byte)(inChar & 0xFF);
                        this.bytesRead[1] = (byte)(this.inInt[0] & 0xFF);
                        this.bytesRead[2] = (byte)(this.inInt[1] & 0xFF);
                        this.bytesRead[3] = (byte)(this.inInt[2] & 0xFF);
                        this.bytesRead[4] = (byte)(this.inInt[3] & 0xFF);
                        for (i = 0; i < msgLen; ++i) {
                            this.bytesRead[i + 5] = (byte)(this.inCharArray[i] & 0xFF);
                        }
                        this.logData = "";
                        for (i = 0; i < msgLen; ++i) {
                            result = String.format(" %c", Character.valueOf(this.inCharArray[i]));
                            this.logData = this.logData + result;
                            if (i == 50) break;
                        }
                        m_log.debug("hostGetAll: inCharArray bytes received[" + msgLen + "] " + this.logData);
                        this.logData = "";
                        for (i = 0; i < rawMsgLen; ++i) {
                            result = String.format(" 0x%02X", this.bytesRead[i]);
                            this.logData = this.logData + result;
                            if (i == 50) break;
                        }
                        m_log.debug("hostGetAll: bytes received[" + rawMsgLen + "] " + this.logData);
                    }
                    this.fireDataReceivedEvent(this.bytesRead, rawMsgLen);
                    continue block12;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    m_log.error("hostGetAll: Interrupted. ", (Throwable)ex);
                }
            }
            catch (IOException e) {
                m_log.error("hostGetAll: IO Exception. ", (Throwable)e);
            }
        } while (!this.bShutDownThread);
        m_log.trace("hostGetAll (out)");
    }

    protected boolean hostGetImageData(char inChar) throws IOException {
        int total = 0;
        int msgLen = 0;
        int i = 0;
        DLSProperties oProps = null;
        String sDest = "";
        oProps = DLSProperties.getInstance();
        int bRead = this.inr.read(this.inInt, 0, 4);
        m_log.debug("hostGetAll: bytesRead  =  " + bRead);
        if (bRead == -1) {
            m_log.debug("hostGetImageData: EOF on read.");
        }
        msgLen = this.inInt[0];
        msgLen = 256 * msgLen + this.inInt[1];
        msgLen = 256 * msgLen + this.inInt[2];
        if ((msgLen = 256 * msgLen + this.inInt[3]) > 1312788 || msgLen < 0) {
            m_log.debug("hostGetImageData: msgLen - out of bounds");
            return false;
        }
        bRead = this.inr.read(this.inInt2, 0, 4);
        m_log.debug("hostGetAll: bytesRead  =  " + bRead);
        if (bRead == -1) {
            m_log.debug("hostGetImageData: EOF on read.");
        }
        int imageID = this.inInt2[0];
        imageID = 256 * imageID + this.inInt2[1];
        imageID = 256 * imageID + this.inInt2[2];
        imageID = 256 * imageID + this.inInt2[3];
        int imgOrientation = this.inr.read();
        int imgFormat = this.inr.read();
        String fname = "ps" + imageID + ".jpg";
        this.inInt[3] = (char)(fname.length() + this.inInt2.length + 2);
        char[] fnameCharArray = fname.toCharArray();
        this.bytesRead = new byte[this.inInt[3] * 2 + 10];
        this.bytesRead[0] = (byte)inChar;
        this.bytesRead[1] = (byte)(this.inInt[0] & 0xFF);
        this.bytesRead[2] = (byte)(this.inInt[1] & 0xFF);
        this.bytesRead[3] = (byte)(this.inInt[2] & 0xFF);
        this.bytesRead[4] = (byte)(this.inInt[3] & 0xFF);
        this.bytesRead[5] = (byte)(this.inInt2[0] & 0xFF);
        this.bytesRead[6] = (byte)(this.inInt2[1] & 0xFF);
        this.bytesRead[7] = (byte)(this.inInt2[2] & 0xFF);
        this.bytesRead[8] = (byte)(this.inInt2[3] & 0xFF);
        this.bytesRead[9] = (byte)imgOrientation;
        this.bytesRead[10] = (byte)imgFormat;
        for (i = 0; i < fnameCharArray.length; ++i) {
            this.bytesRead[i + 11] = (byte)fnameCharArray[i];
        }
        this.bytesRead[1] = (byte)(i + 6 & 0xFF);
        this.bytesRead[2] = 0;
        this.bytesRead[3] = 0;
        this.bytesRead[4] = 0;
        boolean done = false;
        total = 0;
        inChar = '\u0000';
        int imgLength = msgLen - 6;
        Branding oBr = Branding.getInstance();
        String sProp = "com." + oBr.getBrandingPrefix() + ".jpos.transport.DLSTCPIPPort.imageDest";
        sDest = oProps.get(sProp, "");
        if (!sDest.equals("")) {
            File oFile;
            if (!sDest.endsWith("/") && !sDest.endsWith("\\")) {
                sDest = sDest + File.separator;
            }
            if (!(oFile = new File(sDest)).isDirectory()) {
                m_log.error("Invalid image destination specified: " + sDest + " is not a valid directory, resetting.");
                sDest = "";
            }
            if (!oFile.canWrite()) {
                m_log.error("Image destination " + sDest + " cannot be written.  Resetting.");
                sDest = "";
            }
        }
        sDest = sDest + "ps" + imageID + ".jpg";
        this.fOutStream = new FileOutputStream(sDest);
        while (!done) {
            if (imgLength - total >= 32768) {
                inChar = (char)this.inr.read(this.fBuff, 0, 32768);
            } else if (imgLength - total > 0) {
                inChar = (char)this.inr.read(this.fBuff, 0, imgLength - total);
            }
            for (i = 0; i < inChar; ++i) {
                this.tBuff[i] = (byte)this.fBuff[i];
            }
            this.fOutStream.write(this.tBuff, 0, inChar);
            if ((total += inChar) < imgLength) continue;
            done = true;
        }
        this.fOutStream.close();
        this.inState = stEnum.ST_IDLE;
        this.fOutStream = null;
        return true;
    }

    public void tcpRead() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try {
            int numBytes = 0;
            while (this.inputStream.available() > 0) {
                numBytes = this.inputStream.read(this.readBuffer);
                bs.write(this.readBuffer, 0, numBytes);
            }
            byte[] akRead = bs.toByteArray();
            this.logData = "";
            for (int i = 0; i < akRead.length; ++i) {
                String result = String.format(" 0x%02X", akRead[i]);
                this.logData = this.logData + result;
                if (i == 50) break;
            }
            m_log.debug("(tcpRead)bytes received[" + akRead.length + "]");
            this.fireDataReceivedEvent(akRead, akRead.length);
        }
        catch (IOException e) {
            m_log.error("tcpRead: IO Exception. ", (Throwable)e);
        }
    }

    @Override
    public void changeBaudRate(int nBaud) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean startLiveWeight(byte[] buf, int len, int rate) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void stopLiveWeight() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static byte[] setIPAddress(String str) {
        String[] ipSplit = new String[5];
        byte[] lIPAddr = new byte[10];
        ipSplit = str.split("\\x2E");
        int temp = Integer.parseInt(ipSplit[0]);
        lIPAddr[0] = (byte)temp;
        temp = Integer.parseInt(ipSplit[1]);
        lIPAddr[1] = (byte)temp;
        temp = Integer.parseInt(ipSplit[2]);
        lIPAddr[2] = (byte)temp;
        temp = Integer.parseInt(ipSplit[3]);
        lIPAddr[3] = (byte)temp;
        return lIPAddr;
    }

    protected void startup() {
        this.setHostThreadRunning(false);
        tcpipT = new tcpipThread();
        tcpipT.start();
    }

    public class tcpipThread
    extends Thread {
        @Override
        public void run() {
            DLSTCPIPPort.this.hostGetAll();
        }
    }

    static enum stEnum {
        ST_IDLE,
        ST_SIG1,
        ST_ACK,
        ST_ITEM,
        ST_PIC,
        ST_LABEL,
        ST_LOC,
        ST_VOL,
        ST_TRACKING,
        ST_FAULT,
        ST_CONNECTED,
        ST_UPDATE_ITEM,
        ST_LABEL_CHOICE,
        ST_OTHER;

    }
}

