/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.transport;

import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.transport.DLSPort;
import com.dls.jpos.transport.DLSUsbQuery;
import com.ibm.jusb.UsbPipeImp;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbInterface;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import javax.usb.UsbPipe;
import javax.usb.UsbServices;
import javax.usb.event.UsbDeviceDataEvent;
import javax.usb.event.UsbDeviceErrorEvent;
import javax.usb.event.UsbDeviceEvent;
import javax.usb.event.UsbDeviceListener;
import javax.usb.event.UsbServicesEvent;
import javax.usb.event.UsbServicesListener;
import javax.usb.util.UsbUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSUsbJavax
extends DLSPort
implements UsbDeviceListener,
UsbServicesListener {
    private static final byte[] statusCmd = new byte[]{0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private UsbInterface usbInterface = null;
    private ReadData rd = null;
    private boolean bLiveWeight = false;
    private int nPollRate = 1000;
    private byte[] weightCmd;
    private final Object deviceClassLock = new Object();
    private UsbPipe lUsbPipe = null;
    private String sResult = null;
    private String logData = null;
    private static final byte[] resetCmd = new byte[]{0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final Logger m_log = LogManager.getLogger(DLSUsbJavax.class);
    private final ScheduledExecutorService m_scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> m_liveWeight = null;

    public DLSUsbJavax(DLSDeviceInfo info) {
        super(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean openPort() {
        boolean bRc = true;
        m_log.trace("openPort (in)");
        Object object = this.deviceClassLock;
        synchronized (object) {
            DLSUsbQuery query = new DLSUsbQuery();
            UsbEndpoint usbEndpoint = null;
            UsbPipe usbPipe = null;
            try {
                this.usbInterface = query.findDevice(this.m_info);
                if (this.usbInterface == null) {
                    m_log.trace("openPort (out): false");
                    return false;
                }
                this.usbInterface.claim();
                List usbEndpoints = this.usbInterface.getUsbEndpoints();
                for (int i = 0; i < usbEndpoints.size() && (3 != (usbEndpoint = (UsbEndpoint)usbEndpoints.get(i)).getType() || -128 != usbEndpoint.getDirection()); ++i) {
                }
                this.lUsbPipe = usbPipe = usbEndpoint.getUsbPipe();
                usbPipe.open();
                ReadData i = this.rd = new ReadData(usbPipe);
                synchronized (i) {
                    Thread rdThread = new Thread(this.rd);
                    rdThread.start();
                    try {
                        this.rd.wait();
                    }
                    catch (InterruptedException ie) {
                        m_log.error("openPort: Interrupted. ", (Throwable)ie);
                    }
                }
                this.bOpen = true;
            }
            catch (DLSException p) {
                m_log.error("openPort: DLSException. ", (Throwable)p);
                bRc = false;
            }
            catch (UsbException u) {
                m_log.error("openPort: USB Exception. ", (Throwable)u);
                bRc = false;
            }
            catch (UsbNotActiveException na) {
                m_log.error("openPort: USB Not Active. ", (Throwable)na);
                bRc = false;
            }
            catch (UsbNotClaimedException nc) {
                m_log.error("openPort: USB Not Claimed. ", (Throwable)nc);
                bRc = false;
            }
            catch (UsbDisconnectedException dc) {
                m_log.error("openPort: USB Disconnected. ", (Throwable)dc);
                bRc = false;
            }
            if (!bRc) {
                this.usbInterface = null;
                usbPipe = null;
                usbEndpoint = null;
            } else {
                UsbDevice usbDevice = this.usbInterface.getUsbConfiguration().getUsbDevice();
                if (usbDevice != null) {
                    usbDevice.removeUsbDeviceListener((UsbDeviceListener)this);
                    usbDevice.addUsbDeviceListener((UsbDeviceListener)this);
                }
                UsbServices services = null;
                try {
                    services = UsbHostManager.getUsbServices();
                    services.removeUsbServicesListener((UsbServicesListener)this);
                    services.addUsbServicesListener((UsbServicesListener)this);
                }
                catch (UsbException e) {
                    m_log.error("openPort: USB Exception. ", (Throwable)e);
                }
                catch (SecurityException e) {
                    m_log.error("openPort: Security Exception. ", (Throwable)e);
                }
            }
        }
        m_log.trace("openPort (out): " + Boolean.toString(bRc));
        return bRc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closePort() {
        this.bOpen = false;
        boolean result = true;
        m_log.trace("closePort (in)");
        Object object = this.deviceClassLock;
        synchronized (object) {
            block14: {
                UsbServices services = null;
                try {
                    services = UsbHostManager.getUsbServices();
                    services.removeUsbServicesListener((UsbServicesListener)this);
                }
                catch (UsbException e) {
                    m_log.error("closePort: USB Exception. ", (Throwable)e);
                    result = false;
                }
                catch (SecurityException e) {
                    m_log.error("closePort: Security Exception. ", (Throwable)e);
                    result = false;
                }
                try {
                    if (this.rd != null) {
                        if (this.rd.running) {
                            this.rd.stop();
                        }
                        this.rd = null;
                    }
                    if (this.usbInterface == null) break block14;
                    UsbDevice usbDevice = this.usbInterface.getUsbConfiguration().getUsbDevice();
                    if (usbDevice != null) {
                        usbDevice.removeUsbDeviceListener((UsbDeviceListener)this);
                    }
                    try {
                        if (this.lUsbPipe.isOpen()) {
                            this.lUsbPipe.close();
                        }
                        this.usbInterface.release();
                    }
                    catch (UsbDisconnectedException de) {
                        m_log.error("closePort: USB Disconnected. ", (Throwable)de);
                        result = false;
                    }
                    this.usbInterface = null;
                }
                catch (UsbException e) {
                    m_log.error("closePort: USB Exception. ", (Throwable)e);
                    result = false;
                }
            }
        }
        m_log.trace("closePort (out): " + Boolean.toString(result));
        return result;
    }

    @Override
    public void changeBaudRate(int nBaud) {
    }

    @Override
    public int sendData(byte[] buf, int len) {
        m_log.trace("sendData (in): " + new String(buf) + ", " + Integer.toString(len));
        int nBytes = 0;
        if (this.usbInterface == null) {
            m_log.error("sendData: no USB interface");
            m_log.trace("sendData (out): " + Integer.toString(nBytes));
            return nBytes;
        }
        if (null == this.rd || !this.rd.running) {
            m_log.trace("sendData (out): " + Integer.toString(nBytes));
            return nBytes;
        }
        UsbDevice usbDevice = this.usbInterface.getUsbConfiguration().getUsbDevice();
        UsbControlIrp usageIrp = usbDevice.createUsbControlIrp((byte)33, (byte)9, (short)512, UsbUtil.unsignedShort((byte)this.usbInterface.getUsbInterfaceDescriptor().bInterfaceNumber()));
        usageIrp.setOffset(0);
        usageIrp.setData(buf);
        try {
            usbDevice.asyncSubmit(usageIrp);
            nBytes = usageIrp.getActualLength();
            this.logData = "";
            for (int i = 0; i < len; ++i) {
                this.sResult = String.format(" 0x%02X", buf[i]);
                this.logData = this.logData + this.sResult;
            }
            m_log.debug("# raw bytes sent[" + len + "]" + this.logData);
        }
        catch (UsbException e) {
            m_log.error("sendData: USB Exception. ", (Throwable)e);
        }
        this.logData = null;
        m_log.trace("sendData (out): " + Integer.toString(nBytes));
        return nBytes;
    }

    @Override
    public boolean startLiveWeight(byte[] buf, int len, int rate) {
        m_log.trace("startLiveWeight (in): " + Integer.toString(len) + ", " + Integer.toString(rate));
        if (DLSJposConst.updateInProgress) {
            m_log.error("startLiveWeight: Cannot start live weight while update in progress.");
            m_log.trace("startLiveWeight (out): false");
            return false;
        }
        if (buf == null) {
            m_log.error("startLiveWeight: null buffer detected");
            m_log.trace("startLiveWeight (out): false");
            return false;
        }
        m_log.debug("startLiveWeight: buf = " + new String(buf));
        if (this.bLiveWeight) {
            m_log.trace("startLiveWeight (out): false");
            return false;
        }
        this.weightCmd = Arrays.copyOf(buf, buf.length);
        this.nPollRate = rate;
        Runnable lwThread = new Runnable(){

            @Override
            public void run() {
                DLSUsbJavax.this.sendData(DLSUsbJavax.this.weightCmd, DLSUsbJavax.this.weightCmd.length);
            }
        };
        this.m_liveWeight = this.m_scheduler.scheduleAtFixedRate(lwThread, this.nPollRate, this.nPollRate, TimeUnit.MILLISECONDS);
        this.bLiveWeight = true;
        m_log.trace("startLiveWeight (out): true");
        return true;
    }

    @Override
    public void stopLiveWeight() {
        m_log.trace("stopLiveWeight (in)");
        if (this.bLiveWeight) {
            this.m_liveWeight.cancel(true);
            this.bLiveWeight = false;
        }
        m_log.trace("stopLiveWeight (out)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void usbDeviceDetached(UsbDeviceEvent event) {
        Object object = this.deviceClassLock;
        synchronized (object) {
            m_log.debug("Device Removed: " + Integer.toHexString(this.m_info.getVendorId()) + "," + Integer.toHexString(this.m_info.getProductId()));
            boolean result = this.closePort();
            UsbServices services = null;
            try {
                services = UsbHostManager.getUsbServices();
                services.addUsbServicesListener((UsbServicesListener)this);
            }
            catch (UsbException e) {
                m_log.error("usbDeviceDetached: USB Exception. ", (Throwable)e);
            }
            catch (SecurityException e) {
                m_log.error("usbDeviceDetached: Security Exception. ", (Throwable)e);
            }
            this.fireDeviceRemovedEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void usbDeviceDetached() {
        Object object = this.deviceClassLock;
        synchronized (object) {
            m_log.debug("Device Removed: " + Integer.toHexString(this.m_info.getVendorId()) + "," + Integer.toHexString(this.m_info.getProductId()));
            boolean result = this.closePort();
            UsbServices services = null;
            try {
                services = UsbHostManager.getUsbServices();
                services.addUsbServicesListener((UsbServicesListener)this);
            }
            catch (UsbException e) {
                m_log.error("usbDeviceDetached: USB Exception. ", (Throwable)e);
            }
            catch (SecurityException e) {
                m_log.error("usbDeviceDetached: Security Exception. ", (Throwable)e);
            }
            this.fireDeviceRemovedEvent();
        }
    }

    public void errorEventOccurred(UsbDeviceErrorEvent event) {
        m_log.error("ErrorEventOccured on usb: " + event.getUsbException().getMessage());
    }

    public void dataEventOccurred(UsbDeviceDataEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void usbDeviceAttached(UsbServicesEvent event) {
        m_log.trace("usbDeviceAttached (in)");
        Object object = this.deviceClassLock;
        synchronized (object) {
            if (!this.isOpen()) {
                DLSUsbQuery query = new DLSUsbQuery();
                UsbInterface anInterface = null;
                try {
                    anInterface = query.findDevice(this.m_info);
                }
                catch (DLSException e) {
                    m_log.error("usbDeviceAttached: DLS Exception. ", (Throwable)e);
                }
                if (anInterface != null) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException ex) {
                        m_log.error("usbDeviceAttached: Interrupted. ", (Throwable)ex);
                    }
                    m_log.debug("Device Reattached: " + Integer.toHexString(this.m_info.getVendorId()) + "," + Integer.toHexString(this.m_info.getProductId()));
                    this.fireDeviceReattachedEvent();
                }
            }
        }
        m_log.trace("usbDeviceAttached (out)");
    }

    public void usbDeviceDetached(UsbServicesEvent event) {
    }

    public class ReadData
    implements Runnable {
        public boolean running = true;
        public UsbPipe usbPipe = null;

        public ReadData(UsbPipe pipe) {
            this.usbPipe = pipe;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            m_log.trace("ReadData.run (in)");
            byte[] data = new byte[UsbUtil.unsignedInt((short)this.usbPipe.getUsbEndpoint().getUsbEndpointDescriptor().wMaxPacketSize())];
            int length = 0;
            ReadData readData = this;
            synchronized (readData) {
                this.notifyAll();
            }
            while (this.running) {
                block6: {
                    try {
                        length = this.usbPipe.syncSubmit(data);
                    }
                    catch (UsbException e) {
                        if (!this.running) break block6;
                        this.running = false;
                        m_log.error("Severe UsbException in ReadData: ", (Throwable)e);
                        DLSUsbJavax.this.usbDeviceDetached();
                        break;
                    }
                }
                if (!this.running || length == 0) continue;
                DLSUsbJavax.this.fireDataReceivedEvent(data, length);
            }
            m_log.trace("ReadData.run (out)");
        }

        public void stop() {
            m_log.trace("ReadData.stop (in)");
            try {
                this.running = false;
                UsbPipeImp pipeImp = (UsbPipeImp)this.usbPipe;
                pipeImp.getUsbPipeOsImp().abortAllSubmissions();
                this.usbPipe.close();
                this.usbPipe = null;
            }
            catch (Exception e) {
                m_log.error("Stop() exception: ", (Throwable)e);
            }
            m_log.trace("ReadData.stop (out)");
        }
    }
}

