/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.transport;

import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSException;
import com.dls.jpos.transport.DLSUsbInterfacePolicy;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.usb.UsbClaimException;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfacePolicy;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbServices;
import javax.usb.util.UsbUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSUsbQuery {
    protected UsbInterface theUsbInterface = null;
    protected static final byte HID_CLASS = 3;
    public static final byte HID_DESCRIPTOR_TYPE_REPORT = 34;
    public static final byte GET_REPORT_DESCRIPTOR_REQUESTTYPE = -127;
    public static final byte GET_REPORT_DESCRIPTOR_REQUEST = 6;
    public static final short GET_REPORT_DESCRIPTOR_VALUE = 8704;
    private static final Logger m_log = LogManager.getLogger(DLSUsbQuery.class);

    protected boolean validateUsage(UsbInterface usbInterface, DLSDeviceInfo info) {
        boolean bRc;
        block32: {
            bRc = false;
            m_log.trace("validateUsage (in)");
            String strInterface = "";
            try {
                strInterface = usbInterface.getInterfaceString();
                m_log.debug("validateUsage: " + strInterface);
            }
            catch (UsbException e) {
                m_log.error("validateUsage: USB Exception. ", (Throwable)e);
            }
            catch (UnsupportedEncodingException f) {
                m_log.error("validateUsage: Unsupported Encoding. ", (Throwable)f);
            }
            catch (UsbDisconnectedException g) {
                m_log.error("validateUsage: USB Disconnected. ", (Throwable)g);
            }
            try {
                if (usbInterface.isClaimed()) {
                    try {
                        usbInterface.release();
                    }
                    catch (UsbClaimException ex) {
                        m_log.error("validateUsage: USB Claim Exception. ", (Throwable)ex);
                    }
                    catch (UsbException ex) {
                        m_log.error("validateUsage: USB Exception. ", (Throwable)ex);
                    }
                    catch (UsbNotActiveException ex) {
                        m_log.error("validateUsage: USB Not Active. ", (Throwable)ex);
                    }
                    catch (UsbDisconnectedException ex) {
                        m_log.error("validateUsage: USB Disconnected. ", (Throwable)ex);
                    }
                }
                usbInterface.claim((UsbInterfacePolicy)new DLSUsbInterfacePolicy());
            }
            catch (UsbException e) {
                m_log.error("validateUsage: USB Exception. ", (Throwable)e);
                if (!e.getMessage().contains("claimed")) break block32;
                try {
                    usbInterface.release();
                }
                catch (UsbClaimException ex) {
                    m_log.error("validateUsage: USB Claim Exception. ", (Throwable)ex);
                }
                catch (UsbException ex) {
                    m_log.error("validateUsage: USB Exception. ", (Throwable)ex);
                }
                catch (UsbNotActiveException ex) {
                    m_log.error("validateUsage: USB Not Active. ", (Throwable)ex);
                }
                catch (UsbDisconnectedException ex) {
                    m_log.error("validateUsage: USB Disconnected. ", (Throwable)ex);
                }
                try {
                    usbInterface.claim((UsbInterfacePolicy)new DLSUsbInterfacePolicy());
                }
                catch (UsbClaimException ex) {
                    m_log.error("validateUsage: USB Claim Exception. ", (Throwable)ex);
                }
                catch (UsbException ex) {
                    m_log.error("validateUsage: USB Exception. ", (Throwable)ex);
                }
                catch (UsbNotActiveException ex) {
                    m_log.error("validateUsage: USB Not Active. ", (Throwable)ex);
                }
                catch (UsbDisconnectedException ex) {
                    m_log.error("validateUsage: USB Disconnected. ", (Throwable)ex);
                }
            }
        }
        UsbDevice usbDevice = usbInterface.getUsbConfiguration().getUsbDevice();
        UsbControlIrp usageIrp = usbDevice.createUsbControlIrp((byte)-127, (byte)6, (short)8704, UsbUtil.unsignedShort((byte)usbInterface.getUsbInterfaceDescriptor().bInterfaceNumber()));
        byte[] data = new byte[256];
        usageIrp.setData(data);
        try {
            usbDevice.syncSubmit(usageIrp);
            if (UsbUtil.unsignedInt((short)UsbUtil.toShort((byte)data[5], (byte)data[4])) == info.getUsage()) {
                bRc = true;
            }
            m_log.debug("bytes returned:" + usageIrp.getActualLength());
            m_log.debug("usage:" + Integer.toHexString(UsbUtil.unsignedInt((short)UsbUtil.toShort((byte)data[5], (byte)data[4]))) + ", usage2:" + Integer.toHexString(UsbUtil.unsignedInt((short)UsbUtil.toShort((byte)data[2], (byte)data[1]))) + ", getUsage():" + Integer.toHexString(info.getUsage()));
        }
        catch (UsbException e) {
            m_log.error("validateUsage: USB Exception. ", (Throwable)e);
            bRc = false;
        }
        try {
            usbInterface.release();
        }
        catch (UsbException e) {
            m_log.error("validateUsage: USB Exception. ", (Throwable)e);
            try {
                usbInterface.release();
            }
            catch (UsbClaimException ex) {
                m_log.error("validateUsage: USB Claim Exception. ", (Throwable)ex);
            }
            catch (UsbException ex) {
                m_log.error("validateUsage: USB Exception. ", (Throwable)ex);
            }
            catch (UsbNotActiveException ex) {
                m_log.error("validateUsage: USB Not Active. ", (Throwable)ex);
            }
            catch (UsbDisconnectedException ex) {
                m_log.error("USB Disconnected. ", (Throwable)ex);
            }
        }
        m_log.trace("validateUsage (out): " + Boolean.toString(bRc));
        return bRc;
    }

    protected UsbInterface scanHub(UsbDevice device, DLSDeviceInfo info) {
        int i;
        this.theUsbInterface = null;
        if (device.isConfigured() && info.getProductId() == device.getUsbDeviceDescriptor().idProduct() && info.getVendorId() == device.getUsbDeviceDescriptor().idVendor()) {
            List ifaces = device.getActiveUsbConfiguration().getUsbInterfaces();
            m_log.debug("Found product: " + Integer.toHexString(info.getProductId()) + ", vendor: " + Integer.toHexString(info.getVendorId()));
            for (i = 0; i < ifaces.size(); ++i) {
                UsbInterface usbInterface = (UsbInterface)ifaces.get(i);
                if (3 != usbInterface.getUsbInterfaceDescriptor().bInterfaceClass() || !this.validateUsage(usbInterface, info)) continue;
                this.theUsbInterface = usbInterface;
                i = ifaces.size();
                m_log.debug("Interface to product found.");
            }
        }
        if (device.isUsbHub()) {
            List devices = ((UsbHub)device).getAttachedUsbDevices();
            for (i = 0; i < devices.size(); ++i) {
                if (this.theUsbInterface != null) continue;
                this.scanHub((UsbDevice)devices.get(i), info);
            }
        }
        return this.theUsbInterface;
    }

    public UsbInterface findDevice(DLSDeviceInfo info) throws DLSException {
        m_log.trace("findDevice (in)");
        UsbServices services = null;
        UsbHub virtualRootHub = null;
        UsbInterface usbInterface = null;
        try {
            m_log.debug("gettingUsbServices");
            services = UsbHostManager.getUsbServices();
            m_log.debug("gettingRootUsbHub");
            virtualRootHub = services.getRootUsbHub();
        }
        catch (UsbException e) {
            throw new DLSException(-2147483647, e.getMessage());
        }
        catch (SecurityException e) {
            throw new DLSException(-2147483646, e.getMessage());
        }
        m_log.debug("Scanning hub");
        usbInterface = this.scanHub((UsbDevice)virtualRootHub, info);
        m_log.debug("findDevice returned: " + (usbInterface != null));
        return usbInterface;
    }
}

